package com.biz.crm.tpm.business.reconciliation.doc.list.local.service;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;

import java.util.Date;
import java.util.List;

/**
 * 构建对账单账 service
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-07-14 15:58
 */
public interface ReconciliationDocBuildService {

    /**
     * 手动触发创建对账单
     *
     * @param userIdentity
     * @param date
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-07-14 16:37
     */
    void handleBuildReconciliation(Date date,AbstractCrmUserIdentity userIdentity);

    /**
     * 自动触发创建对账单
     *
     * @param
     * @param date
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-07-14 16:05
     */
    void autoBuildReconciliation(Date date);

    /**
     * 自动触发补偿创建失败的对账单
     *
     * @param date
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-07-14 19:57
     */
    void autoBuildFailReconciliation(Date date);

    /**
     * 创建对账单锁定的KEY
     *
     * @param date 为空时,默认当天
     * @return java.lang.String
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-07-14 16:30
     */
    String getBuildRedisLockKey(Date date);

    /**
     * 创建对账单锁定的KEY
     *
     * @param date 为空时,默认当天
     * @return java.lang.String
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-07-14 16:30
     */
    String getBuildFailRedisLockKey(Date date);

    List<String> handleBuildReconciliationForOut(Date date, AbstractCrmUserIdentity abstractLoginUser);
}
