package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.exports;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationSummaryDataDisplayDetailHeadApproveRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationSummaryDataDisplayDetailSubApproveRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailSubApproveDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayDetailHeadApproveExportVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayDetailSubApproveExportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @ClassName ReconciliationSummaryDataDisplayDetailHeadApproveExportProcess
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/9 10:04
 **/
@Component
public class ReconciliationSummaryDataDisplayDetailSubApproveExportProcess implements ExportProcess<ReconciliationSummaryDataDisplayDetailSubApproveExportVo> {

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailSubApproveRepository detailSubApproveRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        return this.detailSubApproveRepository.getExportTotalCount(statementCode);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        List<ReconciliationSummaryDataDisplayDetailSubApproveEntity> approveEntities = this.detailSubApproveRepository.findByStatementCode(statementCode);
        Collection<ReconciliationSummaryDataDisplayDetailSubApproveExportVo> exportVos = this.nebulaToolkitService.copyCollectionByWhiteList(approveEntities, ReconciliationSummaryDataDisplayDetailSubApproveEntity.class, ReconciliationSummaryDataDisplayDetailSubApproveExportVo.class, HashSet.class, ArrayList.class);
        this.convertData(exportVos);
        return JSON.parseArray(JSON.toJSONString(exportVos));
    }

    @Override
    public String getBusinessCode() {
        return "RECONCILIATION_SUMMARY_DATA_DISPLAY_DETAIL_SUB_APPROVE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-分子批复对账单汇总数据明细数据导出";
    }

    private String getStatementCode(Map<String, Object> params){
        return params.get("statementCode").toString();
    }

    /**
     * 获取对象转换实体
     *
     * @return
     */
    @Override
    public Class<ReconciliationSummaryDataDisplayDetailSubApproveExportVo> findCrmExcelVoClass() {
        return ReconciliationSummaryDataDisplayDetailSubApproveExportVo.class;
    }


    //数据字典转换
    private void convertData(Collection<ReconciliationSummaryDataDisplayDetailSubApproveExportVo> data) {
        if (CollectionUtil.isEmpty(data)) {
            return;
        }
        //  转换数据字典值
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DictConstant.MDM_BUSINESS_UNIT, DictConstant.MDM_BUSINESS_FORMAT));
        for (ReconciliationSummaryDataDisplayDetailSubApproveExportVo vo : data) {
            vo.setBusinessUnitCode(this.findDictValue(mapDict, DictConstant.MDM_BUSINESS_UNIT, vo.getBusinessUnitCode()));
            vo.setBusinessFormatCode(this.findDictValue(mapDict, DictConstant.MDM_BUSINESS_FORMAT, vo.getBusinessFormatCode()));
        }
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }
}
