package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.ReconciliationDocBuildService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.concurrent.TimeUnit;


/**
 * 自动构建失败的对账单
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-07-14 15:28
 */
@Slf4j
@Service
public class AutoBuildFailReconciliationSyncXxlJob {


    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private ReconciliationDocBuildService reconciliationDocBuildService;

    /**
     * 自动构建失败的对账单
     */
    @DynamicTaskService(cornExpression = "0 10 4 * * ?", taskDesc = "每天 04:10 执行一次监测是否有需要重新执行的失败的任务")
    public void autoBuildFailXxlJob() {
        log.info("=====>    自动构建失败的对账单[{}] start    <=====", DateUtil.dateStrNowAll());
        boolean lock = true;
        Date date = new Date();
        String lockKey = reconciliationDocBuildService.getBuildFailRedisLockKey(date);
        loginUserService.refreshAuthentication(null);
        try {

            lock = redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4);
            Assert.isTrue(lock, "自动构建失败的对账单加锁失败");
            reconciliationDocBuildService.autoBuildFailReconciliation(date);
            log.info("=====>     自动构建失败的对账单成功     <=====");

        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        } finally {
            if (lock) {
                redisLockService.unlock(lockKey);
            }
        }
        log.info("=====>    自动构建失败的对账单[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
