package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ApprovalStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ClosingStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.SyncECrmStatementDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.BaseEcrmBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationCorrelationVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 构建推送 ECRM service 实现
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-07-18 15:34
 */
@Slf4j
@Service
public class BaseEcrmBuildServiceImpl implements BaseEcrmBuildService {

    /**
     * 登录用户服务
     */
    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 客户vo服务
     */
    @Autowired(required = false)
    private CustomerVoService customerVoService;


    /**
     * ecrm服务
     */
    @Autowired(required = false)
    private EcrmService ecrmService;

    /**
     * 对账单关联数据服务
     */
    @Autowired(required = false)
    private ReconciliationCorrelationVoService correlationVoService;

    /**
     * 数据字典服务
     */
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 对账单生成策略集合
     */
    private List<AbstractReconciliationGenerateStrategy> abstractReconciliationGenerateStrategyList;

    @Autowired
    public void setAbstractReconciliationGenerateStrategyList(List<AbstractReconciliationGenerateStrategy> abstractReconciliationGenerateStrategyList) {
        this.abstractReconciliationGenerateStrategyList = abstractReconciliationGenerateStrategyList;
    }

    @Override
    public void syncECrm(ReconciliationDocListVo reconciliationDocListVo, FacturerUserDetails loginDetails) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationDocListVo.getBusinessUnitCode())) {
            return;
        }

        if (loginDetails == null) {
            loginDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
        }
        //获取当前客户信息
        List<CustomerVo> customerCodes = customerVoService.findBaseByCustomerCodes(Lists.newArrayList(reconciliationDocListVo.getCustomerCode()));
        if (CollectionUtils.isEmpty(customerCodes)) {
            throw new IllegalArgumentException("查询不到此客户," + reconciliationDocListVo.getCustomerCode());
        }
        CustomerVo customerVo = customerCodes.get(0);
        SyncECrmStatementDto eCrmStatementDto = SyncECrmStatementDto.builder()
                // 状态
                .status("A" + reconciliationDocListVo.getStatementStatus())
                .documents(reconciliationDocListVo.getDocumentsId()).contractId(reconciliationDocListVo.getContractId())
                .operatorName(loginDetails.getRealName()).operatorContact(loginDetails.getPhone())
                .tenantName(reconciliationDocListVo.getCustomerName())
                .year(String.valueOf(DateUtil.year(reconciliationDocListVo.getReconciliationMonth())))
                .month(String.valueOf(DateUtil.month(reconciliationDocListVo.getReconciliationMonth()) + 1))

                .sn(customerVo.getErpCode())
                // 利润中心
                .lrzx("00001000")
                // 公司代码
                .company(reconciliationDocListVo.getSalesInstitutionCode())
                .categoryId(reconciliationDocListVo.getAccountReconciliationType()).build();
        ecrmService.syncStatementECrm(eCrmStatementDto);

    }

    /**
     * 推送ECRMcorrelation
     *
     * @param reconciliationDocListVo 对账单vo
     */
    @Override
    public void pushECrm(ReconciliationDocListVo reconciliationDocListVo) {
        // 往来批复推送
        Set<String> serviceByStatementCode =
                correlationVoService.findByStatementCode(reconciliationDocListVo.getStatementCode());
        if (CollectionUtils.isEmpty(serviceByStatementCode)) {
            return;
        }

        AbstractReconciliationGenerateStrategy strategy = null;
        List<AbstractReconciliationGenerateStrategy> generateStrategies = abstractReconciliationGenerateStrategyList.stream().filter(x -> x.getReconciliationType().equals(reconciliationDocListVo.getAccountReconciliationType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(generateStrategies)) {
            return;
        }
        if (generateStrategies.size() > 1) {
            //如果存在多个 根据业务单元区分（业务单元唯一）
            ReconciliationBuesinssTypeEnum businessTypeEnum = ReconciliationBuesinssTypeEnum.findByBusinessUnitCode(reconciliationDocListVo.getBusinessUnitCode());
            if (businessTypeEnum != null) {
                Optional<AbstractReconciliationGenerateStrategy> reconciliationGenerateStrategy = generateStrategies.stream().filter(x -> businessTypeEnum.getCode().equals(x.getBusinessType())).findFirst();
                if (reconciliationGenerateStrategy.isPresent()) {
                    strategy = reconciliationGenerateStrategy.get();
                }
            } else {
                log.error("对账信息[{}]未找到业务单元", reconciliationDocListVo);
            }
        } else {
            strategy = generateStrategies.get(0);
        }

        if (strategy == null) {
            return;
        }

        ReconciliationGenerateDto reconciliationGenerateDto = new ReconciliationGenerateDto();
        reconciliationGenerateDto
                .setAccountReconciliationRuleCode(reconciliationDocListVo.getAccountReconciliationRuleCode());
        reconciliationGenerateDto.setBusinessFormatCode(reconciliationDocListVo.getBusinessFormatCode());
        reconciliationGenerateDto.setBusinessUnitCode(reconciliationDocListVo.getBusinessUnitCode());
        reconciliationGenerateDto.setStartDateTime(reconciliationDocListVo.getStartDate());
        reconciliationGenerateDto.setEndDateTime(reconciliationDocListVo.getEndDate());

        List dateList = strategy.findDateList(reconciliationGenerateDto, reconciliationDocListVo.getCustomerCode());
        if (CollectionUtils.isEmpty(dateList)) {
            return;
        }
        Map<String, String> businessFormatMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_BUSINESS_FORMAT);
        Map<String, String> businessUnitMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_BUSINESS_UNIT);
        Map<String, String> rtmModelMap = dictToolkitService.findMapByDictTypeCode(ReconciliationConstant.MDM_RTX_MODEL);
        log.info("推送电子签章，RTM模式字典数据【{}】", JSON.toJSONString(rtmModelMap));

        if (ReconciliationTypeEnum.APPROVAL.getCode().equals(reconciliationDocListVo.getAccountReconciliationType())) {
            // 分子公司不推
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationGenerateDto.getBusinessUnitCode())) {
                return;
            }
            List<ApprovalStatementDto> approvalStatements = new ArrayList<>();
            if (dateList.get(0) instanceof ActivityDetailPlanItemVo) {
                ((List<ActivityDetailPlanItemVo>) dateList).forEach(item -> {
                    approvalStatements.add(this.buildApproval(item, businessFormatMap, businessUnitMap, reconciliationDocListVo));
                });
                //转换字段
                Set<String> customerCodes = approvalStatements.stream().map(ApprovalStatementDto::getCustomerCode).collect(Collectors.toSet());
                List<CustomerVo> customerVos = this.customerVoService.findBaseByCustomerCodes(Lists.newArrayList(customerCodes));
                if (CollectionUtils.isEmpty(customerVos)) {
                    throw new IllegalArgumentException("推送ecrm异常，查询不到客户信息");
                }
                Map<String, List<CustomerVo>> customerGroup = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getCustomerCode));
                approvalStatements.forEach(item -> {
                    List<CustomerVo> customerVo = customerGroup.get(item.getCustomerCode());
                    log.info("推送电子签章，客户信息【{}】", JSON.toJSONString(customerVo));
                    if (customerVo != null) {
                        CustomerVo vo = customerVo.get(0);
                        item.setCustomerCode(vo.getErpCode());
                        item.setSalesOrgProvinceCode(vo.getSalesOrgErpCode());
                        item.setSalesOrgProvinceName(vo.getSalesOrgName());
                        item.setSalesInstitutionCode(vo.getSalesInstitutionErpCode());
                        item.setSalesInstitutionName(vo.getSalesInstitutionName());
                        item.setSalesOrgRegionCode(vo.getSalesRegionErpCode());
                        item.setSalesOrgRegionName(vo.getSalesRegionName());
                        item.setCustomerType(rtmModelMap.get(vo.getRtmModelCode()));
                    }


                });
            }

            if (CollectionUtils.isEmpty(approvalStatements)) {
                return;
            }
            ecrmService.pushApprovalStatement(approvalStatements);
        }
        if (ReconciliationTypeEnum.CLOSURE.getCode().equals(reconciliationDocListVo.getAccountReconciliationType())) {
            List<ClosingStatementDto> closingStatements = new ArrayList<>();
            List<AuditCustomerDetailCollectionVo> detailCollectionVos = dateList;
            detailCollectionVos.forEach(detail -> {
                closingStatements.add(this.buildClosing(detail, businessFormatMap, businessUnitMap, reconciliationDocListVo));
            });

            if (CollectionUtils.isEmpty(closingStatements)) {
                return;
            }

            //转换字段
            Set<String> customerCodes = closingStatements.stream().map(ClosingStatementDto::getCustomerCode).collect(Collectors.toSet());
            List<CustomerVo> customerVos = this.customerVoService.findBaseByCustomerCodes(Lists.newArrayList(customerCodes));
            if (CollectionUtils.isEmpty(customerVos)) {
                throw new IllegalArgumentException("推送ecrm异常，查询不到客户信息");
            }
            Map<String, List<CustomerVo>> customerGroup = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getCustomerCode));
            closingStatements.forEach(item -> {
                List<CustomerVo> customerVo = customerGroup.get(item.getCustomerCode());
                if (customerVo != null) {
                    CustomerVo vo = customerVo.get(0);
                    log.info("推送电子签章，客户信息【{}】", JSON.toJSONString(customerVo));
                    item.setCustomerCode(vo.getErpCode());
                    item.setSalesOrgProvinceCode(vo.getSalesOrgErpCode());
                    item.setSalesInstitutionCode(vo.getSalesInstitutionErpCode());
                    item.setSalesOrgRegionCode(vo.getSalesRegionErpCode());
                    item.setCustomerType(rtmModelMap.get(vo.getRtmModelCode()));
                }
            });
            ecrmService.pushClosingStatement(closingStatements);
        }
    }

    /**
     * 建立批复对账dto
     *
     * @param item                    活动明细vo
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ApprovalStatementDto}
     */
    private ApprovalStatementDto buildApproval(ActivityDetailPlanItemVo item,
                                               Map<String, String> businessFormatMap,
                                               Map<String, String> businessUnitMap,
                                               ReconciliationDocListVo reconciliationDocListVo) {
        ApprovalStatementDto approvalStatementDto = new ApprovalStatementDto();
        approvalStatementDto.setIntegrationId(item.getId());
        approvalStatementDto.setStatementCode(reconciliationDocListVo.getStatementCode());
        approvalStatementDto.setStatementStatus(reconciliationDocListVo.getStatementStatus());
        approvalStatementDto.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
        approvalStatementDto.setActivityDetailsCode(item.getDetailPlanItemCode());
        approvalStatementDto.setReconciliationMonth(reconciliationDocListVo.getReconciliationMonth());

        approvalStatementDto.setCustomerCode(item.getCustomerCode());
        approvalStatementDto.setCustomerName(item.getCustomerName());
        // 客户分类  （取客户主数据rtm_model_code）
//        approvalStatementDto.setCustomerType(item.getCustomerName());
        approvalStatementDto.setFirstChannelCode(item.getFirstChannelCode());
        approvalStatementDto.setFirstChannelName(item.getFirstChannelName());
        approvalStatementDto.setSecondChannelCode(item.getSecondChannelCode());
        approvalStatementDto.setSecondChannelName(item.getSecondChannelName());
        approvalStatementDto.setCenter("6000");
        // 业态
        if (StrUtil.isNotEmpty(item.getBusinessFormatCode())
                && CollectionUtil.isNotEmpty(businessFormatMap)) {
            approvalStatementDto.setBusinessFormatCode(businessFormatMap.get(item.getBusinessFormatCode()));
        }

        // 业务单元
        if (StrUtil.isNotEmpty(item.getBusinessUnitCode())
                && CollectionUtil.isNotEmpty(businessUnitMap)) {
            approvalStatementDto.setBusinessUnitCode(businessUnitMap.get(item.getBusinessUnitCode()));
        }
        approvalStatementDto.setSalesInstitutionName(item.getSalesInstitutionName());
        approvalStatementDto.setSalesInstitutionCode(item.getSalesInstitutionCode());
        approvalStatementDto.setSalesOrgRegionName(item.getSalesRegionName());
        approvalStatementDto.setSalesOrgRegionCode(item.getSalesRegionCode());

        //预算项目编码
        //推送的预算项目编码取值来自两个字段，活动细案明细的大区预算项目编码和总部预算项目编码
        //取值逻辑：如果两个字段都有值就两个值都取，用逗号隔开，如果两个值一样，就取去重后的结果
        StringBuilder budgetItemName = new StringBuilder();
        StringBuilder budgetItemCode = new StringBuilder();

        //预算项目名称
        if (StringUtils.isNotBlank(item.getBudgetItemName())) {
            budgetItemName.append(item.getBudgetItemName());
        }
        if (StringUtils.isNotBlank(item.getHeadBudgetItemName())) {
            if (!StringUtils.equals(item.getBudgetItemName(), item.getHeadBudgetItemName())) {
                if (StringUtils.isNotBlank(item.getBudgetItemName())) {
                    budgetItemName.append(",");
                }
                budgetItemName.append(item.getHeadBudgetItemName());
            }
        }

        //预算项目编码
        if (StringUtils.isNotBlank(item.getBudgetItemCode())) {
            budgetItemCode.append(item.getBudgetItemCode());
        }
        if (StringUtils.isNotBlank(item.getHeadBudgetItemCode())) {
            if (!StringUtils.equals(item.getBudgetItemCode(), item.getHeadBudgetItemCode())) {
                if (StringUtils.isNotBlank(item.getBudgetItemCode())) {
                    budgetItemCode.append(",");
                }
                budgetItemCode.append(item.getHeadBudgetItemCode());
            }
        }

        approvalStatementDto.setBudgetProjectName(budgetItemName.toString());
        approvalStatementDto.setBudgetProjectCode(budgetItemCode.toString());
        approvalStatementDto.setBrandTxt(item.getProductBrandName());
        approvalStatementDto.setBrand(item.getProductBrandCode());
        approvalStatementDto.setProductName(item.getProductName());
        approvalStatementDto.setProductCode(item.getProductCode());
        approvalStatementDto.setActivityFormName(item.getActivityFormName());
        approvalStatementDto.setActivityFormCode(item.getActivityFormCode());
        approvalStatementDto.setActivityBeginDate(item.getActivityBeginDate());
        approvalStatementDto.setActivityEndDate(item.getActivityEndDate());
        approvalStatementDto.setDescription(item.getFormDescription());

        //自己算一下  这里有坑别用他们算的
        //费用合计=总部承担+大区承担+客户承担
        approvalStatementDto.setTotalcosts(NumberUtil.add(item.getCustomerFeeAmount(), item.getDepartmentFeeAmount(), item.getHeadFeeAmount()));
        //费用申请=总部承担+大区承担
        approvalStatementDto.setApplicationFee(NumberUtil.add(item.getDepartmentFeeAmount(), item.getHeadFeeAmount()));
        approvalStatementDto.setDealerFees(item.getCustomerFeeAmount());
        return approvalStatementDto;
    }

    /**
     * 构建结案推送dto
     *
     * @param detail 结案vo
     * @return {@link ClosingStatementDto}
     */
    private ClosingStatementDto buildClosing(AuditCustomerDetailCollectionVo detail,
                                             Map<String, String> businessFormatMap,
                                             Map<String, String> businessUnitMap,
                                             ReconciliationDocListVo reconciliationDocListVo) {
        ClosingStatementDto closingStatementDto = new ClosingStatementDto();
        closingStatementDto.setIntegrationId(detail.getId());
        closingStatementDto.setStatementCode(reconciliationDocListVo.getStatementCode());
        closingStatementDto.setStatementStatus(reconciliationDocListVo.getStatementStatus());
        closingStatementDto.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
        closingStatementDto.setActivityDetailsCode(detail.getActivityDetailCode());

        if (reconciliationDocListVo.getReconciliationMonth() != null) {
            try {
                closingStatementDto.setReconciliationMonth(
                        DateUtil.format(reconciliationDocListVo.getReconciliationMonth(), "yyyy-MM"));
            } catch (Exception e) {
                throw new IllegalArgumentException("推送ecrm时,年月字段时间类型转换错误");
            }

        }
        closingStatementDto.setCustomerCode(detail.getCustomerCode());
        closingStatementDto.setCustomerName(detail.getCustomerName());
        closingStatementDto.setCustomerType(detail.getCustomerType());
        closingStatementDto.setFirstChannelCode(detail.getFirstChannelCode());
        closingStatementDto.setFirstChannelName(detail.getFirstChannelName());
        closingStatementDto.setSecondChannelCode(detail.getSecondChannelCode());
        closingStatementDto.setSecondChannelName(detail.getSecondChannelName());
        closingStatementDto.setCenter(detail.getCenter());

        // 业态
        if (StrUtil.isNotEmpty(detail.getBusinessFormatCode())
                && CollectionUtil.isNotEmpty(businessFormatMap)) {
            closingStatementDto.setBusinessFormatCode(businessFormatMap.get(detail.getBusinessFormatCode()));
        }

        // 业务单元
        if (StrUtil.isNotEmpty(detail.getBusinessUnitCode())
                && CollectionUtil.isNotEmpty(businessUnitMap)) {
            closingStatementDto.setBusinessUnitCode(businessUnitMap.get(detail.getBusinessUnitCode()));
        }

        closingStatementDto.setSalesInstitutionName(detail.getSalesInstitutionName());
        closingStatementDto.setSalesInstitutionCode(detail.getSalesInstitutionCode());
        closingStatementDto.setSalesOrgRegionName(detail.getSalesRegionName());
        closingStatementDto.setSalesOrgRegionCode(detail.getSalesRegionCode());
        closingStatementDto.setSalesOrgProvinceName(detail.getSalesOrgName());
        closingStatementDto.setSalesOrgProvinceCode(detail.getSalesOrgCode());
        closingStatementDto.setBudgetProjectName(detail.getBudgetItemName());
        closingStatementDto.setBudgetProjectCode(detail.getBudgetItemCode());
        closingStatementDto.setBrandTxt(detail.getProductBrandName());
        closingStatementDto.setBrand(detail.getProductBrandCode());
        closingStatementDto.setProductName(detail.getProductName());
        closingStatementDto.setProductCode(detail.getProductCode());
        closingStatementDto.setActivityFormName(detail.getActivityFormName());
        closingStatementDto.setActivityFormCode(detail.getActivityFormCode());
        if (Objects.nonNull(detail.getActivityBeginTime())) {
            closingStatementDto.setActivityBeginDate(DateUtil.format(detail.getActivityBeginTime(), DatePattern.NORM_DATE_FORMAT));
        }
        if (Objects.nonNull(detail.getActivityEndTime())) {
            closingStatementDto.setActivityEndDate(DateUtil.format(detail.getActivityEndTime(), DatePattern.NORM_DATE_FORMAT));
        }
        closingStatementDto.setDescription(detail.getRemark());
        if (Objects.nonNull(detail.getCustomerFeeAmount())) {
            closingStatementDto.setDealerBearFee(detail.getCustomerFeeAmount().toString());
        }
        if (Objects.nonNull(detail.getApprovedAmount())) {
            closingStatementDto.setApprovedAmount(detail.getApprovedAmount().toString());
        }
        if (Objects.nonNull(detail.getThisAuditAmount())) {
            closingStatementDto.setClosingAmount(detail.getThisAuditAmount().toString());
        }
        if (Objects.nonNull(detail.getDiscountTaxAmount()) && Objects.nonNull(detail.getDiscountAmount())) {
            closingStatementDto
                    .setTaxQuota(NumberUtil.sub(detail.getDiscountTaxAmount(), detail.getDiscountAmount()).toString());
        }
        if (Objects.nonNull(detail.getThisAuditAmount()) && StrUtil.isNotEmpty(closingStatementDto.getTaxQuota())) {
            closingStatementDto.setFinalClosingAmount(
                    detail.getThisAuditAmount().subtract(new BigDecimal(closingStatementDto.getTaxQuota())).toString());
        }
        if (Objects.nonNull(detail.getDiscountAmount())) {
            closingStatementDto.setDiscountTaxTotalAmount(detail.getDiscountAmount().toString());
        }
        if (Objects.nonNull(detail.getReimburseTaxAmount())) {
            closingStatementDto.setReimburseTaxAmount(detail.getReimburseTaxAmount().toString());
        }
        //考核扣款
        if (Objects.nonNull(detail.getExamineCircularAmount())) {
            closingStatementDto.setExamineCircularAmount(detail.getExamineCircularAmount().toPlainString());
            //起草人
            closingStatementDto.setCreateName(detail.getCreateName());
            //便签名称
            closingStatementDto.setProcessTitle(detail.getProcessTitle());
        }
        //上账方式
        closingStatementDto.setMethodAccounting(detail.getMethodAccounting());
        return closingStatementDto;
    }
}
