package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.*;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicSignatureApiService;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.NewFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationFileTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListFileVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Component
public class BaseElectronicSignature {

    /**
     * 文件服务器
     */
    @Autowired(required = false)
    private FileHandleService fileHandleService;

    /**
     * 对账单文件sevice
     */
    @Autowired(required = false)
    private ReconciliationDocListFileVoService reconciliationDocListFileVoService;

    /**
     * 登录用户服务
     */
    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 电子签名api服务
     */
    @Autowired(required = false)
    private ElectronicSignatureApiService electronicSignatureApiService;

    /**
     * 数据字典服务
     */
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Value("${venus.file.fileRoot}")
    public String fileRoot;

    private static final String CATEGORY = "tpm_electronicSignature_category";
    private static final String CATEGORY_ID = "categoryId";
    private static final String CATEGORY_NAME = "categoryName";

    /**
     * 推动电子签章
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}<{@link CreateContractVo}>
     */
    public ElectronicSignatureVo<CreateContractVo> pushElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        AccountCheckBillDto dto = new AccountCheckBillDto();
        ContractDocumentDto contractDocumentDto = new ContractDocumentDto();
        contractDocumentDto.setTitle(reconciliationDocListVo.getStatementCode());
        ReconciliationDocListFileVo detailByStatementCodeAndFileType =
            this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(
                reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.BO_ZHI.getCode());
        Validate.notNull(detailByStatementCodeAndFileType, "文件不存在");

        // 获取文件
        OrdinaryFileVo ordinaryFileVo = fileHandleService.findById(detailByStatementCodeAndFileType.getFileCode());
        byte[] fileByte = fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(),
            ordinaryFileVo.getFileName());

        File mkdir = null;
        try {
            mkdir = FileUtil.newFile(fileRoot + "/" + reconciliationDocListVo.getStatementCode() + ".pdf");
            File file = FileUtil.writeBytes(fileByte, mkdir);
            if (!file.exists()) {
                throw new IllegalArgumentException("文件不存在");
            }
            contractDocumentDto.setAccountCheckBillFile(file);
            dto.setContractDocumentDto(contractDocumentDto);

            // 合同信息
            ContractDto contractDto = new ContractDto();
            //获取用印流程 配置成数据字典了
            List<DictDataVo> dictTypeCode = this.dictDataVoService.findByDictTypeCode(CATEGORY);
            if (CollectionUtil.isEmpty(dictTypeCode)) {
                throw new IllegalArgumentException("用印流程数据字典不存在");
            }

            DictDataVo categoryIdDict = dictTypeCode.stream().filter(x -> CATEGORY_ID.equals(x.getDictCode()))
                .findFirst()
                .orElseThrow(() -> new IllegalArgumentException("数据字典【tpm_electronicSignature_category】不存在用印ID[categoryId]的配置"));
            contractDto.setCategoryId(categoryIdDict.getDictValue());

            DictDataVo categoryNameDict = dictTypeCode.stream().filter(x -> CATEGORY_NAME.equals(x.getDictCode()))
                .findFirst()
                .orElseThrow(() -> new IllegalArgumentException("数据字典【tpm_electronicSignature_category】不存在用印名称[categoryName]的配置"));
            contractDto.setCategoryName(categoryNameDict.getDictValue());


            contractDto.setSubject(reconciliationDocListVo.getStatementCode());
            contractDto.setSn(reconciliationDocListVo.getStatementCode());
            contractDto.setSend(true);
            contractDto.setExtraSign(false);
            contractDto.setTenantName("内蒙古蒙牛乳业（集团）股份有限公司");
            FacturerUserDetails loginDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            contractDto.setCreatorName(loginDetails.getUsername());
            contractDto.setCreatorContact(loginDetails.getPhone());
            contractDto.setMustSign(true);
            contractDto.setCustomerCode(reconciliationDocListVo.getCustomerCode());

            // 签署人信息
            List<SignatoryDto> signatories = new ArrayList<>();
            SignatoryDto signatoryDto = new SignatoryDto();

            signatoryDto.setTenantType("COMPANY");
            signatoryDto.setTenantName(reconciliationDocListVo.getCustomerName());
            signatoryDto.setSignatoryNo(reconciliationDocListVo.getCustomerCode());
            signatoryDto.setReceiverName(reconciliationDocListVo.getRecipientName());
            signatoryDto.setContact(reconciliationDocListVo.getReceiverTelephone());
            signatoryDto.setSerialNo(1);
            signatoryDto.setRemind(true);
            signatoryDto.setAuthMode("DEFAULT");
            signatoryDto.setLanguage("zh_CN");

            //签署动作
            List<ActionDto> actions = new ArrayList<>();
            ActionDto action1Dto = new ActionDto();
            action1Dto.setSerialNo("1");
            action1Dto.setType("CORPORATE");
            action1Dto.setName("企业签章");
            actions.add(action1Dto);

            ActionDto action2Dto = new ActionDto();
            action2Dto.setSerialNo("1");
            action2Dto.setType("LP");
            action2Dto.setName("法人代表人签字");
            actions.add(action2Dto);
            signatoryDto.setActions(actions);
            signatories.add(signatoryDto);
            contractDto.setSignatories(signatories);

            dto.setContractDto(contractDto);

            return this.electronicSignatureApiService.pushAccountCheckBill(dto);
        } catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        } finally {
            if (mkdir != null) {
                mkdir.delete();
            }
        }
    }

    /**
     * 取消电子签章
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo cancelElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        ScrapContractDto dto = new ScrapContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.cancellationContract(dto);
    }

    /**
     * 撤回电子签章
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo withdrawalElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        WithdrawalContractDto dto = new WithdrawalContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.withdrawalContract(dto);
    }

    /**
     * 催签电子签章
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo expeditingElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        ContractExpeditingDto dto = new ContractExpeditingDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.contractExpediting(dto);
    }

    /**
     * 下载电子签章
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo<FileVo> downloadElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        DownloadContractDto dto = new DownloadContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        dto.setDocumentId(Long.valueOf(reconciliationDocListVo.getDocumentsId()));
        return this.electronicSignatureApiService.downloadContract(dto);
    }

    /**
     * 下载电子签章(新)
     *
     * @param reconciliationDocListVo 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo<NewFileVo> downloadElectronicSignatureNew(ReconciliationDocListVo reconciliationDocListVo) {
        DownloadContractDto dto = new DownloadContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        if (null == reconciliationDocListVo.getContractId()) {
            return null;
        }
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        if (null == reconciliationDocListVo.getDocumentsId()) {
            return null;
        }
        dto.setDocumentId(Long.valueOf(reconciliationDocListVo.getDocumentsId()));
        return this.electronicSignatureApiService.downloadContractNew(dto);
    }

}
