package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationCorrelationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationCorrelationRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationCorrelationEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationCorrelationLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationCorrelationVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * TPM-对账单据关联数据(ReconciliationCorrelation)表服务实现类
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:38
 */
@Slf4j
@Service("reconciliationCorrelationService")
public class ReconciliationCorrelationVoServiceImpl implements ReconciliationCorrelationVoService {

    @Autowired(required = false)
    private ReconciliationCorrelationRepository reconciliationCorrelationRepository;

    @Autowired(required = false)
    private List<ReconciliationCorrelationEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<ReconciliationCorrelationVo> findByConditions(Pageable pageable, ReconciliationCorrelationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        dto = Optional.ofNullable(dto).orElse(new ReconciliationCorrelationDto());
        Page<ReconciliationCorrelationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.reconciliationCorrelationRepository.findByConditions(page, dto);
    }

    @Override
    public ReconciliationCorrelationVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        ReconciliationCorrelationEntity reconciliationCorrelation = this.reconciliationCorrelationRepository.findById(id);
        if (reconciliationCorrelation == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(reconciliationCorrelation, ReconciliationCorrelationVo.class,
            HashSet.class, ArrayList.class);
    }

    @Override
    public Set<String> findByStatementCode(String statementCode) {
        if(StringUtils.isEmpty(statementCode)){
            return Sets.newHashSet();
        }
        List<ReconciliationCorrelationEntity> list = this.reconciliationCorrelationRepository.lambdaQuery().eq(ReconciliationCorrelationEntity::getStatementCode, statementCode).list();
        if (CollectionUtils.isEmpty(list)){
            return Sets.newHashSet();
        }
        return list.stream().filter(Objects::nonNull).map(ReconciliationCorrelationEntity::getAssociativeDate).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
      @Transactional
      public ReconciliationCorrelationVo create(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        this.createValidation(reconciliationCorrelationVo);
        reconciliationCorrelationVo.setTenantCode(TenantUtils.getTenantCode());
        reconciliationCorrelationVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationCorrelationVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

        ReconciliationCorrelationEntity reconciliationCorrelation = nebulaToolkitService.copyObjectByWhiteList(reconciliationCorrelationVo, ReconciliationCorrelationEntity.class, HashSet.class, ArrayList.class);
        this.reconciliationCorrelationRepository.saveOrUpdate(reconciliationCorrelation);

         reconciliationCorrelationVo.setId(reconciliationCorrelation.getId());

         //crud监听事件
            if (!CollectionUtils.isEmpty(eventListeners)) {
                for (ReconciliationCorrelationEventListener reconciliationCorrelationEventListener : eventListeners) {
                    reconciliationCorrelationEventListener.onCreate(reconciliationCorrelationVo);
                }
            }

        // 发送通知
        ReconciliationCorrelationLogEventDto logEventDto =new ReconciliationCorrelationLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(reconciliationCorrelationVo);
            SerializableBiConsumer<ReconciliationCorrelationLogEventListener, ReconciliationCorrelationLogEventDto> onCreate =
                    ReconciliationCorrelationLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, ReconciliationCorrelationLogEventListener.class,onCreate);
        return reconciliationCorrelationVo;
      }

    @Override
    public void createBatch(List<ReconciliationCorrelationVo> voList) {
        if (CollectionUtils.isEmpty(voList)){
            return;
        }
        voList.forEach(vo->{
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        Collection<ReconciliationCorrelationEntity> correlationEntities = nebulaToolkitService.copyCollectionByWhiteList(voList, ReconciliationCorrelationVo.class, ReconciliationCorrelationEntity.class, HashSet.class, ArrayList.class);
        this.reconciliationCorrelationRepository.saveBatch(correlationEntities);
    }

    @Override
  @Transactional
  public ReconciliationCorrelationVo update(ReconciliationCorrelationVo reconciliationCorrelationVo) {
    this.updateValidation(reconciliationCorrelationVo);
    String currentId = reconciliationCorrelationVo.getId();
    ReconciliationCorrelationEntity current = reconciliationCorrelationRepository.findById(currentId);
    current = Validate.notNull(current, "修改信息不存在");
    ReconciliationCorrelationVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, ReconciliationCorrelationVo.class, HashSet.class, ArrayList.class);

    
    this.reconciliationCorrelationRepository.saveOrUpdate(current);
    //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (ReconciliationCorrelationEventListener reconciliationCorrelationEventListener : eventListeners) {
                reconciliationCorrelationEventListener.onUpdate(oldVo,reconciliationCorrelationVo);
            }
        }
   
    // 发送修改通知
    ReconciliationCorrelationLogEventDto logEventDto =new ReconciliationCorrelationLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(reconciliationCorrelationVo);
        SerializableBiConsumer<ReconciliationCorrelationLogEventListener, ReconciliationCorrelationLogEventDto> onUpdate =
                ReconciliationCorrelationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, ReconciliationCorrelationLogEventListener.class,onUpdate);
    return reconciliationCorrelationVo;
  }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.reconciliationCorrelationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.reconciliationCorrelationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.reconciliationCorrelationRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        // TODO 具体实现
        this.validation(reconciliationCorrelationVo);
    }

    private void updateValidation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        // TODO 具体实现
        this.validation(reconciliationCorrelationVo);
    }

    private void validation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        // TODO 具体实现
    }
}
