package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListFileEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationDocListFileRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationDocListFileEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationDocListFileLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListFileVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.util.*;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * TPM-对账单据文件(ReconciliationDocListFile)表服务实现类
 *
 * @author makejava
 * @date 2022-12-10 14:56:48
 */
@Slf4j
@Service("reconciliationDocListFileService")
public class ReconciliationDocListFileVoServiceImpl implements ReconciliationDocListFileVoService {

    @Autowired(required = false)
    private ReconciliationDocListFileRepository reconciliationDocListFileRepository;

    @Autowired(required = false)
    private List<ReconciliationDocListFileEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<ReconciliationDocListFileVo> findByConditions(Pageable pageable, ReconciliationDocListFileDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new ReconciliationDocListFileDto());
        Page<ReconciliationDocListFileVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.reconciliationDocListFileRepository.findByConditions(page, dto);
    }

    @Override
    public ReconciliationDocListFileVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        ReconciliationDocListFileEntity reconciliationDocListFile = this.reconciliationDocListFileRepository.findById(id);
        if (reconciliationDocListFile == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(reconciliationDocListFile, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class);
    }


    /**
     * 根据关联编码与文件类型查询文件详情vo
     * @param statementCode 关联编码
     * @param fileType 文件类型
     * @return 文件详情vo
     */
    @Override
    public ReconciliationDocListFileVo findDetailByStatementCodeAndFileType(String statementCode, String fileType) {
        if (StringUtils.isBlank(statementCode) || StringUtils.isBlank(fileType)) {
            return null;
        }
        ReconciliationDocListFileEntity reconciliationDocListFile = this.reconciliationDocListFileRepository.findDetailByStatementCodeAndFileType(statementCode,fileType);
        if (reconciliationDocListFile == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(reconciliationDocListFile, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class);

    }

    @Override
    @Transactional
    public ReconciliationDocListFileVo create(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.createValidation(reconciliationDocListFileVo);
        reconciliationDocListFileVo.setTenantCode(TenantUtils.getTenantCode());

        ReconciliationDocListFileEntity reconciliationDocListFile = nebulaToolkitService.copyObjectByWhiteList(reconciliationDocListFileVo, ReconciliationDocListFileEntity.class, HashSet.class, ArrayList.class);
        this.reconciliationDocListFileRepository.saveOrUpdate(reconciliationDocListFile);

        reconciliationDocListFileVo.setId(reconciliationDocListFile.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (ReconciliationDocListFileEventListener reconciliationDocListFileEventListener : eventListeners) {
                reconciliationDocListFileEventListener.onCreate(reconciliationDocListFileVo);
            }
        }

        // 发送通知
        ReconciliationDocListFileLogEventDto logEventDto = new ReconciliationDocListFileLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(reconciliationDocListFileVo);
        SerializableBiConsumer<ReconciliationDocListFileLogEventListener, ReconciliationDocListFileLogEventDto> onCreate =
                ReconciliationDocListFileLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, ReconciliationDocListFileLogEventListener.class, onCreate);
        return reconciliationDocListFileVo;
    }

    @Override
    @Transactional
    public ReconciliationDocListFileVo update(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.updateValidation(reconciliationDocListFileVo);
        String currentId = reconciliationDocListFileVo.getId();
        ReconciliationDocListFileEntity current = reconciliationDocListFileRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        ReconciliationDocListFileVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class);


        this.reconciliationDocListFileRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (ReconciliationDocListFileEventListener reconciliationDocListFileEventListener : eventListeners) {
                reconciliationDocListFileEventListener.onUpdate(oldVo,reconciliationDocListFileVo);
            }
        }

        // 发送修改通知
        ReconciliationDocListFileLogEventDto logEventDto = new ReconciliationDocListFileLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(reconciliationDocListFileVo);
        SerializableBiConsumer<ReconciliationDocListFileLogEventListener, ReconciliationDocListFileLogEventDto> onUpdate =
                ReconciliationDocListFileLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, ReconciliationDocListFileLogEventListener.class, onUpdate);
        return reconciliationDocListFileVo;
    }

    @Override
    public void createBatch(Set<ReconciliationDocListFileVo> files) {
        if (CollectionUtils.isEmpty(files)){
            return;
        }
        this.reconciliationDocListFileRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(files,ReconciliationDocListFileVo.class,ReconciliationDocListFileEntity.class,HashSet.class,ArrayList.class),10);
    }

    private void createValidation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        // TODO 具体实现
        this.validation(reconciliationDocListFileVo);
    }

    private void updateValidation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        // TODO 具体实现
        this.validation(reconciliationDocListFileVo);
    }

    private void validation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        // TODO 具体实现
    }
}
