package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.constant.ModalTypeEnum;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.service.TpmAccountReconciliationFactorService;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorColumnConfigVo;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl.AuditSubForAbstractReconciliation;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.*;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationFileTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationPdfService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.CustomXMLWorkerFontProvider;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.PdfUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.*;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd121Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 对账单据列表(ReconciliationDocListEntity)服务实现类
 *
 * @author xiaoyoujun
 * @date 2022年11月17日 14:19
 */
@Service
@Slf4j
public class ReconciliationPdfServiceImpl implements ReconciliationPdfService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private BaseElectronicSignature baseElectronicSignature;

    /**
     * 对账要素Service pdf生成模板
     */
    @Autowired(required = false)
    private TpmAccountReconciliationFactorService accountReconciliationFactorService;

    /**
     * TpmAccountReconciliationRule 列表
     */
    @Autowired(required = false)
    private TpmAccountReconciliationRuleService accountReconciliationRuleService;

    @Autowired(required = false)
    private Zmsd121Service zmsd121Service;

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Autowired(required = false)
    private FileHandleService fileHandleService;

    /**
     * 生成pdf
     *
     * @param reconciliationDocListVo                对账单vo
     * @param dataList                               数据列表
     * @param generateStrategy 生成策略
     */
    @Override
    public void generatePdf(ReconciliationDocListVo reconciliationDocListVo, List dataList,
                            AbstractReconciliationGenerateStrategy generateStrategy,
                            ReconciliationSummaryDataDisplayDto displayDto) {
        Validate.notNull(reconciliationDocListVo, "对账单据不能为空！！！");
        Validate.notNull(reconciliationDocListVo.getAccountReconciliationRuleCode(), "对账规则编码不能为空！！！");
        TpmAccountReconciliationRuleRespVo reconciliationRuleRespVo = this.accountReconciliationRuleService
                .findByCode(reconciliationDocListVo.getAccountReconciliationRuleCode());

        List<TpmAccountReconciliationRuleRFactorRespVo> respVoFactorList = reconciliationRuleRespVo.getFactorList();

        if (CollectionUtils.isEmpty(respVoFactorList)) {
            log.info("生成对账单：对账要素列表为空，跳过本次pdf生成");
            return;
        }
        // 对账要素编码集合
        Set<String> factorCodes = respVoFactorList.stream()
                .sorted(Comparator.comparing(TpmAccountReconciliationRuleRFactorRespVo::getOrderNum))
                .map(TpmAccountReconciliationRuleRFactorRespVo::getAccountReconciliationFactorCode).filter(Objects::nonNull)
                .collect(Collectors.toSet());

        Optional<List<TpmAccountReconciliationFactorRespVo>> factorServiceByCodes =
                Optional.ofNullable(accountReconciliationFactorService.findByCodes(factorCodes));
        // 头部
        Optional<TpmAccountReconciliationFactorRespVo> head = Optional.empty();

        // 汇总信息
        Optional<TpmAccountReconciliationFactorRespVo> summary = Optional.empty();

        // 签署栏
        Optional<TpmAccountReconciliationFactorRespVo> sign = Optional.empty();

        // 明细信息
        Optional<TpmAccountReconciliationFactorRespVo> detail = Optional.empty();

        // 尾部信息
        Optional<TpmAccountReconciliationFactorRespVo> tail = Optional.empty();

        if (factorServiceByCodes.isPresent()) {
            // 头部
            head = factorServiceByCodes.get().stream()
                    .filter(x -> ModalTypeEnum.HEAD.getCode().equals(x.getComponentName())).findFirst();

            // 汇总信息
            summary = factorServiceByCodes.get().stream()
                    .filter(x -> ModalTypeEnum.SUMMARY.getCode().equals(x.getComponentName())).findFirst();

            // 签署栏
            sign = factorServiceByCodes.get().stream()
                    .filter(x -> ModalTypeEnum.SIGN.getCode().equals(x.getComponentName())).findFirst();

            // 明细信息
            detail = factorServiceByCodes.get().stream()
                    .filter(x -> ModalTypeEnum.DETAIL.getCode().equals(x.getComponentName())).findFirst();

            // 尾部信息
            tail = factorServiceByCodes.get().stream()
                    .filter(x -> ModalTypeEnum.TAIL.getCode().equals(x.getComponentName())).findFirst();

        }

        log.info("生成对账单：pdf创建开始");
        File dir = new File(baseElectronicSignature.fileRoot);
        if (!dir.exists()) {
            log.info("生成对账单：pdf新建目录");
            dir.mkdirs();
        }

        File file = new File(baseElectronicSignature.fileRoot + "/" + reconciliationDocListVo.getStatementCode() + ".pdf");

        OutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
            document.open();

            // 设置头样式
            Font font = PdfUtil.createFont(23, Font.NORMAL, BaseColor.BLACK);
            Font colFont = PdfUtil.createFont(7, Font.NORMAL, BaseColor.BLACK);

            Paragraph paragraph = PdfUtil.createParagraph(
                    ReconciliationTypeEnum.getDesc(reconciliationDocListVo.getAccountReconciliationType()) + "单", font);
            paragraph.setAlignment(Element.ALIGN_CENTER);
            document.add(paragraph);
            // 创建pdf
            // 普通字体
            font = PdfUtil.createFont(13, Font.NORMAL, BaseColor.BLACK);
            // 加粗字体
            Font fontBold = PdfUtil.createFont(13, Font.BOLD, BaseColor.BLACK);
            log.info("生成对账单：pdf头部信息");
            if (head.isPresent()) {
                if (StrUtil.isNotEmpty(head.get().getFactorConfig())) {
                    inputStream =
                            new ByteArrayInputStream(head.get().getFactorConfig().getBytes(StandardCharsets.UTF_8));
                    XMLWorkerHelper.getInstance().parseXHtml(pdfWriter, document, inputStream,
                            Charset.forName(StandardCharsets.UTF_8.name()), new CustomXMLWorkerFontProvider());
                    document.add(PdfUtil.createParagraph("", font));
                }
            }
            log.info("生成对账单：pdf汇总信息");
            if (summary.isPresent()) {
                List<TpmAccountReconciliationFactorColumnConfigVo> configList = summary.get().getFactorConfigList();
                if (!CollectionUtils.isEmpty(configList)) {

                    // 表单头
                    List<String> fieldsNames =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName)
                                    .filter(Objects::nonNull).collect(Collectors.toList());

                    // 表单属性
                    List<String> fieldsCodes =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode)
                                    .filter(Objects::nonNull)
                                    .collect(Collectors.toList());

                    // 构建表单头
                    PdfPTable pdfPTable = PdfUtil.createPdfPTable(fieldsNames,generateStrategy.getBusinessType());
                    pdfPTable.setExtendLastRow(Boolean.TRUE, Boolean.FALSE);
                    fieldsNames.forEach(x -> {
                        PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(x, 1, 1, colFont);
                        pdfPCell.setNoWrap(Boolean.FALSE);
                        pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                        pdfPTable.addCell(pdfPCell);
                    });


                    // 构建表单值
                    if (!CollectionUtils.isEmpty(dataList)
                            && !CollectionUtils.isEmpty(fieldsCodes)) {
                        if (ReconciliationTypeEnum.COMMUNICATION.getCode()
                                .equals(generateStrategy.getReconciliationType())) {
                            //分子往来对账
                            log.info("分子往来对账");
                            LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = buildSapForReconciliation(dataList);
                            //保留2位小数
                            linkedHashMap.forEach((k,v) -> {
                                v.setAmount(formatBigDecimal(v.getAmount()));
                            });
                            //汇总信息保存
                            buildReconciliationSummaryDataDisplayCommunication(linkedHashMap, displayDto, dataList);
                            for (Map.Entry<String, SapForReconciliationPdfHeadVo> entry : linkedHashMap.entrySet()) {
                                List<SapForReconciliationPdfHeadVo> pdfHeadVos = new ArrayList<>();
                                pdfHeadVos.add(entry.getValue());
                                fieldsCodes.forEach(code -> {
                                    // 转换表单
                                    String convert = generateStrategy.convertHead(code, pdfHeadVos);
                                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                    pdfPCell.setNoWrap(Boolean.FALSE);
                                    pdfPTable.addCell(pdfPCell);
                                });
                            }
                        } else if (ReconciliationTypeEnum.CLOSURE.getCode()
                                .equals(generateStrategy.getReconciliationType())
                                && ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode()
                                .equals(generateStrategy.getBusinessType())) {
                            //分子结案对账
                            //查询zmsd121数据
                            String startDate = com.biz.crm.mn.common.base.util.DateUtil.format(reconciliationDocListVo.getStartDate(), "yyyyMMdd");
                            String endDate = com.biz.crm.mn.common.base.util.DateUtil.format(reconciliationDocListVo.getEndDate(), "yyyyMMdd");
                            String ds = AuditSubForAbstractReconciliation.get121Ds(reconciliationDocListVo.getStartDate());
                            String customerCode = reconciliationDocListVo.getCustomerCode() + "-" + reconciliationDocListVo.getSalesInstitutionErpCode();
                            List<TpmZmsd121Vo> zmsd121VoList = zmsd121Service.findListByDate(startDate, endDate, customerCode, ds);
                            if (CollectionUtils.isEmpty(zmsd121VoList)) {
                                return;
                            }
                            TpmZmsd121Vo zmsd121Vo = zmsd121VoList.get(0);
                            LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = buildAuditSubForReconciliation(zmsd121Vo, dataList);
                            //保留2位小数
                            linkedHashMap.forEach((k,v) -> {
                                v.setAmount(formatBigDecimal(v.getAmount()));
                            });
                            buildReconciliationSummaryDataDisplaySubClosure(linkedHashMap, displayDto, dataList);
                            for (Map.Entry<String, SapForReconciliationPdfHeadVo> entry : linkedHashMap.entrySet()) {
                                List<SapForReconciliationPdfHeadVo> pdfHeadVos = new ArrayList<>();
                                pdfHeadVos.add(entry.getValue());
                                fieldsCodes.forEach(code -> {
                                    // 转换表单
                                    String convert = generateStrategy.convertHead(code, pdfHeadVos);
                                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                    pdfPCell.setNoWrap(Boolean.FALSE);
                                    pdfPTable.addCell(pdfPCell);
                                });
                            }
                        } else if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.APPROVAL.getCode())
                                && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode())) {
                            //分子批复对账
                            LinkedHashMap<String, ReplySubReconciliationHeadVo> linkedHashMap = buildReplySubForReconciliation(dataList);
                            //保留2位小数
                            linkedHashMap.forEach((k,v) -> {
                                v.setAmount(formatBigDecimal(v.getAmount()));
                            });
                            buildReconciliationSummaryDataDisplaySubApproval(linkedHashMap, displayDto, dataList);
                            //转换表单
                            List<Object> headVoList = new ArrayList<>();
                            for (Map.Entry<String, ReplySubReconciliationHeadVo> entry : linkedHashMap.entrySet()) {
                                headVoList.add(entry.getValue());
                                fieldsCodes.forEach(code -> {
                                    String convert = generateStrategy.convertHead(code, headVoList);
                                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                    pdfPCell.setNoWrap(Boolean.FALSE);
                                    pdfPTable.addCell(pdfPCell);
                                });
                                headVoList.clear();
                            }
                        } else if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.DISTRIBUTION.getCode())
                                && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.AUDIT.getCode())) {
                            //分销对账
                            log.info("分销对账");
                            LinkedHashMap<String, String> linkedHashMap = buildDistributionReconciliation(dataList);
                            displayDto.setDistributionReconciliationHeadMap(linkedHashMap);
                            //转换表单
                            fieldsCodes.forEach(code -> {
                                String convert = linkedHashMap.get(code);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                pdfPCell.setNoWrap(Boolean.FALSE);
                                pdfPTable.addCell(pdfPCell);
                            });
                        } else {

                            //主体结案构建汇总信息
                            if (StringUtils.equals(ReconciliationTypeEnum.CLOSURE.getCode(), generateStrategy.getReconciliationType())
                                    && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.DETAIL.getCode())) {
                                buildReconciliationSummaryDataDisplayAuditClosure(displayDto, dataList);
                            }

                            //主体批复构建汇总信息
                            if (StringUtils.equals(ReconciliationTypeEnum.APPROVAL.getCode(), generateStrategy.getReconciliationType())
                                    && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.DETAIL.getCode())) {
                                buildReconciliationSummaryDataDisplayApprove(displayDto, dataList);
                            }

                            fieldsCodes.forEach(code -> {
                                // 转换表单
                                String convert = generateStrategy.convertHead(code, dataList);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                //自动换行
                                pdfPCell.setNoWrap(Boolean.FALSE);

                                pdfPTable.addCell(pdfPCell);
                            });
                        }
                    }

                    document.add(pdfPTable);

                    document.add(PdfUtil.createParagraph("", font));
                }

            }

            log.info("生成对账单：pdf签署栏");
            if (sign.isPresent()) {
                if (ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode()
                        .equals(generateStrategy.getBusinessType())) {
                    
                    if (StrUtil.isNotEmpty(sign.get().getFactorConfig())) {
                        inputStream =
                                new ByteArrayInputStream(sign.get().getFactorConfig().getBytes(StandardCharsets.UTF_8));
                        XMLWorkerHelper.getInstance().parseXHtml(pdfWriter, document, inputStream,
                                Charset.forName(StandardCharsets.UTF_8.name()), new CustomXMLWorkerFontProvider());
                        document.add(PdfUtil.createParagraph("", font));
                    }
                    document.add(PdfUtil.createParagraph("", font));

                    PdfPTable table3 = new PdfPTable(2);
                    int[] width3 = {80, 55};
                    table3.setWidths(width3);
                    PdfPCell cell = new PdfPCell(new Paragraph("客户签字并盖章：", font));
                    PdfPCell cell1 = new PdfPCell(new Paragraph("签字盖章时间：", font));
                    cell.setBorder(0);
                    cell1.setBorder(0);
                    table3.addCell(cell);
                    table3.addCell(cell1);
                    document.add(table3);
                }else {
                    PdfPTable table3 = new PdfPTable(2);
                    int[] width3 = {80, 55};
                    table3.setWidths(width3);
                    PdfPCell cell = new PdfPCell(new Paragraph("客户签字并盖章：", fontBold));
                    PdfPCell cell1 = new PdfPCell(new Paragraph("签字盖章时间：", fontBold));
                    cell.setBorder(0);
                    cell1.setBorder(0);
                    table3.addCell(cell);
                    table3.addCell(cell1);
                    document.add(table3);
                }


                // 设置空行
                document.add(PdfUtil.createParagraph("", font));
                document.add(PdfUtil.createParagraph("", font));
            }

            log.info("生成对账单：pdf明细信息");
            if (detail.isPresent()) {
                List<TpmAccountReconciliationFactorColumnConfigVo> configList = detail.get().getFactorConfigList();
                if (!CollectionUtils.isEmpty(configList)) {

                    // 表单头
                    List<String> fieldsNames =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName)
                                    .filter(Objects::nonNull).collect(Collectors.toList());

                    // 表单属性
                    List<String> fieldsCodes =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode)
                                    .filter(Objects::nonNull).collect(Collectors.toList());

                    PdfPTable pdfPTable = PdfUtil.createPdfPTable(fieldsNames);
                    PdfPCell cell = PdfUtil.createCenterPdfPCell("对账明细：", 1, fieldsNames.size(), fontBold);
                    cell.setBorder(0);
                    cell.setHorizontalAlignment(Element.ALIGN_LEFT);
                    pdfPTable.addCell(cell);
                    pdfPTable.setExtendLastRow(Boolean.TRUE, Boolean.FALSE);

                    fieldsNames.forEach(x -> {
                        PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(x, 1, 1, colFont);
                        pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                        pdfPTable.addCell(pdfPCell);
                    });

                    if (!CollectionUtils.isEmpty(dataList) && !CollectionUtils.isEmpty(fieldsCodes)) {
                        log.info("开始构建明细");
                        for (Object obj : dataList) {


                            if (ReconciliationTypeEnum.CLOSURE.getCode()
                                    .equals(generateStrategy.getReconciliationType())
                                    && ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode()
                                    .equals(generateStrategy.getBusinessType())) {

                                AuditCustomerDetailCollectionVo data = (AuditCustomerDetailCollectionVo) obj;

                                if (StringUtils.equals(AuditFormEnum.EXPENSE.getCode(), data.getEndCaseForm())
                                        || StringUtils.equals(AuditFormEnum.RED_INVOICE.getCode(), data.getEndCaseForm())) {
                                    if (!UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(data.getReimburseUpAccountStatus())) {
                                        continue;
                                    }
                                }else if (StringUtils.equals(AuditFormEnum.DISCOUNT.getCode(), data.getEndCaseForm())
                                        || StringUtils.equals(AuditFormEnum.ORDER.getCode(), data.getEndCaseForm())) {
                                    if (!UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(data.getUpAccountStatus())) {
                                        continue;
                                    }
                                }else {
                                    continue;
                                }


                                fieldsCodes.forEach(code -> {
                                    // 转换表单属性值
                                    if (generateStrategy != null) {
                                        String convert = generateStrategy.convert(code, data);
                                        PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                        pdfPTable.addCell(pdfPCell);
                                    }
                                });


                            }else {
                                log.info("生产对账单4");

                                fieldsCodes.forEach(code -> {
                                    // 转换表单属性值
                                    if (generateStrategy != null) {
                                        String convert = generateStrategy.convert(code, obj);
                                        PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                        pdfPTable.addCell(pdfPCell);
                                    }
                                });
                            }


                        }
                    }
                    document.add(pdfPTable);
                }
            }

            log.info("生成对账单：pdf尾部信息");
            if (tail.isPresent()) {
                List<TpmAccountReconciliationFactorColumnConfigVo> configList = tail.get().getFactorConfigList();
                if (!CollectionUtils.isEmpty(configList)) {
                    // 表单头
                    List<String> fieldsNames =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName)
                                    .filter(Objects::nonNull).collect(Collectors.toList());

                    // 表单属性
                    List<String> fieldsCodes =
                            configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode)
                                    .filter(Objects::nonNull).collect(Collectors.toList());

                    // 构建表单头
                    PdfPTable pdfPTable = PdfUtil.createPdfPTable(fieldsNames,generateStrategy.getBusinessType());
                    pdfPTable.setExtendLastRow(Boolean.TRUE, Boolean.FALSE);
                    fieldsNames.forEach(x -> {
                        PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(x, 1, 1, colFont);
                        pdfPCell.setNoWrap(Boolean.FALSE);
                        pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                        pdfPTable.addCell(pdfPCell);
                    });

                    // 构建表单值
                    if (!CollectionUtils.isEmpty(dataList) && !CollectionUtils.isEmpty(fieldsCodes)) {
                        log.info("开始构建尾部");
                        if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.DISTRIBUTION.getCode())
                                && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.AUDIT.getCode())) {
                            //尾部
                            LinkedHashMap<String, String> map = displayDto.getDistributionReconciliationHeadMap();
                            generateStrategy.convertTail(map);

                            //转换表单
                            fieldsCodes.forEach(code -> {
                                String convert = map.get(code);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell(convert, 1, 1, colFont);
                                pdfPCell.setNoWrap(Boolean.FALSE);
                                pdfPTable.addCell(pdfPCell);
                            });
                        }
                    }

                    document.add(pdfPTable);

                    document.add(PdfUtil.createParagraph("", font));
                }
            }

            document.close();
            log.info("生成对账单：pdf写入结束");
        } catch (DocumentException | IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
//                if (Objects.nonNull(document)) {
//                    document.close();
//                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("生成对账单：pdf上传");
        // 上传到文件服务器
        byte[] fileByte = new byte[(int) file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null,
                    reconciliationDocListVo.getStatementCode() + ".pdf", fileByte);
            Validate.notNull(ordinaryFileVo, "对账单文件生成失败!!! 编码：[%s]", reconciliationDocListVo.getStatementCode());
            ReconciliationDocListFileVo reconciliationDocListFileVo = new ReconciliationDocListFileVo();
            reconciliationDocListFileVo.setFileType(ReconciliationFileTypeEnum.BO_ZHI.getCode());
            reconciliationDocListFileVo.setFileCode(ordinaryFileVo.getId());
            reconciliationDocListFileVo.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            reconciliationDocListFileVo.setStatementCode(reconciliationDocListVo.getStatementCode());
            reconciliationDocListVo.setFiles(Lists.newArrayList(reconciliationDocListFileVo));
        } catch (IOException e) {
            log.info("生成对账单：pdf上传异常：" + e.getMessage());
            throw new RuntimeException(e);
        } finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        // 删除文件
        boolean delete = file.delete();
        if (delete) {
            log.info("文件删除成功,{}", file.getName());
        } else {
            // todo
            log.error("文件删除失败,{}", file.getName());
        }

    }

    private LinkedHashMap<String, String> buildDistributionReconciliation(List<Object> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new LinkedHashMap<>();
        }
        log.info("分销对账共【"+ dataList.size() +"】条");
        LinkedHashMap<String, String> headVoMap = new LinkedHashMap<>();

        List<DistributionReconciliationAuditVo> planItemVos = (List<DistributionReconciliationAuditVo>) (List) dataList;

        Integer monthSaleQuantity = 0;
        BigDecimal monthSaleAmount = BigDecimal.ZERO;
        BigDecimal auditQuantity = BigDecimal.ZERO;
        Integer boundGiftSaleQuantity = 0;
        Integer baseQuantity = 0;
        BigDecimal combinationFee = BigDecimal.ZERO;
        BigDecimal distributionBaseTen = BigDecimal.ZERO;
        BigDecimal goalAchievement = BigDecimal.ZERO;
        BigDecimal month = BigDecimal.ZERO;
        BigDecimal staffFee = BigDecimal.ZERO;
        Integer logisticsQuantity = 0;
        BigDecimal logistics = BigDecimal.ZERO;
        BigDecimal quarter = BigDecimal.ZERO;
        BigDecimal otherCooperation = BigDecimal.ZERO;
        BigDecimal otherCooperationTwo = BigDecimal.ZERO;
        BigDecimal fine = BigDecimal.ZERO;
        BigDecimal lastMonthAccount = BigDecimal.ZERO;
        BigDecimal staffLogistics = BigDecimal.ZERO;
        BigDecimal monthAccount = BigDecimal.ZERO;
        for (DistributionReconciliationAuditVo vo : planItemVos) {
            combinationFee = combinationFee.add(vo.getCombinationFee());
            distributionBaseTen = distributionBaseTen.add(vo.getDistributionBaseTen());
            goalAchievement = goalAchievement.add(vo.getGoalAchievement());
            month = month.add(vo.getMonth());
            staffFee = staffFee.add(vo.getStaffFee());
            logistics = logistics.add(vo.getLogistics());
            quarter = quarter.add(vo.getQuarter());
            otherCooperation = otherCooperation.add(vo.getOtherCooperation());
            otherCooperationTwo = otherCooperationTwo.add(vo.getOtherCooperationTwo());
            fine = fine.add(vo.getFine());

            monthSaleQuantity += vo.getMonthSaleQuantity();
            monthSaleAmount = monthSaleAmount.add(vo.getMonthSaleAmount());
            auditQuantity = auditQuantity.add(vo.getAuditQuantity());
            boundGiftSaleQuantity += vo.getBoundGiftSaleQuantity();
            baseQuantity += vo.getBaseQuantity();

            lastMonthAccount = lastMonthAccount.add(vo.getLastMonthAccount());
            staffLogistics = staffLogistics.add(vo.getStaffLogistics());
            monthAccount = monthAccount.add(vo.getMonthAccount());

            logisticsQuantity += vo.getLogisticsQuantity();
        }
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.year_month.getCode(), planItemVos.get(0).getYearMonth());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_code.getCode(), planItemVos.get(0).getSapCustomerCode());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_name.getCode(), planItemVos.get(0).getCustomerName());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_sale_quantity.getCode(), monthSaleQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_sale_amount.getCode(), monthSaleAmount.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.audit_quantity.getCode(), auditQuantity.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.bound_gift_sale_quantity.getCode(), boundGiftSaleQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.base_quantity.getCode(), baseQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.combination_fee.getCode(), combinationFee.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.distribution_base_ten.getCode(), distributionBaseTen.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.goal_achievement.getCode(), goalAchievement.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month.getCode(), month.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_fee.getCode(), staffFee.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.logistics_quantity.getCode(), logisticsQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.logistics.getCode(), logistics.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.quarter.getCode(), quarter.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.other_cooperation.getCode(), otherCooperation.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.other_cooperation_two.getCode(), otherCooperationTwo.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.fine.getCode(), fine.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.last_month_account.getCode(), lastMonthAccount.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_logistics.getCode(), staffLogistics.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_account.getCode(), monthAccount.toPlainString());
        return headVoMap;
    }

    /**
     * 往来对账汇总信息保存
     *
     * @param linkedHashMap
     */
    private void buildReconciliationSummaryDataDisplayCommunication(LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {

        //构建明细
        if (!CollectionUtils.isEmpty(dataList)) {
            List<SapReconciliationVo> sapReconciliationVos = (List<SapReconciliationVo>) dataList;
            List<ReconciliationSummaryDataDisplayDetailSubCommunicateDto> communicateDtos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubCommunicateDto>) this.nebulaToolkitService.copyCollectionByWhiteList(sapReconciliationVos, SapReconciliationVo.class, ReconciliationSummaryDataDisplayDetailSubCommunicateDto.class, HashSet.class, ArrayList.class);
            communicateDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubCommunicateDtos(communicateDtos);
        }

        //期初余额
        SapForReconciliationPdfHeadVo headVo = linkedHashMap.get(ReconciliationConstant.BEGIN_PERIOD_BALANCE);
        if (Objects.nonNull(headVo)) {
            displayDto.setBeginPeriodBalance(Optional.ofNullable(headVo.getAmount()).orElse(BigDecimal.ZERO).negate());
        }

        //本期回款
        SapForReconciliationPdfHeadVo headVo1 = linkedHashMap.get(ReconciliationConstant.THIS_PERIOD_BACK_MONEY);
        if (Objects.nonNull(headVo1)) {
            displayDto.setThisPeriodBackMoney(headVo1.getAmount());
        }


        //费用报销上账
        SapForReconciliationPdfHeadVo headVo2 = linkedHashMap.get(ReconciliationConstant.EXPENSE_REIMBURSE_UP_ACCOUNT);
        if (Objects.nonNull(headVo2)) {
            displayDto.setExpenseReimburseUpAccount(headVo2.getAmount());
        }


        //本期销售折扣
        SapForReconciliationPdfHeadVo headVo3 = linkedHashMap.get(ReconciliationConstant.THIS_PERIOD_STOCK_IN_AMOUNT);
        if (Objects.nonNull(headVo3)) {
            displayDto.setThisPeriodStockInAmount(headVo3.getAmount());
        }


        //本期进货金额
        SapForReconciliationPdfHeadVo headVo4 = linkedHashMap.get(ReconciliationConstant.THIS_PERIOD_SALES_DISCOUNT);
        if (Objects.nonNull(headVo4)) {
            displayDto.setThisPeriodSalesDiscount(headVo4.getAmount());
        }


        //期末余额
        SapForReconciliationPdfHeadVo headVo5 = linkedHashMap.get(ReconciliationConstant.END_PERIOD_BALANCE);
        if (Objects.nonNull(headVo5)) {
            displayDto.setEndPeriodBalance(Optional.ofNullable(headVo5.getAmount()).orElse(BigDecimal.ZERO).negate());
        }


        //保证金金额
        SapForReconciliationPdfHeadVo headVo6 = linkedHashMap.get(ReconciliationConstant.EARNEST_MONEY);
        if (Objects.nonNull(headVo6)) {
            displayDto.setEarnestMoney(headVo6.getAmount());
        }

    }

    /**
     * 分子结案汇总信息保存
     *
     * @param linkedHashMap
     */
    private void buildReconciliationSummaryDataDisplaySubClosure(LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {

        //构建明细
        if (!CollectionUtils.isEmpty(dataList)) {
            List<AuditCustomerDetailCollectionVo> auditList = (List<AuditCustomerDetailCollectionVo>) dataList;
            List<ReconciliationSummaryDataDisplayDetailSubAuditDto> detailSubAuditDtos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubAuditDto>) this.nebulaToolkitService.copyCollectionByWhiteList(auditList, AuditCustomerDetailCollectionVo.class, ReconciliationSummaryDataDisplayDetailSubAuditDto.class, HashSet.class, ArrayList.class);
            detailSubAuditDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubAuditDtos(detailSubAuditDtos);
        }

        //事中费用合计
        SapForReconciliationPdfHeadVo headVo = linkedHashMap.get(ReconciliationConstant.IN_PROCESS_EXPENSE_TOTAL);
        if (Objects.nonNull(headVo)) {
            displayDto.setInProcessExpenseTotal(headVo.getAmount());
        }

        //其他核对项
        SapForReconciliationPdfHeadVo headVo1 = linkedHashMap.get(ReconciliationConstant.OTHER_CHECK_ITEM);
        if (Objects.nonNull(headVo1)) {
            displayDto.setOtherCheckItem(headVo1.getAmount());
        }


        //期初折扣池余额
        SapForReconciliationPdfHeadVo headVo2 = linkedHashMap.get(ReconciliationConstant.BEGIN_PERIOD_DISCOUNT_POOL_BALANCE);
        if (Objects.nonNull(headVo2)) {
            displayDto.setBeginPeriodDiscountPoolBalance(headVo2.getAmount());
        }


        //本月应处理费用
        SapForReconciliationPdfHeadVo headVo3 = linkedHashMap.get(ReconciliationConstant.THIS_MONTH_SHOULD_HANDLE_AMOUNT);
        if (Objects.nonNull(headVo3)) {
            displayDto.setThisMonthShouldHandleAmount(headVo3.getAmount());
        }


        //本月实际折扣金额
        SapForReconciliationPdfHeadVo headVo4 = linkedHashMap.get(ReconciliationConstant.THIS_MONTH_ACTUAL_DISCOUNT_AMOUNT);
        if (Objects.nonNull(headVo4)) {
            displayDto.setThisMonthActualDiscountAmount(headVo4.getAmount());
        }


        //本月发票报销金额
        SapForReconciliationPdfHeadVo headVo5 = linkedHashMap.get(ReconciliationConstant.THIS_MONTH_INVOICE_REIMBURSE_AMOUNT);
        if (Objects.nonNull(headVo5)) {
            displayDto.setThisMonthInvoiceReimburseAmount(headVo5.getAmount());
        }

        //期末费用池余额
        SapForReconciliationPdfHeadVo headVo6 = linkedHashMap.get(ReconciliationConstant.END_PERIOD_FEE_POOL_BALANCE);
        if (Objects.nonNull(headVo6)) {
            displayDto.setEndPeriodFeePoolBalance(headVo6.getAmount());
        }

        //费用转移
        SapForReconciliationPdfHeadVo headVo7 = linkedHashMap.get(ReconciliationConstant.COST_TRANSFER);
        if (Objects.nonNull(headVo7)) {
            displayDto.setCostTransfer(headVo7.getAmount());
        }

    }

    /**
     * 分子批复汇总信息保存
     *
     * @param linkedHashMap
     */
    private void buildReconciliationSummaryDataDisplaySubApproval(LinkedHashMap<String, ReplySubReconciliationHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {

        //构建明细
        if (!CollectionUtils.isEmpty(dataList)) {
            List<SubComActivityDetailPlanItemVo> planItemVos = (List<SubComActivityDetailPlanItemVo>) dataList;
            List<ReconciliationSummaryDataDisplayDetailSubApproveDto> detailSubApproveDtos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubApproveDto>) this.nebulaToolkitService.copyCollectionByWhiteList(planItemVos, SubComActivityDetailPlanItemVo.class, ReconciliationSummaryDataDisplayDetailSubApproveDto.class, HashSet.class, ArrayList.class);
            detailSubApproveDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubApproveDtos(detailSubApproveDtos);
        }

        //批复合计金额
        ReplySubReconciliationHeadVo headVo = linkedHashMap.get(ReconciliationConstant.APPROVE_TOTAL_AMOUNT);
        if (Objects.nonNull(headVo)) {
            displayDto.setThisPeriodHandleAmount(headVo.getAmount());
        }

        //其他核对项
        ReplySubReconciliationHeadVo headVo1 = linkedHashMap.get(ReconciliationConstant.OTHER_CHECK_ITEM);
        if (Objects.nonNull(headVo1)) {
            displayDto.setOtherCheckItem(headVo1.getAmount());
        }


        //期初折扣池余额
        ReplySubReconciliationHeadVo headVo2 = linkedHashMap.get(ReconciliationConstant.BEGIN_PERIOD_DISCOUNT_POOL_BALANCE);
        if (Objects.nonNull(headVo2)) {
            displayDto.setBeginPeriodDiscountPoolBalance(headVo2.getAmount());
        }


    }

    /**
     * 主体结案汇总构建
     *
     * @param displayDto
     * @param dataList
     */
    private void buildReconciliationSummaryDataDisplayAuditClosure(ReconciliationSummaryDataDisplayDto displayDto, List dataList) {

        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }

        List<AuditCustomerDetailCollectionVo> customerDetailCollectionVos = (List<AuditCustomerDetailCollectionVo>) dataList;
        List<ReconciliationSummaryDataDisplayDetailHeadAuditDto> detailHeadAuditDtos = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadAuditDto>) this.nebulaToolkitService.copyCollectionByWhiteList(customerDetailCollectionVos, AuditCustomerDetailCollectionVo.class, ReconciliationSummaryDataDisplayDetailHeadAuditDto.class, HashSet.class, ArrayList.class);
        detailHeadAuditDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
        displayDto.setDetailHeadAuditDtos(detailHeadAuditDtos);

        //报销合计金额   过滤结案形式包含“报销”且报销上账状态为已上账的所有数据
        customerDetailCollectionVos = customerDetailCollectionVos.stream()
                .filter(c -> !(StringUtils.isNotBlank(c.getEndCaseForm())
                                && c.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())
                                && UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatus())))
                .collect(Collectors.toList());
        BigDecimal promotionTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull)
                .map(AuditCustomerDetailCollectionVo::getReimburseTaxAmount).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //折扣合计金额(汇总入费用池金额) 过滤结案形式包含“折扣”的所有数据
        customerDetailCollectionVos = customerDetailCollectionVos.stream()
                .filter(b -> !(StringUtils.isNotBlank(b.getEndCaseForm())
                        && b.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())))
                .collect(Collectors.toList());
        BigDecimal discountTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull)
                .map(AuditCustomerDetailCollectionVo::getDiscountAmount).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //随车金额(本次结案金额) 过滤结案形式=“随单”的所有数据
        customerDetailCollectionVos = customerDetailCollectionVos.stream()
                .filter(c -> !(StringUtils.isNotBlank(c.getEndCaseForm())
                        && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())))
                .collect(Collectors.toList());
        BigDecimal followCarAmount = customerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getThisAuditAmount)
                .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        //考核扣款金额
        BigDecimal examineCircularAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount())
                .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        //合计金额
        BigDecimal totalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> {
            BigDecimal reimburseTaxAmount = Objects.isNull(x.getReimburseTaxAmount()) ? BigDecimal.ZERO : x.getReimburseTaxAmount();
            BigDecimal discountTaxAmount = Objects.isNull(x.getDiscountTaxAmount()) ? BigDecimal.ZERO : x.getDiscountTaxAmount();
            BigDecimal auditAmount = Objects.nonNull(x.getAuditAmount()) && ReconciliationConstant.TEMPLATE_TYPE.equals(x.getActivityFormCode()) ? x.getAuditAmount() : BigDecimal.ZERO;
            BigDecimal examineCircularAmount1 = Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount();
            return NumberUtil.add(NumberUtil.add(reimburseTaxAmount, discountTaxAmount), NumberUtil.add(auditAmount, examineCircularAmount1));
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        displayDto.setPromotionTotalAmount(promotionTotalAmount);
        displayDto.setDiscountTotalAmount(discountTotalAmount);
        displayDto.setPromotionAndDiscountTotalAmount(promotionTotalAmount.add(discountTotalAmount));
        displayDto.setFollowCarAmount(followCarAmount);
        displayDto.setExamineCircularAmount(examineCircularAmount);
        displayDto.setTotalAmount(totalAmount);
    }

    /**
     * 主体批复汇总构建
     *
     * @param displayDto
     * @param dataList
     */
    private void buildReconciliationSummaryDataDisplayApprove(ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }

        List<ActivityDetailPlanItemVo> itemVos = (List<ActivityDetailPlanItemVo>) dataList;
        List<ReconciliationSummaryDataDisplayDetailHeadApproveDto> detailHeadApproveDtos = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadApproveDto>) this.nebulaToolkitService.copyCollectionByWhiteList(itemVos, ActivityDetailPlanItemVo.class, ReconciliationSummaryDataDisplayDetailHeadApproveDto.class, HashSet.class, ArrayList.class);
        detailHeadApproveDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
        displayDto.setDetailHeadApproveDtos(detailHeadApproveDtos);

        //本月费用合计金额
        BigDecimal thisMonthFeeTotalAmount = itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemVo::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        //本月费用申请金额
        BigDecimal thisMonthFeeApplyAmount = itemVos.stream().filter(Objects::nonNull).map(x -> NumberUtil.add(x.getDepartmentFeeAmount(), x.getHeadFeeAmount())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        //本月客户承担合计金额
        BigDecimal thisMonthCustomerBearTotalAmount = itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemVo::getCustomerFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);

        displayDto.setThisMonthFeeTotalAmount(thisMonthFeeTotalAmount);
        displayDto.setThisMonthFeeApplyAmount(thisMonthFeeApplyAmount);
        displayDto.setThisMonthCustomerBearTotalAmount(thisMonthCustomerBearTotalAmount);

    }

    /**
     * 构建往来对账需要的数据接口
     */
    private LinkedHashMap<String, SapForReconciliationPdfHeadVo> buildSapForReconciliation(List<Object> dataList) {
        List<SapReconciliationVo> sapReconciliationVos = (List<SapReconciliationVo>) (List) dataList;
        LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = new LinkedHashMap<>();

        BigDecimal firstAmt = BigDecimal.ZERO;
        BigDecimal twoAmt = BigDecimal.ZERO;
        BigDecimal threeAmt = BigDecimal.ZERO;
        BigDecimal fourAmt = BigDecimal.ZERO;
        BigDecimal fiveAmt = BigDecimal.ZERO;
        BigDecimal sixAmt = BigDecimal.ZERO;
        for (SapReconciliationVo vo : sapReconciliationVos) {
            if (!StringUtils.isBlank(vo.getZfkfs())) {

                if (vo.getZfkfs().contains("银行存款")
                        || vo.getZfkfs().contains("银行承兑")
                        || vo.getZfkfs().contains("转款")) {

                    BigDecimal conZsh = this.amountCharTransfer(vo.getZsh());
                    twoAmt = twoAmt.add(conZsh);
                }
                if (vo.getZfkfs().contains("费用报销")) {
                    BigDecimal conZsh = this.amountCharTransfer(vo.getZsh());
                    threeAmt = threeAmt.add(conZsh);
                }
            }

            if("总计".equals(vo.getZdocName())) {
                fourAmt = fourAmt.add(amountCharTransfer(vo.getKzwi1()));
                fiveAmt = fiveAmt.add(amountCharTransfer(vo.getKzwi6()));
            }
            if (StringUtils.isNotEmpty(vo.getZdocName()) && vo.getZdocName().equals("期初")) {
                firstAmt = amountCharTransfer(vo.getZysye());
            }
            if (StringUtils.isNotEmpty(vo.getZdocName()) && vo.getZdocName().equals("总计")) {
                sixAmt = amountCharTransfer(vo.getZysye());
            }
        }

        //期初余额 单据名称为 ‘期初’ 的应收余额
        SapForReconciliationPdfHeadVo one = new SapForReconciliationPdfHeadVo();
        one.setName(ReconciliationConstant.BEGIN_PERIOD_BALANCE);
        one.setIndex("1");
        one.setAmount(firstAmt);
        linkedHashMap.put(ReconciliationConstant.BEGIN_PERIOD_BALANCE, one);
        //本期贷款金额 -- 付款方式为：银行存款、银行承兑、转款的实收金额总计
        SapForReconciliationPdfHeadVo two = new SapForReconciliationPdfHeadVo();
        two.setName(ReconciliationConstant.THIS_PERIOD_BACK_MONEY);
        two.setIndex("2");
        two.setAmount(twoAmt);
        linkedHashMap.put(ReconciliationConstant.THIS_PERIOD_BACK_MONEY, two);
        //费用报销上账 付款方式为：费用报销的实收金额汇总
        SapForReconciliationPdfHeadVo three = new SapForReconciliationPdfHeadVo();
        three.setName(ReconciliationConstant.EXPENSE_REIMBURSE_UP_ACCOUNT);
        three.setIndex("3");
        three.setAmount(threeAmt);
        linkedHashMap.put(ReconciliationConstant.EXPENSE_REIMBURSE_UP_ACCOUNT, three);
        //本期进货金额 应收金额总计
        SapForReconciliationPdfHeadVo four = new SapForReconciliationPdfHeadVo();
        four.setName(ReconciliationConstant.THIS_PERIOD_STOCK_IN_AMOUNT);
        four.setIndex("4");
        four.setAmount(fourAmt);
        linkedHashMap.put(ReconciliationConstant.THIS_PERIOD_STOCK_IN_AMOUNT, four);
        //本期销售折扣 折扣金额总计
        SapForReconciliationPdfHeadVo five = new SapForReconciliationPdfHeadVo();
        five.setName(ReconciliationConstant.THIS_PERIOD_SALES_DISCOUNT);
        five.setIndex("5");
        five.setAmount(fiveAmt);
        linkedHashMap.put(ReconciliationConstant.THIS_PERIOD_SALES_DISCOUNT, five);
        //期末余额 单据名称为 ‘总计’ 的应收余额
        SapForReconciliationPdfHeadVo six = new SapForReconciliationPdfHeadVo();
        six.setName(ReconciliationConstant.END_PERIOD_BALANCE);
        six.setIndex("6");
        six.setAmount(sixAmt);
        linkedHashMap.put(ReconciliationConstant.END_PERIOD_BALANCE, six);
        //保证金金额
        BigDecimal sevenAmt = BigDecimal.ZERO;
        /*for(SapReconciliationVo vo : sapReconciliationVos){
            sixAmt = sixAmt.add(vo.getZysye() == null ? new BigDecimal(vo.getZysye()) : BigDecimal.ZERO);
        }*/
        SapForReconciliationPdfHeadVo seven = new SapForReconciliationPdfHeadVo();
        seven.setName(ReconciliationConstant.EARNEST_MONEY);
        seven.setIndex("7");
        seven.setAmount(sevenAmt);
        linkedHashMap.put(ReconciliationConstant.EARNEST_MONEY, seven);

        return linkedHashMap;
    }

    private BigDecimal amountCharTransfer(String sapAmount) {
        if (StringUtils.isNotBlank(sapAmount)) {
            //sap数据金额后面可能有空格
            sapAmount = sapAmount.trim();
            if (sapAmount.contains(ReconciliationConstant.SHORT_LINE)) {
                return new BigDecimal(ReconciliationConstant.SHORT_LINE + sapAmount.replace(ReconciliationConstant.SHORT_LINE, StringUtils.EMPTY));
            } else {
                return new BigDecimal(sapAmount);
            }
        }
        return BigDecimal.ZERO;
    }

    /**
     * 分子结案对账
     *
     * @param zmsd121Vo
     * @param dataList
     */
    private LinkedHashMap<String, SapForReconciliationPdfHeadVo> buildAuditSubForReconciliation(TpmZmsd121Vo zmsd121Vo, List<Object> dataList) {
        LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = new LinkedHashMap<>();
        List<AuditCustomerDetailCollectionVo> auditList = (List<AuditCustomerDetailCollectionVo>) (List) dataList;
        Set<String> detailCodes = auditList.stream().map(AuditCustomerDetailCollectionVo::getActivityDetailCode).collect(Collectors.toSet());
        List<String> detailPlanItemCodes = this.subComActivityDetailPlanItemVoService.findDetailByPlanItemCodeList(detailCodes)
                .stream()
                .filter(o -> StringUtils.equals(ReconciliationConstant.IN_PROCESS, o.getAuditType()))
                .map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode)
                .collect(Collectors.toList());
        //期初折扣池余额
        SapForReconciliationPdfHeadVo one = new SapForReconciliationPdfHeadVo();
        BigDecimal oneAmt = zmsd121Vo.getOpenBalance();
        one.setName(ReconciliationConstant.BEGIN_PERIOD_DISCOUNT_POOL_BALANCE);
        one.setAmount(oneAmt);
        linkedHashMap.put(ReconciliationConstant.BEGIN_PERIOD_DISCOUNT_POOL_BALANCE, one);
        //本期处理费用
        Map<String, List<AuditCustomerDetailCollectionVo>> auditMap = auditList.stream()
                .collect(Collectors.groupingBy(v -> v.getAuditName() + "-" + v.getActivityFormCode()));
        int i = 0;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalReimburseAmount = BigDecimal.ZERO;
        for (List<AuditCustomerDetailCollectionVo> value : auditMap.values()) {
            //红字、报销 过滤 取 ‘报销上账状态’ 为已上账 的
            //随单、折扣 过滤 取 ‘折扣上账状态’ 为以上账 的
            List<AuditCustomerDetailCollectionVo> list = new ArrayList<>(value.size());
            value.stream().forEach(l -> {
                if (StringUtils.equals(AuditFormEnum.EXPENSE.getCode(), l.getEndCaseForm())
                        || StringUtils.equals(AuditFormEnum.RED_INVOICE.getCode(), l.getEndCaseForm())) {
                    if (UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(l.getReimburseUpAccountStatus())) {
                        list.add(l);
                    }
                } else if (StringUtils.equals(AuditFormEnum.DISCOUNT.getCode(), l.getEndCaseForm())
                        || StringUtils.equals(AuditFormEnum.ORDER.getCode(), l.getEndCaseForm())) {
                    if (UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(l.getUpAccountStatus())) {
                        list.add(l);
                    }
                }
            });
            if (CollectionUtils.isEmpty(list)) {
                log.info("生成对账单pdf,分子结案对账，核销数据过滤上账状态后，数据为空");
                continue;
            }

            i = i + 1;
            BigDecimal amt = list.stream().map(e -> {
                // 1028118 生产----对账单据列表---结案对账单取数结案核销管理逻辑更新
                if (StringUtils.equals(AuditFormEnum.EXPENSE.getCode(), e.getEndCaseForm())
                        || StringUtils.equals(AuditFormEnum.RED_INVOICE.getCode(), e.getEndCaseForm())) {
                    //红字视为报销字段 取报销含税
                    return e.getReimburseTaxAmount();
                } else if (StringUtils.equals(AuditFormEnum.DISCOUNT.getCode(), e.getEndCaseForm())
                        || StringUtils.equals(AuditFormEnum.ORDER.getCode(), e.getEndCaseForm())) {
                    //随单视为折扣字段 其它取折扣应处理金额含税
                    return e.getDiscountTaxAmount();
                }
                //其它取本次结案金额含税
                return e.getThisAuditAmount();
            }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            String key = list.get(0).getAuditName() + "-" + list.get(0).getActivityFormName() + ReconciliationConstant.THIS_PERIOD_HANDLE_AMOUNT + "-" + i;
            SapForReconciliationPdfHeadVo headVo = new SapForReconciliationPdfHeadVo();
            headVo.setName(key);
            headVo.setAmount(amt);
            linkedHashMap.put(key, headVo);
            BigDecimal reimburseAmt = list.stream().map(AuditCustomerDetailCollectionVo::getReimburseAmount)
                    .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalAmount = totalAmount.add(amt);
            totalReimburseAmount = totalReimburseAmount.add(reimburseAmt);
        }

        //本月应处理费用 2
        SapForReconciliationPdfHeadVo two = new SapForReconciliationPdfHeadVo();
        two.setName(ReconciliationConstant.THIS_MONTH_SHOULD_HANDLE_AMOUNT);
        two.setAmount(totalAmount);
        linkedHashMap.put(ReconciliationConstant.THIS_MONTH_SHOULD_HANDLE_AMOUNT, two);
        //本月实际折扣金额 3
        SapForReconciliationPdfHeadVo three = new SapForReconciliationPdfHeadVo();
        BigDecimal fourAmt = zmsd121Vo.getMakeAmount();
        three.setName(ReconciliationConstant.THIS_MONTH_ACTUAL_DISCOUNT_AMOUNT);
        three.setAmount(fourAmt);
        linkedHashMap.put(ReconciliationConstant.THIS_MONTH_ACTUAL_DISCOUNT_AMOUNT, three);
        //本月发票报销金额 4
        SapForReconciliationPdfHeadVo four = new SapForReconciliationPdfHeadVo();
        four.setName(ReconciliationConstant.THIS_MONTH_INVOICE_REIMBURSE_AMOUNT);
        four.setAmount(totalReimburseAmount);
        linkedHashMap.put(ReconciliationConstant.THIS_MONTH_INVOICE_REIMBURSE_AMOUNT, four);
        //费用转移 5  暂无取数逻辑，给0
        SapForReconciliationPdfHeadVo five = new SapForReconciliationPdfHeadVo();
        five.setName(ReconciliationConstant.COST_TRANSFER);
        five.setAmount(BigDecimal.ZERO);
        linkedHashMap.put(ReconciliationConstant.COST_TRANSFER, five);
        //考核扣款/折扣上账金额 6
        SapForReconciliationPdfHeadVo six = new SapForReconciliationPdfHeadVo();
        six.setName(ReconciliationConstant.DEDUCTION_AMOUNT);
        six.setAmount(zmsd121Vo.getDeductionAmount());
        linkedHashMap.put(ReconciliationConstant.DEDUCTION_AMOUNT, six);
        //考核上账金额 7
        SapForReconciliationPdfHeadVo seven = new SapForReconciliationPdfHeadVo();
        seven.setName(ReconciliationConstant.EXAMINE_ACCOUNT);
        seven.setAmount(BigDecimal.ZERO);
        linkedHashMap.put(ReconciliationConstant.EXAMINE_ACCOUNT, seven);

        //期末费用池余额  = 期初折扣余额 + 本月应处理费用 - 本月实际折扣金额 - 本月发票报销金额 + 费用转移 - 考核扣款/折扣上账金额 - 考核上账金额
        SapForReconciliationPdfHeadVo eight = new SapForReconciliationPdfHeadVo();
        BigDecimal sevenAmt = oneAmt.add(totalAmount).subtract(fourAmt).subtract(totalReimburseAmount).add(five.getAmount()).subtract(zmsd121Vo.getDeductionAmount()).subtract(seven.getAmount());
        eight.setName(ReconciliationConstant.END_PERIOD_FEE_POOL_BALANCE);
        eight.setAmount(sevenAmt);
        linkedHashMap.put(ReconciliationConstant.END_PERIOD_FEE_POOL_BALANCE, eight);

        //事中费用合计 9 取结案核销里面事中活动的最终处理金额汇总
        BigDecimal inProcessTotalAmount = auditList.stream().filter(o -> detailPlanItemCodes.contains(o.getActivityDetailCode())).map(o -> o.getThisAuditAmount()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        SapForReconciliationPdfHeadVo nine = new SapForReconciliationPdfHeadVo();
        nine.setName(ReconciliationConstant.IN_PROCESS_EXPENSE_TOTAL);
        nine.setAmount(inProcessTotalAmount);
        linkedHashMap.put(ReconciliationConstant.IN_PROCESS_EXPENSE_TOTAL, nine);

        //其他核对项 10 暂无取数逻辑，给0
        SapForReconciliationPdfHeadVo ten = new SapForReconciliationPdfHeadVo();
        ten.setName(ReconciliationConstant.OTHER_CHECK_ITEM);
        ten.setAmount(BigDecimal.ZERO);
        linkedHashMap.put(ReconciliationConstant.OTHER_CHECK_ITEM, ten);

        return linkedHashMap;
    }

    private LinkedHashMap<String, ReplySubReconciliationHeadVo> buildReplySubForReconciliation(List<Object> dataList) {
        LinkedHashMap<String, ReplySubReconciliationHeadVo> headVoMap = new LinkedHashMap<>();

        List<SubComActivityDetailPlanItemVo> planItemVos = (List<SubComActivityDetailPlanItemVo>) (List) dataList;

        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal inProcessTotalAmount = BigDecimal.ZERO;
        /**
         * 本期批复费用
         * 事中费用合计
         */
        for (SubComActivityDetailPlanItemVo planItemVo : planItemVos) {
            BigDecimal totalCost = Objects.isNull(planItemVo.getTotalCost()) ? BigDecimal.ZERO : planItemVo.getTotalCost();

            ReplySubReconciliationHeadVo headVo = new ReplySubReconciliationHeadVo();
            headVo.setProjectName(planItemVo.getConstituentDetailPlanName());
            headVo.setAmount(totalCost);
            headVoMap.put(planItemVo.getConstituentDetailPlanItemCode(), headVo);
            totalAmount = totalAmount.add(totalCost);
            if (StringUtils.equals(ReconciliationConstant.IN_PROCESS, planItemVo.getAuditType())) {
                inProcessTotalAmount = inProcessTotalAmount.add(totalCost);
            }
        }

        /**
         * 事中费用合计
         */
        ReplySubReconciliationHeadVo headVo1 = new ReplySubReconciliationHeadVo();
        headVo1.setAmount(inProcessTotalAmount);
        headVo1.setProjectName(ReconciliationConstant.IN_PROCESS_EXPENSE_TOTAL);
        headVoMap.put(ReconciliationConstant.IN_PROCESS_EXPENSE_TOTAL, headVo1);

        /**
         * 批复金额合计
         */
        ReplySubReconciliationHeadVo headVo = new ReplySubReconciliationHeadVo();
        headVo.setAmount(totalAmount);
        headVo.setProjectName(ReconciliationConstant.APPROVE_TOTAL_AMOUNT);
        headVoMap.put(ReconciliationConstant.APPROVE_TOTAL_AMOUNT, headVo);
        return headVoMap;
    }

    /**
     * 保留2位小数
     * @param amount
     * @return
     */
    public BigDecimal formatBigDecimal(BigDecimal amount) {
        if (Objects.isNull(amount)) {
            return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        }
        return amount.setScale(2, RoundingMode.HALF_UP);
    }
}