package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.*;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.*;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.*;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationSummaryDataDisplayLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationSummaryDataDisplayService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.*;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName ReconciliationSummaryDataDisplayServiceImpl
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/24 16:28
 **/
@Service
@Slf4j
public class ReconciliationSummaryDataDisplayServiceImpl implements ReconciliationSummaryDataDisplayService {

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayRepository reconciliationSummaryDataDisplayRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailHeadApproveRepository detailHeadApproveRepository;

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailHeadAuditRepository detailHeadAuditRepository;

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailSubApproveRepository detailSubApproveRepository;

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailSubAuditRepository detailSubAuditRepository;

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayDetailSubCommunicateRepository detailSubCommunicateRepository;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchCreate(List<ReconciliationSummaryDataDisplayDto> dtos) {
        log.info("进入对账单保存汇总方法,{}", dtos.size());
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        /**
         * 设置基础信息
         */
        this.settingBaseInfo(dtos);

        Collection<ReconciliationSummaryDataDisplayEntity> entities = this.nebulaToolkitService.copyCollectionByWhiteList(dtos, ReconciliationSummaryDataDisplayDto.class, ReconciliationSummaryDataDisplayEntity.class, HashSet.class, ArrayList.class);
        this.reconciliationSummaryDataDisplayRepository.saveBatch(entities);

        //生成明细数据
        List<ReconciliationSummaryDataDisplayDetailHeadApproveDto> detailHeadApproveDtos = new ArrayList<>();
        List<ReconciliationSummaryDataDisplayDetailHeadAuditDto> detailHeadAuditDtos = new ArrayList<>();
        List<ReconciliationSummaryDataDisplayDetailSubApproveDto> detailSubApproveDtos = new ArrayList<>();
        List<ReconciliationSummaryDataDisplayDetailSubAuditDto> detailSubAuditDtos = new ArrayList<>();
        List<ReconciliationSummaryDataDisplayDetailSubCommunicateDto> detailSubCommunicateDtos = new ArrayList<>();
        for (ReconciliationSummaryDataDisplayDto dto : dtos) {
            if (CollectionUtils.isNotEmpty(dto.getDetailHeadApproveDtos())) {
                detailHeadApproveDtos.addAll(dto.getDetailHeadApproveDtos());
            }
            if (CollectionUtils.isNotEmpty(dto.getDetailHeadAuditDtos())) {
                detailHeadAuditDtos.addAll(dto.getDetailHeadAuditDtos());
            }
            if (CollectionUtils.isNotEmpty(dto.getDetailSubApproveDtos())) {
                detailSubApproveDtos.addAll(dto.getDetailSubApproveDtos());
            }
            if (CollectionUtils.isNotEmpty(dto.getDetailSubAuditDtos())) {
                detailSubAuditDtos.addAll(dto.getDetailSubAuditDtos());
            }
            if (CollectionUtils.isNotEmpty(dto.getDetailSubCommunicateDtos())) {
                detailSubCommunicateDtos.addAll(dto.getDetailSubCommunicateDtos());
            }
        }
        log.info("对账单保存汇总方法 主体批复明细集合 ->detailHeadApproveRepository.saveBatch detailHeadApproveRepository");
        //保存
        if (CollectionUtils.isNotEmpty(detailHeadApproveDtos)) {
            List<ReconciliationSummaryDataDisplayDetailHeadApproveEntity> detailHeadApproveEntities = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadApproveEntity>)
                    this.nebulaToolkitService.copyCollectionByWhiteList(detailHeadApproveDtos, ReconciliationSummaryDataDisplayDetailHeadApproveDto.class, ReconciliationSummaryDataDisplayDetailHeadApproveEntity.class, HashSet.class, ArrayList.class);
            this.detailHeadApproveRepository.saveBatch(detailHeadApproveEntities);
        }
        log.info("对账单保存汇总方法 主体结案明细集合 ->detailHeadAuditRepository.saveBatch detailHeadAuditRepository");
        if (CollectionUtils.isNotEmpty(detailHeadAuditDtos)) {
            List<ReconciliationSummaryDataDisplayDetailHeadAuditEntity> detailHeadAuditEntities = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadAuditEntity>)
                    this.nebulaToolkitService.copyCollectionByWhiteList(detailHeadAuditDtos, ReconciliationSummaryDataDisplayDetailHeadAuditDto.class, ReconciliationSummaryDataDisplayDetailHeadAuditEntity.class, HashSet.class, ArrayList.class);
            this.detailHeadAuditRepository.saveBatch(detailHeadAuditEntities);
        }
        log.info("对账单保存汇总方法 分子批复明细集合 ->detailSubApproveRepository.saveBatch detailSubApproveRepository");
        if (CollectionUtils.isNotEmpty(detailSubApproveDtos)) {
            List<ReconciliationSummaryDataDisplayDetailSubApproveEntity> detailSubApproveEntities = (ArrayList<ReconciliationSummaryDataDisplayDetailSubApproveEntity>)
                    this.nebulaToolkitService.copyCollectionByWhiteList(detailSubApproveDtos, ReconciliationSummaryDataDisplayDetailSubApproveDto.class, ReconciliationSummaryDataDisplayDetailSubApproveEntity.class, HashSet.class, ArrayList.class);
            this.detailSubApproveRepository.saveBatch(detailSubApproveEntities);
        }
        log.info("对账单保存汇总方法 分子结案明细集合 ->detailSubAuditRepository.saveBatch detailSubAuditRepository");
        if (CollectionUtils.isNotEmpty(detailSubAuditDtos)) {
            List<ReconciliationSummaryDataDisplayDetailSubAuditEntity> detailHeadApproveEntities = (ArrayList<ReconciliationSummaryDataDisplayDetailSubAuditEntity>)
                    this.nebulaToolkitService.copyCollectionByWhiteList(detailSubAuditDtos, ReconciliationSummaryDataDisplayDetailSubAuditDto.class, ReconciliationSummaryDataDisplayDetailSubAuditEntity.class, HashSet.class, ArrayList.class);
            this.detailSubAuditRepository.saveBatch(detailHeadApproveEntities);
        }
        log.info("对账单保存汇总方法 分子往来明细集合 ->detailSubCommunicateRepository.saveBatch detailSubCommunicateRepository");
        if (CollectionUtils.isNotEmpty(detailSubCommunicateDtos)) {
            List<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> detailSubCommunicateEntities = (ArrayList<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity>)
                    this.nebulaToolkitService.copyCollectionByWhiteList(detailSubCommunicateDtos, ReconciliationSummaryDataDisplayDetailSubCommunicateDto.class, ReconciliationSummaryDataDisplayDetailSubCommunicateEntity.class, HashSet.class, ArrayList.class);
            this.detailSubCommunicateRepository.saveBatch(detailSubCommunicateEntities);
        }
        log.info("结束对账单保存汇总方法");

    }

    /**
     * 设置基础信息
     *
     * @param displayDtos
     */
    private void settingBaseInfo(List<ReconciliationSummaryDataDisplayDto> displayDtos) {
        if (CollectionUtil.isEmpty(displayDtos)) {
            return;
        }
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        displayDtos.forEach(d -> {
            String businessUnitCode = d.getBusinessUnitCode();
            String businessFormatCode = d.getBusinessFormatCode();
            //主体批复明细集合
            if (CollectionUtil.isNotEmpty(d.getDetailHeadApproveDtos())) {
                d.getDetailHeadApproveDtos().forEach(a -> {
                    a.setId(null);
                    a.setEnableStatus(enableCode);
                    a.setDelFlag(delFlag);
                    a.setTenantCode(tenantCode);
                    a.setBusinessUnitCode(businessUnitCode);
                    a.setBusinessFormatCode(businessFormatCode);
                    a.setSalesInstitutionCode(d.getSalesInstitutionCode());
                    a.setSalesInstitutionErpCode(d.getSalesInstitutionErpCode());
                    a.setSalesInstitutionName(d.getSalesInstitutionName());
                    a.setSalesRegionCode(d.getSalesRegionCode());
                    a.setSalesRegionErpCode(d.getSalesRegionErpCode());
                    a.setSalesRegionName(d.getSalesRegionName());
                    a.setSalesOrgCode(d.getSalesOrgCode());
                    a.setSalesOrgErpCode(d.getSalesOrgErpCode());
                    a.setSalesOrgName(d.getSalesOrgName());
                    if (Objects.isNull(a.getCustomerFeeAmount())) {
                        a.setCustomerFeeAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getApplyFee())) {
                        a.setApplyFee(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getTotalFee())) {
                        a.setTotalFee(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                });
            }
            //主体结案明细集合
            if (CollectionUtil.isNotEmpty(d.getDetailHeadAuditDtos())) {
                d.getDetailHeadAuditDtos().forEach(a -> {
                    a.setId(null);
                    a.setEnableStatus(enableCode);
                    a.setDelFlag(delFlag);
                    a.setTenantCode(tenantCode);
                    a.setBusinessUnitCode(businessUnitCode);
                    a.setBusinessFormatCode(businessFormatCode);
                    a.setSalesInstitutionCode(d.getSalesInstitutionCode());
                    a.setSalesInstitutionErpCode(d.getSalesInstitutionErpCode());
                    a.setSalesInstitutionName(d.getSalesInstitutionName());
                    a.setSalesRegionCode(d.getSalesRegionCode());
                    a.setSalesRegionErpCode(d.getSalesRegionErpCode());
                    a.setSalesRegionName(d.getSalesRegionName());
                    a.setSalesOrgCode(d.getSalesOrgCode());
                    a.setSalesOrgErpCode(d.getSalesOrgErpCode());
                    a.setSalesOrgName(d.getSalesOrgName());

                    if (Objects.isNull(a.getDealerUndertakeAmount())) {
                        a.setDealerUndertakeAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getApplyAmount())) {
                        a.setApplyAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getCurrentAuditAmount())) {
                        a.setCurrentAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getDeductionTaxAmount())) {
                        a.setDeductionTaxAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getCurrentActualAuditAmount())) {
                        a.setCurrentActualAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getDiscountAmount())) {
                        a.setDiscountAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getReimburseAmount())) {
                        a.setReimburseAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }
                    if (Objects.isNull(a.getExamineCircularAmount())) {
                        a.setExamineCircularAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
                    }

                });
            }
            //分子批复明细集合
            if (CollectionUtil.isNotEmpty(d.getDetailSubApproveDtos())) {
                d.getDetailSubApproveDtos().forEach(a -> {
                    a.setId(null);
                    a.setEnableStatus(enableCode);
                    a.setDelFlag(delFlag);
                    a.setTenantCode(tenantCode);
                    a.setBusinessUnitCode(businessUnitCode);
                    a.setBusinessFormatCode(businessFormatCode);
                    a.setSalesInstitutionCode(d.getSalesInstitutionCode());
                    a.setSalesInstitutionErpCode(d.getSalesInstitutionErpCode());
                    a.setSalesInstitutionName(d.getSalesInstitutionName());
                    a.setSalesRegionCode(d.getSalesRegionCode());
                    a.setSalesRegionErpCode(d.getSalesRegionErpCode());
                    a.setSalesRegionName(d.getSalesRegionName());
                    a.setSalesOrgCode(d.getSalesOrgCode());
                    a.setSalesOrgErpCode(d.getSalesOrgErpCode());
                    a.setSalesOrgName(d.getSalesOrgName());
                });
            }
            //分子结案明细集合
            if (CollectionUtil.isNotEmpty(d.getDetailSubAuditDtos())) {
                d.getDetailSubAuditDtos().forEach(a -> {
                    a.setId(null);
                    a.setEnableStatus(enableCode);
                    a.setDelFlag(delFlag);
                    a.setTenantCode(tenantCode);
                    a.setBusinessUnitCode(businessUnitCode);
                    a.setBusinessFormatCode(businessFormatCode);
                    a.setSalesInstitutionCode(d.getSalesInstitutionCode());
                    a.setSalesInstitutionErpCode(d.getSalesInstitutionErpCode());
                    a.setSalesInstitutionName(d.getSalesInstitutionName());
                    a.setSalesRegionCode(d.getSalesRegionCode());
                    a.setSalesRegionErpCode(d.getSalesRegionErpCode());
                    a.setSalesRegionName(d.getSalesRegionName());
                    a.setSalesOrgCode(d.getSalesOrgCode());
                    a.setSalesOrgErpCode(d.getSalesOrgErpCode());
                    a.setSalesOrgName(d.getSalesOrgName());
                });
            }
            //分子往来明细集合
            if (CollectionUtil.isNotEmpty(d.getDetailSubCommunicateDtos())) {
                d.getDetailSubCommunicateDtos().forEach(a -> {
                    a.setId(null);
                    a.setEnableStatus(enableCode);
                    a.setDelFlag(delFlag);
                    a.setTenantCode(tenantCode);
                    a.setBusinessUnitCode(businessUnitCode);
                    a.setBusinessFormatCode(businessFormatCode);
                    a.setSalesInstitutionCode(d.getSalesInstitutionCode());
                    a.setSalesInstitutionErpCode(d.getSalesInstitutionErpCode());
                    a.setSalesInstitutionName(d.getSalesInstitutionName());
                    a.setSalesRegionCode(d.getSalesRegionCode());
                    a.setSalesRegionErpCode(d.getSalesRegionErpCode());
                    a.setSalesRegionName(d.getSalesRegionName());
                    a.setSalesOrgCode(d.getSalesOrgCode());
                    a.setSalesOrgErpCode(d.getSalesOrgErpCode());
                    a.setSalesOrgName(d.getSalesOrgName());
                });
            }
        });
    }

    /**
     * 设置产品信息
     *
     * @param displayDtos
     */
    private void setProductInfo(List<ReconciliationSummaryDataDisplayDto> displayDtos) {
        if (CollectionUtil.isEmpty(displayDtos)) {
            return;
        }
        Set<String> productCodeSet = new HashSet<>();
        displayDtos.forEach(d -> {
            if (CollectionUtil.isNotEmpty(d.getDetailHeadApproveDtos())) {
                d.getDetailHeadApproveDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())) {
                        productCodeSet.add(a.getProductCode());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailHeadAuditDtos())) {
                d.getDetailHeadAuditDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())) {
                        productCodeSet.add(a.getProductCode());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubApproveDtos())) {
                d.getDetailSubApproveDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())) {
                        productCodeSet.add(a.getProductCode());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubAuditDtos())) {
                d.getDetailSubAuditDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())) {
                        productCodeSet.add(a.getProductCode());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubCommunicateDtos())) {
                d.getDetailSubCommunicateDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())) {
                        productCodeSet.add(a.getProductCode());
                    }
                });
            }
        });
        if (CollectionUtil.isEmpty(productCodeSet)) {
            return;
        }
        List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
        if (CollectionUtil.isEmpty(productVoList)) {
            return;
        }
        Map<String, ProductVo> productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                v -> v, (n, o) -> n));
        displayDtos.forEach(d -> {
            if (CollectionUtil.isNotEmpty(d.getDetailHeadApproveDtos())) {
                d.getDetailHeadApproveDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())
                            && productVoMap.containsKey(a.getProductCode())) {
                        ProductVo productVo = productVoMap.get(a.getProductCode());
                        a.setProductName(productVo.getProductName());
                        a.setProductBrandCode(productVo.getProductBrandCode());
                        a.setProductBrandName(productVo.getProductBrandName());
                        a.setProductCategoryCode(productVo.getProductCategoryCode());
                        a.setProductCategoryName(productVo.getProductCategoryName());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailHeadAuditDtos())) {
                d.getDetailHeadAuditDtos().forEach(a -> {
                    a.setExamineCircularAmount(Optional.ofNullable(a.getExamineCircularAmount()).orElse(BigDecimal.ZERO));
                    if (StringUtil.isNotEmpty(a.getProductCode())
                            && productVoMap.containsKey(a.getProductCode())) {
                        ProductVo productVo = productVoMap.get(a.getProductCode());
                        a.setProductName(productVo.getProductName());
                        a.setProductBrandCode(productVo.getProductBrandCode());
                        a.setProductBrandName(productVo.getProductBrandName());
                        a.setProductCategoryCode(productVo.getProductCategoryCode());
                        a.setProductCategoryName(productVo.getProductCategoryName());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubApproveDtos())) {
                d.getDetailSubApproveDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())
                            && productVoMap.containsKey(a.getProductCode())) {
                        ProductVo productVo = productVoMap.get(a.getProductCode());
                        a.setProductName(productVo.getProductName());
                        a.setProductBrandCode(productVo.getProductBrandCode());
                        a.setProductBrandName(productVo.getProductBrandName());
                        a.setProductCategoryCode(productVo.getProductCategoryCode());
                        a.setProductCategoryName(productVo.getProductCategoryName());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubAuditDtos())) {
                d.getDetailSubAuditDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())
                            && productVoMap.containsKey(a.getProductCode())) {
                        ProductVo productVo = productVoMap.get(a.getProductCode());
                        a.setProductName(productVo.getProductName());
                        a.setProductBrandCode(productVo.getProductBrandCode());
                        a.setProductBrandName(productVo.getProductBrandName());
                        a.setProductCategoryCode(productVo.getProductCategoryCode());
                        a.setProductCategoryName(productVo.getProductCategoryName());
                    }
                });
            }
            if (CollectionUtil.isNotEmpty(d.getDetailSubCommunicateDtos())) {
                d.getDetailSubCommunicateDtos().forEach(a -> {
                    if (StringUtil.isNotEmpty(a.getProductCode())
                            && productVoMap.containsKey(a.getProductCode())) {
                        ProductVo productVo = productVoMap.get(a.getProductCode());
                        a.setProductName(productVo.getProductName());
                        a.setProductBrandCode(productVo.getProductBrandCode());
                        a.setProductBrandName(productVo.getProductBrandName());
                        a.setProductCategoryCode(productVo.getProductCategoryCode());
                        a.setProductCategoryName(productVo.getProductCategoryName());
                    }
                });
            }
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(ReconciliationSummaryDataDisplayDto displayDto) {
        this.updateValidation(displayDto);
        //更新明细
        ReconciliationTypeEnum typeEnum = ReconciliationTypeEnum.codeToEnum(displayDto.getReconciliationType());
        Assert.notNull(typeEnum, "对账单类型不合法!");
        ReconciliationSummaryDataDisplayEntity one = this.reconciliationSummaryDataDisplayRepository.getById(displayDto.getId());
        Assert.notNull(one, "该数据不存在或已删除！");

        ReconciliationSummaryDataDisplayEntity displayEntity = this.nebulaToolkitService.copyObjectByWhiteList(displayDto, ReconciliationSummaryDataDisplayEntity.class, HashSet.class, ArrayList.class);
        this.reconciliationSummaryDataDisplayRepository.updateById(displayEntity);

        if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), one.getBusinessUnitCode())) {
            switch (typeEnum) {
                case COMMUNICATION:
                    List<ReconciliationSummaryDataDisplayDetailSubCommunicateDto> detailSubCommunicateDtos = displayDto.getDetailSubCommunicateDtos();
                    if (CollectionUtils.isNotEmpty(detailSubCommunicateDtos)) {
                        detailSubCommunicateDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
                        Collection<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> communicateEntities = this.nebulaToolkitService.copyCollectionByWhiteList(detailSubCommunicateDtos, ReconciliationSummaryDataDisplayDetailSubCommunicateDto.class, ReconciliationSummaryDataDisplayDetailSubCommunicateEntity.class, HashSet.class, ArrayList.class);

                        this.detailSubCommunicateRepository.deleteByStatementCode(one.getStatementCode());
                        this.detailSubCommunicateRepository.saveBatch(communicateEntities);
                    }
                    break;
                case APPROVAL:
                    List<ReconciliationSummaryDataDisplayDetailSubApproveDto> detailSubApproveDtos = displayDto.getDetailSubApproveDtos();
                    if (CollectionUtils.isNotEmpty(detailSubApproveDtos)) {
                        detailSubApproveDtos.forEach(o -> o.setStatementCode(one.getStatementCode()));
                        Collection<ReconciliationSummaryDataDisplayDetailSubApproveEntity> approveEntities = this.nebulaToolkitService.copyCollectionByWhiteList(detailSubApproveDtos, ReconciliationSummaryDataDisplayDetailSubApproveDto.class, ReconciliationSummaryDataDisplayDetailSubApproveEntity.class, HashSet.class, ArrayList.class);

                        this.detailSubApproveRepository.deleteByStatementCode(one.getStatementCode());
                        this.detailSubApproveRepository.saveBatch(approveEntities);
                    }
                    break;
                case CLOSURE:
                    List<ReconciliationSummaryDataDisplayDetailSubAuditDto> detailSubAuditDtos = displayDto.getDetailSubAuditDtos();
                    if (CollectionUtils.isNotEmpty(detailSubAuditDtos)) {
                        detailSubAuditDtos.forEach(o -> o.setStatementCode(one.getStatementCode()));
                        Collection<ReconciliationSummaryDataDisplayDetailSubAuditEntity> auditEntities = this.nebulaToolkitService.copyCollectionByWhiteList(detailSubAuditDtos, ReconciliationSummaryDataDisplayDetailSubAuditDto.class, ReconciliationSummaryDataDisplayDetailSubAuditEntity.class, HashSet.class, ArrayList.class);

                        this.detailSubAuditRepository.deleteByStatementCode(one.getStatementCode());
                        this.detailSubAuditRepository.saveBatch(auditEntities);
                    }
                    break;
                default:
                    throw new IllegalArgumentException("未知的对账单类型:" + one.getReconciliationType());
            }
        } else if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), one.getBusinessUnitCode())) {
            switch (typeEnum) {
                case CLOSURE:
                    List<ReconciliationSummaryDataDisplayDetailHeadAuditDto> detailHeadAuditDtos = displayDto.getDetailHeadAuditDtos();
                    if (CollectionUtils.isNotEmpty(detailHeadAuditDtos)) {
                        detailHeadAuditDtos.forEach(o -> o.setStatementCode(one.getStatementCode()));
                        Collection<ReconciliationSummaryDataDisplayDetailHeadAuditEntity> auditEntities = this.nebulaToolkitService.copyCollectionByWhiteList(detailHeadAuditDtos, ReconciliationSummaryDataDisplayDetailHeadAuditDto.class, ReconciliationSummaryDataDisplayDetailHeadAuditEntity.class, HashSet.class, ArrayList.class);

                        this.detailHeadAuditRepository.deleteByStatementCode(one.getStatementCode());
                        this.detailHeadAuditRepository.saveBatch(auditEntities);
                    }
                    break;
                case APPROVAL:
                    List<ReconciliationSummaryDataDisplayDetailHeadApproveDto> detailHeadApproveDtos = displayDto.getDetailHeadApproveDtos();
                    if (CollectionUtils.isNotEmpty(detailHeadApproveDtos)) {
                        detailHeadApproveDtos.forEach(o -> o.setStatementCode(one.getStatementCode()));
                        Collection<ReconciliationSummaryDataDisplayDetailHeadApproveEntity> approveEntities = this.nebulaToolkitService.copyCollectionByWhiteList(detailHeadApproveDtos, ReconciliationSummaryDataDisplayDetailHeadApproveDto.class, ReconciliationSummaryDataDisplayDetailHeadApproveEntity.class, HashSet.class, ArrayList.class);

                        this.detailHeadApproveRepository.deleteByStatementCode(one.getStatementCode());
                        this.detailHeadApproveRepository.saveBatch(approveEntities);
                    }
                    break;
                default:
                    throw new IllegalArgumentException("未知的对账单类型:" + one.getReconciliationType());
            }
        }


        ReconciliationSummaryDataDisplayLogVo oldLogVo = this.nebulaToolkitService.copyObjectByWhiteList(one, ReconciliationSummaryDataDisplayLogVo.class, HashSet.class, ArrayList.class);

        ReconciliationSummaryDataDisplayLogVo newLogVo = this.nebulaToolkitService.copyObjectByWhiteList(displayDto, ReconciliationSummaryDataDisplayLogVo.class, HashSet.class, ArrayList.class);

        // 发送修改通知
        ReconciliationSummaryDataDisplayLogDto logEventDto = new ReconciliationSummaryDataDisplayLogDto();
        logEventDto.setOriginal(oldLogVo);
        logEventDto.setNewest(newLogVo);
        SerializableBiConsumer<ReconciliationSummaryDataDisplayLogEventListener, ReconciliationSummaryDataDisplayLogDto> onUpdate =
                ReconciliationSummaryDataDisplayLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, ReconciliationSummaryDataDisplayLogEventListener.class, onUpdate);

    }

    @Override
    public ReconciliationSummaryDataDisplayVo findById(String id) {
        Validate.notBlank(id, "ID不能为空");
        ReconciliationSummaryDataDisplayEntity dataDisplayEntity = this.reconciliationSummaryDataDisplayRepository.findById(id);
        Validate.notNull(dataDisplayEntity, "数据不存在或已被删除");

        ReconciliationSummaryDataDisplayVo displayVo = this.nebulaToolkitService.copyObjectByWhiteList(dataDisplayEntity, ReconciliationSummaryDataDisplayVo.class, HashSet.class, ArrayList.class);

        ReconciliationTypeEnum reconciliationTypeEnum = ReconciliationTypeEnum.codeToEnum(dataDisplayEntity.getReconciliationType());
        if (Objects.isNull(reconciliationTypeEnum)) {
            return displayVo;
        }
        if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), dataDisplayEntity.getBusinessUnitCode())) {
            switch (reconciliationTypeEnum) {
                case CLOSURE:
                    List<ReconciliationSummaryDataDisplayDetailSubAuditEntity> byStatementCode1 = this.detailSubAuditRepository.findByStatementCode(dataDisplayEntity.getStatementCode());
                    if (CollectionUtils.isNotEmpty(byStatementCode1)) {
                        List<ReconciliationSummaryDataDisplayDetailSubAuditVo> detailSubAuditVos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubAuditVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStatementCode1, ReconciliationSummaryDataDisplayDetailSubAuditEntity.class, ReconciliationSummaryDataDisplayDetailSubAuditVo.class, HashSet.class, ArrayList.class);
                        displayVo.setDetailSubAuditVos(detailSubAuditVos);
                    }
                    break;
                case APPROVAL:
                    List<ReconciliationSummaryDataDisplayDetailSubApproveEntity> byStatementCode2 = this.detailSubApproveRepository.findByStatementCode(dataDisplayEntity.getStatementCode());
                    if (CollectionUtils.isNotEmpty(byStatementCode2)) {
                        List<ReconciliationSummaryDataDisplayDetailSubApproveVo> detailSubAuditVos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubApproveVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStatementCode2, ReconciliationSummaryDataDisplayDetailSubApproveEntity.class, ReconciliationSummaryDataDisplayDetailSubApproveVo.class, HashSet.class, ArrayList.class);
                        displayVo.setDetailSubApproveVos(detailSubAuditVos);
                    }
                    break;
                case COMMUNICATION:
                    List<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> byStatementCode3 = this.detailSubCommunicateRepository.findByStatementCode(dataDisplayEntity.getStatementCode());
                    if (CollectionUtils.isNotEmpty(byStatementCode3)) {
                        List<ReconciliationSummaryDataDisplayDetailSubCommunicateVo> detailSubAuditVos = (ArrayList<ReconciliationSummaryDataDisplayDetailSubCommunicateVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStatementCode3, ReconciliationSummaryDataDisplayDetailSubCommunicateEntity.class, ReconciliationSummaryDataDisplayDetailSubCommunicateVo.class, HashSet.class, ArrayList.class);
                        displayVo.setDetailSubCommunicateVos(detailSubAuditVos);
                    }
                    break;
                default:
                    throw new IllegalArgumentException("未知的对账单类型:" + dataDisplayEntity.getReconciliationType());
            }
        } else if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), dataDisplayEntity.getBusinessUnitCode())) {
            switch (reconciliationTypeEnum) {
                case CLOSURE:
                    List<ReconciliationSummaryDataDisplayDetailHeadAuditEntity> byStatementCode1 = this.detailHeadAuditRepository.findByStatementCode(displayVo.getStatementCode());
                    if (CollectionUtils.isNotEmpty(byStatementCode1)) {
                        List<ReconciliationSummaryDataDisplayDetailHeadAuditVo> auditVos = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadAuditVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStatementCode1, ReconciliationSummaryDataDisplayDetailHeadAuditEntity.class, ReconciliationSummaryDataDisplayDetailHeadAuditVo.class, HashSet.class, ArrayList.class);
                        displayVo.setDetailHeadAuditVos(auditVos);
                    }
                    break;
                case APPROVAL:
                    List<ReconciliationSummaryDataDisplayDetailHeadApproveEntity> byStatementCode2 = this.detailHeadApproveRepository.findByStatementCode(displayVo.getStatementCode());
                    if (CollectionUtils.isNotEmpty(byStatementCode2)) {
                        List<ReconciliationSummaryDataDisplayDetailHeadApproveVo> auditVos = (ArrayList<ReconciliationSummaryDataDisplayDetailHeadApproveVo>) this.nebulaToolkitService.copyCollectionByWhiteList(byStatementCode2, ReconciliationSummaryDataDisplayDetailHeadApproveEntity.class, ReconciliationSummaryDataDisplayDetailHeadApproveVo.class, HashSet.class, ArrayList.class);
                        displayVo.setDetailHeadApproveVos(auditVos);
                    }
                    break;
                default:
                    throw new IllegalArgumentException("未知的对账单类型:" + dataDisplayEntity.getReconciliationType());
            }
        }
        return displayVo;
    }


    private void updateValidation(ReconciliationSummaryDataDisplayDto displayDto) {
        Validate.notNull(displayDto, "请求参数不能为空");
        Validate.notBlank(displayDto.getId(), "数据主键ID不能为空");

    }
}
