package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.ReconciliationSapDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.SapReconciliationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.SapReconciliationRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.PullSapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.SapReconciliationService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class SapReconciliationServiceImpl implements SapReconciliationService {
    @Autowired(required = false)
    private SapSdApiService sapSdApiService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    public Result querySapReconciliation(PullSapReconciliationDto dto) {
        Validate.notBlank(dto.getYearMonth(),"年月不能为空");
        Validate.isTrue(DateUtil.isDate(dto.getYearMonth(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH),"时间年月格式不正确，yyyyMM");
        ReconciliationSapDto queryDto = new ReconciliationSapDto();
        MessageHeaderDto header = new MessageHeaderDto();
        header.setMessageId(UuidCrmUtil.general());
        header.setInterfacePath(ReconciliationConstant.SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT);
        header.setSender(ReconciliationConstant.SENDER_TPM);
        header.setSendTime(String.valueOf(System.currentTimeMillis()));
        header.setReceiver(ReconciliationConstant.RECEIVER_ECC);
        queryDto.setMessageHeader(header);
        Date yearMonth = DateUtil.parseDate(dto.getYearMonth(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
        Calendar yearMonthCalendar = Calendar.getInstance();
        yearMonthCalendar.setTime(yearMonth);
        String year = String.valueOf(yearMonthCalendar.get(Calendar.YEAR));
        String month = String.valueOf(yearMonthCalendar.get(Calendar.MONTH) + 1);
        Result result = new Result();
        //SAP没有批量查询，查询时又必须要传销售组织和分销渠道，目前是循环调接口，很坑
        if(StringUtils.isEmpty(dto.getVtweg())
                || StringUtils.isEmpty(dto.getVkorg())
                || StringUtils.isEmpty(dto.getPrctr())){
            Map<String, List<DictDataVo>> typeCodeList = dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(ReconciliationConstant.SYNC_123_SALES_ORG_CODE, ReconciliationConstant.SYNC_123_CHANNEL_CODE, ReconciliationConstant.SYNC_123_PROFIT_CENTER));
            List<DictDataVo> salesDictDataVos = typeCodeList.get(ReconciliationConstant.SYNC_123_SALES_ORG_CODE);
            List<DictDataVo> channelDictDataVos = typeCodeList.get(ReconciliationConstant.SYNC_123_CHANNEL_CODE);
            List<DictDataVo> profitDictDataVos = typeCodeList.get(ReconciliationConstant.SYNC_123_PROFIT_CENTER);

            for (DictDataVo sales : salesDictDataVos){
                for (DictDataVo channel : channelDictDataVos) {
                    for (DictDataVo profitDictDataVo : profitDictDataVos) {
                        List<ReconciliationSapDto.ReconciliationItemDto> itemList = new ArrayList<>();
                        ReconciliationSapDto.ReconciliationItemDto itemDto = new ReconciliationSapDto.ReconciliationItemDto();
                        itemDto.setGJAHR(year);
                        itemDto.setMONAT(month);
                        itemDto.setVKORG(sales.getDictCode());
                        itemDto.setVTWEG(channel.getDictCode());
                        itemDto.setPRCTR(profitDictDataVo.getDictCode());
                        itemList.add(itemDto);

                        queryDto.setITEM1(itemList);
                        Result sapResult = sapSdApiService.pushReconciliationToSap(queryDto);
                    }
                }
            }

            if (CollectionUtils.isNotEmpty(salesDictDataVos)
                    && CollectionUtils.isNotEmpty(channelDictDataVos)
                    && CollectionUtils.isNotEmpty(profitDictDataVos)) {
                Date date = DateUtil.parse(dto.getYearMonth(), DateUtil.DEFAULT_YEAR_MONTH);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(Calendar.MONTH,1);
                calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
                String startDate = DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                String endDate = DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                //更据日期逻辑删除上月数据
                this.deleteByDate(dto);
            }
//            log.info("定时任务拉取123数据,参数1【{}】,参数2【{}】", JSON.toJSONString(queryDto) ,JSON.toJSONString(queryDto.getITEM1()));
//            result = sapSdApiService.pushReconciliationToSap(queryDto);
        }else{
            Validate.notBlank(dto.getPrctr(),"手动查询时，利润中心不能为空");
            Validate.notBlank(dto.getVkorg(),"手动查询时，销售组织不能为空");
            Validate.notBlank(dto.getVtweg(),"手动查询时，分销渠道不能为空");

            List<ReconciliationSapDto.ReconciliationItemDto> itemList = new ArrayList<>();
            ReconciliationSapDto.ReconciliationItemDto itemDto = new ReconciliationSapDto.ReconciliationItemDto();
            itemDto.setGJAHR(year);
            itemDto.setMONAT(month);
            itemDto.setPRCTR(dto.getPrctr());
            itemDto.setVTWEG(dto.getVtweg());
            itemDto.setVKORG(dto.getVkorg());
            itemList.add(itemDto);
            queryDto.setITEM1(itemList);
            log.info("手动拉取123数据,参数1【{}】,参数2【{}】", JSON.toJSONString(queryDto) ,JSON.toJSONString(queryDto.getITEM1()));
            result = sapSdApiService.pushReconciliationToSap(queryDto);

            if (result.getCode().equals("202")){
                Date date = DateUtil.parse(dto.getYearMonth(), DateUtil.DEFAULT_YEAR_MONTH);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(Calendar.MONTH,1);
                calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
                String startDate = DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
                String endDate = DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                //更据日期逻辑删除上月数据
                this.deleteByDate(dto);
            }
        }

        return result;
    }

    /**
     * 根据日期逻辑删除数据
     *
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    public void deleteByDate(PullSapReconciliationDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (StringUtils.isBlank(dto.getStartDate()) || StringUtils.isBlank(dto.getEndDate())) {
            return;
        }
        this.sapReconciliationRepository.deleteByDate(dto);
    }

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SapReconciliationRepository sapReconciliationRepository;

    @Override
    public void testReconciliationCallback(ReconciliationCallbackDto dto) {
        log.info("sap客户对账单回调接口数据为，信息:{}", dto);
        if (Objects.nonNull(dto) && CollectionUtil.isNotEmpty(dto.getITEM1())){
            List<ReconciliationCallbackDataDto> callbackData = dto.getITEM1();
            //callbackData.stream().collect(Collectors.groupingBy(ReconciliationCallbackDataDto::getKunag_txt));
            //保存sap客户对账信息，tpm生成对账单直接从此表获取数据
            List<SapReconciliationEntity> reconciliationEntities = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(callbackData,ReconciliationCallbackDataDto.class,SapReconciliationEntity.class, HashSet.class, ArrayList.class));
            if(CollectionUtils.isNotEmpty(reconciliationEntities)){
                reconciliationEntities.forEach(entity->{
                    entity.setTenantCode(TenantUtils.getTenantCode());
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                });
                sapReconciliationRepository.saveOrUpdateBatch(reconciliationEntities);
            }
        }
    }

    @Override
    public Set<String> findCustomer(SapReconciliationDto dto) {
        if (Objects.isNull(dto)){
            return Sets.newHashSet();
        }
        return this.sapReconciliationRepository.findCustomer(dto);
    }

    @Override
    public List<SapReconciliationVo> findListByCustomerCode(SapReconciliationDto dto) {
        List<SapReconciliationEntity> list = Lists.newArrayList();
        try {
            Validate.notBlank(dto.getSubReconciliationCustomerCode(),"生成对账单,findListByCustomerCode ===》 客户编码不能为空");
            Validate.notBlank(dto.getSubReconciliationInstitutionCode(),"生成对账单,findListByCustomerCode ===》 销售机构编码不能为空");
            Validate.notBlank(dto.getStartDateStr(),"生成对账单,findListByCustomerCode ===》 开始时间不能为空");
            Validate.notBlank(dto.getEndDateStr(),"生成对账单,findListByCustomerCode ===》 结束时间不能为空");
            dto.setTenantCode(TenantUtils.getTenantCode());
            //业态业务单元对应到SAP字段可能不对
            list = this.sapReconciliationRepository.findListByCustomerCode(dto);
            /*list = this.sapReconciliationRepository.lambdaQuery()
                    .eq(StringUtils.isNotEmpty(dto.getCustomerCode()), SapReconciliationEntity::getKunrg,dto.getCustomerCode())
                    .eq(StringUtils.isNotEmpty(dto.getSubReconciliationCustomerCode()),SapReconciliationEntity::getKunrg,dto.getSubReconciliationCustomerCode())
                    .eq(StringUtils.isNotEmpty(dto.getSubReconciliationInstitutionCode()),SapReconciliationEntity::getVkorg,dto.getSubReconciliationInstitutionCode())
                    *//*.eq(SapReconciliationEntity::getVtweg,dto.getBusinessFormatCode())
                    .eq(SapReconciliationEntity::getVkorg,dto.getBusinessUnitCode())*//*
                    .between(SapReconciliationEntity::getFkdat,dto.getStartDateStr(),dto.getEndDateStr())
                    .list();*/
        } catch (Exception e) {
            log.info("生成对账单ERROR,findListByCustomerCode==>:{}", JSONObject.toJSONString(dto));
            throw e;
        }
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(list,SapReconciliationEntity.class, SapReconciliationVo.class,HashSet.class,ArrayList.class));
    }

    @Override
    public Page<SapReconciliationVo> findByReconciliations(Pageable pageable, SapReconciliationDto sapReconciliationDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        return this.sapReconciliationRepository.findByReconciliations(pageable, sapReconciliationDto);
    }

    @Override
    @DynamicTaskService(cornExpression = "0 0 2 2 * ?", taskDesc = "每月2号 02:00 点执行123数据拉取任务")
    public void sync123DataScheduleTask() {
        loginUserService.refreshAuthentication(null);
        log.info("123数据拉取任务开始执行");
        boolean lock = false;
        String lockKey = cn.hutool.core.date.DateUtil.format(new Date(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.lock(lockKey);
            if (lock){
                //2023/9/6 拉取日期改成上月
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(Calendar.MONTH,-1);
                String dateStr = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);

                PullSapReconciliationDto dto = new PullSapReconciliationDto();
                dto.setYearMonth(dateStr);
                this.querySapReconciliation(dto);
            }else {
                throw new RuntimeException("加锁失败！");
            }
        } catch (Exception e) {
            log.error("123数据拉取任务执行失败", e.getMessage());
            e.printStackTrace();
        } finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }


    /**
     * 按年月日加锁
     *
     * @param yearMonthDay
     * @return boolean
     **/
    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("拉取123数据job执行失败，日期不能为空！");
        }
        return this.redisLockService.tryLock(ReconciliationConstant.RECONCILIATION_SYNC_123_JOB + yearMonthDay, TimeUnit.HOURS, 12);
    }

    /**
     * 按年月日解锁
     *
     * @param yearMonthDay
     **/
    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty(yearMonthDay)) {
            throw new RuntimeException("拉取123数据job执行失败，日期不能为空！");
        }
        this.redisLockService.unlock(ReconciliationConstant.RECONCILIATION_SYNC_123_JOB + yearMonthDay);
    }


}
