package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.observer;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.CallbackArgumentsDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicCallbackService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationDocListRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.BaseEcrmBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal.BaseElectronicSignature;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ThirdReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;

/**
 * @describe: 电子签章回调
 * @author: xiaoyoujun
 * @date: 2022.11.30
 */
@Service("electronicCallbackService")
@Slf4j
public class ElectronicCallbackServiceImpl extends BaseElectronicSignature implements ElectronicCallbackService {


    @Autowired
    private ReconciliationDocListRepository reconciliationDocListRepository;

    @Autowired
    private ReconciliationDocListService reconciliationDocListService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private BaseEcrmBuildService baseEcrmBuildService;

    @Override
    public void electronicCallback(CallbackArgumentsDto dto) {
        log.info("电子签章回调!!!!!! {}", JSONUtil.toJsonPrettyStr(dto));
        ReconciliationDocListEntity reconciliationDocList = reconciliationDocListRepository.findByContractId(dto.getContractId());
        if (reconciliationDocList == null) {
            return;
        }
        if (StrUtil.isNotEmpty(dto.getReconciliationResult())){
            String code = ThirdReconciliationStatusEnum.findByThirdCode(dto.getReconciliationResult());
            if (StrUtil.isNotEmpty(code)){
                reconciliationDocList.setStatementStatus(code);
                this.reconciliationDocListRepository.updateById(reconciliationDocList);
                ReconciliationDocListVo reconciliationDocListVo = nebulaToolkitService.copyObjectByWhiteList(reconciliationDocList, ReconciliationDocListVo.class, HashSet.class, ArrayList.class);
                try {
                    //改成异步
                    if (ReconciliationStatusEnum.COMPLETE.getCode().equals(code)){
                        reconciliationDocListService.downloadContract(Lists.newArrayList(reconciliationDocList.getId()));
                    }
                    baseEcrmBuildService.pushECrm(reconciliationDocListVo);
                }catch (Exception e){
                    log.error("电子签章推送ecrm异常 ，e:{}",e.getMessage());
                }
            }

        }



    }
}
