package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.observer;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ReconciliationCallbackService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.SapReconciliationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.SapReconciliationRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Component
@Slf4j
public class ReconciliationCallbackServiceListener implements ReconciliationCallbackService {

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SapReconciliationRepository sapReconciliationRepository;

    @Override
    public void reconciliationCallback(ReconciliationCallbackDto dto) {
        log.info("sap客户对账单回调接口数据为，信息:{}", dto);
        if (Objects.nonNull(dto) && CollectionUtil.isNotEmpty(dto.getITEM1())){
            List<ReconciliationCallbackDataDto> callbackData = dto.getITEM1();
            //保存sap客户对账信息，tpm生成对账单直接从此表获取数据
            List<SapReconciliationEntity> reconciliationEntities = new ArrayList<>();
            /*List<SapReconciliationEntity> reconciliationEntities = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(callbackData,ReconciliationCallbackDataDto.class,SapReconciliationEntity.class, HashSet.class, ArrayList.class));
            if(CollectionUtils.isNotEmpty(reconciliationEntities)){
                reconciliationEntities.forEach(entity->{
                    entity.setTenantCode(TenantUtils.getTenantCode());
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                });*/

            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(Calendar.MONTH,-1);
            String fkdat = DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
            for (ReconciliationCallbackDataDto callbackDatum : callbackData) {
                SapReconciliationEntity entity = nebulaToolkitService.copyObjectByWhiteList(callbackDatum, SapReconciliationEntity.class, HashSet.class, ArrayList.class);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setKunagTxt(callbackDatum.getKunag_txt());
                entity.setZdocName(callbackDatum.getZdoc_name());
                entity.setZyszkBdyy(callbackDatum.getZyszk_bdyy());
                entity.setPstyvT(callbackDatum.getPstyv_t());
                entity.setNetwrHs(callbackDatum.getNetwr_hs());
                entity.setNetwrZk(callbackDatum.getNetwr_zk());
                entity.setKunweTxt(callbackDatum.getKunwe_txt());
                if (StringUtils.isNotBlank(entity.getZdocName())
                        && (entity.getZdocName().contains("期初") || entity.getZdocName().contains("总计") )) {
                //期初和总计没有日期，默认设置成上月1号
                    entity.setFkdat(fkdat + "01");
                }
                reconciliationEntities.add(entity);
            }
            this.createByreconciliationCallback(reconciliationEntities);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void createByreconciliationCallback(List<SapReconciliationEntity> reconciliationEntities) {
        if (CollectionUtil.isEmpty(reconciliationEntities)) {
            return;
        }
        //保存新数据
        sapReconciliationRepository.saveBatch(reconciliationEntities);
    }

}
