package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.*;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结案对账单  主体  策略实现类
 */
@Component
@Slf4j
public class AuditForAbstractReconciliation extends AbstractReconciliationGenerateStrategy<AuditCustomerDetailCollectionVo> {

    @Autowired(required = false)
    private AuditService auditService;

    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private AuditHandleSdkService auditHandleSdkService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.CLOSURE.getCode();
    }

    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.DETAIL.getCode();
    }

    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        String tenantCode = TenantUtils.getTenantCode();
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setTenantCode(tenantCode);
        detailCollectionDto.setCustomerCode(dto.getCustomerCode());
        log.info("生成结案对账单主体客户核销，查询客户参数:{}", detailCollectionDto);
        List<String> customerCodeList = auditService.auditDetailCustomerList(detailCollectionDto);

        TpmExamineCircularDto circularDto = new TpmExamineCircularDto();
        circularDto.setStartDate(dto.getStartDateTime());
        circularDto.setEndDate(dto.getEndDateTime());
        circularDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        circularDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        circularDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        circularDto.setTenantCode(tenantCode);
        circularDto.setCustomerCode(dto.getCustomerCode());
        List<String> circularCustomerCodeList = tpmExamineCircularService.tpmExamineCircularCustomerList(circularDto);

        AuditHandleDetailDto handleDetailDto = new AuditHandleDetailDto();
        handleDetailDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        handleDetailDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        handleDetailDto.setActivityBeginDate(dto.getStartDateTime());
        handleDetailDto.setActivityEndDate(dto.getEndDateTime());
        handleDetailDto.setTenantCode(tenantCode);
        handleDetailDto.setCustomerCode(dto.getCustomerCode());
        List<String> handleCustomerCodeList = auditHandleSdkService.auditHandleCustomerList(handleDetailDto);

        HashSet<String> codes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            codes.addAll(customerCodeList);
        }
        if (!CollectionUtils.isEmpty(circularCustomerCodeList)) {
            codes.addAll(circularCustomerCodeList);
        }
        if (!CollectionUtils.isEmpty(handleCustomerCodeList)) {
            codes.addAll(handleCustomerCodeList);
        }
        Map<String, Set<String>> map = new HashMap<>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), codes);
        log.info("生成结案对账单主体客户核销，客户信息:{}", map);
        return map;
    }

    /**
     * 获取核销明细集合 // 23/8/3 时间范围 由活动开始时间调整为审批通过时间
     * 返回结果数据从 1.结案核销明细、2.直接上账明细、3.考核通报管理 中获取。
     * <p>
     * 上账方式按以下四步执行，进行覆盖赋值。最后执行的，优先级最高。
     * 顺序1（折扣、报销）：根据上账单号匹配“结案核销管理“和”直接上账“明细数据的“结案形式”字段，然后赋值
     * 顺序2（备案）：根据上账单号（活动明细编码）判断已结案金额=0的，更新上账方式为“备案”（有批复没有结案金额的活动，比如2月活动3月结案，但3月未结案或延迟结案的部分活动）
     * 顺序3（随车搭赠）：根据上账单号匹配”结案核销表“和”直接上账“表中明细数据的结案形式为“随单”时，对该行数据重新赋值【随车搭赠】
     * 顺序4（CE报销）：根据上账单号匹配结案核销管理明细数据中活动明细编码，当该匹配数据的客商类型为”供应商“且核销单的是否付款为”是“时，对该行记录重新赋值”CE报销“。
     *
     * @param dto          对账单生成dto
     * @param customerCode 客户编码
     * @return {@link List}<{@link AuditCustomerDetailCollectionVo}>
     */
    @Override
    public List<AuditCustomerDetailCollectionVo> findDateList(ReconciliationGenerateDto dto,
                                                              String customerCode) {
        log.info("主体结案对账查询参数customerCode{},参数[{}]", customerCode, JSON.toJSONString(dto));
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setCustomerCode(customerCode);

        //结案核销客户活动明细数据
        List<AuditCustomerDetailCollectionVo> result = this.auditService.auditDetail(detailCollectionDto);
        log.info("主体结案对账customerCode{},结案核销客户活动明细数据【{}】", customerCode, JSON.toJSONString(result));

        //结案核销数据剔除
        result = result.stream()
                .filter(c -> UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatus())
                        || UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatusHead())
                        || (StringUtils.isNotBlank(c.getEndCaseForm()) && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode()))
                ).collect(Collectors.toList());

        result.forEach(r -> {
            r.setMenu("audit");
            //报销上账状态取的结案核销头表上的字段，这里重新赋值下。
            r.setReimburseUpAccountStatus(r.getReimburseUpAccountStatusHead());
        });

        //获取直接上账明细数据
        AuditHandleDetailDto handleDetailDto = new AuditHandleDetailDto();
        handleDetailDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        handleDetailDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        handleDetailDto.setActivityBeginDate(dto.getStartDateTime());
        handleDetailDto.setActivityEndDate(dto.getEndDateTime());
        handleDetailDto.setCustomerCode(customerCode);
        List<AuditHandleDetailVo> handleDetailVoList = auditHandleSdkService.findListForReconciliation(handleDetailDto);
        log.info("查询到的直接上账明细数据,客户【{}】：【{}】", customerCode, JSON.toJSONString(handleDetailVoList));
        handleDetailVoList = handleDetailVoList.stream()
                .filter(c -> UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatus())
                        || UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatusReimburse())
                        || (StringUtils.isNotBlank(c.getEndCaseForm()) && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode()))

                ).collect(Collectors.toList());
        List<AuditCustomerDetailCollectionVo> handleDetailCollectionVos = this.transformHandleDetail(handleDetailVoList);
        Set<String> activityFormCodeSet = handleDetailCollectionVos.stream().filter(k -> StringUtil.isNotEmpty(k.getActivityFormCode()))
                .map(AuditCustomerDetailCollectionVo::getActivityFormCode).collect(Collectors.toSet());
        Map<String, ActivityFormVo> activityFormMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(activityFormCodeSet)) {
            List<ActivityFormVo> activityFormVoList = activityFormService.findActivityFormByCode(activityFormCodeSet);
            if (CollectionUtil.isNotEmpty(activityFormVoList)) {
                activityFormMap.putAll(activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, v -> v, (n, o) -> n)));
            }
        }
        result.addAll(handleDetailCollectionVos);
        //获取考核通报明细数据
        TpmExamineCircularDto circularDto = new TpmExamineCircularDto();
        circularDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        circularDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        circularDto.setStartDate(dto.getStartDateTime());
        circularDto.setEndDate(dto.getEndDateTime());
        circularDto.setCustomerCode(customerCode);

        List<TpmExamineCircularRespVo> circularRespVos = this.tpmExamineCircularService.findListForReconciliation(circularDto);
        log.info("查询到的考核通报数据,客户【{}】：【{}】", customerCode, JSON.toJSONString(circularRespVos));

        //构建明细信息
        List<AuditCustomerDetailCollectionVo> detailCollectionVos = this.tpmExamineCircularRespVoToAuditCustomerDetailCollectionVo(circularRespVos);
        result.addAll(detailCollectionVos);
        Set<String> productCodeSet = detailCollectionVos.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtil.isNotEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                        v -> v, (n, o) -> n)));
            }
        }

        result.forEach(item -> {
            if (StringUtil.isNotEmpty(item.getProductCode())
                    && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
            //对账月份取计算开始时间月份
            item.setReconciliationYearMonth(com.biz.crm.mn.common.base.util.DateUtil.format(dto.getStartDateTime(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH));

            BigDecimal thisAuditAmount = Optional.ofNullable(item.getThisAuditAmount()).orElse(BigDecimal.ZERO);

            //CE报销
            if (CustomerSupplierTypeEnum.SUPPLIER.getValue().equals(item.getCustomerSupplierType())
                    && BooleanEnum.TRUE.getCapital().equals(item.getWhetherPay())) {
                item.setMethodAccounting(MethodAccountingEnum.CE_REIMBURSE.getDesc());
            }
            //随车搭赠
            else if (ReconciliationConstant.TEMPLATE_TYPE.equals(item.getActivityFormCode())) {
                item.setMethodAccounting(MethodAccountingEnum.FREE_RIDE.getDesc());
            }
            //备案
            else if (thisAuditAmount.compareTo(BigDecimal.ZERO) == 0) {
                item.setMethodAccounting(MethodAccountingEnum.FILINGS.getDesc());
            } else if (StringUtils.isNotBlank(item.getEndCaseForm()) &&
                    item.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())
                    && item.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                item.setMethodAccounting(MethodAccountingEnum.DISCOUNT.getDesc() + "," + MethodAccountingEnum.REIMBURSE.getDesc());
            }
            //折扣
            else if (EndCaseFormEnum.DISCOUNT.getCode().equals(item.getEndCaseForm())) {
                item.setMethodAccounting(MethodAccountingEnum.DISCOUNT.getDesc());
            }
            //报销
            else if (EndCaseFormEnum.REIMBURSE.getCode().equals(item.getEndCaseForm())) {
                item.setMethodAccounting(MethodAccountingEnum.REIMBURSE.getDesc());
            }
            if ("examine".equals(item.getMenu())) {
                item.setMethodAccounting("");
            }
            item.setAccountMethod(item.getMethodAccounting());
            item.setAccountNumber(item.getActivityDetailCode());
            if (StringUtil.isNotEmpty(item.getActivityFormCode())
                    && activityFormMap.containsKey(item.getActivityFormCode())) {
                item.setActivityFormName(activityFormMap.get(item.getActivityFormCode()).getActivityFormName());
            }
            if (StringUtil.isEmpty(item.getActivityFormName())) {
                item.setActivityFormName(item.getActivityFormCode());
            }
            item.setDealerUndertakeAmount(item.getCustomerFeeAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP)
                    : item.getCustomerFeeAmount().setScale(2, RoundingMode.HALF_UP));

            item.setCurrentAuditAmount(null);
            if ("audit".equals(item.getMenu())) {
                item.setCurrentAuditAmount(Objects.nonNull(item.getApplyAmount()) ? item.getApplyAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            } else if ("handle".equals(item.getMenu())) {
                item.setCurrentAuditAmount(Objects.nonNull(item.getThisAuditAmount()) ? item.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            } else if ("examine".equals(item.getMenu())) {
                item.setCurrentAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }


            item.setCurrentActualAuditAmount(null);
            if ("audit".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(Objects.nonNull(item.getThisAuditAmount()) ? item.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("handle".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(Objects.nonNull(item.getThisAuditAmountNotTax()) ? item.getThisAuditAmountNotTax().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("examine".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }

            item.setDeductionTaxAmount(null);
            if ("audit".equals(item.getMenu())) {
                if (Objects.nonNull(item.getDiscountTaxDeduction())) {
                    item.setDeductionTaxAmount(NumberUtil.add(item.getDiscountTaxDeduction(), item.getTaxQuota())
                            .setScale(2, RoundingMode.HALF_UP));
                }
            } else if ("handle".equals(item.getMenu())) {
                item.setDeductionTaxAmount(Objects.nonNull(item.getTaxDeductionAmount()) ?
                        item.getTaxDeductionAmount().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("examine".equals(item.getMenu())) {
                item.setDeductionTaxAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }

            item.setExamineCircularAmount(Objects.isNull(item.getExamineCircularAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getExamineCircularAmount().setScale(2, RoundingMode.HALF_UP));
            item.setReimburseTaxAmount(Objects.isNull(item.getReimburseTaxAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP));
            item.setReimburseAmount(Objects.isNull(item.getReimburseAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getReimburseAmount().setScale(2, RoundingMode.HALF_UP));
            item.setDiscountUpAccount(Objects.isNull(item.getDiscountUpAccount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getDiscountUpAccount().setScale(2, RoundingMode.HALF_UP));


        });

        List<AuditCustomerDetailCollectionVo> customerDetailCollectionVos = result.stream()
                .filter(c -> !(StringUtils.isNotBlank(c.getEndCaseForm())
                        && c.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())
                        && UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatus())))
                .collect(Collectors.toList());
        BigDecimal promotionTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull)
                .map(AuditCustomerDetailCollectionVo::getReimburseTaxAmount).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        promotionTotalAmount = Optional.ofNullable(promotionTotalAmount).orElse(BigDecimal.ZERO);

        //折扣合计金额(汇总入费用池金额) 过滤结案形式包含“折扣”的所有数据
        customerDetailCollectionVos = customerDetailCollectionVos.stream()
                .filter(b -> !(StringUtils.isNotBlank(b.getEndCaseForm())
                        && b.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())))
                .collect(Collectors.toList());
        BigDecimal discountTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull)
                .map(AuditCustomerDetailCollectionVo::getDiscountAmount).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        discountTotalAmount = Optional.ofNullable(discountTotalAmount).orElse(BigDecimal.ZERO);

        //随车金额(本次结案金额) 过滤结案形式=“随单”的所有数据
        customerDetailCollectionVos = customerDetailCollectionVos.stream()
                .filter(c -> !(StringUtils.isNotBlank(c.getEndCaseForm())
                        && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())))
                .collect(Collectors.toList());
        BigDecimal followCarAmount = customerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getThisAuditAmount)
                .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        followCarAmount = Optional.ofNullable(followCarAmount).orElse(BigDecimal.ZERO);

        //考核扣款金额
        BigDecimal examineCircularAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount())
                .filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        examineCircularAmount = Optional.ofNullable(examineCircularAmount).orElse(BigDecimal.ZERO);

        //合计金额
        BigDecimal totalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> {
            BigDecimal reimburseTaxAmount = Objects.isNull(x.getReimburseTaxAmount()) ? BigDecimal.ZERO : x.getReimburseTaxAmount();
            BigDecimal discountTaxAmount = Objects.isNull(x.getDiscountTaxAmount()) ? BigDecimal.ZERO : x.getDiscountTaxAmount();
            BigDecimal auditAmount = Objects.nonNull(x.getAuditAmount()) && ReconciliationConstant.TEMPLATE_TYPE.equals(x.getActivityFormCode()) ? x.getAuditAmount() : BigDecimal.ZERO;
            BigDecimal examineCircularAmount1 = Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount();
            return NumberUtil.add(NumberUtil.add(reimburseTaxAmount, discountTaxAmount), NumberUtil.add(auditAmount, examineCircularAmount1));
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalAmount = Optional.ofNullable(totalAmount).orElse(BigDecimal.ZERO);

        //生成pdf序号
        for (int i = 0; i < result.size(); i++) {
            AuditCustomerDetailCollectionVo vo = result.get(i);
            vo.setAuditNum(String.valueOf(i + 1));
            vo.setDiscountTotalAmount(discountTotalAmount);
            vo.setPromotionTotalAmount(promotionTotalAmount);
            vo.setPromotionAndDiscountTotalAmount(discountTotalAmount.add(promotionTotalAmount));
            vo.setFollowCarAmount(followCarAmount);
            vo.setExamineCircularAmount(examineCircularAmount);
            vo.setTotalAmount(totalAmount);
        }
        return result;
    }

    public List<AuditCustomerDetailCollectionVo> transformHandleDetail(List<AuditHandleDetailVo> handleDetailVoList) {
        List<AuditCustomerDetailCollectionVo> detailCollectionVos = new ArrayList<>();
        for (AuditHandleDetailVo handleDetailVo : handleDetailVoList) {
            AuditCustomerDetailCollectionVo collectionVo = new AuditCustomerDetailCollectionVo();
            collectionVo.setMenu("handle");
            //id
            collectionVo.setId(handleDetailVo.getId());
            //编码
            collectionVo.setActivityDetailCode(handleDetailVo.getAuditHandleDetailCode());

            //客户信息
            collectionVo.setCustomerCode(handleDetailVo.getCustomerCode());
            collectionVo.setCustomerName(handleDetailVo.getCustomerName());
            //业务单元
            collectionVo.setBusinessUnitCode(handleDetailVo.getBusinessUnitCode());
            //业态
            collectionVo.setBusinessFormatCode(handleDetailVo.getBusinessFormatCode());
            //销售机构 错误的
            collectionVo.setSalesInstitutionCode(handleDetailVo.getSalesOrgCode());
            collectionVo.setSalesInstitutionName(handleDetailVo.getSalesOrgName());
            //销售大区 错误的
            collectionVo.setSalesRegionCode(handleDetailVo.getSalesOrgCode());
            collectionVo.setSalesRegionName(handleDetailVo.getSalesOrgName());
            //销售省区 错误的
            collectionVo.setSalesOrgCode(handleDetailVo.getSalesGroupCode());
            collectionVo.setSalesOrgName(handleDetailVo.getSalesGroupName());
            //产品名称
            collectionVo.setProductCode(handleDetailVo.getProductCode());
            collectionVo.setProductName(handleDetailVo.getProductName());
            //预算项目
            collectionVo.setBudgetItemCode(handleDetailVo.getYearBudgetCode());
            collectionVo.setBudgetItemName(handleDetailVo.getYearBudgetName());
            //活动形式
            collectionVo.setActivityFormCode(handleDetailVo.getActivityFormCode());
            collectionVo.setActivityFormName(handleDetailVo.getActivityFormName());
            //活动开始时间
            if (Objects.nonNull(handleDetailVo.getActivityBeginDate())) {
                collectionVo.setActivityBeginTime(handleDetailVo.getActivityBeginDate());
            } else {
                Calendar instance = Calendar.getInstance();
                instance.set(Calendar.DAY_OF_MONTH, 1);
                collectionVo.setActivityBeginTime(instance.getTime());
            }
            //活动结束时间
            if (Objects.nonNull(handleDetailVo.getActivityEndDate())) {
                collectionVo.setActivityEndTime(handleDetailVo.getActivityEndDate());
            } else {
                Calendar instance = Calendar.getInstance();
                int maxDay = instance.getMaximum(Calendar.DAY_OF_MONTH);
                instance.set(Calendar.DAY_OF_MONTH, maxDay);
                collectionVo.setActivityEndTime(instance.getTime());
            }
            //结案形式
            collectionVo.setEndCaseForm(handleDetailVo.getEndCaseForm());
            //申请金额
            collectionVo.setApplyAmount(handleDetailVo.getApplyFee());
            //本次应结案金额
            collectionVo.setThisAuditAmount(handleDetailVo.getThisAuditAmountTax());
            //直接上账的本次实际结案金额
            collectionVo.setThisAuditAmountNotTax(handleDetailVo.getThisAuditAmountNotTax());
            //扣税金额
            //collectionVo.setTaxDeductionAmount(handleDetailVo.getDeductTaxAmount());
            collectionVo.setTaxDeductionAmount(handleDetailVo.getDeductTaxAmount());
            //入费用池金额
            collectionVo.setDiscountAmount(handleDetailVo.getInFeePoolAmount());
            //备注
            collectionVo.setRemark(handleDetailVo.getRemark());
            //起草人
            collectionVo.setCreateName(handleDetailVo.getCreateName());
            //便签名称
            collectionVo.setProcessTitle(handleDetailVo.getAuditHandleName());
            //折扣上账状态
            collectionVo.setUpAccountStatus(handleDetailVo.getUpAccountStatus());
            //报销上账状态
            collectionVo.setReimburseUpAccountStatus(handleDetailVo.getUpAccountStatusReimburse());
            //报销金额
            //collectionVo.setReimburseTaxAmount(handleDetailVo.getReimburseAmountTax());
            collectionVo.setReimburseTaxAmount(handleDetailVo.getThisAuditAmountNotTax());
            detailCollectionVos.add(collectionVo);
        }
        return detailCollectionVos;
    }

    public List<AuditCustomerDetailCollectionVo> tpmExamineCircularRespVoToAuditCustomerDetailCollectionVo(List<TpmExamineCircularRespVo> circularRespVos) {
        Map<String, String> examineType = dictToolkitService.findMapByDictTypeCode(ReconciliationConstant.EXAMINE_CIRCULAR_EXAMINE_TYPE);
        List<AuditCustomerDetailCollectionVo> detailCollectionVos = new ArrayList<>();
        for (TpmExamineCircularRespVo circularRespVo : circularRespVos) {
            AuditCustomerDetailCollectionVo collectionVo = new AuditCustomerDetailCollectionVo();
            collectionVo.setMenu("examine");
            //id
            collectionVo.setId(circularRespVo.getId());
            //编码
            collectionVo.setActivityDetailCode(circularRespVo.getExamineCircularCode());
            //中心
            collectionVo.setCenter(ReconciliationConstant.TPM_EXAMINE_CIRCULAR);
            //客户信息
            collectionVo.setCustomerCode(circularRespVo.getCustomerCode());
            collectionVo.setCustomerName(circularRespVo.getCustomerName());
            //业务单元
            collectionVo.setBusinessUnitCode(circularRespVo.getBusinessUnitCode());
            //业态
            collectionVo.setBusinessFormatCode(circularRespVo.getBusinessFormatCode());
            //销售机构
            collectionVo.setSalesInstitutionCode(circularRespVo.getSalesOrgCode());
            collectionVo.setSalesInstitutionName(circularRespVo.getSalesOrgName());
            //销售大区
            collectionVo.setSalesRegionCode(circularRespVo.getSalesDepartmentCode());
            collectionVo.setSalesRegionName(circularRespVo.getSalesDepartmentName());
            //销售省区
            collectionVo.setSalesOrgCode(circularRespVo.getSalesGroupCode());
            collectionVo.setSalesOrgName(circularRespVo.getSalesGroupName());
            //预算项目
            collectionVo.setBudgetItemCode(circularRespVo.getBudgetProjectCode());
            collectionVo.setBudgetItemName(circularRespVo.getBudgetProjectName());
            //活动形式
            collectionVo.setActivityFormName(circularRespVo.getActivityFormName());
            collectionVo.setActivityFormCode(circularRespVo.getActivityForm());
            //活动开始时间
            if (Objects.nonNull(circularRespVo.getStartDate())) {
                collectionVo.setActivityBeginTime(circularRespVo.getStartDate());
            } else {
                Calendar instance = Calendar.getInstance();
                instance.set(Calendar.DAY_OF_MONTH, 1);
                collectionVo.setActivityBeginTime(instance.getTime());
            }
            //活动结束时间
            if (Objects.nonNull(circularRespVo.getEndDate())) {
                collectionVo.setActivityEndTime(circularRespVo.getEndDate());
            } else {
                Calendar instance = Calendar.getInstance();
                int maxDay = instance.getMaximum(Calendar.DAY_OF_MONTH);
                instance.set(Calendar.DAY_OF_MONTH, maxDay);
                collectionVo.setActivityEndTime(instance.getTime());
            }
            //形式说明
            collectionVo.setActivityFormDesc(examineType.get(circularRespVo.getExamineType()));
            //本次应结案金额
            collectionVo.setThisAuditAmount(circularRespVo.getExamineCircularAmount());
            //本次实际结案金额
            //折扣金额
            collectionVo.setDiscountTaxAmount(circularRespVo.getExamineCircularAmount());
            //备注
            collectionVo.setRemark(circularRespVo.getRemark());
            //起草人
            collectionVo.setCreateName(circularRespVo.getCreateName());
            //便签名称
            collectionVo.setProcessTitle(circularRespVo.getExamineCircularName());
            //考核扣款金额
            collectionVo.setExamineCircularAmount(circularRespVo.getExamineCircularAmount());
            collectionVo.setProductName(circularRespVo.getProductName());
            detailCollectionVos.add(collectionVo);
        }
        return detailCollectionVos;
    }

    /**
     * 转换table
     *
     * @param propertyName  属性名
     * @param propertyClass 属性类
     * @return {@link String}
     */
    @Override
    public String convert(String propertyName, AuditCustomerDetailCollectionVo propertyClass) {
        ReconciliationPropertyEnum.AuditDetailPropertyEnum auditDetailPropertyEnum =
                ReconciliationPropertyEnum.AuditDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(auditDetailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        switch (auditDetailPropertyEnum) {
            case audit_number:
                return propertyClass.getAuditNum();
            case audit_customerName:
                return propertyClass.getCustomerName();
            case audit_firstChannelName:
                return propertyClass.getFirstChannelName();
            case audit_secondChannelName:
                return propertyClass.getSecondChannelName();
            case audit_center:
                return "6000";
            case audit_businessFormatCode:
                return BusinessFormatEnum.getDesc(propertyClass.getBusinessFormatCode());
            case audit_businessUnitCode:
                return BusinessUnitEnum.getDesc(propertyClass.getBusinessUnitCode());
            case audit_salesInstitutionName:
                return propertyClass.getSalesInstitutionName();
            case audit_salesOrgRegionName:
                return propertyClass.getSalesRegionName();
            case audit_salesOrgProvinceName:
                return propertyClass.getSalesOrgName();
            case audit_budgetProjectName:
                return StringUtils.isBlank(propertyClass.getBudgetItemName()) ? propertyClass.getHeadBudgetItemName() : propertyClass.getBudgetItemName();
            case audit_brand_Txt:
                return propertyClass.getProductBrandName();
            case audit_productName:
                return propertyClass.getProductName();
            case audit_activityFormName:
                return StringUtils.isNotBlank(propertyClass.getActivityFormName()) ? propertyClass.getActivityFormName() : propertyClass.getActivityFormCode();
            case audit_activityBeginDate:
                if (Objects.nonNull(propertyClass.getActivityBeginTime())) {
                    return DateUtil.formatDate(propertyClass.getActivityBeginTime());
                }
                return StrUtil.EMPTY;
            case audit_activityEndDate:
                if (Objects.nonNull(propertyClass.getActivityEndTime())) {
                    return DateUtil.formatDate(propertyClass.getActivityEndTime());
                }
                return StrUtil.EMPTY;

            case audit_description:
                return propertyClass.getActivityFormDesc();
            case audit_dealerBearFee:
                return propertyClass.getDealerUndertakeAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString()
                        : propertyClass.getDealerUndertakeAmount().setScale(2, RoundingMode.HALF_UP).toString();
            case audit_approvedAmount:
                return Optional.ofNullable(propertyClass.getApplyAmount()).orElse(BigDecimal.ZERO).toPlainString();
            case audit_closingAmount:
                if (Objects.nonNull(propertyClass.getCurrentAuditAmount())) {
                    return propertyClass.getCurrentAuditAmount().toString();
                }
                return "";
            case audit_taxQuota:
                if (Objects.nonNull(propertyClass.getDeductionTaxAmount())) {
                    return propertyClass.getDeductionTaxAmount().toString();
                }
                return "";
            case audit_finalClosingAmount:
                if (Objects.nonNull(propertyClass.getCurrentActualAuditAmount())) {
                    return propertyClass.getCurrentActualAuditAmount().toString();
                }
                return "";
            case audit_discountTaxTotalAmount:
                return propertyClass.getDiscountUpAccount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString() : propertyClass.getDiscountUpAccount().setScale(2, RoundingMode.HALF_UP).toPlainString();
            case audit_reimburse_TaxAmount:
                return propertyClass.getReimburseTaxAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString() : propertyClass.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP).toString();
            case create_name:
                return propertyClass.getCreateName();
            case examine_circular_amount:
                return Objects.isNull(propertyClass.getExamineCircularAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString() : propertyClass.getExamineCircularAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
            case process_title:
                return propertyClass.getProcessTitle();
            case method_accounting:
                return propertyClass.getAccountMethod();
            case up_account_code:
                return propertyClass.getAccountNumber();
            default:
                return StringUtils.EMPTY;
        }
    }

    /**
     * 转换汇总表头
     *
     * @param propertyName 属性名
     * @param propertyList 属性列表
     * @return {@link String}
     */
    @Override
    public String convertHead(String propertyName, List<Object> propertyList) {
        ReconciliationPropertyHeadEnum.AuditDetailPropertyEnum auditDetailPropertyEnum =
                ReconciliationPropertyHeadEnum.AuditDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(auditDetailPropertyEnum) || CollectionUtils.isEmpty(propertyList)) {
            return StringUtils.EMPTY;
        }
        List<AuditCustomerDetailCollectionVo> customerDetailCollectionVos =
                (List<AuditCustomerDetailCollectionVo>) (List) propertyList;
        switch (auditDetailPropertyEnum) {
            case audit_year_month:
                //对账月份取计算开始日期月份
                return customerDetailCollectionVos.get(0).getReconciliationYearMonth();
            case audit_customer_name:
                return customerDetailCollectionVos.get(0).getCustomerName();
            case audit_total_reimburseTaxAmount:
                return customerDetailCollectionVos.get(0).getPromotionTotalAmount().toString();
            case audit_total_discountTaxTotalAmount:
                return customerDetailCollectionVos.get(0).getDiscountTotalAmount().toString();
            case audit_toytal_discount_And_reimbursement:
                return customerDetailCollectionVos.get(0).getPromotionAndDiscountTotalAmount().toString();
            case car_amount:
                return customerDetailCollectionVos.get(0).getFollowCarAmount().toString();
            case assessment_deduction_amount:
                return customerDetailCollectionVos.get(0).getExamineCircularAmount().toString();
            case total_amount:
                return customerDetailCollectionVos.get(0).getTotalAmount().toString();
            default:
                return StrUtil.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }

}
