package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailAuditTypeEnum;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结案对账单 分子  实现类
 */
@Component
@Slf4j
public class AuditSubForAbstractReconciliation extends AbstractReconciliationGenerateStrategy<AuditCustomerDetailCollectionVo> {

    @Autowired(required = false)
    private AuditService auditService;

    @Autowired(required = false)
    private Zmsd121Service zmsd121Service;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.CLOSURE.getCode();
    }

    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode();
    }

    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        //查询zmsd121数据
        String startDate = DateUtil.format(dto.getStartDateTime(), DatePattern.PURE_DATE_PATTERN);
        String endDate = DateUtil.format(dto.getEndDateTime(), DatePattern.PURE_DATE_PATTERN);
        String ds = get121Ds(dto.getStartDateTime());
        log.info("生成结案对账单121,查询参数:{}", dto);
        log.info("生成结案对账单121,startDate:{},endDate:{},ds:{}", startDate, endDate, ds);
        List<String> customerCodes = zmsd121Service.findCustomerListByDate(startDate, endDate, dto.getCustomerCode(), ds);
        Map<String, Set<String>> map = new HashMap<>(4);
        map.put(BusinessUnitEnum.SON_COMPANY.getCode(), Sets.newHashSet(customerCodes));
        log.info("生成结案对账单121客户编码{}", map);
        return map;
    }

    /**
     * /23/8/3 时间范围 由活动开始时间调整为审批通过时间
     *
     * @param dto          生成对账单信息
     * @param customerCode 客户编码
     * @return
     */
    @Override
    public List<AuditCustomerDetailCollectionVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {

        log.info("分子结案对账查询参数customerCode{},参数[{}]", customerCode, JSON.toJSONString(dto));
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        if (StringUtils.isNotEmpty(customerCode)) {
            String[] split = customerCode.split("-");
            detailCollectionDto.setSubReconciliationCustomerCode(split[0]);
            if (split.length > 1) {
                detailCollectionDto.setSubReconciliationInstitutionCode(split[1]);
            }
        }
        List<AuditCustomerDetailCollectionVo> result = this.auditService.auditDetail(detailCollectionDto);
        Set<String> productCodeSet = result.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtil.isNotEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                        v -> v, (n, o) -> n)));
            }
        }
        result.forEach(item -> {
            if (StringUtil.isNotEmpty(item.getProductCode())
                    && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });
        log.info("分子结案对账customerCode{}单查询结果【{}】", customerCode, JSON.toJSONString(result));
        return result;
    }

    @Override
    public String convert(String propertyName, AuditCustomerDetailCollectionVo propertyClass) {
        ReconciliationPropertyEnum.AuditSubDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.AuditSubDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        switch (detailPropertyEnum) {
            case audit_sub_channel:
                return propertyClass.getFirstChannelName();
            case audit_sub_sale_org:
                return propertyClass.getSalesRegionName();
            case audit_sub_customer:
                return propertyClass.getCustomerName();
            case audit_sub_activity_form_name:
                return propertyClass.getActivityFormName();
            case head_budget_item_name:
                return propertyClass.getHeadBudgetItemName();
            case product_name:
                return propertyClass.getProductName();
            case start_date:
                if (Objects.nonNull(propertyClass.getActivityBeginTime())) {
                    return DateUtil.format(propertyClass.getActivityBeginTime(), "yyyy-MM-dd");
                } else {
                    return StringUtils.EMPTY;
                }
            case end_date:
                if (Objects.nonNull(propertyClass.getActivityEndTime())) {
                    return DateUtil.format(propertyClass.getActivityEndTime(), "yyyy-MM-dd");
                } else {
                    return StringUtils.EMPTY;
                }
            case approved_amount:
                if (Objects.nonNull(propertyClass.getApplyAmount())) {
                    return propertyClass.getApplyAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
            case end_case_form:
                return EndCaseFormEnum.codeToValue(propertyClass.getEndCaseForm());
            case amount:
                // 1028118 生产----对账单据列表---结案对账单取数结案核销管理逻辑更新
                if (StringUtils.equals(AuditFormEnum.EXPENSE.getCode(), propertyClass.getEndCaseForm()) || StringUtils.equals(AuditFormEnum.RED_INVOICE.getCode(), propertyClass.getEndCaseForm())) {
                    //红字视为报销字段 取报销含税
                    if (Objects.nonNull(propertyClass.getReimburseTaxAmount())) {
                        return propertyClass.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                    } else {
                        return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
                    }
                } else if (StringUtils.equals(AuditFormEnum.DISCOUNT.getCode(), propertyClass.getEndCaseForm()) || StringUtils.equals(AuditFormEnum.ORDER.getCode(), propertyClass.getEndCaseForm())) {
                    //随单视为折扣字段 其它取折扣应处理金额含税
                    if (Objects.nonNull(propertyClass.getDiscountTaxAmount())) {
                        return propertyClass.getDiscountTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                    } else {
                        return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
                    }
                }
                //其它取本次结案金额含税
                if (Objects.nonNull(propertyClass.getThisAuditAmount())) {
                    return propertyClass.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
            case remark:
                return propertyClass.getRemark();
            case audit_activity_name:
                return propertyClass.getActivityName();
            case audit_way:
                return SubComActivityDetailAuditTypeEnum.codeToName(propertyClass.getAuditWay());
            default:
                return StringUtils.EMPTY;
        }
    }

    @Override
    public String convertHead(String propertyName, List<Object> propertyList) {
        ReconciliationPropertyHeadEnum.AuditSubHeadlPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.AuditSubHeadlPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(headPropertyEnum) || CollectionUtils.isEmpty(propertyList)) {
            return StringUtils.EMPTY;
        }
        List<SapForReconciliationPdfHeadVo> pdfHeadVos = JSON.parseArray(JSON.toJSONString(propertyList), SapForReconciliationPdfHeadVo.class);
        SapForReconciliationPdfHeadVo headVo = pdfHeadVos.get(0);
        switch (headPropertyEnum) {
            case audit_sub_item_name:
                return headVo.getName();
            case audit_sub_amount:
                return Objects.nonNull(headVo.getAmount()) ?
                        headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : StringUtils.EMPTY;
            default:
                return StrUtil.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }

    /**
     * 获取121数据的ds，默认下一个月的第一天，比如取2023年5月数据，ds等于20230601
     * 2023/7/7 ds 调整为当月最后一天
     * 2023/8/15 ds 调整回默认下一个月的第一天，比如取2023年5月数据，ds等于20230601
     *
     * @param date
     * @return
     */
    public static String get121Ds(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 1);
        String ds = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_NO_CH);
        return ds + "01";
    }
}
