package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.Zmfi046Dto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.Zmfi046Voservice;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.Zmfi046SdkVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.DistributionReconciliationAuditVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分销业务对账单
 *
 * @author: yaoyongming
 * @date: 2023/7/19 16:59
 */

@Component
@Slf4j
public class DistributionAuditForAbstractReconciliation extends AbstractReconciliationGenerateStrategy<DistributionReconciliationAuditVo> {

    @Autowired(required = false)
    private AuditService auditService;

    @Autowired(required = false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;

    @Autowired(required = false)
    TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private Zmfi046Voservice zmfi046Voservice;

    @Autowired(required = false)
    private ProductVoService productVoService;

    /**
     * 对账类型
     *
     * @return 对账类型编码
     */
    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.DISTRIBUTION.getCode();
    }

    /**
     * 业务类型 用于同对账类型 不同数据源的扩展
     *
     * @return {@link String}
     */
    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.AUDIT.getCode();
    }

    /**
     * 获取客户数据列表
     *
     * @param dto 生成对账单信息
     * @return {@link List}<{@link T}>
     */
    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setTenantCode(TenantUtils.getTenantCode());
        detailCollectionDto.setCustomerCode(dto.getCustomerCode());
        //渠道：经销
        //渠道编码：20
        detailCollectionDto.setChannelCode("20");
        //销售机构：经销-常温-内蒙古数科数字营销有限公司
        //销售机构编码：20111171
        detailCollectionDto.setSalesInstitutionCode("20111171");
        log.info("生成对账单:主体客户-核销，detailCollectionDto:{}", detailCollectionDto);
        List<String> customerCodeList = auditService.auditDetailEndCaseCustomerList(detailCollectionDto);

//        1039255 [2023-12-28]【验收前】电商对账单逻辑修正
//        1.查找对应业态、对应业务单元，核销明细审批通过时间在2023.10.01 00:00:00——1023.10.31 23:59:59之间的，结案审批状态为审批通过的核销明细数据
//        2.查找活动开始年月（活动开始时间所属年月）为对账规则开始年月（10月）的审批状态为审批通过的核销明细数据
//        1和2为对账的基础数据（符合对账规则的数据），其中结案客户一个结案客户生成一张对账单
        detailCollectionDto.setActivityBeginTime(null);
        detailCollectionDto.setActivityEndTime(null);
        detailCollectionDto.setActivityBeginTimeYearMonthStr(dto.getStartDate().substring(0,7));
        List<String> customerCodeList2 = auditService.auditDetailEndCaseCustomerList(detailCollectionDto);
        customerCodeList.addAll(customerCodeList2);

        Map<String, Set<String>> map = new HashMap<>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), Sets.newHashSet(customerCodeList));
        return map;
    }

    /**
     * 获取数据列表
     *
     * @param dto          生成对账单信息
     * @param customerCode 客户编码
     * @return {@link List}<{@link T}>
     */
    @Override
    public List findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List<DistributionReconciliationAuditVo> list = new ArrayList<>();
        //核销明细数据
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setEndCaseCustomerCode(customerCode);
        //渠道：经销
        //渠道编码：20
        detailCollectionDto.setChannelCode("20");
        //销售机构：经销-常温-内蒙古数科数字营销有限公司
        //销售机构编码：20111171
        detailCollectionDto.setSalesInstitutionCode("20111171");
        log.info("生成对账单:主体客户-核销，detailCollectionDto:{}", detailCollectionDto);
        List<AuditCustomerDetailCollectionVo> auditCustomerDetails = this.auditService.auditDetail(detailCollectionDto);

//        1039255 [2023-12-28]【验收前】电商对账单逻辑修正
//        1.查找对应业态、对应业务单元，核销明细审批通过时间在2023.10.01 00:00:00——1023.10.31 23:59:59之间的，结案审批状态为审批通过的核销明细数据
//        2.查找活动开始年月（活动开始时间所属年月）为对账规则开始年月（10月）的审批状态为审批通过的核销明细数据
//        1和2为对账的基础数据（符合对账规则的数据），其中结案客户一个结案客户生成一张对账单
        detailCollectionDto.setActivityBeginTime(null);
        detailCollectionDto.setActivityEndTime(null);
        detailCollectionDto.setActivityBeginTimeYearMonthStr(dto.getStartDate().substring(0,7));
        List<AuditCustomerDetailCollectionVo> auditCustomerDetails2 = auditService.auditDetail(detailCollectionDto);

        List<String> auditDetailCodeList = auditCustomerDetails.stream().map(AuditCustomerDetailCollectionVo::getAuditDetailCode).collect(Collectors.toList());
        for (AuditCustomerDetailCollectionVo auditCustomerDetailCollectionVo : auditCustomerDetails2) {
            if (!auditDetailCodeList.contains(auditCustomerDetailCollectionVo.getAuditDetailCode())){
                auditCustomerDetails.add(auditCustomerDetailCollectionVo);
            }
        }

        if (CollectionUtils.isEmpty(auditCustomerDetails)) {
            return new ArrayList();
        }
        Set<String> productCodeSet = auditCustomerDetails.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtil.isNotEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                        v -> v, (n, o) -> n)));
            }
        }
        auditCustomerDetails.forEach(item -> {
            if (StringUtil.isNotEmpty(item.getProductCode())
                    && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });

        Map<String, List<AuditCustomerDetailCollectionVo>> auditCustomerDetailMap = auditCustomerDetails.stream()
                .peek(item -> {
                    if (StringUtils.isEmpty(item.getOffsetProductCode())){
                        item.setOffsetProductCode("空");
                        item.setOffsetProductName("空");
                    }
                })
                .collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getOffsetProductCode));

        String sapCustomerCode = customerCode.substring(0, 10);
        String yearMonth = DateUtil.format(dto.getStartDateTime(), "yyyy-MM");
        //分销客户月度销售表
        TpmDistributionCustomerMonthSaleDto distributionMonthDto = new TpmDistributionCustomerMonthSaleDto();
        distributionMonthDto.setCustomerCode(sapCustomerCode);
        distributionMonthDto.setDistributionCustomerMonthSaleYearMonth(yearMonth);
        List<TpmDistributionCustomerMonthSaleRespVo> distributionCustomerVoList = tpmDistributionCustomerMonthSaleService.findDistribution(distributionMonthDto);
        Map<String, List<TpmDistributionCustomerMonthSaleRespVo>>  distributionCustomerMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(distributionCustomerVoList)) {
            distributionCustomerMap = distributionCustomerVoList.stream().collect(
                    Collectors.groupingBy(TpmDistributionCustomerMonthSaleRespVo::getProductCode));
        }
        //分销物流结案数据表
        TpmDistributionCustomerAuditDataDto distributionAuditDto = new TpmDistributionCustomerAuditDataDto();
        distributionAuditDto.setCustomerCode(sapCustomerCode);
        distributionAuditDto.setDistributionCustomerAuditYearMonth(yearMonth);
        List<TpmDistributionCustomerAuditDataRespVo> distributionAuditVoList = tpmDistributionCustomerAuditDataService.findListByConditions(distributionAuditDto);
        Map<String, Integer> distributionAuditMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(distributionAuditVoList)) {
           distributionAuditMap = distributionAuditVoList.stream().collect(
                    Collectors.groupingBy(TpmDistributionCustomerAuditDataRespVo::getProductCode, Collectors.summingInt(e -> e.getInFactAuditQuantity() != null ? e.getInFactAuditQuantity() : 0)));
        }

        //e.供货价：根据对账单T-1计算年月+客户取月度销售数据表“供货价”；
        //f.销售数量：根据对账单T-1计算年月+客户+产品取月度销售数据表“月度销量”；
        //g.订货金额：根据对账单T-1计算年月+客户+产品取月度销售数据表“月度销售金额”；
        //h.核销数量：根据对账单T-1计算年月+客户+产品取月度销售数据表“月度销量-手工已核销销量”；
        //i.组合装数量：根据对账单T-1计算年月+客户+产品取月度销售数据表“捆赠销售数量”；
        //j.基础数量：根据对账单T-1计算年月+客户+产品取月度销售数据表“销售数量-手工已核销销量-捆赠销售数量-月度剔量数量”的值；
        //k.组合装费用：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为组合装费用 、红字发票上账状态为上账成功的本次结案金额汇总值；
        //l.基础旬返费用：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为分销基础返点（旬返）、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //m.基础目标返费用：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为 月度目标达成返点（分销）、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //n.基础月返（基础运营返）：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为基础返点-月返、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //o.实际人员返点：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为人员费用、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //p.实际核销物流数量：根据对账单T-1计算年月+客户+产品+销售机构+业态+渠道取分销物流结案数据表中“实际核销数量”；
        //q.物流返点费用：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为物流支持（分销） 、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //r.季返：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为季返（分销） 、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //s.其它支持1：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为其它支持1（分销） 、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //t.其它支持2：根据对账单T-1计算月份+客户+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为其它支持2（分销） 、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //u.罚款金额：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中活动年月、活动形式为考核罚款（分销）、电商红字发票上账状态为上账成功的本次结案金额汇总值的绝对值；
        //v.上月已上账：根据对账单T-1计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中审批通过年月、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //已过期-----w.基础返当月上账：根据对账单计算月份+客户+产品+销售机构+业态+渠道取结案核销管理表中审批通过年月、活动形式除人员物流外、电商红字发票上账状态为上账成功的本次结案金额汇总值；
        //x.人员物流当月上账：对账要素中字段“实际人员返点”+“物流返点费用”的合计值；
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        for (String k : auditCustomerDetailMap.keySet()) {
            List<AuditCustomerDetailCollectionVo> details = auditCustomerDetailMap.get(k);

            DistributionReconciliationAuditVo reconciliationVo = nebulaToolkitService.copyObjectByWhiteList(details.get(0), DistributionReconciliationAuditVo.class, HashSet.class, ArrayList.class);
            reconciliationVo.setCustomerCode(details.get(0).getEndCaseCustomerCode());
            reconciliationVo.setSapCustomerCode(sapCustomerCode);
            reconciliationVo.setCustomerName(details.get(0).getEndCaseCustomerName());

            BigDecimal supplyPrice = BigDecimal.ZERO;
            Integer monthSaleQuantity = 0;
            BigDecimal monthSaleAmount = BigDecimal.ZERO;
            BigDecimal auditQuantity = BigDecimal.ZERO;
            Integer boundGiftSaleQuantity = 0;
            Integer baseQuantity = 0;
            BigDecimal combinationFee = BigDecimal.ZERO;
            BigDecimal distributionBaseTen = BigDecimal.ZERO;
            BigDecimal goalAchievement = BigDecimal.ZERO;
            BigDecimal month = BigDecimal.ZERO;
            BigDecimal staffFee = BigDecimal.ZERO;
            Integer logisticsQuantity = 0;
            BigDecimal logistics = BigDecimal.ZERO;
            BigDecimal quarter = BigDecimal.ZERO;
            BigDecimal otherCooperation = BigDecimal.ZERO;
            BigDecimal otherCooperationTwo = BigDecimal.ZERO;
            BigDecimal fine = BigDecimal.ZERO;
            BigDecimal lastMonthAccount = BigDecimal.ZERO;
            for (AuditCustomerDetailCollectionVo detail : details) {
                BigDecimal thisAuditAmount = bdNull(detail.getThisAuditAmount());
//                上月已上账费用  根据结案客户和冲差产品查找对应的活动开始时间和结案审批过时间所属年月都为对账规则所属年月对应的结案明细的本次结案金额汇总
                if (null != detail.getProcessDate() && yearMonthFormat.format(detail.getProcessDate()).equals(yearMonth)){
                    lastMonthAccount = lastMonthAccount.add(thisAuditAmount);
                }
                if (StringUtils.isBlank(detail.getActivityFormCode())) {
                    continue;
                }
                String formCode = detail.getActivityFormCode();
                //季返  DA45
                //组合装费用 DB15
                //分销基础返点（旬返）  DA35
                //月度目标达成返点（分销）   DB01
                //分销基础返点（月返）  DA36
                //年度目标达成返点（分销）  DA67
                //仓间不均  DA08
                //物流支持（分销）  DA91
                //人员费用（分销） DA78
                switch (formCode) {
                    case "DB15" :
                        combinationFee = combinationFee.add(thisAuditAmount);
                        break;
                    case "DA35":
                        distributionBaseTen = distributionBaseTen.add(thisAuditAmount);
                        break;
                    case "DB01":
                        goalAchievement = goalAchievement.add(thisAuditAmount);
                        break;
                    case "DA36":
                        month = month.add(thisAuditAmount);
                        break;
                    case "DA78":
                        staffFee = staffFee.add(thisAuditAmount);
                        break;
                    case "DA91":
                        logistics = logistics.add(thisAuditAmount);
                        break;
                    case "DA45":
                        quarter = quarter.add(thisAuditAmount);
                        break;
                    case "其它支持1（分销）":
                        otherCooperation = otherCooperation.add(thisAuditAmount);
                        break;
                    case "其它支持2（分销）":
                        otherCooperationTwo = otherCooperationTwo.add(thisAuditAmount);
                        break;
                    case "DA71":
                        fine = fine.add(thisAuditAmount);
                        break;
                    default:
                        break;
                }
            }

            if (!distributionCustomerMap.isEmpty() && !CollectionUtils.isEmpty(distributionCustomerMap.get(k))) {
                List<TpmDistributionCustomerMonthSaleRespVo> monthList = distributionCustomerMap.get(k);
                for (TpmDistributionCustomerMonthSaleRespVo monthVo : monthList) {
                    Integer monthSaleQuantityTemp = intNull(monthVo.getMonthSaleQuantity());
                    BigDecimal manualAuditSaleQuantityTemp = bdNull(monthVo.getManualAuditSaleQuantity());
                    Integer boundGiftSaleQuantityTemp = intNull(monthVo.getBoundGiftSaleQuantity());
                    Integer ridSaleQuantityTemp = bdNull(monthVo.getRidSaleQuantity()).intValue();

                    supplyPrice = supplyPrice.add(bdNull(monthVo.getSupplyPrice()));
                    monthSaleQuantity += monthSaleQuantityTemp;
                    monthSaleAmount = monthSaleAmount.add(bdNull(monthVo.getMonthSaleAmount()));
                    auditQuantity = auditQuantity.add(new BigDecimal(monthSaleQuantityTemp).subtract(manualAuditSaleQuantityTemp));
                    boundGiftSaleQuantity += boundGiftSaleQuantityTemp;
                    baseQuantity += (
                            monthSaleQuantityTemp
                            - manualAuditSaleQuantityTemp.intValue()
                            - boundGiftSaleQuantityTemp
                            - ridSaleQuantityTemp
                            );
                }
            }
            if (!distributionAuditMap.isEmpty() && distributionAuditMap.get(k) != null) {
                logisticsQuantity += distributionAuditMap.get(k);
            }
            reconciliationVo.setYearMonth(yearMonth);
            reconciliationVo.setProductCode(details.get(0).getOffsetProductCode());
            reconciliationVo.setProductName(details.get(0).getOffsetProductName());
            reconciliationVo.setCombinationFee(combinationFee);
            reconciliationVo.setDistributionBaseTen(distributionBaseTen);
            reconciliationVo.setGoalAchievement(goalAchievement);
            reconciliationVo.setMonth(month);
            reconciliationVo.setStaffFee(staffFee);
            reconciliationVo.setLogistics(logistics);
            reconciliationVo.setQuarter(quarter);
            reconciliationVo.setOtherCooperation(otherCooperation);
            reconciliationVo.setOtherCooperationTwo(otherCooperationTwo);
            reconciliationVo.setFine(fine);
            reconciliationVo.setLastMonthAccount(lastMonthAccount);
            reconciliationVo.setStaffLogistics(reconciliationVo.getStaffFee().add(reconciliationVo.getLogistics()));
//            基础返当月上账	对账要素中字段【组合装费用】【基础旬返费用】【基础月返（基础运营返）】【季返】【罚款金额】的合计
            reconciliationVo.setMonthAccount(combinationFee.add(distributionBaseTen).add(month).add(quarter).add(fine));

            reconciliationVo.setSupplyPrice(supplyPrice);
            reconciliationVo.setMonthSaleQuantity(monthSaleQuantity);
            reconciliationVo.setMonthSaleAmount(monthSaleAmount);
            reconciliationVo.setAuditQuantity(auditQuantity);
            reconciliationVo.setBoundGiftSaleQuantity(boundGiftSaleQuantity);
            reconciliationVo.setBaseQuantity(baseQuantity);

            reconciliationVo.setLogisticsQuantity(logisticsQuantity);

            list.add(reconciliationVo);
        }
        return list;
    }

    /**
     * 转换
     *
     * @param propertyName  属性名
     * @param propertyClass 属性类
     * @return {@link String}
     */
    @Override
    public String convert(String propertyName, DistributionReconciliationAuditVo propertyClass) {
        ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        switch (detailPropertyEnum) {
            case year_month:
                return propertyClass.getYearMonth();
            case customer_code:
                return propertyClass.getCustomerCode();
            case customer_name:
                return propertyClass.getCustomerName();
            case product_code:
                return propertyClass.getProductCode();
            case product_name:
                return propertyClass.getProductName();
            case supply_price:
                return propertyClass.getSupplyPrice().toPlainString();
            case month_sale_quantity:
                return propertyClass.getMonthSaleQuantity().toString();
            case month_sale_amount:
                return propertyClass.getMonthSaleAmount().toPlainString();
            case audit_quantity:
                return propertyClass.getAuditQuantity().toPlainString();
            case bound_gift_sale_quantity:
                return propertyClass.getBoundGiftSaleQuantity().toString();
            case base_quantity:
                return propertyClass.getBaseQuantity().toString();
            case combination_fee:
                return propertyClass.getCombinationFee().toPlainString();
            case distribution_base_ten:
                return propertyClass.getDistributionBaseTen().toPlainString();
            case goal_achievement:
                return propertyClass.getGoalAchievement().toPlainString();
            case month:
                return propertyClass.getMonth().toPlainString();
            case staff_fee:
                return propertyClass.getStaffFee().toPlainString();
            case logistics_quantity:
                return propertyClass.getLogisticsQuantity().toString();
            case logistics:
                return propertyClass.getLogistics().toPlainString();
            case quarter:
                return propertyClass.getQuarter().toPlainString();
            case other_cooperation:
                return propertyClass.getOtherCooperation().toPlainString();
            case other_cooperation_two:
                return propertyClass.getOtherCooperationTwo().toPlainString();
            case fine:
                return propertyClass.getFine().toPlainString();
            case last_month_account:
                return propertyClass.getLastMonthAccount().toPlainString();
            case month_account:
                return propertyClass.getMonthAccount().toPlainString();
            case staff_logistics:
                return propertyClass.getStaffLogistics().toPlainString();
            default:
                return StringUtils.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
        log.info("开始转换尾部");
        if (CollectionUtils.isEmpty(linkedHashMap)) {
            log.info("尾部数据为空");
            return;
        }

        //b.活动月发货：根据对账单T-1计算年月+客户取分销月度销售数据表中“月度销售金额”；
        //c.活动月已上账：取对账单计算T-1年月+客户+业态+渠道+销售机构匹配结案核销管理表中活动年月+结案形式为红字发票的审批通过的核销单“已结案金额”汇总值；
        //d.活动下月上账费用：分销明细要素“基础返费用上账”+“人员物流费用上账”的值；
        //e.活动月打款：根据客户+对账规则T-1计算年月取046表中“本期贷方发生额”值；
        //f.活动月期初：根据客户+对账规则T-1计算年月046接口取“活动月期末”字段值+尾部要素中“活动下月上账费用”的值；
        //g.活动月核算期末余额：计算活动月期末（根据客户+对账规则T-1计算年月046接口取“期末余额”字段值）+活动月客户打款（根据客户+对账规则T-1计算年月046接口取“本期贷方发生额”字段值）+活动月上账费用-活动月发货的值；
        //h.财务期末余额：-核算期末余额。

        Zmfi046Dto dto = new Zmfi046Dto();
        dto.setCyM(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.year_month.getCode()));
        dto.setGenLegrCtm(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_code.getCode()));
        log.info("开始调用kms接口");
        List<Zmfi046SdkVo> zmfi046VoList = zmfi046Voservice.findZmfi046VoForReconciliation(dto);
        log.info("结束调用kms接口");

        BigDecimal crtCreditIncrcAmt = BigDecimal.ZERO;
        BigDecimal finalBalc = BigDecimal.ZERO;

        if (!CollectionUtils.isEmpty(zmfi046VoList)) {
            Zmfi046SdkVo vo = zmfi046VoList.get(0);
            crtCreditIncrcAmt = bdNull(vo.getCrtCreditIncrcAmt());
            finalBalc = bdNull(vo.getFinalBalc());
        }
        BigDecimal monthAccount = new BigDecimal(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_account.getCode()));
        BigDecimal staffLogistics = new BigDecimal(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_logistics.getCode()));


        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.next_month_account.getCode(), monthAccount.add(staffLogistics).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.crt_credit_incrc_amt.getCode(), crtCreditIncrcAmt.toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_init.getCode(), finalBalc.add(monthAccount.add(staffLogistics)).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.audit_final.getCode(), finalBalc.add(crtCreditIncrcAmt).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.financial_final.getCode(), finalBalc.add(crtCreditIncrcAmt).negate().toPlainString());
        log.info("结束转换尾部");
    }

    private BigDecimal bdNull (BigDecimal b) {
        return Optional.ofNullable(b).orElse(BigDecimal.ZERO);
    }

    private Integer intNull (Integer i) {
        return Optional.ofNullable(i).orElse(0);
    }

    /**
     * 转换头
     *
     * @param propertyName 属性名
     * @param propertyList 属性集合
     * @return {@link String}
     */
    @Override
    public String convertHead(String propertyName, List propertyList) {
        return null;
    }
}
