package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;


/**
 * 批复对账单 主体 策略实现类
 */
@Slf4j
@Component
public class ReplyForAbstractReconciliation extends AbstractReconciliationGenerateStrategy<ActivityDetailPlanItemVo> {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private ProductVoService productVoService;


    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.APPROVAL.getCode();
    }

    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.DETAIL.getCode();
    }


    /**
     * 找到客户代码
     *
     * @param dto 对账单生成dto
     * @return {@link Set}<{@link String}>
     */
    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        activityDetailPlanItemDto.setActivityBeginDate(dto.getStartDateTime());
        activityDetailPlanItemDto.setActivityEndDate(dto.getEndDateTime());
        activityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        activityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        activityDetailPlanItemDto.setCustomerCode(dto.getCustomerCode());
        log.info("生成批复对账单主体客户活动，查询参数:{}", activityDetailPlanItemDto);
        Set<String> set = this.activityDetailPlanItemSdkService.findCustomer(activityDetailPlanItemDto);
        Map<String, Set<String>> map = new HashMap<>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), set);
        log.info("生成批复对账单主体客户活动，客户信息:{}", map);
        return map;
    }

    @Override
    public List<ActivityDetailPlanItemVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        log.info("主体批复对账查询参数customerCode{},参数[{}]", customerCode, JSON.toJSONString(dto));
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        activityDetailPlanItemDto.setActivityBeginDate(dto.getStartDateTime());
        activityDetailPlanItemDto.setActivityEndDate(dto.getEndDateTime());
        activityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        activityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        activityDetailPlanItemDto.setCustomerCode(customerCode);
        List<ActivityDetailPlanItemVo> result = this.activityDetailPlanItemSdkService.findByCustomerCode(activityDetailPlanItemDto);
        if (CollectionUtil.isEmpty(result)) {
            return Collections.emptyList();
        }

        Set<String> productCodeSet = result.stream()
                .filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(ActivityDetailPlanItemVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtil.isNotEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                        v -> v, (n, o) -> n)));
            }
        }

        AtomicInteger index = new AtomicInteger(1);
        result.forEach(item -> {
            if (StringUtil.isNotEmpty(item.getProductCode())
                    && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }

            item.setNumber(String.valueOf(index.getAndIncrement()));
            if (Objects.isNull(item.getHeadFeeAmount())) {
                item.setHeadFeeAmount(BigDecimal.ZERO);
            }
            item.setHeadFeeAmount(item.getHeadFeeAmount().setScale(2, RoundingMode.HALF_UP));

            if (Objects.isNull(item.getDepartmentFeeAmount())) {
                item.setDepartmentFeeAmount(BigDecimal.ZERO);
            }
            item.setDepartmentFeeAmount(item.getDepartmentFeeAmount().setScale(2, RoundingMode.HALF_UP));

            if (Objects.isNull(item.getCustomerFeeAmount())) {
                item.setCustomerFeeAmount(BigDecimal.ZERO);
            }
            item.setCustomerFeeAmount(item.getCustomerFeeAmount().setScale(2, RoundingMode.HALF_UP));
            //费用合计=总部承担+大区承担+客户承担
            item.setTotalFee((item.getHeadFeeAmount().add(item.getDepartmentFeeAmount()).add(item.getCustomerFeeAmount())).setScale(2, RoundingMode.HALF_UP));
            //费用申请=总部承担+大区承担
            item.setApplyFee((item.getHeadFeeAmount().add(item.getDepartmentFeeAmount())).setScale(2, RoundingMode.HALF_UP));
        });

        log.info("主体批复对账customerCode{}单查询结果【{}】", customerCode, JSON.toJSONString(result));
        return result;
    }


    /**
     * 转换
     *
     * @param propertyName  属性名
     * @param propertyClass 属性类
     * @return {@link String}
     */
    @Override
    public String convert(String propertyName, ActivityDetailPlanItemVo propertyClass) {
        ReconciliationPropertyEnum.ReplyDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.ReplyDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        switch (detailPropertyEnum) {
            case number:
                return Optional.ofNullable(propertyClass.getNumber()).orElse("");
            case business_format:
                return BusinessFormatEnum.getDesc(propertyClass.getBusinessFormatCode());
            case business_unit:
                return BusinessUnitEnum.getDesc(propertyClass.getBusinessUnitCode());
            case customer_name:
                return propertyClass.getCustomerName();
            case sales_organization:
                return propertyClass.getSalesInstitutionName();
            case sales_region:
                return propertyClass.getSalesRegionName();
            case budget_project:
                return propertyClass.getBudgetItemName();
            case activity_form:
                return propertyClass.getActivityFormName();
            case brand:
                return propertyClass.getProductBrandName();
            case product:
                return propertyClass.getProductName();
            case expense_application:
                //费用申请=总部承担+大区承担
                return propertyClass.getApplyFee().toString();
            case total_expenses:
                //费用合计=总部承担+大区承担+客户承担
                return propertyClass.getTotalFee().toString();
            case customer_bear:
                return propertyClass.getCustomerFeeAmount().toString();
            case start_time:
                if (Objects.nonNull(propertyClass.getActivityBeginDate())) {
                    return DateUtil.formatDate(propertyClass.getActivityBeginDate());
                }
                return StringUtils.EMPTY;
            case end_time:
                if (Objects.nonNull(propertyClass.getActivityEndDate())) {
                    return DateUtil.formatDate(propertyClass.getActivityEndDate());
                }
                return StringUtils.EMPTY;
            case remarks:
                return propertyClass.getRemark();
            default:
                return StringUtils.EMPTY;
        }
    }

    @Override
    public String convertHead(String propertyName, List<Object> propertyList) {
        if (CollectionUtils.isEmpty(propertyList) || !(propertyList.get(0) instanceof ActivityDetailPlanItemVo)) {
            return StringUtils.EMPTY;
        }
        List<ActivityDetailPlanItemVo> itemVos = (List<ActivityDetailPlanItemVo>) (List) propertyList;
        if (CollectionUtils.isEmpty(itemVos)) {
            return StringUtils.EMPTY;
        }

        ReconciliationPropertyHeadEnum.ReplyHeadPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.ReplyHeadPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(headPropertyEnum)) {
            return StringUtils.EMPTY;
        }
        switch (headPropertyEnum) {
            case year_month:
                if (Objects.nonNull(itemVos.get(0).getActivityBeginDate())) {
                    return DateUtil.format(itemVos.get(0).getActivityBeginDate(), "yyyy-MM");
                }
            case customer_name:
                return itemVos.get(0).getCustomerName();
            case total_expenses:
                return itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemVo::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            case total_expenses_application:
                return itemVos.stream().filter(Objects::nonNull).map(x -> NumberUtil.add(x.getDepartmentFeeAmount(), x.getHeadFeeAmount())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            case customer_bear_total:
                return itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemVo::getCustomerFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            default:
                return StringUtils.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }


}
