package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReplySubReconciliationHeadVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 批复对账单  分子  策略实现类
 */
@Slf4j
@Component
public class ReplySubForAbstractReconciliation extends AbstractReconciliationGenerateStrategy<SubComActivityDetailPlanItemVo> {

    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.APPROVAL.getCode();
    }

    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode();
    }


    /**
     * 找到客户代码
     *
     * @param dto 对账单生成dto
     * @return {@link Set}<{@link String}>
     */
    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto = new SubComActivityDetailPlanItemDto();
        subComActivityDetailPlanItemDto.setActivityBeginTime(dto.getStartDateTime());
        subComActivityDetailPlanItemDto.setActivityEndTime(dto.getEndDateTime());
        subComActivityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComActivityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        //subComActivityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List<String> activityDetailStatusList = new ArrayList<>();
        activityDetailStatusList.add(ActivityStatusEnum.PASS.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.END.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_REJECT.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_RECOVER.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode());
        subComActivityDetailPlanItemDto.setActivityDetailStatusList(activityDetailStatusList);
        subComActivityDetailPlanItemDto.setCustomerCode(dto.getCustomerCode());
        log.info("生成批复对账单分子客户活动，查询参数:{}", subComActivityDetailPlanItemDto);
        Set<String> set = this.subComActivityDetailPlanItemVoService.findCustomer(subComActivityDetailPlanItemDto);
        Map<String, Set<String>> map = new HashMap<>(4);
        map.put(BusinessUnitEnum.SON_COMPANY.getCode(), set);
        log.info("生成批复对账单分子客户活动，客户信息:{}", map);
        return map;
    }

    @Override
    public List<SubComActivityDetailPlanItemVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        log.info("分子批复对账查询参数customerCode{},参数[{}]", customerCode, JSON.toJSONString(dto));
        SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto = new SubComActivityDetailPlanItemDto();
        subComActivityDetailPlanItemDto.setActivityBeginTime(dto.getStartDateTime());
        subComActivityDetailPlanItemDto.setActivityEndTime(dto.getEndDateTime());
        subComActivityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComActivityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        if (StringUtils.isNotEmpty(customerCode)) {
            String[] split = customerCode.split("-");
            subComActivityDetailPlanItemDto.setSubReconciliationCustomerCode(split[0]);
            if (split.length > 1) {
                subComActivityDetailPlanItemDto.setSubReconciliationInstitutionCode(split[1]);
            }
        }
        //subComActivityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List<String> activityDetailStatusList = new ArrayList<>();
        activityDetailStatusList.add(ActivityStatusEnum.PASS.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.END.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_REJECT.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_RECOVER.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode());
        subComActivityDetailPlanItemDto.setActivityDetailStatusList(activityDetailStatusList);
        List<SubComActivityDetailPlanItemVo> result = this.subComActivityDetailPlanItemVoService.findByCustomerCode(subComActivityDetailPlanItemDto);


        Set<String> productCodeSet = result.stream().filter(k -> StringUtil.isNotEmpty(k.getProductCode()))
                .map(SubComActivityDetailPlanItemVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findDetailsByProductCodes(new ArrayList<>(productCodeSet));
            if (CollectionUtil.isNotEmpty(productVoList)) {
                productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode,
                        v -> v, (n, o) -> n)));
            }
        }

        Set<String> itemCodes = result.stream()
                .map(SubComActivityDetailPlanItemVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<BudgetItemVo> budgetItemVoList = this.budgetItemService.listByCodes(new ArrayList<>(itemCodes));
        Map<String, String> itemVoMap = budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getBudgetItemName));
        result.forEach(item -> {
            item.setBudgetItemName(itemVoMap.get(item.getBudgetItemCode()));
            if (StringUtil.isNotEmpty(item.getProductCode())
                    && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });
        log.info("分子批复对账customerCode{}单查询结果【{}】", customerCode, JSON.toJSONString(result));
        return result;
    }

    /**
     * 转换
     *
     * @param propertyName  属性名
     * @param propertyClass 属性类
     * @return {@link String}
     */
    @Override
    public String convert(String propertyName, SubComActivityDetailPlanItemVo propertyClass) {
        ReconciliationPropertyEnum.ReplyDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.ReplyDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        switch (detailPropertyEnum) {
            case channel_name:
                return Optional.ofNullable(propertyClass.getChannelName()).orElse(StringUtils.EMPTY);
            case department_name:
                return Optional.ofNullable(propertyClass.getDepartmentName()).orElse(StringUtils.EMPTY);
            case customer_name:
                return Optional.ofNullable(propertyClass.getCustomerName()).orElse(StringUtils.EMPTY);
            case activity_form:
                return Optional.ofNullable(propertyClass.getActivityFormName()).orElse(StringUtils.EMPTY);
            case budget_project:
                return Optional.ofNullable(propertyClass.getBudgetItemName()).orElse(StringUtils.EMPTY);
            case product:
                return Optional.ofNullable(propertyClass.getProductName()).orElse(StringUtils.EMPTY);
            case activity_intensity:
                return Optional.ofNullable(propertyClass.getActivityIntensity()).orElse(StringUtils.EMPTY);
            case start_time:
                if (propertyClass.getActivityBeginTime() != null) {
                    return DateUtil.formatDate(propertyClass.getActivityBeginTime());
                }
                return StringUtils.EMPTY;
            case end_time:
                if (propertyClass.getActivityEndTime() != null) {
                    return DateUtil.formatDate(propertyClass.getActivityEndTime());
                }
                return StringUtils.EMPTY;
//            case total_cost:
//                return NumberUtil.add(Optional.ofNullable(propertyClass.getSubComAutoAmount()).orElse(BigDecimal.ZERO),
//                        Optional.ofNullable(propertyClass.getHeadquartersSupportedAmount()).orElse(BigDecimal.ZERO),
//                        Optional.ofNullable(propertyClass.getCustomerFeeAmount()).orElse(BigDecimal.ZERO)).toString();
            case total_cost:
                return Optional.ofNullable(propertyClass.getTotalCost()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP).toPlainString();
            default:
                return StringUtils.EMPTY;
        }
    }

    @Override
    public String convertHead(String propertyName, List<Object> propertyList) {

        if (CollectionUtils.isEmpty(propertyList)) {
            return StringUtils.EMPTY;
        }

        ReplySubReconciliationHeadVo headVo = (ReplySubReconciliationHeadVo) propertyList.get(0);

        ReconciliationPropertyHeadEnum.ReplySubHeadPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.ReplySubHeadPropertyEnum.codeToEnum(propertyName);

        if (Objects.isNull(headVo) || Objects.isNull(headPropertyEnum)) {
            return StringUtils.EMPTY;
        }

        switch (headPropertyEnum) {
            case reply_sub_item_name:
                return Optional.ofNullable(headVo.getProjectName()).orElse(StringUtils.EMPTY);
            case reply_sub_amount:
                return Objects.nonNull(headVo.getAmount()) ?
                        headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : StringUtils.EMPTY;
            default:
                return StringUtils.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }


}
