package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.SapReconciliationService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;


/**
 * 往来对账单 sap 策略实现类
 */
@Component
@Slf4j
public class SapForAbstractReconciliation extends AbstractReconciliationGenerateStrategy {

    @Autowired(required = false)
    private SapReconciliationService sapReconciliationService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public String getReconciliationType() {
        return ReconciliationTypeEnum.COMMUNICATION.getCode();
    }

    @Override
    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SAP.getCode();
    }


    @Override
    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto reconciliationGenerateDto) {
        SapReconciliationDto dto = new SapReconciliationDto();
        dto.setCustomerCode(reconciliationGenerateDto.getCustomerCode());
        dto.setStartDateStr(DateUtil.format(reconciliationGenerateDto.getStartDateTime(), DatePattern.PURE_DATE_PATTERN));
        dto.setEndDateStr(DateUtil.format(reconciliationGenerateDto.getEndDateTime(), DatePattern.PURE_DATE_PATTERN));
        dto.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        dto.setCustomerCode(reconciliationGenerateDto.getCustomerCode());
        log.info("生成往来对账单单客户SAP，查询参数:{}", dto);
        Set<String> set = sapReconciliationService.findCustomer(dto);
        Map<String, Set<String>> map = new HashMap<>(4);
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationGenerateDto.getBusinessUnitCode())) {
            map.put(BusinessUnitEnum.SON_COMPANY.getCode(), set);
        } else {
            map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), set);
        }
        log.info("生成往来对账单单客户SAP，客户信息:{}", dto);
        return map;
    }

    @Override
    public List<SapReconciliationVo> findDateList(ReconciliationGenerateDto reconciliationGenerateDto, String customerCode) {
        SapReconciliationDto dto = new SapReconciliationDto();
        log.info("SAP往来对账查询参数customerCode{},参数[{}]", customerCode, JSON.toJSONString(dto));
        if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), reconciliationGenerateDto.getBusinessUnitCode())) {
            if (StringUtils.isNotEmpty(customerCode)) {
                String[] split = customerCode.split("-");
                dto.setSubReconciliationCustomerCode(split[0]);
                if (split.length > 1) {
                    dto.setSubReconciliationInstitutionCode(split[1]);
                }
            }
        } else {
            dto.setCustomerCode(customerCode);
        }
//        dto.setCustomerCode(reconciliationGenerateDto.getCustomerCode());
//        dto.setStartDateStr(reconciliationGenerateDto.getStartDate());
//        dto.setEndDateStr(reconciliationGenerateDto.getEndDate());

        dto.setStartDateStr(DateUtil.format(reconciliationGenerateDto.getStartDateTime(), DatePattern.PURE_DATE_PATTERN));
        dto.setEndDateStr(DateUtil.format(reconciliationGenerateDto.getEndDateTime(), DatePattern.PURE_DATE_PATTERN));

        dto.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        //每月第一条为期初。期初没有日期，用创建时间获取
        dto.setYearMonthLy(com.biz.crm.mn.common.base.util.DateUtil.format(reconciliationGenerateDto.getStartDateTime(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH));
        log.info("SAP往来对账查询参数【{}】", JSON.toJSONString(dto));
        List<SapReconciliationVo> result = sapReconciliationService.findListByCustomerCode(dto);
        log.info("SAP往来对账customerCode{}单查询结果【{}】", customerCode, JSON.toJSONString(result));
        return result;
    }

    @Override
    public String convert(String propertyName, Object propertyClass) {
        ReconciliationPropertyEnum.SapDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.SapDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return StringUtils.EMPTY;
        }
        SapReconciliationVo vo = (SapReconciliationVo) propertyClass;
        switch (detailPropertyEnum) {
            case sap_vtext:
                return vo.getVtext();
            case sap_kunrg:
                return vo.getKunrg();
            case sap_kunag_txt:
                return vo.getKunagTxt();
            case sap_fkdat:
                return vo.getFkdat();
            case sap_zdoc_name:
                return vo.getZdocName();
            case sap_zsh:
                return vo.getZsh();
            case sap_zfkfs:
                return vo.getZfkfs();
            case sap_zyszk_bdyy:
                return vo.getZyszkBdyy();
            case sap_vbeln:
                return vo.getVbeln();
            case sap_posnr:
                return vo.getPosnr();
            case sap_pstyv:
                return vo.getPstyv();
            case sap_belnr:
                return vo.getBelnr();
            case sap_aubel:
                return vo.getAubel();
            case sap_vgbel:
                return vo.getVgbel();
            case sap_arktx:
                return vo.getArktx();
            case sap_matnr:
                return vo.getMatnr();
            case sap_netwr_hs:
                return vo.getNetwrHs();
            case sap_netwr_zk:
                return vo.getNetwrZk();
            case sap_ratio:
                return vo.getRatio();
            case sap_fkimg:
                return vo.getFkimg();
            case sap_vrkme:
                return vo.getVrkme();
            case sap_fklmg:
                return vo.getFklmg();
            case sap_meins:
                return vo.getMeins();
            case sap_kzwi6:
                return vo.getKzwi6();
            case sap_kzwi1:
                return vo.getKzwi1();
            case sap_zysye:
                return vo.getZysye();
            case sap_zsdfy:
                return vo.getZsdfy();
            case sap_zk01:
                return vo.getZk01();
            case sap_zfpfy:
                return vo.getZfpfy();
            case sap_kunwe:
                return vo.getKunwe();
            case sap_kunwe_txt:
                return vo.getKunweTxt();
            case sap_bstnk:
                return vo.getBstnk();
            case sap_prctr:
                return vo.getPrctr();
            default:
                return StringUtils.EMPTY;
        }
    }

    /**
     * 转换尾部
     *
     * @param linkedHashMap
     */
    @Override
    public void convertTail(LinkedHashMap linkedHashMap) {
    }

    @Override
    public String convertHead(String propertyName, List propertyList) {

        ReconciliationPropertyHeadEnum.SapDetailPropertyEnum headPropertyEnum =
                ReconciliationPropertyHeadEnum.SapDetailPropertyEnum.codeToEnum(propertyName);
        if (Objects.isNull(headPropertyEnum)
                || CollectionUtils.isEmpty(propertyList)) {
            return StringUtils.EMPTY;
        }
        SapForReconciliationPdfHeadVo headVo = (SapForReconciliationPdfHeadVo) propertyList.get(0);
        if (Objects.isNull(headVo)) {
            return StringUtils.EMPTY;
        }
        BigDecimal amount = Objects.nonNull(headVo.getAmount()) ? headVo.getAmount() : BigDecimal.ZERO;
        switch (headPropertyEnum) {
            case sap_item_name:
                return headVo.getName();
            case sap_order:
                return headVo.getIndex();
            case sap_amount:
                return Objects.nonNull(headVo.getAmount()) ?
                        headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : StringUtils.EMPTY;
            default:
                return StrUtil.EMPTY;
        }
    }

}
