/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.ReconciliationDocBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/reconciliation/docList"})
@Api(tags={"\u5bf9\u8d26\u5355\u636e\u5217\u8868"})
public class ReconciliationDocListController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDocListController.class);
    @Autowired(required=false)
    private ReconciliationDocListService reconciliationDocListService;
    @Autowired(required=false)
    private ReconciliationDocBuildService reconciliationDocBuildService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByReconciliations"})
    public Result<Page<ReconciliationDocListVo>> findByReconciliations(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="reconciliationDocListDto", value="\u5bf9\u8d26\u5355\u636e\u5217\u8868") ReconciliationDocListDto reconciliationDocListDto) {
        try {
            Page page = this.reconciliationDocListService.findByReconciliations(pageable, reconciliationDocListDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findPageForOut"})
    public Result<Page<ReconciliationDocListVo>> findPageForOut(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, ReconciliationDocListDto reconciliationDocListDto) {
        try {
            Page page = this.reconciliationDocListService.findPageForOut(pageable, reconciliationDocListDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5bf9\u8d26\u5355(\u91cd\u65b0\u751f\u6210\u5bf9\u8d26\u5355)")
    @PatchMapping
    public Result<?> update(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.regenerate(ids);
            return Result.ok((String)"");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ReconciliationDocListVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String id) {
        try {
            ReconciliationDocListVo eventPrepaymentVo = this.reconciliationDocListService.findById(id);
            return Result.ok((Object)eventPrepaymentVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63a8\u9001\u7535\u5b50\u7b7e\u7ae0")
    @PostMapping(value={"contract"})
    public Result<?> pushAccountCheckBill(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.pushAccountCheckBill(ids);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f5c\u5e9f")
    @PostMapping(value={"cancel"})
    public Result<?> cancellationContract(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.cancellationContract(ids);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u64a4\u56de")
    @PostMapping(value={"recall"})
    public Result<?> withdrawalContract(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.withdrawalContract(ids);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b")
    @PostMapping(value={"viewurl"})
    public Result<List<ReconciliationDocListFileVo>> browseContract(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            return Result.ok((Object)this.reconciliationDocListService.browseContract(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u8f7d")
    @PostMapping(value={"download"})
    public Result<List<ReconciliationDocListFileVo>> downloadContract(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            return Result.ok((Object)this.reconciliationDocListService.downloadContract(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u4e0b\u8f7d\u9644\u4ef6\u538b\u7f29\u5305")
    @RequestMapping(value={"/downloadZip"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ids") List<String> ids) throws IOException {
        byte[] bytes = this.reconciliationDocListService.findFileZipByIds(ids);
        if (bytes == null) {
            return;
        }
        String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "\u5bf9\u8d26\u5355\u538b\u7f29\u5305.zip";
        this.writeResponseFile(request, response, bytes, fileName);
    }

    @ApiOperation(value="\u50ac\u7b7e")
    @PostMapping(value={"notify"})
    public Result<?> contractExpediting(@ApiParam(name="ids", value="\u4e3b\u952e\u5217\u8868") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.contractExpediting(ids);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"handleManualGenerate"})
    public Result handleManualGenerate(@RequestParam(value="yearMonthDay", required=false) String yearMonthDay) {
        try {
            Date date = new Date();
            if (StringUtils.isNotBlank((CharSequence)yearMonthDay)) {
                try {
                    date = DateUtil.parseDate((String)yearMonthDay, (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    return Result.error((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,[yyyy-MM-dd]");
                }
            }
            if (Objects.isNull(date)) {
                return Result.error((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,[yyyy-MM-dd]");
            }
            boolean lockFlag = this.redisLockService.isLock(this.reconciliationDocBuildService.getBuildRedisLockKey(date));
            if (lockFlag) {
                return Result.error((String)"\u4e0a\u6b21\u751f\u6210\u5bf9\u8d26\u5c1a\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            this.reconciliationDocBuildService.handleBuildReconciliation(date, this.loginUserService.getAbstractLoginUser());
            return Result.ok((String)"\u5bf9\u8d26\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"handleManualGenerateForOut"})
    public Result<List<String>> handleManualGenerateForOut(@RequestParam(value="yearMonthDay", required=false) String yearMonthDay) {
        try {
            Date date = new Date();
            if (StringUtils.isNotBlank((CharSequence)yearMonthDay)) {
                try {
                    date = DateUtil.parseDate((String)yearMonthDay, (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    return Result.error((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,[yyyy-MM-dd]");
                }
            }
            if (Objects.isNull(date)) {
                return Result.error((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,[yyyy-MM-dd]");
            }
            boolean lockFlag = this.redisLockService.isLock(this.reconciliationDocBuildService.getBuildRedisLockKey(date));
            if (lockFlag) {
                return Result.error((String)"\u4e0a\u6b21\u751f\u6210\u5bf9\u8d26\u5c1a\u672a\u5b8c\u6210,\u8bf7\u8010\u5fc3\u7b49\u5f85!");
            }
            List<String> idList = this.reconciliationDocBuildService.handleBuildReconciliationForOut(date, this.loginUserService.getAbstractLoginUser());
            return Result.ok(idList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5pdf\u751f\u6210")
    @GetMapping(value={"generatePdfTest"})
    public Result<?> handleManualGenerate(ReconciliationDocListVo reconciliationDocListVo) {
        try {
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

