/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.exports;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationSummaryDataDisplayDetailHeadApproveRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayDetailHeadApproveExportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationSummaryDataDisplayDetailHeadApproveExportProcess
implements ExportProcess<ReconciliationSummaryDataDisplayDetailHeadApproveExportVo> {
    @Autowired(required=false)
    private ReconciliationSummaryDataDisplayDetailHeadApproveRepository detailHeadApproveRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getTotal(Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        return this.detailHeadApproveRepository.getExportTotalCount(statementCode);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        List<ReconciliationSummaryDataDisplayDetailHeadApproveEntity> approveEntities = this.detailHeadApproveRepository.findByStatementCode(statementCode);
        Collection exportVos = this.nebulaToolkitService.copyCollectionByWhiteList(approveEntities, ReconciliationSummaryDataDisplayDetailHeadApproveEntity.class, ReconciliationSummaryDataDisplayDetailHeadApproveExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.convertData(exportVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportVos));
    }

    public String getBusinessCode() {
        return "RECONCILIATION_SUMMARY_DATA_DISPLAY_DETAIL_HEAD_APPROVE_EXPORT";
    }

    public String getBusinessName() {
        return "TPM-\u4e3b\u4f53\u6279\u590d\u5bf9\u8d26\u5355\u6c47\u603b\u6570\u636e\u660e\u7ec6\u6570\u636e\u5bfc\u51fa";
    }

    private String getStatementCode(Map<String, Object> params) {
        return params.get("statementCode").toString();
    }

    public Class<ReconciliationSummaryDataDisplayDetailHeadApproveExportVo> findCrmExcelVoClass() {
        return ReconciliationSummaryDataDisplayDetailHeadApproveExportVo.class;
    }

    private void convertData(Collection<ReconciliationSummaryDataDisplayDetailHeadApproveExportVo> data) {
        if (CollectionUtil.isEmpty(data)) {
            return;
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_unit", "mdm_business_format"}));
        for (ReconciliationSummaryDataDisplayDetailHeadApproveExportVo vo : data) {
            vo.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", vo.getBusinessUnitCode()));
            vo.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", vo.getBusinessFormatCode()));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

