/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.exports;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubCommunicateEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationSummaryDataDisplayDetailSubCommunicateRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationSummaryDataDisplayDetailSubCommunicateExportProcess
implements ExportProcess<ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo> {
    @Autowired(required=false)
    private ReconciliationSummaryDataDisplayDetailSubCommunicateRepository detailSubCommunicateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getTotal(Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        return this.detailSubCommunicateRepository.getExportTotalCount(statementCode);
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String statementCode = this.getStatementCode(params);
        List<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> auditEntities = this.detailSubCommunicateRepository.findByStatementCode(statementCode);
        Collection exportVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditEntities, ReconciliationSummaryDataDisplayDetailSubCommunicateEntity.class, ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.convertData(exportVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportVos));
    }

    public String getBusinessCode() {
        return "RECONCILIATION_SUMMARY_DATA_DISPLAY_DETAIL_SUB_COMMUNICATE_EXPORT";
    }

    public String getBusinessName() {
        return "TPM-\u5206\u5b50\u5f80\u6765\u5bf9\u8d26\u5355\u6c47\u603b\u6570\u636e\u660e\u7ec6\u6570\u636e\u5bfc\u51fa";
    }

    private String getStatementCode(Map<String, Object> params) {
        return params.get("statementCode").toString();
    }

    public Class<ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo> findCrmExcelVoClass() {
        return ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo.class;
    }

    private void convertData(Collection<ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo> data) {
        if (CollectionUtil.isEmpty(data)) {
            return;
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_unit", "mdm_business_format"}));
        for (ReconciliationSummaryDataDisplayDetailSubCommunicateExportVo vo : data) {
            vo.setBusinessUnitCode(this.findDictValue(mapDict, "mdm_business_unit", vo.getBusinessUnitCode()));
            vo.setBusinessFormatCode(this.findDictValue(mapDict, "mdm_business_format", vo.getBusinessFormatCode()));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

