/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.ReconciliationDocBuildService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AutoBuildReconciliationSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(AutoBuildReconciliationSyncXxlJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private ReconciliationDocBuildService reconciliationDocBuildService;

    @DynamicTaskService(cornExpression="0 10 2 * * ?", taskDesc="\u6bcf\u5929 02:10 \u6267\u884c\u4e00\u6b21\u76d1\u6d4b\u662f\u5426\u6709\u9700\u8981\u751f\u6210\u7684\u5bf9\u8d26\u5355\u4efb\u52a1")
    public void autoBuildXxlJob() {
        log.info("=====>    \u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
        boolean lock = true;
        Date date = new Date();
        String lockKey = this.reconciliationDocBuildService.getBuildRedisLockKey(date);
        this.loginUserService.refreshAuthentication(null);
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
            Assert.isTrue((boolean)lock, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u52a0\u9501\u5931\u8d25");
            this.reconciliationDocBuildService.autoBuildReconciliation(date);
            log.info("=====>     \u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u6210\u529f     <=====");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
        log.info("=====>    \u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
    }
}

