/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ApprovalStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ClosingStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.SyncECrmStatementDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.BaseEcrmBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationCorrelationVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseEcrmBuildServiceImpl
implements BaseEcrmBuildService {
    private static final Logger log = LoggerFactory.getLogger(BaseEcrmBuildServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private EcrmService ecrmService;
    @Autowired(required=false)
    private ReconciliationCorrelationVoService correlationVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    private List<AbstractReconciliationGenerateStrategy> abstractReconciliationGenerateStrategyList;

    @Autowired
    public void setAbstractReconciliationGenerateStrategyList(List<AbstractReconciliationGenerateStrategy> abstractReconciliationGenerateStrategyList) {
        this.abstractReconciliationGenerateStrategyList = abstractReconciliationGenerateStrategyList;
    }

    @Override
    public void syncECrm(ReconciliationDocListVo reconciliationDocListVo, FacturerUserDetails loginDetails) {
        List customerCodes;
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationDocListVo.getBusinessUnitCode())) {
            return;
        }
        if (loginDetails == null) {
            loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        }
        if (CollectionUtils.isEmpty((Collection)(customerCodes = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList((Object[])new String[]{reconciliationDocListVo.getCustomerCode()}))))) {
            throw new IllegalArgumentException("\u67e5\u8be2\u4e0d\u5230\u6b64\u5ba2\u6237," + reconciliationDocListVo.getCustomerCode());
        }
        CustomerVo customerVo = (CustomerVo)customerCodes.get(0);
        SyncECrmStatementDto eCrmStatementDto = SyncECrmStatementDto.builder().status("A" + reconciliationDocListVo.getStatementStatus()).documents(reconciliationDocListVo.getDocumentsId()).contractId(reconciliationDocListVo.getContractId()).operatorName(loginDetails.getRealName()).operatorContact(loginDetails.getPhone()).tenantName(reconciliationDocListVo.getCustomerName()).year(String.valueOf(DateUtil.year((Date)reconciliationDocListVo.getReconciliationMonth()))).month(String.valueOf(DateUtil.month((Date)reconciliationDocListVo.getReconciliationMonth()) + 1)).sn(customerVo.getErpCode()).lrzx("00001000").company(reconciliationDocListVo.getSalesInstitutionCode()).categoryId(reconciliationDocListVo.getAccountReconciliationType()).build();
        this.ecrmService.syncStatementECrm(eCrmStatementDto);
    }

    @Override
    public void pushECrm(ReconciliationDocListVo reconciliationDocListVo) {
        Set serviceByStatementCode = this.correlationVoService.findByStatementCode(reconciliationDocListVo.getStatementCode());
        if (CollectionUtils.isEmpty((Collection)serviceByStatementCode)) {
            return;
        }
        AbstractReconciliationGenerateStrategy strategy = null;
        List generateStrategies = this.abstractReconciliationGenerateStrategyList.stream().filter(x -> x.getReconciliationType().equals(reconciliationDocListVo.getAccountReconciliationType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(generateStrategies)) {
            return;
        }
        if (generateStrategies.size() > 1) {
            ReconciliationBuesinssTypeEnum businessTypeEnum = ReconciliationBuesinssTypeEnum.findByBusinessUnitCode((String)reconciliationDocListVo.getBusinessUnitCode());
            if (businessTypeEnum != null) {
                Optional<AbstractReconciliationGenerateStrategy> reconciliationGenerateStrategy = generateStrategies.stream().filter(x -> businessTypeEnum.getCode().equals(x.getBusinessType())).findFirst();
                if (reconciliationGenerateStrategy.isPresent()) {
                    strategy = reconciliationGenerateStrategy.get();
                }
            } else {
                log.error("\u5bf9\u8d26\u4fe1\u606f[{}]\u672a\u627e\u5230\u4e1a\u52a1\u5355\u5143", (Object)reconciliationDocListVo);
            }
        } else {
            strategy = (AbstractReconciliationGenerateStrategy)generateStrategies.get(0);
        }
        if (strategy == null) {
            return;
        }
        ReconciliationGenerateDto reconciliationGenerateDto = new ReconciliationGenerateDto();
        reconciliationGenerateDto.setAccountReconciliationRuleCode(reconciliationDocListVo.getAccountReconciliationRuleCode());
        reconciliationGenerateDto.setBusinessFormatCode(reconciliationDocListVo.getBusinessFormatCode());
        reconciliationGenerateDto.setBusinessUnitCode(reconciliationDocListVo.getBusinessUnitCode());
        reconciliationGenerateDto.setStartDateTime(reconciliationDocListVo.getStartDate());
        reconciliationGenerateDto.setEndDateTime(reconciliationDocListVo.getEndDate());
        List dateList = strategy.findDateList(reconciliationGenerateDto, reconciliationDocListVo.getCustomerCode());
        if (CollectionUtils.isEmpty((Collection)dateList)) {
            return;
        }
        Map businessFormatMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_format");
        Map businessUnitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
        Map rtmModelMap = this.dictToolkitService.findMapByDictTypeCode("mdm_rtx_model");
        log.info("\u63a8\u9001\u7535\u5b50\u7b7e\u7ae0\uff0cRTM\u6a21\u5f0f\u5b57\u5178\u6570\u636e\u3010{}\u3011", (Object)JSON.toJSONString((Object)rtmModelMap));
        if (ReconciliationTypeEnum.APPROVAL.getCode().equals(reconciliationDocListVo.getAccountReconciliationType())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationGenerateDto.getBusinessUnitCode())) {
                return;
            }
            ArrayList approvalStatements = new ArrayList();
            if (dateList.get(0) instanceof ActivityDetailPlanItemVo) {
                dateList.forEach(item -> approvalStatements.add(this.buildApproval((ActivityDetailPlanItemVo)item, businessFormatMap, businessUnitMap, reconciliationDocListVo)));
                Set customerCodes = approvalStatements.stream().map(ApprovalStatementDto::getCustomerCode).collect(Collectors.toSet());
                List customerVos = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList(customerCodes));
                if (CollectionUtils.isEmpty((Collection)customerVos)) {
                    throw new IllegalArgumentException("\u63a8\u9001ecrm\u5f02\u5e38\uff0c\u67e5\u8be2\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
                }
                Map<String, List<CustomerVo>> customerGroup = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getCustomerCode));
                approvalStatements.forEach(item -> {
                    List customerVo = (List)customerGroup.get(item.getCustomerCode());
                    log.info("\u63a8\u9001\u7535\u5b50\u7b7e\u7ae0\uff0c\u5ba2\u6237\u4fe1\u606f\u3010{}\u3011", (Object)JSON.toJSONString((Object)customerVo));
                    if (customerVo != null) {
                        CustomerVo vo = (CustomerVo)customerVo.get(0);
                        item.setCustomerCode(vo.getErpCode());
                        item.setSalesOrgProvinceCode(vo.getSalesOrgErpCode());
                        item.setSalesOrgProvinceName(vo.getSalesOrgName());
                        item.setSalesInstitutionCode(vo.getSalesInstitutionErpCode());
                        item.setSalesInstitutionName(vo.getSalesInstitutionName());
                        item.setSalesOrgRegionCode(vo.getSalesRegionErpCode());
                        item.setSalesOrgRegionName(vo.getSalesRegionName());
                        item.setCustomerType((String)rtmModelMap.get(vo.getRtmModelCode()));
                    }
                });
            }
            if (CollectionUtils.isEmpty(approvalStatements)) {
                return;
            }
            this.ecrmService.pushApprovalStatement(approvalStatements);
        }
        if (ReconciliationTypeEnum.CLOSURE.getCode().equals(reconciliationDocListVo.getAccountReconciliationType())) {
            ArrayList closingStatements = new ArrayList();
            List detailCollectionVos = dateList;
            detailCollectionVos.forEach(detail -> closingStatements.add(this.buildClosing((AuditCustomerDetailCollectionVo)detail, businessFormatMap, businessUnitMap, reconciliationDocListVo)));
            if (CollectionUtils.isEmpty(closingStatements)) {
                return;
            }
            Set customerCodes = closingStatements.stream().map(ClosingStatementDto::getCustomerCode).collect(Collectors.toSet());
            List customerVos = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList(customerCodes));
            if (CollectionUtils.isEmpty((Collection)customerVos)) {
                throw new IllegalArgumentException("\u63a8\u9001ecrm\u5f02\u5e38\uff0c\u67e5\u8be2\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
            }
            Map<String, List<CustomerVo>> customerGroup = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getCustomerCode));
            closingStatements.forEach(item -> {
                List customerVo = (List)customerGroup.get(item.getCustomerCode());
                if (customerVo != null) {
                    CustomerVo vo = (CustomerVo)customerVo.get(0);
                    log.info("\u63a8\u9001\u7535\u5b50\u7b7e\u7ae0\uff0c\u5ba2\u6237\u4fe1\u606f\u3010{}\u3011", (Object)JSON.toJSONString((Object)customerVo));
                    item.setCustomerCode(vo.getErpCode());
                    item.setSalesOrgProvinceCode(vo.getSalesOrgErpCode());
                    item.setSalesInstitutionCode(vo.getSalesInstitutionErpCode());
                    item.setSalesOrgRegionCode(vo.getSalesRegionErpCode());
                    item.setCustomerType((String)rtmModelMap.get(vo.getRtmModelCode()));
                }
            });
            this.ecrmService.pushClosingStatement(closingStatements);
        }
    }

    private ApprovalStatementDto buildApproval(ActivityDetailPlanItemVo item, Map<String, String> businessFormatMap, Map<String, String> businessUnitMap, ReconciliationDocListVo reconciliationDocListVo) {
        ApprovalStatementDto approvalStatementDto = new ApprovalStatementDto();
        approvalStatementDto.setIntegrationId(item.getId());
        approvalStatementDto.setStatementCode(reconciliationDocListVo.getStatementCode());
        approvalStatementDto.setStatementStatus(reconciliationDocListVo.getStatementStatus());
        approvalStatementDto.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
        approvalStatementDto.setActivityDetailsCode(item.getDetailPlanItemCode());
        approvalStatementDto.setReconciliationMonth(reconciliationDocListVo.getReconciliationMonth());
        approvalStatementDto.setCustomerCode(item.getCustomerCode());
        approvalStatementDto.setCustomerName(item.getCustomerName());
        approvalStatementDto.setFirstChannelCode(item.getFirstChannelCode());
        approvalStatementDto.setFirstChannelName(item.getFirstChannelName());
        approvalStatementDto.setSecondChannelCode(item.getSecondChannelCode());
        approvalStatementDto.setSecondChannelName(item.getSecondChannelName());
        approvalStatementDto.setCenter("6000");
        if (StrUtil.isNotEmpty((CharSequence)item.getBusinessFormatCode()) && CollectionUtil.isNotEmpty(businessFormatMap)) {
            approvalStatementDto.setBusinessFormatCode(businessFormatMap.get(item.getBusinessFormatCode()));
        }
        if (StrUtil.isNotEmpty((CharSequence)item.getBusinessUnitCode()) && CollectionUtil.isNotEmpty(businessUnitMap)) {
            approvalStatementDto.setBusinessUnitCode(businessUnitMap.get(item.getBusinessUnitCode()));
        }
        approvalStatementDto.setSalesInstitutionName(item.getSalesInstitutionName());
        approvalStatementDto.setSalesInstitutionCode(item.getSalesInstitutionCode());
        approvalStatementDto.setSalesOrgRegionName(item.getSalesRegionName());
        approvalStatementDto.setSalesOrgRegionCode(item.getSalesRegionCode());
        StringBuilder budgetItemName = new StringBuilder();
        StringBuilder budgetItemCode = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)item.getBudgetItemName())) {
            budgetItemName.append(item.getBudgetItemName());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getHeadBudgetItemName()) && !StringUtils.equals((CharSequence)item.getBudgetItemName(), (CharSequence)item.getHeadBudgetItemName())) {
            if (StringUtils.isNotBlank((CharSequence)item.getBudgetItemName())) {
                budgetItemName.append(",");
            }
            budgetItemName.append(item.getHeadBudgetItemName());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getBudgetItemCode())) {
            budgetItemCode.append(item.getBudgetItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)item.getHeadBudgetItemCode()) && !StringUtils.equals((CharSequence)item.getBudgetItemCode(), (CharSequence)item.getHeadBudgetItemCode())) {
            if (StringUtils.isNotBlank((CharSequence)item.getBudgetItemCode())) {
                budgetItemCode.append(",");
            }
            budgetItemCode.append(item.getHeadBudgetItemCode());
        }
        approvalStatementDto.setBudgetProjectName(budgetItemName.toString());
        approvalStatementDto.setBudgetProjectCode(budgetItemCode.toString());
        approvalStatementDto.setBrandTxt(item.getProductBrandName());
        approvalStatementDto.setBrand(item.getProductBrandCode());
        approvalStatementDto.setProductName(item.getProductName());
        approvalStatementDto.setProductCode(item.getProductCode());
        approvalStatementDto.setActivityFormName(item.getActivityFormName());
        approvalStatementDto.setActivityFormCode(item.getActivityFormCode());
        approvalStatementDto.setActivityBeginDate(item.getActivityBeginDate());
        approvalStatementDto.setActivityEndDate(item.getActivityEndDate());
        approvalStatementDto.setDescription(item.getFormDescription());
        approvalStatementDto.setTotalcosts(NumberUtil.add((BigDecimal[])new BigDecimal[]{item.getCustomerFeeAmount(), item.getDepartmentFeeAmount(), item.getHeadFeeAmount()}));
        approvalStatementDto.setApplicationFee(NumberUtil.add((Number)item.getDepartmentFeeAmount(), (Number)item.getHeadFeeAmount()));
        approvalStatementDto.setDealerFees(item.getCustomerFeeAmount());
        return approvalStatementDto;
    }

    private ClosingStatementDto buildClosing(AuditCustomerDetailCollectionVo detail, Map<String, String> businessFormatMap, Map<String, String> businessUnitMap, ReconciliationDocListVo reconciliationDocListVo) {
        ClosingStatementDto closingStatementDto = new ClosingStatementDto();
        closingStatementDto.setIntegrationId(detail.getId());
        closingStatementDto.setStatementCode(reconciliationDocListVo.getStatementCode());
        closingStatementDto.setStatementStatus(reconciliationDocListVo.getStatementStatus());
        closingStatementDto.setAccountReconciliationType(reconciliationDocListVo.getAccountReconciliationType());
        closingStatementDto.setActivityDetailsCode(detail.getActivityDetailCode());
        if (reconciliationDocListVo.getReconciliationMonth() != null) {
            try {
                closingStatementDto.setReconciliationMonth(DateUtil.format((Date)reconciliationDocListVo.getReconciliationMonth(), (String)"yyyy-MM"));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u63a8\u9001ecrm\u65f6,\u5e74\u6708\u5b57\u6bb5\u65f6\u95f4\u7c7b\u578b\u8f6c\u6362\u9519\u8bef");
            }
        }
        closingStatementDto.setCustomerCode(detail.getCustomerCode());
        closingStatementDto.setCustomerName(detail.getCustomerName());
        closingStatementDto.setCustomerType(detail.getCustomerType());
        closingStatementDto.setFirstChannelCode(detail.getFirstChannelCode());
        closingStatementDto.setFirstChannelName(detail.getFirstChannelName());
        closingStatementDto.setSecondChannelCode(detail.getSecondChannelCode());
        closingStatementDto.setSecondChannelName(detail.getSecondChannelName());
        closingStatementDto.setCenter(detail.getCenter());
        if (StrUtil.isNotEmpty((CharSequence)detail.getBusinessFormatCode()) && CollectionUtil.isNotEmpty(businessFormatMap)) {
            closingStatementDto.setBusinessFormatCode(businessFormatMap.get(detail.getBusinessFormatCode()));
        }
        if (StrUtil.isNotEmpty((CharSequence)detail.getBusinessUnitCode()) && CollectionUtil.isNotEmpty(businessUnitMap)) {
            closingStatementDto.setBusinessUnitCode(businessUnitMap.get(detail.getBusinessUnitCode()));
        }
        closingStatementDto.setSalesInstitutionName(detail.getSalesInstitutionName());
        closingStatementDto.setSalesInstitutionCode(detail.getSalesInstitutionCode());
        closingStatementDto.setSalesOrgRegionName(detail.getSalesRegionName());
        closingStatementDto.setSalesOrgRegionCode(detail.getSalesRegionCode());
        closingStatementDto.setSalesOrgProvinceName(detail.getSalesOrgName());
        closingStatementDto.setSalesOrgProvinceCode(detail.getSalesOrgCode());
        closingStatementDto.setBudgetProjectName(detail.getBudgetItemName());
        closingStatementDto.setBudgetProjectCode(detail.getBudgetItemCode());
        closingStatementDto.setBrandTxt(detail.getProductBrandName());
        closingStatementDto.setBrand(detail.getProductBrandCode());
        closingStatementDto.setProductName(detail.getProductName());
        closingStatementDto.setProductCode(detail.getProductCode());
        closingStatementDto.setActivityFormName(detail.getActivityFormName());
        closingStatementDto.setActivityFormCode(detail.getActivityFormCode());
        if (Objects.nonNull(detail.getActivityBeginTime())) {
            closingStatementDto.setActivityBeginDate(DateUtil.format((Date)detail.getActivityBeginTime(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
        }
        if (Objects.nonNull(detail.getActivityEndTime())) {
            closingStatementDto.setActivityEndDate(DateUtil.format((Date)detail.getActivityEndTime(), (DatePrinter)DatePattern.NORM_DATE_FORMAT));
        }
        closingStatementDto.setDescription(detail.getRemark());
        if (Objects.nonNull(detail.getCustomerFeeAmount())) {
            closingStatementDto.setDealerBearFee(detail.getCustomerFeeAmount().toString());
        }
        if (Objects.nonNull(detail.getApprovedAmount())) {
            closingStatementDto.setApprovedAmount(detail.getApprovedAmount().toString());
        }
        if (Objects.nonNull(detail.getThisAuditAmount())) {
            closingStatementDto.setClosingAmount(detail.getThisAuditAmount().toString());
        }
        if (Objects.nonNull(detail.getDiscountTaxAmount()) && Objects.nonNull(detail.getDiscountAmount())) {
            closingStatementDto.setTaxQuota(NumberUtil.sub((Number)detail.getDiscountTaxAmount(), (Number)detail.getDiscountAmount()).toString());
        }
        if (Objects.nonNull(detail.getThisAuditAmount()) && StrUtil.isNotEmpty((CharSequence)closingStatementDto.getTaxQuota())) {
            closingStatementDto.setFinalClosingAmount(detail.getThisAuditAmount().subtract(new BigDecimal(closingStatementDto.getTaxQuota())).toString());
        }
        if (Objects.nonNull(detail.getDiscountAmount())) {
            closingStatementDto.setDiscountTaxTotalAmount(detail.getDiscountAmount().toString());
        }
        if (Objects.nonNull(detail.getReimburseTaxAmount())) {
            closingStatementDto.setReimburseTaxAmount(detail.getReimburseTaxAmount().toString());
        }
        if (Objects.nonNull(detail.getExamineCircularAmount())) {
            closingStatementDto.setExamineCircularAmount(detail.getExamineCircularAmount().toPlainString());
            closingStatementDto.setCreateName(detail.getCreateName());
            closingStatementDto.setProcessTitle(detail.getProcessTitle());
        }
        closingStatementDto.setMethodAccounting(detail.getMethodAccounting());
        return closingStatementDto;
    }
}

