/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.AccountCheckBillDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ActionDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ContractDocumentDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ContractDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ContractExpeditingDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.DownloadContractDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.ScrapContractDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.SignatoryDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.WithdrawalContractDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicSignatureApiService;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.NewFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationFileTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListFileVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaseElectronicSignature {
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ReconciliationDocListFileVoService reconciliationDocListFileVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ElectronicSignatureApiService electronicSignatureApiService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Value(value="${venus.file.fileRoot}")
    public String fileRoot;
    private static final String CATEGORY = "tpm_electronicSignature_category";
    private static final String CATEGORY_ID = "categoryId";
    private static final String CATEGORY_NAME = "categoryName";

    public ElectronicSignatureVo<CreateContractVo> pushElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        AccountCheckBillDto dto = new AccountCheckBillDto();
        ContractDocumentDto contractDocumentDto = new ContractDocumentDto();
        contractDocumentDto.setTitle(reconciliationDocListVo.getStatementCode());
        ReconciliationDocListFileVo detailByStatementCodeAndFileType = this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.BO_ZHI.getCode());
        Validate.notNull((Object)detailByStatementCodeAndFileType, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(detailByStatementCodeAndFileType.getFileCode());
        byte[] fileByte = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
        File mkdir = null;
        try {
            mkdir = FileUtil.newFile((String)(this.fileRoot + "/" + reconciliationDocListVo.getStatementCode() + ".pdf"));
            File file = FileUtil.writeBytes((byte[])fileByte, (File)mkdir);
            if (!file.exists()) {
                throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            contractDocumentDto.setAccountCheckBillFile(file);
            dto.setContractDocumentDto(contractDocumentDto);
            ContractDto contractDto = new ContractDto();
            List dictTypeCode = this.dictDataVoService.findByDictTypeCode(CATEGORY);
            if (CollectionUtil.isEmpty((Collection)dictTypeCode)) {
                throw new IllegalArgumentException("\u7528\u5370\u6d41\u7a0b\u6570\u636e\u5b57\u5178\u4e0d\u5b58\u5728");
            }
            DictDataVo categoryIdDict = dictTypeCode.stream().filter(x -> CATEGORY_ID.equals(x.getDictCode())).findFirst().orElseThrow(() -> new IllegalArgumentException("\u6570\u636e\u5b57\u5178\u3010tpm_electronicSignature_category\u3011\u4e0d\u5b58\u5728\u7528\u5370ID[categoryId]\u7684\u914d\u7f6e"));
            contractDto.setCategoryId(categoryIdDict.getDictValue());
            DictDataVo categoryNameDict = dictTypeCode.stream().filter(x -> CATEGORY_NAME.equals(x.getDictCode())).findFirst().orElseThrow(() -> new IllegalArgumentException("\u6570\u636e\u5b57\u5178\u3010tpm_electronicSignature_category\u3011\u4e0d\u5b58\u5728\u7528\u5370\u540d\u79f0[categoryName]\u7684\u914d\u7f6e"));
            contractDto.setCategoryName(categoryNameDict.getDictValue());
            contractDto.setSubject(reconciliationDocListVo.getStatementCode());
            contractDto.setSn(reconciliationDocListVo.getStatementCode());
            contractDto.setSend(Boolean.valueOf(true));
            contractDto.setExtraSign(Boolean.valueOf(false));
            contractDto.setTenantName("\u5185\u8499\u53e4\u8499\u725b\u4e73\u4e1a\uff08\u96c6\u56e2\uff09\u80a1\u4efd\u6709\u9650\u516c\u53f8");
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            contractDto.setCreatorName(loginDetails.getUsername());
            contractDto.setCreatorContact(loginDetails.getPhone());
            contractDto.setMustSign(Boolean.valueOf(true));
            contractDto.setCustomerCode(reconciliationDocListVo.getCustomerCode());
            ArrayList<SignatoryDto> signatories = new ArrayList<SignatoryDto>();
            SignatoryDto signatoryDto = new SignatoryDto();
            signatoryDto.setTenantType("COMPANY");
            signatoryDto.setTenantName(reconciliationDocListVo.getCustomerName());
            signatoryDto.setSignatoryNo(reconciliationDocListVo.getCustomerCode());
            signatoryDto.setReceiverName(reconciliationDocListVo.getRecipientName());
            signatoryDto.setContact(reconciliationDocListVo.getReceiverTelephone());
            signatoryDto.setSerialNo(Integer.valueOf(1));
            signatoryDto.setRemind(Boolean.valueOf(true));
            signatoryDto.setAuthMode("DEFAULT");
            signatoryDto.setLanguage("zh_CN");
            ArrayList<ActionDto> actions = new ArrayList<ActionDto>();
            ActionDto action1Dto = new ActionDto();
            action1Dto.setSerialNo("1");
            action1Dto.setType("CORPORATE");
            action1Dto.setName("\u4f01\u4e1a\u7b7e\u7ae0");
            actions.add(action1Dto);
            ActionDto action2Dto = new ActionDto();
            action2Dto.setSerialNo("1");
            action2Dto.setType("LP");
            action2Dto.setName("\u6cd5\u4eba\u4ee3\u8868\u4eba\u7b7e\u5b57");
            actions.add(action2Dto);
            signatoryDto.setActions(actions);
            signatories.add(signatoryDto);
            contractDto.setSignatories(signatories);
            dto.setContractDto(contractDto);
            ElectronicSignatureVo electronicSignatureVo = this.electronicSignatureApiService.pushAccountCheckBill(dto);
            return electronicSignatureVo;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (mkdir != null) {
                mkdir.delete();
            }
        }
    }

    public ElectronicSignatureVo cancelElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        ScrapContractDto dto = new ScrapContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.cancellationContract(dto);
    }

    public ElectronicSignatureVo withdrawalElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        WithdrawalContractDto dto = new WithdrawalContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.withdrawalContract(dto);
    }

    public ElectronicSignatureVo expeditingElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        ContractExpeditingDto dto = new ContractExpeditingDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        return this.electronicSignatureApiService.contractExpediting(dto);
    }

    public ElectronicSignatureVo<FileVo> downloadElectronicSignature(ReconciliationDocListVo reconciliationDocListVo) {
        DownloadContractDto dto = new DownloadContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        dto.setDocumentId(Long.valueOf(reconciliationDocListVo.getDocumentsId()));
        return this.electronicSignatureApiService.downloadContract(dto);
    }

    public ElectronicSignatureVo<NewFileVo> downloadElectronicSignatureNew(ReconciliationDocListVo reconciliationDocListVo) {
        DownloadContractDto dto = new DownloadContractDto();
        dto.setBizId(reconciliationDocListVo.getStatementCode());
        if (null == reconciliationDocListVo.getContractId()) {
            return null;
        }
        dto.setContractId(Long.valueOf(reconciliationDocListVo.getContractId()));
        if (null == reconciliationDocListVo.getDocumentsId()) {
            return null;
        }
        dto.setDocumentId(Long.valueOf(reconciliationDocListVo.getDocumentsId()));
        return this.electronicSignatureApiService.downloadContractNew(dto);
    }
}

