/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationCorrelationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationCorrelationRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationCorrelationEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationCorrelationLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationCorrelationVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reconciliationCorrelationService")
public class ReconciliationCorrelationVoServiceImpl
implements ReconciliationCorrelationVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationCorrelationVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationCorrelationRepository reconciliationCorrelationRepository;
    @Autowired(required=false)
    private List<ReconciliationCorrelationEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<ReconciliationCorrelationVo> findByConditions(Pageable pageable, ReconciliationCorrelationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ReconciliationCorrelationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.reconciliationCorrelationRepository.findByConditions((Page<ReconciliationCorrelationVo>)page, dto);
    }

    public ReconciliationCorrelationVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ReconciliationCorrelationEntity reconciliationCorrelation = this.reconciliationCorrelationRepository.findById(id);
        if (reconciliationCorrelation == null) {
            return null;
        }
        return (ReconciliationCorrelationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationCorrelation, ReconciliationCorrelationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<String> findByStatementCode(String statementCode) {
        if (StringUtils.isEmpty((CharSequence)statementCode)) {
            return Sets.newHashSet();
        }
        List list = ((LambdaQueryChainWrapper)this.reconciliationCorrelationRepository.lambdaQuery().eq(ReconciliationCorrelationEntity::getStatementCode, (Object)statementCode)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Sets.newHashSet();
        }
        return list.stream().filter(Objects::nonNull).map(ReconciliationCorrelationEntity::getAssociativeDate).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Transactional
    public ReconciliationCorrelationVo create(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        this.createValidation(reconciliationCorrelationVo);
        reconciliationCorrelationVo.setTenantCode(TenantUtils.getTenantCode());
        reconciliationCorrelationVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationCorrelationVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ReconciliationCorrelationEntity reconciliationCorrelation = (ReconciliationCorrelationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationCorrelationVo, ReconciliationCorrelationEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationCorrelationRepository.saveOrUpdate((Object)reconciliationCorrelation);
        reconciliationCorrelationVo.setId(reconciliationCorrelation.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationCorrelationEventListener reconciliationCorrelationEventListener : this.eventListeners) {
                reconciliationCorrelationEventListener.onCreate(reconciliationCorrelationVo);
            }
        }
        ReconciliationCorrelationLogEventDto logEventDto = new ReconciliationCorrelationLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(reconciliationCorrelationVo);
        SerializableBiConsumer & Serializable onCreate = ReconciliationCorrelationLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationCorrelationLogEventListener.class, (SerializableBiConsumer)onCreate);
        return reconciliationCorrelationVo;
    }

    public void createBatch(List<ReconciliationCorrelationVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        voList.forEach(vo -> {
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        Collection correlationEntities = this.nebulaToolkitService.copyCollectionByWhiteList(voList, ReconciliationCorrelationVo.class, ReconciliationCorrelationEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.reconciliationCorrelationRepository.saveBatch(correlationEntities);
    }

    @Transactional
    public ReconciliationCorrelationVo update(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        this.updateValidation(reconciliationCorrelationVo);
        String currentId = reconciliationCorrelationVo.getId();
        ReconciliationCorrelationEntity current = this.reconciliationCorrelationRepository.findById(currentId);
        current = (ReconciliationCorrelationEntity)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        ReconciliationCorrelationVo oldVo = (ReconciliationCorrelationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, ReconciliationCorrelationVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.reconciliationCorrelationRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationCorrelationEventListener reconciliationCorrelationEventListener : this.eventListeners) {
                reconciliationCorrelationEventListener.onUpdate(oldVo, reconciliationCorrelationVo);
            }
        }
        ReconciliationCorrelationLogEventDto logEventDto = new ReconciliationCorrelationLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(reconciliationCorrelationVo);
        SerializableBiConsumer & Serializable onUpdate = ReconciliationCorrelationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationCorrelationLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return reconciliationCorrelationVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationCorrelationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationCorrelationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationCorrelationRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        this.validation(reconciliationCorrelationVo);
    }

    private void updateValidation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
        this.validation(reconciliationCorrelationVo);
    }

    private void validation(ReconciliationCorrelationVo reconciliationCorrelationVo) {
    }
}

