/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.ReconciliationDocBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ReconciliationDocBuildServiceImpl
implements ReconciliationDocBuildService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDocBuildServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ReconciliationDocListService reconciliationDocListService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    @Async
    public void handleBuildReconciliation(Date date, AbstractCrmUserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        String lockKey = this.getBuildRedisLockKey(date);
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
            Assert.isTrue((boolean)lock, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u52a0\u9501\u5931\u8d25");
            this.autoBuildReconciliation(date);
            log.info("=====>     \u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u6210\u529f     <=====");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @Override
    public List<String> handleBuildReconciliationForOut(Date date, AbstractCrmUserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        String lockKey = this.getBuildRedisLockKey(date);
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
            Assert.isTrue((boolean)lock, (String)"\u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u52a0\u9501\u5931\u8d25");
            List<String> list = this.autoBuildReconciliationForOut(date);
            log.info("=====>     \u81ea\u52a8\u751f\u6210\u7684\u5bf9\u8d26\u5355\u6210\u529f     <=====");
            List<String> list2 = list;
            return list2;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    private List<String> autoBuildReconciliationForOut(Date date) {
        return this.reconciliationDocListService.autoBuildReconciliationForOut(date);
    }

    @Override
    public void autoBuildReconciliation(Date date) {
        this.reconciliationDocListService.autoBuildReconciliation(date);
    }

    @Override
    public void autoBuildFailReconciliation(Date date) {
        this.reconciliationDocListService.autoBuildFailReconciliation(date);
    }

    @Override
    public String getBuildRedisLockKey(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        String lockKey = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
        return "audit:reconciliation:lock:" + lockKey;
    }

    @Override
    public String getBuildFailRedisLockKey(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        String lockKey = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
        return "audit:reconciliation:lock:fail:" + lockKey;
    }
}

