/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListFileEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationDocListFileRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationDocListFileEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationDocListFileLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListFileVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reconciliationDocListFileService")
public class ReconciliationDocListFileVoServiceImpl
implements ReconciliationDocListFileVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDocListFileVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationDocListFileRepository reconciliationDocListFileRepository;
    @Autowired(required=false)
    private List<ReconciliationDocListFileEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<ReconciliationDocListFileVo> findByConditions(Pageable pageable, ReconciliationDocListFileDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ReconciliationDocListFileDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.reconciliationDocListFileRepository.findByConditions((Page<ReconciliationDocListFileVo>)page, dto);
    }

    public ReconciliationDocListFileVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ReconciliationDocListFileEntity reconciliationDocListFile = this.reconciliationDocListFileRepository.findById(id);
        if (reconciliationDocListFile == null) {
            return null;
        }
        return (ReconciliationDocListFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListFile, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public ReconciliationDocListFileVo findDetailByStatementCodeAndFileType(String statementCode, String fileType) {
        if (StringUtils.isBlank((CharSequence)statementCode) || StringUtils.isBlank((CharSequence)fileType)) {
            return null;
        }
        ReconciliationDocListFileEntity reconciliationDocListFile = this.reconciliationDocListFileRepository.findDetailByStatementCodeAndFileType(statementCode, fileType);
        if (reconciliationDocListFile == null) {
            return null;
        }
        return (ReconciliationDocListFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListFile, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public ReconciliationDocListFileVo create(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.createValidation(reconciliationDocListFileVo);
        reconciliationDocListFileVo.setTenantCode(TenantUtils.getTenantCode());
        ReconciliationDocListFileEntity reconciliationDocListFile = (ReconciliationDocListFileEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListFileVo, ReconciliationDocListFileEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationDocListFileRepository.saveOrUpdate((Object)reconciliationDocListFile);
        reconciliationDocListFileVo.setId(reconciliationDocListFile.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationDocListFileEventListener reconciliationDocListFileEventListener : this.eventListeners) {
                reconciliationDocListFileEventListener.onCreate(reconciliationDocListFileVo);
            }
        }
        ReconciliationDocListFileLogEventDto logEventDto = new ReconciliationDocListFileLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(reconciliationDocListFileVo);
        SerializableBiConsumer & Serializable onCreate = ReconciliationDocListFileLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationDocListFileLogEventListener.class, (SerializableBiConsumer)onCreate);
        return reconciliationDocListFileVo;
    }

    @Transactional
    public ReconciliationDocListFileVo update(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.updateValidation(reconciliationDocListFileVo);
        String currentId = reconciliationDocListFileVo.getId();
        ReconciliationDocListFileEntity current = this.reconciliationDocListFileRepository.findById(currentId);
        current = (ReconciliationDocListFileEntity)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        ReconciliationDocListFileVo oldVo = (ReconciliationDocListFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, ReconciliationDocListFileVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.reconciliationDocListFileRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationDocListFileEventListener reconciliationDocListFileEventListener : this.eventListeners) {
                reconciliationDocListFileEventListener.onUpdate(oldVo, reconciliationDocListFileVo);
            }
        }
        ReconciliationDocListFileLogEventDto logEventDto = new ReconciliationDocListFileLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(reconciliationDocListFileVo);
        SerializableBiConsumer & Serializable onUpdate = ReconciliationDocListFileLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationDocListFileLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return reconciliationDocListFileVo;
    }

    public void createBatch(Set<ReconciliationDocListFileVo> files) {
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        this.reconciliationDocListFileRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList(files, ReconciliationDocListFileVo.class, ReconciliationDocListFileEntity.class, HashSet.class, ArrayList.class, new String[0]), 10);
    }

    private void createValidation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.validation(reconciliationDocListFileVo);
    }

    private void updateValidation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
        this.validation(reconciliationDocListFileVo);
    }

    private void validation(ReconciliationDocListFileVo reconciliationDocListFileVo) {
    }
}

