/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.NewFileVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleDateConfigRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationDocListRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.BaseEcrmBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal.BaseElectronicSignature;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal.ReconciliationDocListTaskService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant.ReconciliationConstant;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListTaskDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.log.ReconciliationDocListLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationFileTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationDocListLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationCorrelationVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListFileVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationJobLogVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationDocListServiceImpl
implements ReconciliationDocListService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDocListServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationDocListRepository reconciliationDocListRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private BaseElectronicSignature baseElectronicSignature;
    @Autowired(required=false)
    private TpmAccountReconciliationRuleService accountReconciliationRuleService;
    @Autowired(required=false)
    private ReconciliationJobLogVoService reconciliationJobLogVoService;
    @Autowired(required=false)
    private ReconciliationDocListTaskService reconciliationDocListTaskService;
    @Autowired(required=false)
    private ReconciliationCorrelationVoService correlationVoService;
    @Autowired(required=false)
    private BaseEcrmBuildService baseEcrmBuildService;
    @Autowired(required=false)
    private ReconciliationDocListFileVoService reconciliationDocListFileVoService;
    @Autowired
    private FileHandleService fileHandleService;

    public Page<ReconciliationDocListVo> findByReconciliations(Pageable pageable, ReconciliationDocListDto reconciliationDocListDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(reconciliationDocListDto)) {
            reconciliationDocListDto = new ReconciliationDocListDto();
        }
        return this.reconciliationDocListRepository.findByReconciliations(pageable, reconciliationDocListDto);
    }

    public void regenerate(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        reconciliationDocListVos.forEach(x -> {
            if (ReconciliationStatusEnum.CONFIRMED.getCode().equals(x.getStatementStatus()) || ReconciliationStatusEnum.COMPLETE.getCode().equals(x.getStatementStatus())) {
                throw new IllegalArgumentException("\u5bf9\u8d26\u5355\u3010" + x.getStatementCode() + "\u3011\uff0c\u4e3a\u5f85\u5ba2\u6237\u786e\u8ba4\u6216\u5bf9\u8d26\u5b8c\u6210\u72b6\u6001\uff0c\u4e0d\u53ef\u66f4\u65b0\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u63d0\u4ea4");
            }
        });
        reconciliationDocListVos.forEach(this::regeneratePdf);
    }

    @Transactional(rollbackFor={Exception.class})
    public void regeneratePdf(ReconciliationDocListVo doc) {
        TpmAccountReconciliationRuleDateConfigRespVo ruleDateConfigRespVo = new TpmAccountReconciliationRuleDateConfigRespVo();
        ruleDateConfigRespVo.setStartDate(DateUtil.formatDateTime((Date)doc.getStartDate()));
        ruleDateConfigRespVo.setEndDate(DateUtil.formatDateTime((Date)doc.getEndDate()));
        ruleDateConfigRespVo.setAccountReconciliationRuleCode(doc.getAccountReconciliationRuleCode());
        TpmAccountReconciliationRuleRespVo ruleRespVo = new TpmAccountReconciliationRuleRespVo();
        ruleRespVo.setBusinessUnitCode(doc.getBusinessUnitCode());
        ruleRespVo.setBusinessFormatCode(doc.getBusinessFormatCode());
        ruleRespVo.setAccountReconciliationRuleCode(doc.getAccountReconciliationRuleCode());
        ReconciliationJobLogDto logDto = ReconciliationJobLogDto.builder().accountReconciliationRuleCode(doc.getAccountReconciliationRuleCode()).businessUnitCode(doc.getBusinessUnitCode()).businessFormatCode(doc.getBusinessFormatCode()).startDate(doc.getStartDate()).endDate(doc.getEndDate()).build();
        ReconciliationJobLogVo jobLogVo = this.reconciliationJobLogVoService.findUniqueJobInfo(logDto);
        if (Objects.nonNull(jobLogVo)) {
            jobLogVo.setIsSuccess(Boolean.valueOf(false));
            this.reconciliationJobLogVoService.update(jobLogVo);
        }
        ReconciliationDocListTaskDto taskDto = null;
        taskDto = jobLogVo == null ? ReconciliationDocListTaskDto.builder().accountReconciliationType(doc.getAccountReconciliationType()).accountReconciliationRuleCode(doc.getAccountReconciliationRuleCode()).calculationTime((Date)DateUtil.date()).businessFormatCode(doc.getBusinessFormatCode()).businessUnitCode(doc.getBusinessUnitCode()).endDate(doc.getEndDate()).startDate(doc.getStartDate()).customerCode(doc.getCustomerCode()).build() : ReconciliationDocListTaskDto.builder().accountReconciliationType(doc.getAccountReconciliationType()).accountReconciliationRuleCode(jobLogVo.getAccountReconciliationRuleCode()).calculationTime(jobLogVo.getCalculationTime()).businessFormatCode(jobLogVo.getBusinessFormatCode()).businessUnitCode(jobLogVo.getBusinessUnitCode()).endDate(jobLogVo.getEndDate()).startDate(jobLogVo.getStartDate()).customerCode(doc.getCustomerCode()).build();
        List<ReconciliationDocListVo> docListVos = this.reconciliationDocListTaskService.executeTask(taskDto);
        this.createBatch(docListVos);
        this.reconciliationDocListRepository.removeById((Serializable)((Object)doc.getId()));
    }

    public ReconciliationDocListVo update(ReconciliationDocListDto reconciliationDocListDto) {
        ReconciliationDocListVo reconciliationDocListVo = this.findById(reconciliationDocListDto.getId());
        Validate.notNull((Object)reconciliationDocListVo, (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (!reconciliationDocListDto.getStatementStatus().equals(ReconciliationStatusEnum.WITHDRAW.getCode())) {
            throw new IllegalArgumentException("\u4ec5\u66f4\u65b0\u5bf9\u8d26\u64a4\u56de\u72b6\u6001!");
        }
        reconciliationDocListDto.setTenantCode(TenantUtils.getTenantCode());
        reconciliationDocListDto.setStatementStatus(ReconciliationStatusEnum.WAIT.getCode());
        ReconciliationDocListEntity reconciliationDocListEntity = (ReconciliationDocListEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListDto, ReconciliationDocListEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.reconciliationDocListRepository.save((Object)reconciliationDocListEntity);
        ReconciliationDocListDto dto = (ReconciliationDocListDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListVo, ReconciliationDocListDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ReconciliationDocListLogEventDto logEventDto = new ReconciliationDocListLogEventDto();
        logEventDto.setOriginal(dto);
        logEventDto.setNewest(reconciliationDocListDto);
        SerializableBiConsumer & Serializable onCreate = ReconciliationDocListLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationDocListLogEventListener.class, (SerializableBiConsumer)onCreate);
        return reconciliationDocListVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> createBatch(List<ReconciliationDocListVo> reconciliationDocListVos) {
        if (CollectionUtils.isEmpty(reconciliationDocListVos)) {
            return new ArrayList<String>();
        }
        Date reconciliationMonth = reconciliationDocListVos.stream().map(ReconciliationDocListVo::getReconciliationMonth).filter(Objects::nonNull).findFirst().orElse(null);
        String accountReconciliationType = reconciliationDocListVos.stream().map(ReconciliationDocListVo::getAccountReconciliationType).filter(Objects::nonNull).findFirst().orElse(null);
        String businessFormatCode = reconciliationDocListVos.stream().map(ReconciliationDocListVo::getBusinessFormatCode).filter(Objects::nonNull).findFirst().orElse(null);
        String businessUnitCode = reconciliationDocListVos.stream().map(ReconciliationDocListVo::getBusinessUnitCode).filter(Objects::nonNull).findFirst().orElse(null);
        if (!Objects.isNull(reconciliationMonth) && StringUtils.isNotBlank((CharSequence)accountReconciliationType) && StringUtils.isNotBlank((CharSequence)businessFormatCode) && StringUtils.isNotBlank((CharSequence)businessUnitCode)) {
            ReconciliationDocListDto dto = new ReconciliationDocListDto();
            dto.setReconciliationMonth(reconciliationMonth);
            dto.setAccountReconciliationType(accountReconciliationType);
            dto.setBusinessFormatCode(businessFormatCode);
            dto.setBusinessUnitCode(businessUnitCode);
            dto.setTenantCode(TenantUtils.getTenantCode());
            List<String> customerJointInstitutionErpCodes = this.findNotUpdateReconciliationDocList(dto);
            if (!CollectionUtils.isEmpty(customerJointInstitutionErpCodes)) {
                reconciliationDocListVos = reconciliationDocListVos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCustomerErpCode()) && StringUtils.isNotBlank((CharSequence)r.getSalesInstitutionCode())).filter(r -> !customerJointInstitutionErpCodes.contains(r.getCustomerErpCode() + "-" + r.getSalesInstitutionCode())).collect(Collectors.toList());
            }
            List collect = reconciliationDocListVos.stream().map(o -> o.getCustomerErpCode() + "-" + o.getSalesInstitutionCode()).distinct().collect(Collectors.toList());
            dto.setCustomerJointInstitutionErpCode(collect);
            this.deleteByCondition(dto);
        }
        ArrayList reconciliationDocListEntities = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(reconciliationDocListVos, ReconciliationDocListVo.class, ReconciliationDocListEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationDocListRepository.saveBatch(reconciliationDocListEntities);
        List correlationVos = reconciliationDocListVos.stream().filter(Objects::nonNull).map(ReconciliationDocListVo::getCorrelations).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        this.correlationVoService.createBatch(correlationVos);
        Set files = reconciliationDocListVos.stream().filter(Objects::nonNull).map(ReconciliationDocListVo::getFiles).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        this.reconciliationDocListFileVoService.createBatch(files);
        return reconciliationDocListEntities.stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    private void deleteByCondition(ReconciliationDocListDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (Objects.isNull(dto.getReconciliationMonth()) || StringUtils.isBlank((CharSequence)dto.getAccountReconciliationType()) || StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.reconciliationDocListRepository.deleteByCondition(dto);
    }

    private List<String> findNotUpdateReconciliationDocList(ReconciliationDocListDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getAccountReconciliationType())) {
            return Lists.newArrayList();
        }
        if (Objects.isNull(dto.getReconciliationMonth())) {
            dto.setReconciliationMonth(new Date());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<String> list = this.reconciliationDocListRepository.findNotUpdateReconciliationDocList(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public ReconciliationDocListVo findById(String id) {
        Validate.notNull((Object)id, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReconciliationDocListEntity reconciliationDocListEntity = (ReconciliationDocListEntity)((Object)this.reconciliationDocListRepository.getById((Serializable)((Object)id)));
        if (reconciliationDocListEntity == null) {
            return null;
        }
        return (ReconciliationDocListVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListEntity, ReconciliationDocListVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public ReconciliationDocListVo findByContractId(String contractId) {
        Validate.notNull((Object)contractId, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReconciliationDocListEntity reconciliationDocListEntity = this.reconciliationDocListRepository.findByContractId(contractId);
        if (reconciliationDocListEntity == null) {
            return null;
        }
        return (ReconciliationDocListVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocListEntity, ReconciliationDocListVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private List<ReconciliationDocListVo> validateIds(List<String> ids) {
        Validate.notNull(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ReconciliationDocListEntity> docListEntities = this.reconciliationDocListRepository.findByIds(ids);
        Validate.notEmpty(docListEntities, (String)"\u5bf9\u5e94id\u67e5\u8be2\u4e0d\u5230\u5b9e\u4f8b\u5bf9\u8c61,\u8bf7\u68c0\u67e5id\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        Collection reconciliationDocListVos = this.nebulaToolkitService.copyCollectionByWhiteList(docListEntities, ReconciliationDocListEntity.class, ReconciliationDocListVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)reconciliationDocListVos);
    }

    public void pushAccountCheckBill(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        List dateList = reconciliationDocListVos.stream().filter(x -> !ReconciliationStatusEnum.WAIT.getCode().equals(x.getStatementStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dateList), (String)"\u6570\u636e\u96c6\u4e2d\u5b58\u5728\u975e\u5f85\u63a8\u9001\u72b6\u6001\u7684\u6570\u636e\uff0c\u53ea\u6709\u5f85\u63a8\u9001\u53ef\u4ee5\u63a8\u9001\u7535\u5b50\u7b7e\u7ae0", (Object[])new Object[0]);
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            ElectronicSignatureVo<CreateContractVo> longElectronicSignatureVo;
            Optional<ElectronicSignatureVo<CreateContractVo>> electronicSignatureVo;
            Validate.notNull((Object)reconciliationDocListVo.getReceiverTelephone(), (String)"\u63a5\u53d7\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)reconciliationDocListVo.getRecipientName(), (String)"\u63a5\u53d7\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (StrUtil.isEmpty((CharSequence)reconciliationDocListVo.getContractId()) && StrUtil.isEmpty((CharSequence)reconciliationDocListVo.getDocumentsId()) && (electronicSignatureVo = Optional.ofNullable(longElectronicSignatureVo = this.baseElectronicSignature.pushElectronicSignature((ReconciliationDocListVo)reconciliationDocListVo))).isPresent()) {
                ElectronicSignatureVo<CreateContractVo> voElectronicSignatureVo = electronicSignatureVo.get();
                if (Objects.isNull(voElectronicSignatureVo.getResult())) {
                    return;
                }
                reconciliationDocListVo.setContractId(String.valueOf(((CreateContractVo)voElectronicSignatureVo.getResult()).getContractId()));
                reconciliationDocListVo.setDocumentsId(String.valueOf(((CreateContractVo)voElectronicSignatureVo.getResult()).getDocumentId()));
            }
            reconciliationDocListVo.setStatementStatus(ReconciliationStatusEnum.CONFIRMED.getCode());
            this.baseEcrmBuildService.pushECrm((ReconciliationDocListVo)reconciliationDocListVo);
            this.baseEcrmBuildService.syncECrm((ReconciliationDocListVo)reconciliationDocListVo, null);
            ReconciliationDocListEntity docListEntity = (ReconciliationDocListEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(reconciliationDocListVo, ReconciliationDocListEntity.class, HashSet.class, ArrayList.class, new String[0])));
            this.reconciliationDocListRepository.updateById((Object)docListEntity);
        });
    }

    public void cancellationContract(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        List dateList = reconciliationDocListVos.stream().filter(x -> !ReconciliationStatusEnum.COMPLETE.getCode().equals(x.getStatementStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dateList), (String)"\u6570\u636e\u96c6\u4e2d\u5b58\u5728\u975e\u5bf9\u8d26\u5b8c\u6210\u72b6\u6001\u7684\u6570\u636e\uff0c\u53ea\u6709\u5bf9\u8d26\u5b8c\u6210\u53ef\u4ee5\u4f5c\u5e9f", (Object[])new Object[0]);
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            if (ReconciliationStatusEnum.SCRAP.getCode().equals(reconciliationDocListVo.getStatementStatus())) {
                return;
            }
            Validate.notBlank((CharSequence)reconciliationDocListVo.getContractId(), (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)reconciliationDocListVo.getDocumentsId(), (String)"\u6587\u6863ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ElectronicSignatureVo signatureVo = this.baseElectronicSignature.cancelElectronicSignature((ReconciliationDocListVo)reconciliationDocListVo);
            if (Objects.nonNull(signatureVo) && signatureVo.isSuccess()) {
                reconciliationDocListVo.setStatementStatus(ReconciliationStatusEnum.SCRAP.getCode());
                this.baseEcrmBuildService.syncECrm((ReconciliationDocListVo)reconciliationDocListVo, null);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.reconciliationDocListRepository.lambdaUpdate().eq(UuidEntity::getId, (Object)reconciliationDocListVo.getId())).set(ReconciliationDocListEntity::getStatementStatus, (Object)ReconciliationStatusEnum.SCRAP.getCode())).set(ReconciliationDocListEntity::getContractId, null)).set(ReconciliationDocListEntity::getDocumentsId, null)).update();
            }
        });
    }

    public void withdrawalContract(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        List dateList = reconciliationDocListVos.stream().filter(x -> !ReconciliationStatusEnum.CONFIRMED.getCode().equals(x.getStatementStatus())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dateList), (String)"\u6570\u636e\u96c6\u4e2d\u5b58\u5728\u975e\u5f85\u5ba2\u6237\u786e\u8ba4\u72b6\u6001\u7684\u6570\u636e\uff0c\u53ea\u6709\u5f85\u5ba2\u6237\u786e\u8ba4\u53ef\u4ee5\u64a4\u56de", (Object[])new Object[0]);
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            if (ReconciliationStatusEnum.WITHDRAW.getCode().equals(reconciliationDocListVo.getStatementStatus())) {
                return;
            }
            Validate.notBlank((CharSequence)reconciliationDocListVo.getContractId(), (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ElectronicSignatureVo signatureVo = this.baseElectronicSignature.withdrawalElectronicSignature((ReconciliationDocListVo)reconciliationDocListVo);
            if (Objects.nonNull(signatureVo) && signatureVo.isSuccess()) {
                reconciliationDocListVo.setStatementStatus(ReconciliationStatusEnum.WITHDRAW.getCode());
                this.baseEcrmBuildService.syncECrm((ReconciliationDocListVo)reconciliationDocListVo, null);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.reconciliationDocListRepository.lambdaUpdate().eq(UuidEntity::getId, (Object)reconciliationDocListVo.getId())).set(ReconciliationDocListEntity::getStatementStatus, (Object)ReconciliationStatusEnum.WITHDRAW.getCode())).set(ReconciliationDocListEntity::getContractId, null)).set(ReconciliationDocListEntity::getDocumentsId, null)).update();
            }
        });
    }

    public List<ReconciliationDocListFileVo> browseContract(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        ArrayList<ReconciliationDocListFileVo> result = new ArrayList<ReconciliationDocListFileVo>(ids.size());
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            ReconciliationDocListFileVo reconciliationDocListFileVo = this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.MENG_NIU.getCode());
            if (reconciliationDocListFileVo == null) {
                reconciliationDocListFileVo = this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.BO_ZHI.getCode());
            }
            result.add(reconciliationDocListFileVo);
        });
        return result;
    }

    public List<ReconciliationDocListFileVo> downloadContract(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        ArrayList<ReconciliationDocListFileVo> result = new ArrayList<ReconciliationDocListFileVo>(ids.size());
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            ReconciliationDocListFileVo reconciliationDocListFileVo = this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.MENG_NIU.getCode());
            if (reconciliationDocListFileVo != null) {
                result.add(reconciliationDocListFileVo);
                return;
            }
            ElectronicSignatureVo<FileVo> signatureVo = this.baseElectronicSignature.downloadElectronicSignature((ReconciliationDocListVo)reconciliationDocListVo);
            Optional<FileVo> fileVo = Optional.ofNullable(signatureVo).map(ElectronicSignatureVo::getResult);
            fileVo.ifPresent(file -> {
                ReconciliationDocListFileVo docListFileVo = new ReconciliationDocListFileVo();
                docListFileVo.setStatementCode(reconciliationDocListVo.getStatementCode());
                docListFileVo.setFileType(ReconciliationFileTypeEnum.MENG_NIU.getCode());
                docListFileVo.setFileCode(file.getFileCode());
                docListFileVo.setTenantCode(TenantUtils.getTenantCode());
                docListFileVo.setOriginalFileName(file.getOriginalFileName());
                this.reconciliationDocListFileVoService.create(docListFileVo);
                result.add(docListFileVo);
            });
        });
        return result;
    }

    public byte[] findFileZipByIds(List<String> ids) throws IOException {
        log.info("\u8fdb\u5165\u6279\u91cf\u4e0b\u8f7d\u7535\u5b50\u7b7e\u7ae0\u65b9\u6cd5");
        if (CollectionUtils.isEmpty(ids)) {
            return new byte[0];
        }
        Validate.isTrue((ids.size() <= 200 ? 1 : 0) != 0, (String)"\u6700\u591a\u4e0b\u8f7d200\u4e2a\u6587\u4ef6!", (Object[])new Object[0]);
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        ArrayList result = new ArrayList(ids.size());
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            ReconciliationDocListFileVo reconciliationDocListFileVo = this.reconciliationDocListFileVoService.findDetailByStatementCodeAndFileType(reconciliationDocListVo.getStatementCode(), ReconciliationFileTypeEnum.BO_ZHI.getCode());
            if (reconciliationDocListFileVo != null) {
                result.add(reconciliationDocListFileVo);
                return;
            }
            ElectronicSignatureVo<NewFileVo> signatureVo = this.baseElectronicSignature.downloadElectronicSignatureNew((ReconciliationDocListVo)reconciliationDocListVo);
            if (null != signatureVo) {
                Optional<NewFileVo> fileVo = Optional.ofNullable(signatureVo).map(ElectronicSignatureVo::getResult);
                fileVo.ifPresent(file -> {
                    ReconciliationDocListFileVo docListFileVo = new ReconciliationDocListFileVo();
                    docListFileVo.setStatementCode(reconciliationDocListVo.getStatementCode());
                    docListFileVo.setFileType(ReconciliationFileTypeEnum.MENG_NIU.getCode());
                    docListFileVo.setFileCode(file.getFileCode());
                    docListFileVo.setTenantCode(TenantUtils.getTenantCode());
                    docListFileVo.setRelativeLocal(file.getRelativeLocal());
                    docListFileVo.setOriginalFileName(file.getOriginalFileName());
                    this.reconciliationDocListFileVoService.create(docListFileVo);
                    result.add(docListFileVo);
                });
            }
        });
        log.info("\u67e5\u8be2\u5230\u7684\u7535\u5b50\u7b7e\u7ae0\u6587\u4ef6,{}", (Object)JSON.toJSONString(result));
        Map<String, ReconciliationDocListVo> params = reconciliationDocListVos.stream().collect(Collectors.toMap(ReconciliationDocListVo::getStatementCode, s -> s));
        if (!CollectionUtils.isEmpty(result)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(bos);
            for (ReconciliationDocListFileVo file : result) {
                OrdinaryFileVo venus;
                ReconciliationDocListVo reconciliationDocListVo2 = params.get(file.getStatementCode());
                if (reconciliationDocListVo2 == null || Objects.isNull(venus = this.fileHandleService.findById(file.getFileCode()))) continue;
                log.info("\u67e5\u8be2venus\u6587\u4ef6\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)venus));
                byte[] fileBytes = this.fileHandleService.findContentByFilePathAndFileRename(venus.getRelativeLocal(), venus.getFileName());
                String fileName = StringUtils.join((Object[])new String[]{reconciliationDocListVo2.getCustomerName(), com.biz.crm.mn.common.base.util.DateUtil.format((Date)reconciliationDocListVo2.getReconciliationMonth(), (String)"yyyy-MM"), reconciliationDocListVo2.getAccountReconciliationType()});
                zipOut.putNextEntry(new ZipEntry(fileName + "." + venus.getPrefix()));
                zipOut.write(fileBytes, 0, fileBytes.length);
                zipOut.closeEntry();
            }
            zipOut.flush();
            zipOut.close();
            return bos.toByteArray();
        }
        return new byte[0];
    }

    public void contractExpediting(List<String> ids) {
        List<ReconciliationDocListVo> reconciliationDocListVos = this.validateIds(ids);
        reconciliationDocListVos.forEach(reconciliationDocListVo -> {
            Validate.isTrue((boolean)ReconciliationStatusEnum.CONFIRMED.getCode().equals(reconciliationDocListVo.getStatementStatus()), (String)"\u72b6\u6001\u4e3a\u5f85\u5ba2\u6237\u786e\u8ba4\u7684\u65f6\u5019\uff0c\u53ef\u4ee5\u70b9\u51fb\u50ac\u7b7e", (Object[])new Object[0]);
            ElectronicSignatureVo electronicSignatureVo = this.baseElectronicSignature.expeditingElectronicSignature((ReconciliationDocListVo)reconciliationDocListVo);
            if (Objects.isNull(electronicSignatureVo) || !electronicSignatureVo.isSuccess()) {
                throw new IllegalArgumentException("\u50ac\u7b7e\u5931\u8d25");
            }
        });
    }

    private String amountCharTransfer(String sapAmount) {
        if (StringUtils.isNotBlank((CharSequence)sapAmount)) {
            if (sapAmount.contains("-")) {
                return "-" + sapAmount.trim().replace("-", "");
            }
            return sapAmount.trim();
        }
        return BigDecimal.ZERO.toPlainString();
    }

    public void autoBuildReconciliation(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        PageRequest page = PageRequest.of((int)1, (int)20);
        Page pageResult = null;
        do {
            pageResult = this.accountReconciliationRuleService.findCurrentEffectiveRule((Pageable)page);
            log.info("=====>    \u5bf9\u8d26\u89c4\u5219 page[{}/{}]    <=====", (Object)pageResult.getCurrent(), (Object)pageResult.getPages());
            this.buildReconciliation(date, pageResult.getRecords());
            page = page.next();
        } while (pageResult.hasNext() && page.getPageNumber() < ReconciliationConstant.LOOP_TIMES_MAX);
    }

    public List<String> autoBuildReconciliationForOut(Date date) {
        ArrayList idList = Lists.newArrayList();
        if (Objects.isNull(date)) {
            date = new Date();
        }
        PageRequest page = PageRequest.of((int)1, (int)20);
        Page pageResult = null;
        do {
            pageResult = this.accountReconciliationRuleService.findCurrentEffectiveRule((Pageable)page);
            log.info("=====>    \u5bf9\u8d26\u89c4\u5219 page[{}/{}]    <=====", (Object)pageResult.getCurrent(), (Object)pageResult.getPages());
            this.buildReconciliation(date, pageResult.getRecords());
            page = page.next();
        } while (pageResult.hasNext() && page.getPageNumber() < ReconciliationConstant.LOOP_TIMES_MAX);
        return idList;
    }

    public Page<ReconciliationDocListVo> findPageForOut(Pageable pageable, ReconciliationDocListDto dto) {
        return this.reconciliationDocListRepository.findPageForOut(pageable, dto);
    }

    private List<String> buildReconciliationForOut(Date date, List<TpmAccountReconciliationRuleRespVo> ruleRespVos) {
        ArrayList idList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ruleRespVos)) {
            return Lists.newArrayList();
        }
        if (Objects.isNull(date)) {
            date = new Date();
        }
        Map<String, List<TpmAccountReconciliationRuleRespVo>> reconciliationRuleMap = ruleRespVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getAccountReconciliationRuleCode())).collect(Collectors.groupingBy(TpmAccountReconciliationRuleRespVo::getAccountReconciliationRuleCode));
        Date finalDate = date;
        List ruleDateConfigRespVos = ruleRespVos.stream().map(TpmAccountReconciliationRuleRespVo::getDateConfigList).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toList(), a -> a.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getCalculateDate()) && DateUtil.isSameDay((Date)finalDate, (Date)DateUtil.parseDateTime((CharSequence)x.getCalculateDate()))).collect(Collectors.toList())));
        if (!CollectionUtils.isEmpty((Collection)ruleDateConfigRespVos)) {
            ruleDateConfigRespVos.forEach(dataConfig -> {
                List rules = (List)reconciliationRuleMap.get(dataConfig.getAccountReconciliationRuleCode());
                if (!CollectionUtils.isEmpty((Collection)rules)) {
                    rules.forEach(rule -> {
                        ReconciliationDocListTaskDto taskDto = ReconciliationDocListTaskDto.builder().accountReconciliationType(rule.getAccountReconciliationType()).accountReconciliationRuleCode(rule.getAccountReconciliationRuleCode()).calculationTime((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getCalculateDate())).businessFormatCode(rule.getBusinessFormatCode()).businessUnitCode(rule.getBusinessUnitCode()).endDate((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getEndDate())).startDate((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getStartDate())).build();
                        log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1aReconciliationDocListTaskDto\uff1a{}", (Object)JSONObject.toJSONString((Object)taskDto));
                        List<ReconciliationDocListVo> docListVos = this.reconciliationDocListTaskService.executeTask(taskDto);
                        idList.addAll(this.createBatch(docListVos));
                    });
                }
            });
        }
        return idList;
    }

    public List<String> handleManualGenerate(Date date) {
        ArrayList idList = Lists.newArrayList();
        if (Objects.isNull(date)) {
            date = new Date();
        }
        PageRequest page = PageRequest.of((int)1, (int)20);
        Page pageResult = null;
        do {
            pageResult = this.accountReconciliationRuleService.findCurrentEffectiveRule((Pageable)page);
            log.info("=====>    \u5bf9\u8d26\u89c4\u5219 page[{}/{}]    <=====", (Object)pageResult.getCurrent(), (Object)pageResult.getPages());
            idList.addAll(this.buildReconciliationForOut(date, pageResult.getRecords()));
            page = page.next();
        } while (pageResult.hasNext() && page.getPageNumber() < ReconciliationConstant.LOOP_TIMES_MAX);
        return idList;
    }

    private void buildReconciliation(Date date, List<TpmAccountReconciliationRuleRespVo> ruleRespVos) {
        if (CollectionUtils.isEmpty(ruleRespVos)) {
            return;
        }
        if (Objects.isNull(date)) {
            date = new Date();
        }
        Map<String, List<TpmAccountReconciliationRuleRespVo>> reconciliationRuleMap = ruleRespVos.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getAccountReconciliationRuleCode())).collect(Collectors.groupingBy(TpmAccountReconciliationRuleRespVo::getAccountReconciliationRuleCode));
        log.info("\u5206\u7ec4[{}]\u5b8c\u6210\u5f00\u59cb\u751f\u6210\u5bf9\u8d26\u5355", (Object)reconciliationRuleMap.size());
        Date finalDate = date;
        List ruleDateConfigRespVos = ruleRespVos.stream().map(TpmAccountReconciliationRuleRespVo::getDateConfigList).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toList(), a -> a.stream().filter(x -> StrUtil.isNotEmpty((CharSequence)x.getCalculateDate()) && DateUtil.isSameDay((Date)finalDate, (Date)DateUtil.parseDateTime((CharSequence)x.getCalculateDate()))).collect(Collectors.toList())));
        if (CollectionUtils.isEmpty((Collection)ruleDateConfigRespVos)) {
            log.error("\u5bf9\u8d26\u89c4\u5219\u65e0\u6709\u6548\u5bf9\u8d26\u5355\u53ef\u751f\u6210[{}]", (Object)DateUtil.format((Date)finalDate, (String)"yyyy-MM-dd HH:mm:ss"));
            return;
        }
        ruleDateConfigRespVos.forEach(dataConfig -> {
            List rules = (List)reconciliationRuleMap.get(dataConfig.getAccountReconciliationRuleCode());
            if (CollectionUtils.isEmpty((Collection)rules)) {
                log.error("\u5bf9\u8d26\u89c4\u5219[{}]\u65e0\u6709\u6548\u5bf9\u8d26\u5355", (Object)dataConfig.getAccountReconciliationRuleCode());
                return;
            }
            log.error("\u5bf9\u8d26\u89c4\u5219[{}]\u5f00\u59cb\u751f\u6210\u5bf9\u8d26\u5355", (Object)dataConfig.getAccountReconciliationRuleCode());
            rules.forEach(rule -> {
                ReconciliationDocListTaskDto taskDto = ReconciliationDocListTaskDto.builder().accountReconciliationType(rule.getAccountReconciliationType()).accountReconciliationRuleCode(rule.getAccountReconciliationRuleCode()).calculationTime((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getCalculateDate())).businessFormatCode(rule.getBusinessFormatCode()).businessUnitCode(rule.getBusinessUnitCode()).endDate((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getEndDate())).startDate((Date)DateUtil.parseDateTime((CharSequence)dataConfig.getStartDate())).build();
                log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1aReconciliationDocListTaskDto\uff1a{}", (Object)JSONObject.toJSONString((Object)taskDto));
                List<ReconciliationDocListVo> docListVos = this.reconciliationDocListTaskService.executeTask(taskDto);
                this.createBatch(docListVos);
            });
        });
    }

    public void autoBuildFailReconciliation(Date date) {
        PageRequest page = PageRequest.of((int)1, (int)20);
        ReconciliationJobLogDto dto = new ReconciliationJobLogDto();
        dto.setIsSuccess(Boolean.valueOf(false));
        dto.setRetryTimes(ReconciliationConstant.RETRY_TIMES_MAX);
        Page failJobPage = null;
        do {
            failJobPage = this.reconciliationJobLogVoService.findByConditions((Pageable)page, dto);
            log.info("=====>    \u5bf9\u8d26\u5931\u8d25\u65e5\u5fd7 page[{}/{}]    <=====", (Object)failJobPage.getCurrent(), (Object)failJobPage.getPages());
            this.buildFailReconciliation(failJobPage.getRecords());
            page = page.next();
        } while (failJobPage.hasNext() && page.getPageNumber() < ReconciliationConstant.LOOP_TIMES_MAX);
    }

    private void buildFailReconciliation(List<ReconciliationJobLogVo> failJobInfos) {
        if (CollectionUtil.isEmpty(failJobInfos)) {
            return;
        }
        failJobInfos.forEach(failJobInfo -> {
            log.info("\u5bf9\u8d26\u5931\u8d25 \u4fe1\u606f{}", failJobInfo);
            ReconciliationDocListTaskDto taskDto = ReconciliationDocListTaskDto.builder().accountReconciliationType(failJobInfo.getAccountReconciliationType()).accountReconciliationRuleCode(failJobInfo.getAccountReconciliationRuleCode()).calculationTime(failJobInfo.getCalculationTime()).businessFormatCode(failJobInfo.getBusinessFormatCode()).businessUnitCode(failJobInfo.getBusinessUnitCode()).endDate(failJobInfo.getEndDate()).startDate(failJobInfo.getStartDate()).build();
            List<ReconciliationDocListVo> docListVos = this.reconciliationDocListTaskService.executeTask(taskDto);
            this.createBatch(docListVos);
        });
    }
}

