/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListTaskDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationJobLogVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component
public class ReconciliationDocListTaskService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationDocListTaskService.class);
    @Autowired(required=false)
    private ReconciliationJobLogVoService reconciliationJobLogVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    protected List<AbstractReconciliationGenerateStrategy> reconciliationGenerateStrategies;

    public List<ReconciliationDocListVo> executeTask(ReconciliationDocListTaskDto reconciliationDocListTaskDto) {
        if (StrUtil.isEmpty((CharSequence)reconciliationDocListTaskDto.getAccountReconciliationRuleCode())) {
            return Lists.newArrayList();
        }
        String accountReconciliationRuleCode = reconciliationDocListTaskDto.getAccountReconciliationRuleCode();
        String lock = "audit:reconciliation:lock:" + accountReconciliationRuleCode;
        boolean locked = this.redisLockService.tryLock(lock, TimeUnit.HOURS, 2L, 3L);
        if (!locked) {
            log.error("=====>      \u5f53\u524d\u5bf9\u8d26\u89c4\u5219[{}]\u6709\u4efb\u52a1\u6267\u884c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c!      <=====", (Object)accountReconciliationRuleCode);
            return new ArrayList<ReconciliationDocListVo>();
        }
        try {
            List<ReconciliationDocListVo> list = this.runTask(reconciliationDocListTaskDto);
            return list;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.redisLockService.unlock(lock);
        }
    }

    private List<ReconciliationDocListVo> runTask(ReconciliationDocListTaskDto dto) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ReconciliationJobLogDto jobLogDto = ReconciliationJobLogDto.builder().businessUnitCode(dto.getBusinessUnitCode()).businessFormatCode(dto.getBusinessFormatCode()).accountReconciliationRuleCode(dto.getAccountReconciliationRuleCode()).accountReconciliationType(dto.getAccountReconciliationType()).startDate(dto.getStartDate()).endDate(dto.getEndDate()).calculationTime(Objects.isNull(dto.getCalculationTime()) ? null : dto.getCalculationTime()).build();
        ReconciliationJobLogVo jobLogVo = this.reconciliationJobLogVoService.findUniqueJobInfo(jobLogDto);
        if (jobLogVo == null) {
            jobLogVo = ReconciliationJobLogVo.builder().executionStartTime(new Date()).isSuccess(Boolean.valueOf(false)).retryTimes(Integer.valueOf(0)).businessUnitCode(dto.getBusinessUnitCode()).businessFormatCode(dto.getBusinessFormatCode()).accountReconciliationRuleCode(dto.getAccountReconciliationRuleCode()).accountReconciliationType(dto.getAccountReconciliationType()).startDate(dto.getStartDate()).endDate(dto.getEndDate()).calculationTime(Objects.isNull(dto.getCalculationTime()) ? null : dto.getCalculationTime()).build();
            this.reconciliationJobLogVoService.create(jobLogVo);
        } else if (Objects.isNull(jobLogVo.getIsSuccess()) || !jobLogVo.getIsSuccess().booleanValue()) {
            jobLogVo.setRetryTimes(Integer.valueOf(jobLogVo.getRetryTimes() + 1));
            this.reconciliationJobLogVoService.update(jobLogVo);
        } else {
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1a\u5df2\u751f\u6210\u8fc7\u5bf9\u8d26\u5355\uff0c\u8df3\u8fc7\u672c\u6b21\u751f\u6210");
            return Lists.newArrayList();
        }
        try {
            boolean smallBusinessUnit = BusinessUnitEnum.isLittleBusinessUnit((String)dto.getBusinessUnitCode());
            AbstractReconciliationGenerateStrategy strategy = smallBusinessUnit ? this.getGenerateStrategy(dto.getAccountReconciliationType(), BusinessUnitEnum.HEADQUARTERS.getCode()) : this.getGenerateStrategy(dto.getAccountReconciliationType(), dto.getBusinessUnitCode());
            Assert.notNull((Object)strategy, (String)("\u4e0d\u5b58\u5728\u7684\u4e1a\u52a1\u7c7b\u578b[" + dto.getAccountReconciliationType() + "|" + dto.getBusinessUnitCode() + "],\u8bf7\u68c0\u67e5\u4ee3\u7801\u4e1a\u52a1\u7f16\u7801\u662f\u5426\u6709\u5bf9\u5e94\u5b9e\u73b0\u7b56\u7565"));
            ReconciliationGenerateDto generateDto = new ReconciliationGenerateDto();
            generateDto.setBusinessFormatCode(dto.getBusinessFormatCode());
            generateDto.setBusinessUnitCode(dto.getBusinessUnitCode());
            generateDto.setStartDate(DateUtil.formatDateTime((Date)dto.getStartDate()));
            generateDto.setEndDate(DateUtil.formatDateTime((Date)dto.getEndDate()));
            generateDto.setStartDateTime(dto.getStartDate());
            generateDto.setEndDateTime(dto.getEndDate());
            generateDto.setAccountReconciliationRuleCode(dto.getAccountReconciliationRuleCode());
            generateDto.setAccountReconciliationType(dto.getAccountReconciliationType());
            generateDto.setCustomerCode(dto.getCustomerCode());
            generateDto.setSmallBusinessUnit(smallBusinessUnit);
            jobLogVo.setIsSuccess(Boolean.valueOf(true));
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1aReconciliationGenerateDto\uff1a{}", (Object)JSONObject.toJSONString((Object)generateDto));
            List resultList = strategy.generateDate(generateDto);
            if (smallBusinessUnit) {
                resultList.forEach(r -> r.setBusinessUnitCode(dto.getBusinessUnitCode()));
            }
            List list = resultList;
            return list;
        }
        catch (Exception e) {
            jobLogVo.setIsSuccess(Boolean.valueOf(false));
            jobLogVo.setErrorMsg(StrUtil.isEmpty((CharSequence)e.getMessage()) ? "\u7a7a\u6307\u9488\u5f02\u5e38" : e.getMessage());
            log.error("\u5bf9\u8d26\u5355\u751f\u6210\u6267\u884c\u5931\u8d25,{}", (Object)e.getMessage());
            log.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            stopWatch.stop();
            jobLogVo.setExecutionMillisecond(Integer.valueOf((int)stopWatch.getTotalTimeMillis()));
            jobLogVo.setExecutionEndTime(new Date());
            this.reconciliationJobLogVoService.update(jobLogVo);
        }
    }

    public AbstractReconciliationGenerateStrategy getGenerateStrategy(String reconciliationType, String businessUnitCode) {
        List generateStrategies = this.reconciliationGenerateStrategies.stream().filter(x -> x.getReconciliationType().equals(reconciliationType)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(generateStrategies)) {
            return null;
        }
        AbstractReconciliationGenerateStrategy strategy = null;
        if (generateStrategies.size() > 1) {
            ReconciliationBuesinssTypeEnum businessTypeEnum = ReconciliationBuesinssTypeEnum.findByBusinessUnitCode((String)businessUnitCode);
            if (businessTypeEnum != null) {
                Optional<AbstractReconciliationGenerateStrategy> reconciliationGenerateStrategy = generateStrategies.stream().filter(x -> businessTypeEnum.getCode().equals(x.getBusinessType())).findFirst();
                if (reconciliationGenerateStrategy.isPresent()) {
                    strategy = reconciliationGenerateStrategy.get();
                }
            } else {
                log.error("=====>   \u5bf9\u8d26\u5355\u7b56\u7565\u5339\u914d\u65f6,\u4e1a\u52a1\u5355\u5143\u7f16\u7801[{}]\u4e0d\u5b58\u5728<   =====", (Object)businessUnitCode);
            }
        } else {
            strategy = (AbstractReconciliationGenerateStrategy)generateStrategies.get(0);
        }
        return strategy;
    }
}

