/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationJobLogEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationJobLogRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogLogEventDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.ReconciliationJobLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationJobLogLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationJobLogVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reconciliationJobLogService")
public class ReconciliationJobLogVoServiceImpl
implements ReconciliationJobLogVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationJobLogVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationJobLogRepository reconciliationJobLogRepository;
    @Autowired(required=false)
    private List<ReconciliationJobLogEventListener> eventListeners;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<ReconciliationJobLogVo> findByConditions(Pageable pageable, ReconciliationJobLogDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ReconciliationJobLogDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.reconciliationJobLogRepository.findByConditions((Page<ReconciliationJobLogVo>)page, dto);
    }

    public ReconciliationJobLogVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ReconciliationJobLogEntity reconciliationJobLog = this.reconciliationJobLogRepository.findById(id);
        if (reconciliationJobLog == null) {
            return null;
        }
        return (ReconciliationJobLogVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationJobLog, ReconciliationJobLogVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public ReconciliationJobLogVo create(ReconciliationJobLogVo reconciliationJobLogVo) {
        this.createValidation(reconciliationJobLogVo);
        reconciliationJobLogVo.setTenantCode(TenantUtils.getTenantCode());
        reconciliationJobLogVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationJobLogVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ReconciliationJobLogEntity reconciliationJobLog = (ReconciliationJobLogEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationJobLogVo, ReconciliationJobLogEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationJobLogRepository.saveOrUpdate((Object)reconciliationJobLog);
        reconciliationJobLogVo.setId(reconciliationJobLog.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationJobLogEventListener reconciliationJobLogEventListener : this.eventListeners) {
                reconciliationJobLogEventListener.onCreate(reconciliationJobLogVo);
            }
        }
        ReconciliationJobLogLogEventDto logEventDto = new ReconciliationJobLogLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(reconciliationJobLogVo);
        SerializableBiConsumer & Serializable onCreate = ReconciliationJobLogLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationJobLogLogEventListener.class, (SerializableBiConsumer)onCreate);
        return reconciliationJobLogVo;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public ReconciliationJobLogVo update(ReconciliationJobLogVo reconciliationJobLogVo) {
        this.updateValidation(reconciliationJobLogVo);
        String currentId = reconciliationJobLogVo.getId();
        ReconciliationJobLogEntity current = this.reconciliationJobLogRepository.findById(currentId);
        current = (ReconciliationJobLogEntity)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        ReconciliationJobLogVo oldVo = (ReconciliationJobLogVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, ReconciliationJobLogVo.class, HashSet.class, ArrayList.class, new String[0]);
        current.setExecutionEndTime(reconciliationJobLogVo.getExecutionEndTime());
        current.setExecutionMillisecond(reconciliationJobLogVo.getExecutionMillisecond());
        current.setIsSuccess(reconciliationJobLogVo.getIsSuccess());
        current.setAccountReconciliationRuleCode(reconciliationJobLogVo.getAccountReconciliationRuleCode());
        this.reconciliationJobLogRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (ReconciliationJobLogEventListener reconciliationJobLogEventListener : this.eventListeners) {
                reconciliationJobLogEventListener.onUpdate(oldVo, reconciliationJobLogVo);
            }
        }
        ReconciliationJobLogLogEventDto logEventDto = new ReconciliationJobLogLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(reconciliationJobLogVo);
        SerializableBiConsumer & Serializable onUpdate = ReconciliationJobLogLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ReconciliationJobLogLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return reconciliationJobLogVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationJobLogRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationJobLogRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.reconciliationJobLogRepository.updateDelFlagByIds(ids);
    }

    public ReconciliationJobLogVo findUniqueJobInfo(ReconciliationJobLogDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartDate(), (String)"\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndDate(), (String)"\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAccountReconciliationRuleCode(), (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReconciliationJobLogEntity logEntity = this.reconciliationJobLogRepository.findUniqueJobInfo(dto);
        if (Objects.isNull((Object)logEntity)) {
            return null;
        }
        return (ReconciliationJobLogVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)logEntity, ReconciliationJobLogVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(ReconciliationJobLogVo reconciliationJobLogVo) {
        this.validation(reconciliationJobLogVo);
    }

    private void updateValidation(ReconciliationJobLogVo reconciliationJobLogVo) {
        this.validation(reconciliationJobLogVo);
    }

    private void validation(ReconciliationJobLogVo reconciliationJobLogVo) {
    }
}

