/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.constant.ModalTypeEnum;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.service.TpmAccountReconciliationFactorService;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorColumnConfigVo;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRFactorRespVo;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal.BaseElectronicSignature;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl.AuditSubForAbstractReconciliation;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailHeadApproveDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailHeadAuditDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailSubApproveDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailSubAuditDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDetailSubCommunicateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationFileTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationPdfService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.CustomXMLWorkerFontProvider;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.utils.PdfUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.DistributionReconciliationAuditVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReplySubReconciliationHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd121Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationPdfServiceImpl
implements ReconciliationPdfService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationPdfServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BaseElectronicSignature baseElectronicSignature;
    @Autowired(required=false)
    private TpmAccountReconciliationFactorService accountReconciliationFactorService;
    @Autowired(required=false)
    private TpmAccountReconciliationRuleService accountReconciliationRuleService;
    @Autowired(required=false)
    private Zmsd121Service zmsd121Service;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePdf(ReconciliationDocListVo reconciliationDocListVo, List dataList, AbstractReconciliationGenerateStrategy generateStrategy, ReconciliationSummaryDataDisplayDto displayDto) {
        Validate.notNull((Object)reconciliationDocListVo, (String)"\u5bf9\u8d26\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationDocListVo.getAccountReconciliationRuleCode(), (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (Object[])new Object[0]);
        TpmAccountReconciliationRuleRespVo reconciliationRuleRespVo = this.accountReconciliationRuleService.findByCode(reconciliationDocListVo.getAccountReconciliationRuleCode());
        List respVoFactorList = reconciliationRuleRespVo.getFactorList();
        if (CollectionUtils.isEmpty((Collection)respVoFactorList)) {
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1a\u5bf9\u8d26\u8981\u7d20\u5217\u8868\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u672c\u6b21pdf\u751f\u6210");
            return;
        }
        Set factorCodes = respVoFactorList.stream().sorted(Comparator.comparing(TpmAccountReconciliationRuleRFactorRespVo::getOrderNum)).map(TpmAccountReconciliationRuleRFactorRespVo::getAccountReconciliationFactorCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Optional<List> factorServiceByCodes = Optional.ofNullable(this.accountReconciliationFactorService.findByCodes(factorCodes));
        Optional<Object> head = Optional.empty();
        Optional<Object> summary = Optional.empty();
        Optional<Object> sign = Optional.empty();
        Optional<Object> detail = Optional.empty();
        Optional<Object> tail = Optional.empty();
        if (factorServiceByCodes.isPresent()) {
            head = factorServiceByCodes.get().stream().filter(x -> ModalTypeEnum.HEAD.getCode().equals(x.getComponentName())).findFirst();
            summary = factorServiceByCodes.get().stream().filter(x -> ModalTypeEnum.SUMMARY.getCode().equals(x.getComponentName())).findFirst();
            sign = factorServiceByCodes.get().stream().filter(x -> ModalTypeEnum.SIGN.getCode().equals(x.getComponentName())).findFirst();
            detail = factorServiceByCodes.get().stream().filter(x -> ModalTypeEnum.DETAIL.getCode().equals(x.getComponentName())).findFirst();
            tail = factorServiceByCodes.get().stream().filter(x -> ModalTypeEnum.TAIL.getCode().equals(x.getComponentName())).findFirst();
        }
        log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u521b\u5efa\u5f00\u59cb");
        File dir = new File(this.baseElectronicSignature.fileRoot);
        if (!dir.exists()) {
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u65b0\u5efa\u76ee\u5f55");
            dir.mkdirs();
        }
        File file = new File(this.baseElectronicSignature.fileRoot + "/" + reconciliationDocListVo.getStatementCode() + ".pdf");
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            PdfPTable pdfPTable;
            List<String> fieldsCodes;
            List<String> fieldsNames;
            List configList;
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            Font font = PdfUtil.createFont((int)23, (int)0, (BaseColor)BaseColor.BLACK);
            Font colFont = PdfUtil.createFont((int)7, (int)0, (BaseColor)BaseColor.BLACK);
            Paragraph paragraph = PdfUtil.createParagraph((String)(ReconciliationTypeEnum.getDesc((String)reconciliationDocListVo.getAccountReconciliationType()) + "\u5355"), (Font)font);
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
            font = PdfUtil.createFont((int)13, (int)0, (BaseColor)BaseColor.BLACK);
            Font fontBold = PdfUtil.createFont((int)13, (int)1, (BaseColor)BaseColor.BLACK);
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u5934\u90e8\u4fe1\u606f");
            if (head.isPresent() && StrUtil.isNotEmpty((CharSequence)((TpmAccountReconciliationFactorRespVo)head.get()).getFactorConfig())) {
                inputStream = new ByteArrayInputStream(((TpmAccountReconciliationFactorRespVo)head.get()).getFactorConfig().getBytes(StandardCharsets.UTF_8));
                XMLWorkerHelper.getInstance().parseXHtml(pdfWriter, document, inputStream, Charset.forName(StandardCharsets.UTF_8.name()), (FontProvider)new CustomXMLWorkerFontProvider());
                document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
            }
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u6c47\u603b\u4fe1\u606f");
            if (summary.isPresent() && !CollectionUtils.isEmpty((Collection)(configList = ((TpmAccountReconciliationFactorRespVo)summary.get()).getFactorConfigList()))) {
                fieldsNames = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName).filter(Objects::nonNull).collect(Collectors.toList());
                fieldsCodes = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode).filter(Objects::nonNull).collect(Collectors.toList());
                pdfPTable = PdfUtil.createPdfPTable(fieldsNames, (String)generateStrategy.getBusinessType());
                pdfPTable.setExtendLastRow(Boolean.TRUE.booleanValue(), Boolean.FALSE.booleanValue());
                fieldsNames.forEach(x -> {
                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)x, (int)1, (int)1, (Font)colFont);
                    pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                    pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                    pdfPTable.addCell(pdfPCell);
                });
                if (!CollectionUtils.isEmpty((Collection)dataList) && !CollectionUtils.isEmpty(fieldsCodes)) {
                    LinkedHashMap<String, Object> linkedHashMap;
                    if (ReconciliationTypeEnum.COMMUNICATION.getCode().equals(generateStrategy.getReconciliationType())) {
                        log.info("\u5206\u5b50\u5f80\u6765\u5bf9\u8d26");
                        linkedHashMap = this.buildSapForReconciliation(dataList);
                        linkedHashMap.forEach((k, v) -> v.setAmount(this.formatBigDecimal(v.getAmount())));
                        this.buildReconciliationSummaryDataDisplayCommunication(linkedHashMap, displayDto, dataList);
                        for (Map.Entry<String, SapForReconciliationPdfHeadVo> entry : linkedHashMap.entrySet()) {
                            ArrayList<SapForReconciliationPdfHeadVo> arrayList = new ArrayList<SapForReconciliationPdfHeadVo>();
                            arrayList.add(entry.getValue());
                            fieldsCodes.forEach(code -> {
                                String convert = generateStrategy.convertHead(code, pdfHeadVos);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                                pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                                pdfPTable.addCell(pdfPCell);
                            });
                        }
                    } else if (ReconciliationTypeEnum.CLOSURE.getCode().equals(generateStrategy.getReconciliationType()) && ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode().equals(generateStrategy.getBusinessType())) {
                        String startDate = DateUtil.format((Date)reconciliationDocListVo.getStartDate(), (String)"yyyyMMdd");
                        String endDate = DateUtil.format((Date)reconciliationDocListVo.getEndDate(), (String)"yyyyMMdd");
                        String ds = AuditSubForAbstractReconciliation.get121Ds(reconciliationDocListVo.getStartDate());
                        String string = reconciliationDocListVo.getCustomerCode() + "-" + reconciliationDocListVo.getSalesInstitutionErpCode();
                        List zmsd121VoList = this.zmsd121Service.findListByDate(startDate, endDate, string, ds);
                        if (CollectionUtils.isEmpty((Collection)zmsd121VoList)) {
                            return;
                        }
                        TpmZmsd121Vo zmsd121Vo = (TpmZmsd121Vo)zmsd121VoList.get(0);
                        LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap2 = this.buildAuditSubForReconciliation(zmsd121Vo, dataList);
                        linkedHashMap2.forEach((k, v) -> v.setAmount(this.formatBigDecimal(v.getAmount())));
                        this.buildReconciliationSummaryDataDisplaySubClosure(linkedHashMap2, displayDto, dataList);
                        for (Map.Entry<String, SapForReconciliationPdfHeadVo> entry : linkedHashMap2.entrySet()) {
                            ArrayList<SapForReconciliationPdfHeadVo> pdfHeadVos = new ArrayList<SapForReconciliationPdfHeadVo>();
                            pdfHeadVos.add(entry.getValue());
                            fieldsCodes.forEach(code -> {
                                String convert = generateStrategy.convertHead(code, pdfHeadVos);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                                pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                                pdfPTable.addCell(pdfPCell);
                            });
                        }
                    } else if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.APPROVAL.getCode()) && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode())) {
                        linkedHashMap = this.buildReplySubForReconciliation(dataList);
                        linkedHashMap.forEach((k, v) -> v.setAmount(this.formatBigDecimal(v.getAmount())));
                        this.buildReconciliationSummaryDataDisplaySubApproval(linkedHashMap, displayDto, dataList);
                        ArrayList headVoList = new ArrayList();
                        for (Map.Entry entry : linkedHashMap.entrySet()) {
                            headVoList.add(entry.getValue());
                            fieldsCodes.forEach(code -> {
                                String convert = generateStrategy.convertHead(code, headVoList);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                                pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                                pdfPTable.addCell(pdfPCell);
                            });
                            headVoList.clear();
                        }
                    } else if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.DISTRIBUTION.getCode()) && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.AUDIT.getCode())) {
                        log.info("\u5206\u9500\u5bf9\u8d26");
                        linkedHashMap = this.buildDistributionReconciliation(dataList);
                        displayDto.setDistributionReconciliationHeadMap(linkedHashMap);
                        fieldsCodes.forEach(code -> {
                            String convert = (String)linkedHashMap.get(code);
                            PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                            pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                            pdfPTable.addCell(pdfPCell);
                        });
                    } else {
                        if (StringUtils.equals((CharSequence)ReconciliationTypeEnum.CLOSURE.getCode(), (CharSequence)generateStrategy.getReconciliationType()) && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.DETAIL.getCode())) {
                            this.buildReconciliationSummaryDataDisplayAuditClosure(displayDto, dataList);
                        }
                        if (StringUtils.equals((CharSequence)ReconciliationTypeEnum.APPROVAL.getCode(), (CharSequence)generateStrategy.getReconciliationType()) && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.DETAIL.getCode())) {
                            this.buildReconciliationSummaryDataDisplayApprove(displayDto, dataList);
                        }
                        fieldsCodes.forEach(code -> {
                            String convert = generateStrategy.convertHead(code, dataList);
                            PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                            pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                            pdfPTable.addCell(pdfPCell);
                        });
                    }
                }
                document.add((Element)pdfPTable);
                document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
            }
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u7b7e\u7f72\u680f");
            if (sign.isPresent()) {
                PdfPCell cell1;
                PdfPCell cell;
                int[] width3;
                PdfPTable table3;
                if (ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode().equals(generateStrategy.getBusinessType())) {
                    if (StrUtil.isNotEmpty((CharSequence)((TpmAccountReconciliationFactorRespVo)sign.get()).getFactorConfig())) {
                        inputStream = new ByteArrayInputStream(((TpmAccountReconciliationFactorRespVo)sign.get()).getFactorConfig().getBytes(StandardCharsets.UTF_8));
                        XMLWorkerHelper.getInstance().parseXHtml(pdfWriter, document, inputStream, Charset.forName(StandardCharsets.UTF_8.name()), (FontProvider)new CustomXMLWorkerFontProvider());
                        document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
                    }
                    document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
                    table3 = new PdfPTable(2);
                    width3 = new int[]{80, 55};
                    table3.setWidths(width3);
                    cell = new PdfPCell((Phrase)new Paragraph("\u5ba2\u6237\u7b7e\u5b57\u5e76\u76d6\u7ae0\uff1a", font));
                    cell1 = new PdfPCell((Phrase)new Paragraph("\u7b7e\u5b57\u76d6\u7ae0\u65f6\u95f4\uff1a", font));
                    cell.setBorder(0);
                    cell1.setBorder(0);
                    table3.addCell(cell);
                    table3.addCell(cell1);
                    document.add((Element)table3);
                } else {
                    table3 = new PdfPTable(2);
                    width3 = new int[]{80, 55};
                    table3.setWidths(width3);
                    cell = new PdfPCell((Phrase)new Paragraph("\u5ba2\u6237\u7b7e\u5b57\u5e76\u76d6\u7ae0\uff1a", fontBold));
                    cell1 = new PdfPCell((Phrase)new Paragraph("\u7b7e\u5b57\u76d6\u7ae0\u65f6\u95f4\uff1a", fontBold));
                    cell.setBorder(0);
                    cell1.setBorder(0);
                    table3.addCell(cell);
                    table3.addCell(cell1);
                    document.add((Element)table3);
                }
                document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
                document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
            }
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u660e\u7ec6\u4fe1\u606f");
            if (detail.isPresent() && !CollectionUtils.isEmpty((Collection)(configList = ((TpmAccountReconciliationFactorRespVo)detail.get()).getFactorConfigList()))) {
                fieldsNames = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName).filter(Objects::nonNull).collect(Collectors.toList());
                fieldsCodes = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode).filter(Objects::nonNull).collect(Collectors.toList());
                pdfPTable = PdfUtil.createPdfPTable(fieldsNames);
                PdfPCell cell = PdfUtil.createCenterPdfPCell((String)"\u5bf9\u8d26\u660e\u7ec6\uff1a", (int)1, (int)fieldsNames.size(), (Font)fontBold);
                cell.setBorder(0);
                cell.setHorizontalAlignment(0);
                pdfPTable.addCell(cell);
                pdfPTable.setExtendLastRow(Boolean.TRUE.booleanValue(), Boolean.FALSE.booleanValue());
                fieldsNames.forEach(x -> {
                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)x, (int)1, (int)1, (Font)colFont);
                    pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                    pdfPTable.addCell(pdfPCell);
                });
                if (!CollectionUtils.isEmpty((Collection)dataList) && !CollectionUtils.isEmpty(fieldsCodes)) {
                    log.info("\u5f00\u59cb\u6784\u5efa\u660e\u7ec6");
                    for (Map.Entry<String, SapForReconciliationPdfHeadVo> obj : dataList) {
                        if (ReconciliationTypeEnum.CLOSURE.getCode().equals(generateStrategy.getReconciliationType()) && ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode().equals(generateStrategy.getBusinessType())) {
                            AuditCustomerDetailCollectionVo auditCustomerDetailCollectionVo = (AuditCustomerDetailCollectionVo)obj;
                            if (StringUtils.equals((CharSequence)AuditFormEnum.EXPENSE.getCode(), (CharSequence)auditCustomerDetailCollectionVo.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.RED_INVOICE.getCode(), (CharSequence)auditCustomerDetailCollectionVo.getEndCaseForm()) ? !UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(auditCustomerDetailCollectionVo.getReimburseUpAccountStatus()) : !StringUtils.equals((CharSequence)AuditFormEnum.DISCOUNT.getCode(), (CharSequence)auditCustomerDetailCollectionVo.getEndCaseForm()) && !StringUtils.equals((CharSequence)AuditFormEnum.ORDER.getCode(), (CharSequence)auditCustomerDetailCollectionVo.getEndCaseForm()) || !UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(auditCustomerDetailCollectionVo.getUpAccountStatus())) continue;
                            fieldsCodes.forEach(code -> {
                                if (generateStrategy != null) {
                                    String convert = generateStrategy.convert(code, (Object)data);
                                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                                    pdfPTable.addCell(pdfPCell);
                                }
                            });
                            continue;
                        }
                        log.info("\u751f\u4ea7\u5bf9\u8d26\u53554");
                        fieldsCodes.forEach(code -> {
                            if (generateStrategy != null) {
                                String convert = generateStrategy.convert(code, obj);
                                PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                                pdfPTable.addCell(pdfPCell);
                            }
                        });
                    }
                }
                document.add((Element)pdfPTable);
            }
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u5c3e\u90e8\u4fe1\u606f");
            if (tail.isPresent() && !CollectionUtils.isEmpty((Collection)(configList = ((TpmAccountReconciliationFactorRespVo)tail.get()).getFactorConfigList()))) {
                fieldsNames = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsName).filter(Objects::nonNull).collect(Collectors.toList());
                fieldsCodes = configList.stream().map(TpmAccountReconciliationFactorColumnConfigVo::getFieldsCode).filter(Objects::nonNull).collect(Collectors.toList());
                pdfPTable = PdfUtil.createPdfPTable(fieldsNames, (String)generateStrategy.getBusinessType());
                pdfPTable.setExtendLastRow(Boolean.TRUE.booleanValue(), Boolean.FALSE.booleanValue());
                fieldsNames.forEach(x -> {
                    PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)x, (int)1, (int)1, (Font)colFont);
                    pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                    pdfPCell.setBackgroundColor(new BaseColor(165, 165, 165));
                    pdfPTable.addCell(pdfPCell);
                });
                if (!CollectionUtils.isEmpty((Collection)dataList) && !CollectionUtils.isEmpty(fieldsCodes)) {
                    log.info("\u5f00\u59cb\u6784\u5efa\u5c3e\u90e8");
                    if (generateStrategy.getReconciliationType().equals(ReconciliationTypeEnum.DISTRIBUTION.getCode()) && generateStrategy.getBusinessType().equals(ReconciliationBuesinssTypeEnum.AUDIT.getCode())) {
                        LinkedHashMap map = displayDto.getDistributionReconciliationHeadMap();
                        generateStrategy.convertTail(map);
                        fieldsCodes.forEach(code -> {
                            String convert = (String)map.get(code);
                            PdfPCell pdfPCell = PdfUtil.createCenterPdfPCell((String)convert, (int)1, (int)1, (Font)colFont);
                            pdfPCell.setNoWrap(Boolean.FALSE.booleanValue());
                            pdfPTable.addCell(pdfPCell);
                        });
                    }
                }
                document.add((Element)pdfPTable);
                document.add((Element)PdfUtil.createParagraph((String)"", (Font)font));
            }
            document.close();
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u5199\u5165\u7ed3\u675f");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u4e0a\u4f20");
        byte[] fileByte = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = this.fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null, reconciliationDocListVo.getStatementCode() + ".pdf", fileByte);
            Validate.notNull((Object)ordinaryFileVo, (String)"\u5bf9\u8d26\u5355\u6587\u4ef6\u751f\u6210\u5931\u8d25!!! \u7f16\u7801\uff1a[%s]", (Object[])new Object[]{reconciliationDocListVo.getStatementCode()});
            ReconciliationDocListFileVo reconciliationDocListFileVo = new ReconciliationDocListFileVo();
            reconciliationDocListFileVo.setFileType(ReconciliationFileTypeEnum.BO_ZHI.getCode());
            reconciliationDocListFileVo.setFileCode(ordinaryFileVo.getId());
            reconciliationDocListFileVo.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            reconciliationDocListFileVo.setStatementCode(reconciliationDocListVo.getStatementCode());
            reconciliationDocListVo.setFiles((List)Lists.newArrayList((Object[])new ReconciliationDocListFileVo[]{reconciliationDocListFileVo}));
        }
        catch (IOException e) {
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u4e0a\u4f20\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        boolean delete = file.delete();
        if (delete) {
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f,{}", (Object)file.getName());
        } else {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25,{}", (Object)file.getName());
        }
    }

    private LinkedHashMap<String, String> buildDistributionReconciliation(List<Object> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new LinkedHashMap<String, String>();
        }
        log.info("\u5206\u9500\u5bf9\u8d26\u5171\u3010" + dataList.size() + "\u3011\u6761");
        LinkedHashMap<String, String> headVoMap = new LinkedHashMap<String, String>();
        List<Object> planItemVos = dataList;
        Integer monthSaleQuantity = 0;
        BigDecimal monthSaleAmount = BigDecimal.ZERO;
        BigDecimal auditQuantity = BigDecimal.ZERO;
        Integer boundGiftSaleQuantity = 0;
        Integer baseQuantity = 0;
        BigDecimal combinationFee = BigDecimal.ZERO;
        BigDecimal distributionBaseTen = BigDecimal.ZERO;
        BigDecimal goalAchievement = BigDecimal.ZERO;
        BigDecimal month = BigDecimal.ZERO;
        BigDecimal staffFee = BigDecimal.ZERO;
        Integer logisticsQuantity = 0;
        BigDecimal logistics = BigDecimal.ZERO;
        BigDecimal quarter = BigDecimal.ZERO;
        BigDecimal otherCooperation = BigDecimal.ZERO;
        BigDecimal otherCooperationTwo = BigDecimal.ZERO;
        BigDecimal fine = BigDecimal.ZERO;
        BigDecimal lastMonthAccount = BigDecimal.ZERO;
        BigDecimal staffLogistics = BigDecimal.ZERO;
        BigDecimal monthAccount = BigDecimal.ZERO;
        for (DistributionReconciliationAuditVo distributionReconciliationAuditVo : planItemVos) {
            combinationFee = combinationFee.add(distributionReconciliationAuditVo.getCombinationFee());
            distributionBaseTen = distributionBaseTen.add(distributionReconciliationAuditVo.getDistributionBaseTen());
            goalAchievement = goalAchievement.add(distributionReconciliationAuditVo.getGoalAchievement());
            month = month.add(distributionReconciliationAuditVo.getMonth());
            staffFee = staffFee.add(distributionReconciliationAuditVo.getStaffFee());
            logistics = logistics.add(distributionReconciliationAuditVo.getLogistics());
            quarter = quarter.add(distributionReconciliationAuditVo.getQuarter());
            otherCooperation = otherCooperation.add(distributionReconciliationAuditVo.getOtherCooperation());
            otherCooperationTwo = otherCooperationTwo.add(distributionReconciliationAuditVo.getOtherCooperationTwo());
            fine = fine.add(distributionReconciliationAuditVo.getFine());
            monthSaleQuantity = monthSaleQuantity + distributionReconciliationAuditVo.getMonthSaleQuantity();
            monthSaleAmount = monthSaleAmount.add(distributionReconciliationAuditVo.getMonthSaleAmount());
            auditQuantity = auditQuantity.add(distributionReconciliationAuditVo.getAuditQuantity());
            boundGiftSaleQuantity = boundGiftSaleQuantity + distributionReconciliationAuditVo.getBoundGiftSaleQuantity();
            baseQuantity = baseQuantity + distributionReconciliationAuditVo.getBaseQuantity();
            lastMonthAccount = lastMonthAccount.add(distributionReconciliationAuditVo.getLastMonthAccount());
            staffLogistics = staffLogistics.add(distributionReconciliationAuditVo.getStaffLogistics());
            monthAccount = monthAccount.add(distributionReconciliationAuditVo.getMonthAccount());
            logisticsQuantity = logisticsQuantity + distributionReconciliationAuditVo.getLogisticsQuantity();
        }
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.year_month.getCode(), ((DistributionReconciliationAuditVo)planItemVos.get(0)).getYearMonth());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_code.getCode(), ((DistributionReconciliationAuditVo)planItemVos.get(0)).getSapCustomerCode());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_name.getCode(), ((DistributionReconciliationAuditVo)planItemVos.get(0)).getCustomerName());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_sale_quantity.getCode(), monthSaleQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_sale_amount.getCode(), monthSaleAmount.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.audit_quantity.getCode(), auditQuantity.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.bound_gift_sale_quantity.getCode(), boundGiftSaleQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.base_quantity.getCode(), baseQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.combination_fee.getCode(), combinationFee.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.distribution_base_ten.getCode(), distributionBaseTen.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.goal_achievement.getCode(), goalAchievement.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month.getCode(), month.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_fee.getCode(), staffFee.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.logistics_quantity.getCode(), logisticsQuantity.toString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.logistics.getCode(), logistics.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.quarter.getCode(), quarter.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.other_cooperation.getCode(), otherCooperation.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.other_cooperation_two.getCode(), otherCooperationTwo.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.fine.getCode(), fine.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.last_month_account.getCode(), lastMonthAccount.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_logistics.getCode(), staffLogistics.toPlainString());
        headVoMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_account.getCode(), monthAccount.toPlainString());
        return headVoMap;
    }

    private void buildReconciliationSummaryDataDisplayCommunication(LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        SapForReconciliationPdfHeadVo headVo6;
        SapForReconciliationPdfHeadVo headVo5;
        SapForReconciliationPdfHeadVo headVo4;
        SapForReconciliationPdfHeadVo headVo3;
        SapForReconciliationPdfHeadVo headVo2;
        SapForReconciliationPdfHeadVo headVo1;
        SapForReconciliationPdfHeadVo headVo;
        if (!CollectionUtils.isEmpty((Collection)dataList)) {
            List sapReconciliationVos = dataList;
            ArrayList communicateDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)sapReconciliationVos, SapReconciliationVo.class, ReconciliationSummaryDataDisplayDetailSubCommunicateDto.class, HashSet.class, ArrayList.class, new String[0]);
            communicateDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubCommunicateDtos((List)communicateDtos);
        }
        if (Objects.nonNull(headVo = linkedHashMap.get("\u671f\u521d\u4f59\u989d"))) {
            displayDto.setBeginPeriodBalance(Optional.ofNullable(headVo.getAmount()).orElse(BigDecimal.ZERO).negate());
        }
        if (Objects.nonNull(headVo1 = linkedHashMap.get("\u672c\u671f\u8d27\u6b3e\u91d1\u989d"))) {
            displayDto.setThisPeriodBackMoney(headVo1.getAmount());
        }
        if (Objects.nonNull(headVo2 = linkedHashMap.get("\u8d39\u7528\u62a5\u9500\u4e0a\u8d26"))) {
            displayDto.setExpenseReimburseUpAccount(headVo2.getAmount());
        }
        if (Objects.nonNull(headVo3 = linkedHashMap.get("\u672c\u671f\u8fdb\u8d27\u91d1\u989d"))) {
            displayDto.setThisPeriodStockInAmount(headVo3.getAmount());
        }
        if (Objects.nonNull(headVo4 = linkedHashMap.get("\u672c\u671f\u9500\u552e\u6298\u6263"))) {
            displayDto.setThisPeriodSalesDiscount(headVo4.getAmount());
        }
        if (Objects.nonNull(headVo5 = linkedHashMap.get("\u671f\u672b\u4f59\u989d"))) {
            displayDto.setEndPeriodBalance(Optional.ofNullable(headVo5.getAmount()).orElse(BigDecimal.ZERO).negate());
        }
        if (Objects.nonNull(headVo6 = linkedHashMap.get("\u4fdd\u8bc1\u91d1\u91d1\u989d"))) {
            displayDto.setEarnestMoney(headVo6.getAmount());
        }
    }

    private void buildReconciliationSummaryDataDisplaySubClosure(LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        SapForReconciliationPdfHeadVo headVo7;
        SapForReconciliationPdfHeadVo headVo6;
        SapForReconciliationPdfHeadVo headVo5;
        SapForReconciliationPdfHeadVo headVo4;
        SapForReconciliationPdfHeadVo headVo3;
        SapForReconciliationPdfHeadVo headVo2;
        SapForReconciliationPdfHeadVo headVo1;
        SapForReconciliationPdfHeadVo headVo;
        if (!CollectionUtils.isEmpty((Collection)dataList)) {
            List auditList = dataList;
            ArrayList detailSubAuditDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditList, AuditCustomerDetailCollectionVo.class, ReconciliationSummaryDataDisplayDetailSubAuditDto.class, HashSet.class, ArrayList.class, new String[0]);
            detailSubAuditDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubAuditDtos((List)detailSubAuditDtos);
        }
        if (Objects.nonNull(headVo = linkedHashMap.get("\u672c\u6708\u4e8b\u4e2d\u8d39\u7528\u91d1\u989d"))) {
            displayDto.setInProcessExpenseTotal(headVo.getAmount());
        }
        if (Objects.nonNull(headVo1 = linkedHashMap.get("\u5176\u4ed6\u6838\u5bf9\u9879"))) {
            displayDto.setOtherCheckItem(headVo1.getAmount());
        }
        if (Objects.nonNull(headVo2 = linkedHashMap.get("\u671f\u521d\u6298\u6263\u6c60\u4f59\u989d\u2460"))) {
            displayDto.setBeginPeriodDiscountPoolBalance(headVo2.getAmount());
        }
        if (Objects.nonNull(headVo3 = linkedHashMap.get("\u672c\u6708\u5e94\u5904\u7406\u8d39\u7528\u2461"))) {
            displayDto.setThisMonthShouldHandleAmount(headVo3.getAmount());
        }
        if (Objects.nonNull(headVo4 = linkedHashMap.get("\u672c\u6708\u5b9e\u9645\u6298\u6263\u91d1\u989d\u2462"))) {
            displayDto.setThisMonthActualDiscountAmount(headVo4.getAmount());
        }
        if (Objects.nonNull(headVo5 = linkedHashMap.get("\u672c\u6708\u53d1\u7968\u62a5\u9500\u91d1\u989d\u2463"))) {
            displayDto.setThisMonthInvoiceReimburseAmount(headVo5.getAmount());
        }
        if (Objects.nonNull(headVo6 = linkedHashMap.get("\u671f\u672b\u8d39\u7528\u6c60\u4f59\u989d\u2467=\u2460+\u2461-\u2462-\u2463+\u2464-\u2465+\u2466"))) {
            displayDto.setEndPeriodFeePoolBalance(headVo6.getAmount());
        }
        if (Objects.nonNull(headVo7 = linkedHashMap.get("\u8d39\u7528\u8f6c\u79fb\u2464"))) {
            displayDto.setCostTransfer(headVo7.getAmount());
        }
    }

    private void buildReconciliationSummaryDataDisplaySubApproval(LinkedHashMap<String, ReplySubReconciliationHeadVo> linkedHashMap, ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        ReplySubReconciliationHeadVo headVo2;
        ReplySubReconciliationHeadVo headVo1;
        ReplySubReconciliationHeadVo headVo;
        if (!CollectionUtils.isEmpty((Collection)dataList)) {
            List planItemVos = dataList;
            ArrayList detailSubApproveDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planItemVos, SubComActivityDetailPlanItemVo.class, ReconciliationSummaryDataDisplayDetailSubApproveDto.class, HashSet.class, ArrayList.class, new String[0]);
            detailSubApproveDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
            displayDto.setDetailSubApproveDtos((List)detailSubApproveDtos);
        }
        if (Objects.nonNull(headVo = linkedHashMap.get("\u6279\u590d\u5408\u8ba1\u91d1\u989d"))) {
            displayDto.setThisPeriodHandleAmount(headVo.getAmount());
        }
        if (Objects.nonNull(headVo1 = linkedHashMap.get("\u5176\u4ed6\u6838\u5bf9\u9879"))) {
            displayDto.setOtherCheckItem(headVo1.getAmount());
        }
        if (Objects.nonNull(headVo2 = linkedHashMap.get("\u671f\u521d\u6298\u6263\u6c60\u4f59\u989d\u2460"))) {
            displayDto.setBeginPeriodDiscountPoolBalance(headVo2.getAmount());
        }
    }

    private void buildReconciliationSummaryDataDisplayAuditClosure(ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        List customerDetailCollectionVos = dataList;
        ArrayList detailHeadAuditDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)customerDetailCollectionVos, AuditCustomerDetailCollectionVo.class, ReconciliationSummaryDataDisplayDetailHeadAuditDto.class, HashSet.class, ArrayList.class, new String[0]);
        detailHeadAuditDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
        displayDto.setDetailHeadAuditDtos((List)detailHeadAuditDtos);
        customerDetailCollectionVos = customerDetailCollectionVos.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) || !c.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode()) || !UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatus())).collect(Collectors.toList());
        BigDecimal promotionTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(AuditCustomerDetailCollectionVo::getReimburseTaxAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        customerDetailCollectionVos = customerDetailCollectionVos.stream().filter(b -> !StringUtils.isNotBlank((CharSequence)b.getEndCaseForm()) || !b.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).collect(Collectors.toList());
        BigDecimal discountTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(AuditCustomerDetailCollectionVo::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        customerDetailCollectionVos = customerDetailCollectionVos.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) || !c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())).collect(Collectors.toList());
        BigDecimal followCarAmount = customerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal examineCircularAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> {
            BigDecimal reimburseTaxAmount = Objects.isNull(x.getReimburseTaxAmount()) ? BigDecimal.ZERO : x.getReimburseTaxAmount();
            BigDecimal discountTaxAmount = Objects.isNull(x.getDiscountTaxAmount()) ? BigDecimal.ZERO : x.getDiscountTaxAmount();
            BigDecimal auditAmount = Objects.nonNull(x.getAuditAmount()) && "Z321".equals(x.getActivityFormCode()) ? x.getAuditAmount() : BigDecimal.ZERO;
            BigDecimal examineCircularAmount1 = Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount();
            return NumberUtil.add((Number)NumberUtil.add((Number)reimburseTaxAmount, (Number)discountTaxAmount), (Number)NumberUtil.add((Number)auditAmount, (Number)examineCircularAmount1));
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        displayDto.setPromotionTotalAmount(promotionTotalAmount);
        displayDto.setDiscountTotalAmount(discountTotalAmount);
        displayDto.setPromotionAndDiscountTotalAmount(promotionTotalAmount.add(discountTotalAmount));
        displayDto.setFollowCarAmount(followCarAmount);
        displayDto.setExamineCircularAmount(examineCircularAmount);
        displayDto.setTotalAmount(totalAmount);
    }

    private void buildReconciliationSummaryDataDisplayApprove(ReconciliationSummaryDataDisplayDto displayDto, List dataList) {
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        List itemVos = dataList;
        ArrayList detailHeadApproveDtos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemVos, ActivityDetailPlanItemVo.class, ReconciliationSummaryDataDisplayDetailHeadApproveDto.class, HashSet.class, ArrayList.class, new String[0]);
        detailHeadApproveDtos.forEach(o -> o.setStatementCode(displayDto.getStatementCode()));
        displayDto.setDetailHeadApproveDtos((List)detailHeadApproveDtos);
        BigDecimal thisMonthFeeTotalAmount = itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemBase::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisMonthFeeApplyAmount = itemVos.stream().filter(Objects::nonNull).map(x -> NumberUtil.add((Number)x.getDepartmentFeeAmount(), (Number)x.getHeadFeeAmount())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisMonthCustomerBearTotalAmount = itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemBase::getCustomerFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        displayDto.setThisMonthFeeTotalAmount(thisMonthFeeTotalAmount);
        displayDto.setThisMonthFeeApplyAmount(thisMonthFeeApplyAmount);
        displayDto.setThisMonthCustomerBearTotalAmount(thisMonthCustomerBearTotalAmount);
    }

    private LinkedHashMap<String, SapForReconciliationPdfHeadVo> buildSapForReconciliation(List<Object> dataList) {
        List<Object> sapReconciliationVos = dataList;
        LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = new LinkedHashMap<String, SapForReconciliationPdfHeadVo>();
        BigDecimal firstAmt = BigDecimal.ZERO;
        BigDecimal twoAmt = BigDecimal.ZERO;
        BigDecimal threeAmt = BigDecimal.ZERO;
        BigDecimal fourAmt = BigDecimal.ZERO;
        BigDecimal fiveAmt = BigDecimal.ZERO;
        BigDecimal sixAmt = BigDecimal.ZERO;
        for (SapReconciliationVo sapReconciliationVo : sapReconciliationVos) {
            if (!StringUtils.isBlank((CharSequence)sapReconciliationVo.getZfkfs())) {
                BigDecimal conZsh;
                if (sapReconciliationVo.getZfkfs().contains("\u94f6\u884c\u5b58\u6b3e") || sapReconciliationVo.getZfkfs().contains("\u94f6\u884c\u627f\u5151") || sapReconciliationVo.getZfkfs().contains("\u8f6c\u6b3e")) {
                    conZsh = this.amountCharTransfer(sapReconciliationVo.getZsh());
                    twoAmt = twoAmt.add(conZsh);
                }
                if (sapReconciliationVo.getZfkfs().contains("\u8d39\u7528\u62a5\u9500")) {
                    conZsh = this.amountCharTransfer(sapReconciliationVo.getZsh());
                    threeAmt = threeAmt.add(conZsh);
                }
            }
            if ("\u603b\u8ba1".equals(sapReconciliationVo.getZdocName())) {
                fourAmt = fourAmt.add(this.amountCharTransfer(sapReconciliationVo.getKzwi1()));
                fiveAmt = fiveAmt.add(this.amountCharTransfer(sapReconciliationVo.getKzwi6()));
            }
            if (StringUtils.isNotEmpty((CharSequence)sapReconciliationVo.getZdocName()) && sapReconciliationVo.getZdocName().equals("\u671f\u521d")) {
                firstAmt = this.amountCharTransfer(sapReconciliationVo.getZysye());
            }
            if (!StringUtils.isNotEmpty((CharSequence)sapReconciliationVo.getZdocName()) || !sapReconciliationVo.getZdocName().equals("\u603b\u8ba1")) continue;
            sixAmt = this.amountCharTransfer(sapReconciliationVo.getZysye());
        }
        SapForReconciliationPdfHeadVo one = new SapForReconciliationPdfHeadVo();
        one.setName("\u671f\u521d\u4f59\u989d");
        one.setIndex("1");
        one.setAmount(firstAmt);
        linkedHashMap.put("\u671f\u521d\u4f59\u989d", one);
        SapForReconciliationPdfHeadVo sapForReconciliationPdfHeadVo = new SapForReconciliationPdfHeadVo();
        sapForReconciliationPdfHeadVo.setName("\u672c\u671f\u8d27\u6b3e\u91d1\u989d");
        sapForReconciliationPdfHeadVo.setIndex("2");
        sapForReconciliationPdfHeadVo.setAmount(twoAmt);
        linkedHashMap.put("\u672c\u671f\u8d27\u6b3e\u91d1\u989d", sapForReconciliationPdfHeadVo);
        SapForReconciliationPdfHeadVo three = new SapForReconciliationPdfHeadVo();
        three.setName("\u8d39\u7528\u62a5\u9500\u4e0a\u8d26");
        three.setIndex("3");
        three.setAmount(threeAmt);
        linkedHashMap.put("\u8d39\u7528\u62a5\u9500\u4e0a\u8d26", three);
        SapForReconciliationPdfHeadVo four = new SapForReconciliationPdfHeadVo();
        four.setName("\u672c\u671f\u8fdb\u8d27\u91d1\u989d");
        four.setIndex("4");
        four.setAmount(fourAmt);
        linkedHashMap.put("\u672c\u671f\u8fdb\u8d27\u91d1\u989d", four);
        SapForReconciliationPdfHeadVo five = new SapForReconciliationPdfHeadVo();
        five.setName("\u672c\u671f\u9500\u552e\u6298\u6263");
        five.setIndex("5");
        five.setAmount(fiveAmt);
        linkedHashMap.put("\u672c\u671f\u9500\u552e\u6298\u6263", five);
        SapForReconciliationPdfHeadVo six = new SapForReconciliationPdfHeadVo();
        six.setName("\u671f\u672b\u4f59\u989d");
        six.setIndex("6");
        six.setAmount(sixAmt);
        linkedHashMap.put("\u671f\u672b\u4f59\u989d", six);
        BigDecimal sevenAmt = BigDecimal.ZERO;
        SapForReconciliationPdfHeadVo seven = new SapForReconciliationPdfHeadVo();
        seven.setName("\u4fdd\u8bc1\u91d1\u91d1\u989d");
        seven.setIndex("7");
        seven.setAmount(sevenAmt);
        linkedHashMap.put("\u4fdd\u8bc1\u91d1\u91d1\u989d", seven);
        return linkedHashMap;
    }

    private BigDecimal amountCharTransfer(String sapAmount) {
        if (StringUtils.isNotBlank((CharSequence)sapAmount)) {
            if ((sapAmount = sapAmount.trim()).contains("-")) {
                return new BigDecimal("-" + sapAmount.replace("-", ""));
            }
            return new BigDecimal(sapAmount);
        }
        return BigDecimal.ZERO;
    }

    private LinkedHashMap<String, SapForReconciliationPdfHeadVo> buildAuditSubForReconciliation(TpmZmsd121Vo zmsd121Vo, List<Object> dataList) {
        LinkedHashMap<String, SapForReconciliationPdfHeadVo> linkedHashMap = new LinkedHashMap<String, SapForReconciliationPdfHeadVo>();
        List<Object> auditList = dataList;
        Set detailCodes = auditList.stream().map(AuditCustomerDetailCollectionVo::getActivityDetailCode).collect(Collectors.toSet());
        List detailPlanItemCodes = this.subComActivityDetailPlanItemVoService.findDetailByPlanItemCodeList(detailCodes).stream().filter(o -> StringUtils.equals((CharSequence)"1", (CharSequence)o.getAuditType())).map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        SapForReconciliationPdfHeadVo one = new SapForReconciliationPdfHeadVo();
        BigDecimal oneAmt = zmsd121Vo.getOpenBalance();
        one.setName("\u671f\u521d\u6298\u6263\u6c60\u4f59\u989d\u2460");
        one.setAmount(oneAmt);
        linkedHashMap.put("\u671f\u521d\u6298\u6263\u6c60\u4f59\u989d\u2460", one);
        Map<String, List<AuditCustomerDetailCollectionVo>> auditMap = auditList.stream().collect(Collectors.groupingBy(v -> v.getAuditName() + "-" + v.getActivityFormCode()));
        int i = 0;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalReimburseAmount = BigDecimal.ZERO;
        for (List<AuditCustomerDetailCollectionVo> value : auditMap.values()) {
            ArrayList list = new ArrayList(value.size());
            value.stream().forEach(l -> {
                if (StringUtils.equals((CharSequence)AuditFormEnum.EXPENSE.getCode(), (CharSequence)l.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.RED_INVOICE.getCode(), (CharSequence)l.getEndCaseForm())) {
                    if (UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(l.getReimburseUpAccountStatus())) {
                        list.add(l);
                    }
                } else if ((StringUtils.equals((CharSequence)AuditFormEnum.DISCOUNT.getCode(), (CharSequence)l.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.ORDER.getCode(), (CharSequence)l.getEndCaseForm())) && UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(l.getUpAccountStatus())) {
                    list.add(l);
                }
            });
            if (CollectionUtils.isEmpty(list)) {
                log.info("\u751f\u6210\u5bf9\u8d26\u5355pdf,\u5206\u5b50\u7ed3\u6848\u5bf9\u8d26\uff0c\u6838\u9500\u6570\u636e\u8fc7\u6ee4\u4e0a\u8d26\u72b6\u6001\u540e\uff0c\u6570\u636e\u4e3a\u7a7a");
                continue;
            }
            BigDecimal amt = list.stream().map(e -> {
                if (StringUtils.equals((CharSequence)AuditFormEnum.EXPENSE.getCode(), (CharSequence)e.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.RED_INVOICE.getCode(), (CharSequence)e.getEndCaseForm())) {
                    return e.getReimburseTaxAmount();
                }
                if (StringUtils.equals((CharSequence)AuditFormEnum.DISCOUNT.getCode(), (CharSequence)e.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.ORDER.getCode(), (CharSequence)e.getEndCaseForm())) {
                    return e.getDiscountTaxAmount();
                }
                return e.getThisAuditAmount();
            }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            String key = ((AuditCustomerDetailCollectionVo)list.get(0)).getAuditName() + "-" + ((AuditCustomerDetailCollectionVo)list.get(0)).getActivityFormName() + "\u8d39\u7528\u2461" + "-" + ++i;
            SapForReconciliationPdfHeadVo headVo = new SapForReconciliationPdfHeadVo();
            headVo.setName(key);
            headVo.setAmount(amt);
            linkedHashMap.put(key, headVo);
            BigDecimal reimburseAmt = list.stream().map(AuditCustomerDetailCollectionVo::getReimburseAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalAmount = totalAmount.add(amt);
            totalReimburseAmount = totalReimburseAmount.add(reimburseAmt);
        }
        SapForReconciliationPdfHeadVo two = new SapForReconciliationPdfHeadVo();
        two.setName("\u672c\u6708\u5e94\u5904\u7406\u8d39\u7528\u2461");
        two.setAmount(totalAmount);
        linkedHashMap.put("\u672c\u6708\u5e94\u5904\u7406\u8d39\u7528\u2461", two);
        SapForReconciliationPdfHeadVo three = new SapForReconciliationPdfHeadVo();
        BigDecimal fourAmt = zmsd121Vo.getMakeAmount();
        three.setName("\u672c\u6708\u5b9e\u9645\u6298\u6263\u91d1\u989d\u2462");
        three.setAmount(fourAmt);
        linkedHashMap.put("\u672c\u6708\u5b9e\u9645\u6298\u6263\u91d1\u989d\u2462", three);
        SapForReconciliationPdfHeadVo four = new SapForReconciliationPdfHeadVo();
        four.setName("\u672c\u6708\u53d1\u7968\u62a5\u9500\u91d1\u989d\u2463");
        four.setAmount(totalReimburseAmount);
        linkedHashMap.put("\u672c\u6708\u53d1\u7968\u62a5\u9500\u91d1\u989d\u2463", four);
        SapForReconciliationPdfHeadVo five = new SapForReconciliationPdfHeadVo();
        five.setName("\u8d39\u7528\u8f6c\u79fb\u2464");
        five.setAmount(BigDecimal.ZERO);
        linkedHashMap.put("\u8d39\u7528\u8f6c\u79fb\u2464", five);
        SapForReconciliationPdfHeadVo six = new SapForReconciliationPdfHeadVo();
        six.setName("\u8003\u6838\u6263\u6b3e\u91d1\u989d\u2465");
        six.setAmount(zmsd121Vo.getDeductionAmount());
        linkedHashMap.put("\u8003\u6838\u6263\u6b3e\u91d1\u989d\u2465", six);
        SapForReconciliationPdfHeadVo seven = new SapForReconciliationPdfHeadVo();
        seven.setName("\u8003\u6838\u4e0a\u8d26\u91d1\u989d\u2466");
        seven.setAmount(BigDecimal.ZERO);
        linkedHashMap.put("\u8003\u6838\u4e0a\u8d26\u91d1\u989d\u2466", seven);
        SapForReconciliationPdfHeadVo eight = new SapForReconciliationPdfHeadVo();
        BigDecimal sevenAmt = oneAmt.add(totalAmount).subtract(fourAmt).subtract(totalReimburseAmount).add(five.getAmount()).subtract(zmsd121Vo.getDeductionAmount()).subtract(seven.getAmount());
        eight.setName("\u671f\u672b\u8d39\u7528\u6c60\u4f59\u989d\u2467=\u2460+\u2461-\u2462-\u2463+\u2464-\u2465+\u2466");
        eight.setAmount(sevenAmt);
        linkedHashMap.put("\u671f\u672b\u8d39\u7528\u6c60\u4f59\u989d\u2467=\u2460+\u2461-\u2462-\u2463+\u2464-\u2465+\u2466", eight);
        BigDecimal inProcessTotalAmount = auditList.stream().filter(o -> detailPlanItemCodes.contains(o.getActivityDetailCode())).map(o -> o.getThisAuditAmount()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        SapForReconciliationPdfHeadVo nine = new SapForReconciliationPdfHeadVo();
        nine.setName("\u672c\u6708\u4e8b\u4e2d\u8d39\u7528\u91d1\u989d");
        nine.setAmount(inProcessTotalAmount);
        linkedHashMap.put("\u672c\u6708\u4e8b\u4e2d\u8d39\u7528\u91d1\u989d", nine);
        SapForReconciliationPdfHeadVo ten = new SapForReconciliationPdfHeadVo();
        ten.setName("\u5176\u4ed6\u6838\u5bf9\u9879");
        ten.setAmount(BigDecimal.ZERO);
        linkedHashMap.put("\u5176\u4ed6\u6838\u5bf9\u9879", ten);
        return linkedHashMap;
    }

    private LinkedHashMap<String, ReplySubReconciliationHeadVo> buildReplySubForReconciliation(List<Object> dataList) {
        LinkedHashMap<String, ReplySubReconciliationHeadVo> headVoMap = new LinkedHashMap<String, ReplySubReconciliationHeadVo>();
        List<Object> planItemVos = dataList;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal inProcessTotalAmount = BigDecimal.ZERO;
        for (SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo : planItemVos) {
            BigDecimal totalCost = Objects.isNull(subComActivityDetailPlanItemVo.getTotalCost()) ? BigDecimal.ZERO : subComActivityDetailPlanItemVo.getTotalCost();
            ReplySubReconciliationHeadVo headVo = new ReplySubReconciliationHeadVo();
            headVo.setProjectName(subComActivityDetailPlanItemVo.getConstituentDetailPlanName());
            headVo.setAmount(totalCost);
            headVoMap.put(subComActivityDetailPlanItemVo.getConstituentDetailPlanItemCode(), headVo);
            totalAmount = totalAmount.add(totalCost);
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)subComActivityDetailPlanItemVo.getAuditType())) continue;
            inProcessTotalAmount = inProcessTotalAmount.add(totalCost);
        }
        ReplySubReconciliationHeadVo headVo1 = new ReplySubReconciliationHeadVo();
        headVo1.setAmount(inProcessTotalAmount);
        headVo1.setProjectName("\u672c\u6708\u4e8b\u4e2d\u8d39\u7528\u91d1\u989d");
        headVoMap.put("\u672c\u6708\u4e8b\u4e2d\u8d39\u7528\u91d1\u989d", headVo1);
        ReplySubReconciliationHeadVo replySubReconciliationHeadVo = new ReplySubReconciliationHeadVo();
        replySubReconciliationHeadVo.setAmount(totalAmount);
        replySubReconciliationHeadVo.setProjectName("\u6279\u590d\u5408\u8ba1\u91d1\u989d");
        headVoMap.put("\u6279\u590d\u5408\u8ba1\u91d1\u989d", replySubReconciliationHeadVo);
        return headVoMap;
    }

    public BigDecimal formatBigDecimal(BigDecimal amount) {
        if (Objects.isNull(amount)) {
            return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        }
        return amount.setScale(2, RoundingMode.HALF_UP);
    }
}

