/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.ReconciliationSapDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.SapReconciliationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.SapReconciliationRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.PullSapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.SapReconciliationService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SapReconciliationServiceImpl
implements SapReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(SapReconciliationServiceImpl.class);
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SapReconciliationRepository sapReconciliationRepository;

    public Result querySapReconciliation(PullSapReconciliationDto dto) {
        Validate.notBlank((CharSequence)dto.getYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)com.biz.crm.mn.common.base.util.DateUtil.isDate((String)dto.getYearMonth(), (String)"yyyyMM"), (String)"\u65f6\u95f4\u5e74\u6708\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cyyyyMM", (Object[])new Object[0]);
        ReconciliationSapDto queryDto = new ReconciliationSapDto();
        MessageHeaderDto header = new MessageHeaderDto();
        header.setMessageId(UuidCrmUtil.general());
        header.setInterfacePath("SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT");
        header.setSender("TPM");
        header.setSendTime(String.valueOf(System.currentTimeMillis()));
        header.setReceiver("ECC");
        queryDto.setMessageHeader(header);
        Date yearMonth = com.biz.crm.mn.common.base.util.DateUtil.parseDate((String)dto.getYearMonth(), (String)"yyyyMM");
        Calendar yearMonthCalendar = Calendar.getInstance();
        yearMonthCalendar.setTime(yearMonth);
        String year = String.valueOf(yearMonthCalendar.get(1));
        String month = String.valueOf(yearMonthCalendar.get(2) + 1);
        Result result = new Result();
        if (StringUtils.isEmpty((CharSequence)dto.getVtweg()) || StringUtils.isEmpty((CharSequence)dto.getVkorg()) || StringUtils.isEmpty((CharSequence)dto.getPrctr())) {
            Map typeCodeList = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"sync_123_sales_org_code", "sync_123_channel_code", "sync_123_profit_center"}));
            List salesDictDataVos = (List)typeCodeList.get("sync_123_sales_org_code");
            List channelDictDataVos = (List)typeCodeList.get("sync_123_channel_code");
            List profitDictDataVos = (List)typeCodeList.get("sync_123_profit_center");
            for (DictDataVo sales : salesDictDataVos) {
                for (DictDataVo channel : channelDictDataVos) {
                    for (DictDataVo profitDictDataVo : profitDictDataVos) {
                        ArrayList<ReconciliationSapDto.ReconciliationItemDto> itemList = new ArrayList<ReconciliationSapDto.ReconciliationItemDto>();
                        ReconciliationSapDto.ReconciliationItemDto itemDto = new ReconciliationSapDto.ReconciliationItemDto();
                        itemDto.setGJAHR(year);
                        itemDto.setMONAT(month);
                        itemDto.setVKORG(sales.getDictCode());
                        itemDto.setVTWEG(channel.getDictCode());
                        itemDto.setPRCTR(profitDictDataVo.getDictCode());
                        itemList.add(itemDto);
                        queryDto.setITEM1(itemList);
                        Result result2 = this.sapSdApiService.pushReconciliationToSap(queryDto);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)salesDictDataVos) && CollectionUtils.isNotEmpty((Collection)channelDictDataVos) && CollectionUtils.isNotEmpty((Collection)profitDictDataVos)) {
                Date date = com.biz.crm.mn.common.base.util.DateUtil.parse((String)dto.getYearMonth(), (String)"yyyy-MM");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(2, 1);
                calendar.set(5, calendar.getActualMinimum(5));
                String startDate = com.biz.crm.mn.common.base.util.DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
                calendar.set(5, calendar.getActualMaximum(5));
                String endDate = com.biz.crm.mn.common.base.util.DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                this.deleteByDate(dto);
            }
        } else {
            Validate.notBlank((CharSequence)dto.getPrctr(), (String)"\u624b\u52a8\u67e5\u8be2\u65f6\uff0c\u5229\u6da6\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getVkorg(), (String)"\u624b\u52a8\u67e5\u8be2\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getVtweg(), (String)"\u624b\u52a8\u67e5\u8be2\u65f6\uff0c\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ArrayList<ReconciliationSapDto.ReconciliationItemDto> itemList = new ArrayList<ReconciliationSapDto.ReconciliationItemDto>();
            ReconciliationSapDto.ReconciliationItemDto itemDto = new ReconciliationSapDto.ReconciliationItemDto();
            itemDto.setGJAHR(year);
            itemDto.setMONAT(month);
            itemDto.setPRCTR(dto.getPrctr());
            itemDto.setVTWEG(dto.getVtweg());
            itemDto.setVKORG(dto.getVkorg());
            itemList.add(itemDto);
            queryDto.setITEM1(itemList);
            log.info("\u624b\u52a8\u62c9\u53d6123\u6570\u636e,\u53c2\u65701\u3010{}\u3011,\u53c2\u65702\u3010{}\u3011", (Object)JSON.toJSONString((Object)queryDto), (Object)JSON.toJSONString((Object)queryDto.getITEM1()));
            result = this.sapSdApiService.pushReconciliationToSap(queryDto);
            if (result.getCode().equals("202")) {
                Date date = com.biz.crm.mn.common.base.util.DateUtil.parse((String)dto.getYearMonth(), (String)"yyyy-MM");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(2, 1);
                calendar.set(5, calendar.getActualMinimum(5));
                String startDate = com.biz.crm.mn.common.base.util.DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
                calendar.set(5, calendar.getActualMaximum(5));
                String endDate = com.biz.crm.mn.common.base.util.DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
                dto.setStartDate(startDate);
                dto.setEndDate(endDate);
                this.deleteByDate(dto);
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByDate(PullSapReconciliationDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dto.getStartDate()) || StringUtils.isBlank((CharSequence)dto.getEndDate())) {
            return;
        }
        this.sapReconciliationRepository.deleteByDate(dto);
    }

    public void testReconciliationCallback(ReconciliationCallbackDto dto) {
        List callbackData;
        ArrayList reconciliationEntities;
        log.info("sap\u5ba2\u6237\u5bf9\u8d26\u5355\u56de\u8c03\u63a5\u53e3\u6570\u636e\u4e3a\uff0c\u4fe1\u606f:{}", (Object)dto);
        if (Objects.nonNull(dto) && CollectionUtil.isNotEmpty((Collection)dto.getITEM1()) && CollectionUtils.isNotEmpty((Collection)(reconciliationEntities = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)(callbackData = dto.getITEM1()), ReconciliationCallbackDataDto.class, SapReconciliationEntity.class, HashSet.class, ArrayList.class, new String[0]))))) {
            reconciliationEntities.forEach(entity -> {
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            });
            this.sapReconciliationRepository.saveOrUpdateBatch(reconciliationEntities);
        }
    }

    public Set<String> findCustomer(SapReconciliationDto dto) {
        if (Objects.isNull(dto)) {
            return Sets.newHashSet();
        }
        return this.sapReconciliationRepository.findCustomer(dto);
    }

    public List<SapReconciliationVo> findListByCustomerCode(SapReconciliationDto dto) {
        List<Object> list = Lists.newArrayList();
        try {
            Validate.notBlank((CharSequence)dto.getSubReconciliationCustomerCode(), (String)"\u751f\u6210\u5bf9\u8d26\u5355,findListByCustomerCode ===\u300b \u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSubReconciliationInstitutionCode(), (String)"\u751f\u6210\u5bf9\u8d26\u5355,findListByCustomerCode ===\u300b \u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getStartDateStr(), (String)"\u751f\u6210\u5bf9\u8d26\u5355,findListByCustomerCode ===\u300b \u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getEndDateStr(), (String)"\u751f\u6210\u5bf9\u8d26\u5355,findListByCustomerCode ===\u300b \u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.setTenantCode(TenantUtils.getTenantCode());
            list = this.sapReconciliationRepository.findListByCustomerCode(dto);
        }
        catch (Exception e) {
            log.info("\u751f\u6210\u5bf9\u8d26\u5355ERROR,findListByCustomerCode==>:{}", (Object)JSONObject.toJSONString((Object)dto));
            throw e;
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, SapReconciliationEntity.class, SapReconciliationVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public Page<SapReconciliationVo> findByReconciliations(Pageable pageable, SapReconciliationDto sapReconciliationDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.sapReconciliationRepository.findByReconciliations(pageable, sapReconciliationDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 2 2 * ?", taskDesc="\u6bcf\u67082\u53f7 02:00 \u70b9\u6267\u884c123\u6570\u636e\u62c9\u53d6\u4efb\u52a1")
    public void sync123DataScheduleTask() {
        block7: {
            this.loginUserService.refreshAuthentication(null);
            log.info("123\u6570\u636e\u62c9\u53d6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
            boolean lock = false;
            String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            try {
                lock = this.lock(lockKey);
                if (lock) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date());
                    calendar.add(2, -1);
                    String dateStr = com.biz.crm.mn.common.base.util.DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
                    PullSapReconciliationDto dto = new PullSapReconciliationDto();
                    dto.setYearMonth(dateStr);
                    this.querySapReconciliation(dto);
                    break block7;
                }
                throw new RuntimeException("\u52a0\u9501\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                log.error("123\u6570\u636e\u62c9\u53d6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object)e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (lock) {
                    this.unLock(lockKey);
                }
            }
        }
    }

    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6123\u6570\u636ejob\u6267\u884c\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("reconciliation_sync_123_job:lock:" + yearMonthDay, TimeUnit.HOURS, 12L);
    }

    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6123\u6570\u636ejob\u6267\u884c\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock("reconciliation_sync_123_job:lock:" + yearMonthDay);
    }
}

