/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.observer;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.CallbackArgumentsDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicCallbackService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.ReconciliationDocListRepository;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.BaseEcrmBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.internal.BaseElectronicSignature;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ThirdReconciliationStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="electronicCallbackService")
public class ElectronicCallbackServiceImpl
extends BaseElectronicSignature
implements ElectronicCallbackService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicCallbackServiceImpl.class);
    @Autowired
    private ReconciliationDocListRepository reconciliationDocListRepository;
    @Autowired
    private ReconciliationDocListService reconciliationDocListService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BaseEcrmBuildService baseEcrmBuildService;

    public void electronicCallback(CallbackArgumentsDto dto) {
        String code;
        log.info("\u7535\u5b50\u7b7e\u7ae0\u56de\u8c03!!!!!! {}", (Object)JSONUtil.toJsonPrettyStr((Object)dto));
        ReconciliationDocListEntity reconciliationDocList = this.reconciliationDocListRepository.findByContractId(dto.getContractId());
        if (reconciliationDocList == null) {
            return;
        }
        if (StrUtil.isNotEmpty((CharSequence)dto.getReconciliationResult()) && StrUtil.isNotEmpty((CharSequence)(code = ThirdReconciliationStatusEnum.findByThirdCode((String)dto.getReconciliationResult())))) {
            reconciliationDocList.setStatementStatus(code);
            this.reconciliationDocListRepository.updateById((Object)reconciliationDocList);
            ReconciliationDocListVo reconciliationDocListVo = (ReconciliationDocListVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationDocList, ReconciliationDocListVo.class, HashSet.class, ArrayList.class, new String[0]);
            try {
                if (ReconciliationStatusEnum.COMPLETE.getCode().equals(code)) {
                    this.reconciliationDocListService.downloadContract((List)Lists.newArrayList((Object[])new String[]{reconciliationDocList.getId()}));
                }
                this.baseEcrmBuildService.pushECrm(reconciliationDocListVo);
            }
            catch (Exception e) {
                log.error("\u7535\u5b50\u7b7e\u7ae0\u63a8\u9001ecrm\u5f02\u5e38 \uff0ce:{}", (Object)e.getMessage());
            }
        }
    }
}

