/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.service.observer;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ReconciliationCallbackService;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.SapReconciliationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.repository.SapReconciliationRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReconciliationCallbackServiceListener
implements ReconciliationCallbackService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationCallbackServiceListener.class);
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SapReconciliationRepository sapReconciliationRepository;

    public void reconciliationCallback(ReconciliationCallbackDto dto) {
        log.info("sap\u5ba2\u6237\u5bf9\u8d26\u5355\u56de\u8c03\u63a5\u53e3\u6570\u636e\u4e3a\uff0c\u4fe1\u606f:{}", (Object)dto);
        if (Objects.nonNull(dto) && CollectionUtil.isNotEmpty((Collection)dto.getITEM1())) {
            List callbackData = dto.getITEM1();
            ArrayList<SapReconciliationEntity> reconciliationEntities = new ArrayList<SapReconciliationEntity>();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(2, -1);
            String fkdat = DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
            for (ReconciliationCallbackDataDto callbackDatum : callbackData) {
                SapReconciliationEntity entity = (SapReconciliationEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)callbackDatum, SapReconciliationEntity.class, HashSet.class, ArrayList.class, new String[0]));
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setKunagTxt(callbackDatum.getKunag_txt());
                entity.setZdocName(callbackDatum.getZdoc_name());
                entity.setZyszkBdyy(callbackDatum.getZyszk_bdyy());
                entity.setPstyvT(callbackDatum.getPstyv_t());
                entity.setNetwrHs(callbackDatum.getNetwr_hs());
                entity.setNetwrZk(callbackDatum.getNetwr_zk());
                entity.setKunweTxt(callbackDatum.getKunwe_txt());
                if (StringUtils.isNotBlank((CharSequence)entity.getZdocName()) && (entity.getZdocName().contains("\u671f\u521d") || entity.getZdocName().contains("\u603b\u8ba1"))) {
                    entity.setFkdat(fkdat + "01");
                }
                reconciliationEntities.add(entity);
            }
            this.createByreconciliationCallback(reconciliationEntities);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void createByreconciliationCallback(List<SapReconciliationEntity> reconciliationEntities) {
        if (CollectionUtil.isEmpty(reconciliationEntities)) {
            return;
        }
        this.sapReconciliationRepository.saveBatch(reconciliationEntities);
    }
}

