/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.handle.sdk.dto.AuditHandleDetailDto;
import com.biz.crm.tpm.business.audit.handle.sdk.service.AuditHandleSdkService;
import com.biz.crm.tpm.business.audit.handle.sdk.vo.AuditHandleDetailVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.MethodAccountingEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy<AuditCustomerDetailCollectionVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditForAbstractReconciliation.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private AuditHandleSdkService auditHandleSdkService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.CLOSURE.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.DETAIL.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        String tenantCode = TenantUtils.getTenantCode();
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setTenantCode(tenantCode);
        detailCollectionDto.setCustomerCode(dto.getCustomerCode());
        log.info("\u751f\u6210\u7ed3\u6848\u5bf9\u8d26\u5355\u4e3b\u4f53\u5ba2\u6237\u6838\u9500\uff0c\u67e5\u8be2\u5ba2\u6237\u53c2\u6570:{}", (Object)detailCollectionDto);
        List customerCodeList = this.auditService.auditDetailCustomerList(detailCollectionDto);
        TpmExamineCircularDto circularDto = new TpmExamineCircularDto();
        circularDto.setStartDate(dto.getStartDateTime());
        circularDto.setEndDate(dto.getEndDateTime());
        circularDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        circularDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        circularDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        circularDto.setTenantCode(tenantCode);
        circularDto.setCustomerCode(dto.getCustomerCode());
        List circularCustomerCodeList = this.tpmExamineCircularService.tpmExamineCircularCustomerList(circularDto);
        AuditHandleDetailDto handleDetailDto = new AuditHandleDetailDto();
        handleDetailDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        handleDetailDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        handleDetailDto.setActivityBeginDate(dto.getStartDateTime());
        handleDetailDto.setActivityEndDate(dto.getEndDateTime());
        handleDetailDto.setTenantCode(tenantCode);
        handleDetailDto.setCustomerCode(dto.getCustomerCode());
        List handleCustomerCodeList = this.auditHandleSdkService.auditHandleCustomerList(handleDetailDto);
        HashSet codes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)customerCodeList)) {
            codes.addAll(customerCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)circularCustomerCodeList)) {
            codes.addAll(circularCustomerCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)handleCustomerCodeList)) {
            codes.addAll(handleCustomerCodeList);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), codes);
        log.info("\u751f\u6210\u7ed3\u6848\u5bf9\u8d26\u5355\u4e3b\u4f53\u5ba2\u6237\u6838\u9500\uff0c\u5ba2\u6237\u4fe1\u606f:{}", map);
        return map;
    }

    public List<AuditCustomerDetailCollectionVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List productVoList;
        List activityFormVoList;
        log.info("\u4e3b\u4f53\u7ed3\u6848\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570customerCode{},\u53c2\u6570[{}]", (Object)customerCode, (Object)JSON.toJSONString((Object)dto));
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setCustomerCode(customerCode);
        List<AuditCustomerDetailCollectionVo> result = this.auditService.auditDetail(detailCollectionDto);
        log.info("\u4e3b\u4f53\u7ed3\u6848\u5bf9\u8d26customerCode{},\u7ed3\u6848\u6838\u9500\u5ba2\u6237\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)result));
        result = result.stream().filter(c -> UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatus()) || UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatusHead()) || StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())).collect(Collectors.toList());
        result.forEach(r -> {
            r.setMenu("audit");
            r.setReimburseUpAccountStatus(r.getReimburseUpAccountStatusHead());
        });
        AuditHandleDetailDto handleDetailDto = new AuditHandleDetailDto();
        handleDetailDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        handleDetailDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        handleDetailDto.setActivityBeginDate(dto.getStartDateTime());
        handleDetailDto.setActivityEndDate(dto.getEndDateTime());
        handleDetailDto.setCustomerCode(customerCode);
        List<AuditHandleDetailVo> handleDetailVoList = this.auditHandleSdkService.findListForReconciliation(handleDetailDto);
        log.info("\u67e5\u8be2\u5230\u7684\u76f4\u63a5\u4e0a\u8d26\u660e\u7ec6\u6570\u636e,\u5ba2\u6237\u3010{}\u3011\uff1a\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)handleDetailVoList));
        handleDetailVoList = handleDetailVoList.stream().filter(c -> UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatus()) || UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getUpAccountStatusReimburse()) || StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) && c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())).collect(Collectors.toList());
        List<AuditCustomerDetailCollectionVo> handleDetailCollectionVos = this.transformHandleDetail(handleDetailVoList);
        Set activityFormCodeSet = handleDetailCollectionVos.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getActivityFormCode())).map(AuditCustomerDetailCollectionVo::getActivityFormCode).collect(Collectors.toSet());
        HashMap activityFormMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(activityFormCodeSet) && CollectionUtil.isNotEmpty((Collection)(activityFormVoList = this.activityFormService.findActivityFormByCode(activityFormCodeSet)))) {
            activityFormMap.putAll(activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, v -> v, (n, o) -> n)));
        }
        result.addAll(handleDetailCollectionVos);
        TpmExamineCircularDto circularDto = new TpmExamineCircularDto();
        circularDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        circularDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        circularDto.setStartDate(dto.getStartDateTime());
        circularDto.setEndDate(dto.getEndDateTime());
        circularDto.setCustomerCode(customerCode);
        List circularRespVos = this.tpmExamineCircularService.findListForReconciliation(circularDto);
        log.info("\u67e5\u8be2\u5230\u7684\u8003\u6838\u901a\u62a5\u6570\u636e,\u5ba2\u6237\u3010{}\u3011\uff1a\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)circularRespVos));
        List<AuditCustomerDetailCollectionVo> detailCollectionVos = this.tpmExamineCircularRespVoToAuditCustomerDetailCollectionVo(circularRespVos);
        result.addAll(detailCollectionVos);
        Set productCodeSet = detailCollectionVos.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getProductCode())).map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        result.forEach(item -> {
            if (StringUtil.isNotEmpty((CharSequence)item.getProductCode()) && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
            item.setReconciliationYearMonth(com.biz.crm.mn.common.base.util.DateUtil.format((Date)dto.getStartDateTime(), (String)"yyyy-MM"));
            BigDecimal thisAuditAmount = Optional.ofNullable(item.getThisAuditAmount()).orElse(BigDecimal.ZERO);
            if (CustomerSupplierTypeEnum.SUPPLIER.getValue().equals(item.getCustomerSupplierType()) && BooleanEnum.TRUE.getCapital().equals(item.getWhetherPay())) {
                item.setMethodAccounting(MethodAccountingEnum.CE_REIMBURSE.getDesc());
            } else if ("Z321".equals(item.getActivityFormCode())) {
                item.setMethodAccounting(MethodAccountingEnum.FREE_RIDE.getDesc());
            } else if (thisAuditAmount.compareTo(BigDecimal.ZERO) == 0) {
                item.setMethodAccounting(MethodAccountingEnum.FILINGS.getDesc());
            } else if (StringUtils.isNotBlank((CharSequence)item.getEndCaseForm()) && item.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode()) && item.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) {
                item.setMethodAccounting(MethodAccountingEnum.DISCOUNT.getDesc() + "," + MethodAccountingEnum.REIMBURSE.getDesc());
            } else if (EndCaseFormEnum.DISCOUNT.getCode().equals(item.getEndCaseForm())) {
                item.setMethodAccounting(MethodAccountingEnum.DISCOUNT.getDesc());
            } else if (EndCaseFormEnum.REIMBURSE.getCode().equals(item.getEndCaseForm())) {
                item.setMethodAccounting(MethodAccountingEnum.REIMBURSE.getDesc());
            }
            if ("examine".equals(item.getMenu())) {
                item.setMethodAccounting("");
            }
            item.setAccountMethod(item.getMethodAccounting());
            item.setAccountNumber(item.getActivityDetailCode());
            if (StringUtil.isNotEmpty((CharSequence)item.getActivityFormCode()) && activityFormMap.containsKey(item.getActivityFormCode())) {
                item.setActivityFormName(((ActivityFormVo)activityFormMap.get(item.getActivityFormCode())).getActivityFormName());
            }
            if (StringUtil.isEmpty((CharSequence)item.getActivityFormName())) {
                item.setActivityFormName(item.getActivityFormCode());
            }
            item.setDealerUndertakeAmount(item.getCustomerFeeAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getCustomerFeeAmount().setScale(2, RoundingMode.HALF_UP));
            item.setCurrentAuditAmount(null);
            if ("audit".equals(item.getMenu())) {
                item.setCurrentAuditAmount(Objects.nonNull(item.getApplyAmount()) ? item.getApplyAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            } else if ("handle".equals(item.getMenu())) {
                item.setCurrentAuditAmount(Objects.nonNull(item.getThisAuditAmount()) ? item.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            } else if ("examine".equals(item.getMenu())) {
                item.setCurrentAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }
            item.setCurrentActualAuditAmount(null);
            if ("audit".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(Objects.nonNull(item.getThisAuditAmount()) ? item.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("handle".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(Objects.nonNull(item.getThisAuditAmountNotTax()) ? item.getThisAuditAmountNotTax().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("examine".equals(item.getMenu())) {
                item.setCurrentActualAuditAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }
            item.setDeductionTaxAmount(null);
            if ("audit".equals(item.getMenu())) {
                if (Objects.nonNull(item.getDiscountTaxDeduction())) {
                    item.setDeductionTaxAmount(NumberUtil.add((Number)item.getDiscountTaxDeduction(), (Number)item.getTaxQuota()).setScale(2, RoundingMode.HALF_UP));
                }
            } else if ("handle".equals(item.getMenu())) {
                item.setDeductionTaxAmount(Objects.nonNull(item.getTaxDeductionAmount()) ? item.getTaxDeductionAmount().setScale(2, RoundingMode.HALF_UP) : null);
            } else if ("examine".equals(item.getMenu())) {
                item.setDeductionTaxAmount(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
            }
            item.setExamineCircularAmount(Objects.isNull(item.getExamineCircularAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getExamineCircularAmount().setScale(2, RoundingMode.HALF_UP));
            item.setReimburseTaxAmount(Objects.isNull(item.getReimburseTaxAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP));
            item.setReimburseAmount(Objects.isNull(item.getReimburseAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getReimburseAmount().setScale(2, RoundingMode.HALF_UP));
            item.setDiscountUpAccount(Objects.isNull(item.getDiscountUpAccount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : item.getDiscountUpAccount().setScale(2, RoundingMode.HALF_UP));
        });
        List customerDetailCollectionVos = result.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) || !c.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode()) || !UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(c.getReimburseUpAccountStatus())).collect(Collectors.toList());
        BigDecimal promotionTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(AuditCustomerDetailCollectionVo::getReimburseTaxAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        promotionTotalAmount = Optional.ofNullable(promotionTotalAmount).orElse(BigDecimal.ZERO);
        customerDetailCollectionVos = customerDetailCollectionVos.stream().filter(b -> !StringUtils.isNotBlank((CharSequence)b.getEndCaseForm()) || !b.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).collect(Collectors.toList());
        BigDecimal discountTotalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(AuditCustomerDetailCollectionVo::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        discountTotalAmount = Optional.ofNullable(discountTotalAmount).orElse(BigDecimal.ZERO);
        customerDetailCollectionVos = customerDetailCollectionVos.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getEndCaseForm()) || !c.getEndCaseForm().contains(EndCaseFormEnum.WITH_ORDER.getCode())).collect(Collectors.toList());
        BigDecimal followCarAmount = customerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        followCarAmount = Optional.ofNullable(followCarAmount).orElse(BigDecimal.ZERO);
        BigDecimal examineCircularAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount()).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        examineCircularAmount = Optional.ofNullable(examineCircularAmount).orElse(BigDecimal.ZERO);
        BigDecimal totalAmount = customerDetailCollectionVos.stream().filter(Objects::nonNull).map(x -> {
            BigDecimal reimburseTaxAmount = Objects.isNull(x.getReimburseTaxAmount()) ? BigDecimal.ZERO : x.getReimburseTaxAmount();
            BigDecimal discountTaxAmount = Objects.isNull(x.getDiscountTaxAmount()) ? BigDecimal.ZERO : x.getDiscountTaxAmount();
            BigDecimal auditAmount = Objects.nonNull(x.getAuditAmount()) && "Z321".equals(x.getActivityFormCode()) ? x.getAuditAmount() : BigDecimal.ZERO;
            BigDecimal examineCircularAmount1 = Objects.isNull(x.getExamineCircularAmount()) ? BigDecimal.ZERO : x.getExamineCircularAmount();
            return NumberUtil.add((Number)NumberUtil.add((Number)reimburseTaxAmount, (Number)discountTaxAmount), (Number)NumberUtil.add((Number)auditAmount, (Number)examineCircularAmount1));
        }).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalAmount = Optional.ofNullable(totalAmount).orElse(BigDecimal.ZERO);
        for (int i = 0; i < result.size(); ++i) {
            AuditCustomerDetailCollectionVo vo = result.get(i);
            vo.setAuditNum(String.valueOf(i + 1));
            vo.setDiscountTotalAmount(discountTotalAmount);
            vo.setPromotionTotalAmount(promotionTotalAmount);
            vo.setPromotionAndDiscountTotalAmount(discountTotalAmount.add(promotionTotalAmount));
            vo.setFollowCarAmount(followCarAmount);
            vo.setExamineCircularAmount(examineCircularAmount);
            vo.setTotalAmount(totalAmount);
        }
        return result;
    }

    public List<AuditCustomerDetailCollectionVo> transformHandleDetail(List<AuditHandleDetailVo> handleDetailVoList) {
        ArrayList<AuditCustomerDetailCollectionVo> detailCollectionVos = new ArrayList<AuditCustomerDetailCollectionVo>();
        for (AuditHandleDetailVo handleDetailVo : handleDetailVoList) {
            Calendar instance;
            AuditCustomerDetailCollectionVo collectionVo = new AuditCustomerDetailCollectionVo();
            collectionVo.setMenu("handle");
            collectionVo.setId(handleDetailVo.getId());
            collectionVo.setActivityDetailCode(handleDetailVo.getAuditHandleDetailCode());
            collectionVo.setCustomerCode(handleDetailVo.getCustomerCode());
            collectionVo.setCustomerName(handleDetailVo.getCustomerName());
            collectionVo.setBusinessUnitCode(handleDetailVo.getBusinessUnitCode());
            collectionVo.setBusinessFormatCode(handleDetailVo.getBusinessFormatCode());
            collectionVo.setSalesInstitutionCode(handleDetailVo.getSalesOrgCode());
            collectionVo.setSalesInstitutionName(handleDetailVo.getSalesOrgName());
            collectionVo.setSalesRegionCode(handleDetailVo.getSalesOrgCode());
            collectionVo.setSalesRegionName(handleDetailVo.getSalesOrgName());
            collectionVo.setSalesOrgCode(handleDetailVo.getSalesGroupCode());
            collectionVo.setSalesOrgName(handleDetailVo.getSalesGroupName());
            collectionVo.setProductCode(handleDetailVo.getProductCode());
            collectionVo.setProductName(handleDetailVo.getProductName());
            collectionVo.setBudgetItemCode(handleDetailVo.getYearBudgetCode());
            collectionVo.setBudgetItemName(handleDetailVo.getYearBudgetName());
            collectionVo.setActivityFormCode(handleDetailVo.getActivityFormCode());
            collectionVo.setActivityFormName(handleDetailVo.getActivityFormName());
            if (Objects.nonNull(handleDetailVo.getActivityBeginDate())) {
                collectionVo.setActivityBeginTime(handleDetailVo.getActivityBeginDate());
            } else {
                instance = Calendar.getInstance();
                instance.set(5, 1);
                collectionVo.setActivityBeginTime(instance.getTime());
            }
            if (Objects.nonNull(handleDetailVo.getActivityEndDate())) {
                collectionVo.setActivityEndTime(handleDetailVo.getActivityEndDate());
            } else {
                instance = Calendar.getInstance();
                int maxDay = instance.getMaximum(5);
                instance.set(5, maxDay);
                collectionVo.setActivityEndTime(instance.getTime());
            }
            collectionVo.setEndCaseForm(handleDetailVo.getEndCaseForm());
            collectionVo.setApplyAmount(handleDetailVo.getApplyFee());
            collectionVo.setThisAuditAmount(handleDetailVo.getThisAuditAmountTax());
            collectionVo.setThisAuditAmountNotTax(handleDetailVo.getThisAuditAmountNotTax());
            collectionVo.setTaxDeductionAmount(handleDetailVo.getDeductTaxAmount());
            collectionVo.setDiscountAmount(handleDetailVo.getInFeePoolAmount());
            collectionVo.setRemark(handleDetailVo.getRemark());
            collectionVo.setCreateName(handleDetailVo.getCreateName());
            collectionVo.setProcessTitle(handleDetailVo.getAuditHandleName());
            collectionVo.setUpAccountStatus(handleDetailVo.getUpAccountStatus());
            collectionVo.setReimburseUpAccountStatus(handleDetailVo.getUpAccountStatusReimburse());
            collectionVo.setReimburseTaxAmount(handleDetailVo.getThisAuditAmountNotTax());
            detailCollectionVos.add(collectionVo);
        }
        return detailCollectionVos;
    }

    public List<AuditCustomerDetailCollectionVo> tpmExamineCircularRespVoToAuditCustomerDetailCollectionVo(List<TpmExamineCircularRespVo> circularRespVos) {
        Map examineType = this.dictToolkitService.findMapByDictTypeCode("examine_circular_examine_type");
        ArrayList<AuditCustomerDetailCollectionVo> detailCollectionVos = new ArrayList<AuditCustomerDetailCollectionVo>();
        for (TpmExamineCircularRespVo circularRespVo : circularRespVos) {
            Calendar instance;
            AuditCustomerDetailCollectionVo collectionVo = new AuditCustomerDetailCollectionVo();
            collectionVo.setMenu("examine");
            collectionVo.setId(circularRespVo.getId());
            collectionVo.setActivityDetailCode(circularRespVo.getExamineCircularCode());
            collectionVo.setCenter("\u8003\u6838\u6263\u6b3e");
            collectionVo.setCustomerCode(circularRespVo.getCustomerCode());
            collectionVo.setCustomerName(circularRespVo.getCustomerName());
            collectionVo.setBusinessUnitCode(circularRespVo.getBusinessUnitCode());
            collectionVo.setBusinessFormatCode(circularRespVo.getBusinessFormatCode());
            collectionVo.setSalesInstitutionCode(circularRespVo.getSalesOrgCode());
            collectionVo.setSalesInstitutionName(circularRespVo.getSalesOrgName());
            collectionVo.setSalesRegionCode(circularRespVo.getSalesDepartmentCode());
            collectionVo.setSalesRegionName(circularRespVo.getSalesDepartmentName());
            collectionVo.setSalesOrgCode(circularRespVo.getSalesGroupCode());
            collectionVo.setSalesOrgName(circularRespVo.getSalesGroupName());
            collectionVo.setBudgetItemCode(circularRespVo.getBudgetProjectCode());
            collectionVo.setBudgetItemName(circularRespVo.getBudgetProjectName());
            collectionVo.setActivityFormName(circularRespVo.getActivityFormName());
            collectionVo.setActivityFormCode(circularRespVo.getActivityForm());
            if (Objects.nonNull(circularRespVo.getStartDate())) {
                collectionVo.setActivityBeginTime(circularRespVo.getStartDate());
            } else {
                instance = Calendar.getInstance();
                instance.set(5, 1);
                collectionVo.setActivityBeginTime(instance.getTime());
            }
            if (Objects.nonNull(circularRespVo.getEndDate())) {
                collectionVo.setActivityEndTime(circularRespVo.getEndDate());
            } else {
                instance = Calendar.getInstance();
                int maxDay = instance.getMaximum(5);
                instance.set(5, maxDay);
                collectionVo.setActivityEndTime(instance.getTime());
            }
            collectionVo.setActivityFormDesc((String)examineType.get(circularRespVo.getExamineType()));
            collectionVo.setThisAuditAmount(circularRespVo.getExamineCircularAmount());
            collectionVo.setDiscountTaxAmount(circularRespVo.getExamineCircularAmount());
            collectionVo.setRemark(circularRespVo.getRemark());
            collectionVo.setCreateName(circularRespVo.getCreateName());
            collectionVo.setProcessTitle(circularRespVo.getExamineCircularName());
            collectionVo.setExamineCircularAmount(circularRespVo.getExamineCircularAmount());
            collectionVo.setProductName(circularRespVo.getProductName());
            detailCollectionVos.add(collectionVo);
        }
        return detailCollectionVos;
    }

    public String convert(String propertyName, AuditCustomerDetailCollectionVo propertyClass) {
        ReconciliationPropertyEnum.AuditDetailPropertyEnum auditDetailPropertyEnum = ReconciliationPropertyEnum.AuditDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(auditDetailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        switch (auditDetailPropertyEnum) {
            case audit_number: {
                return propertyClass.getAuditNum();
            }
            case audit_customerName: {
                return propertyClass.getCustomerName();
            }
            case audit_firstChannelName: {
                return propertyClass.getFirstChannelName();
            }
            case audit_secondChannelName: {
                return propertyClass.getSecondChannelName();
            }
            case audit_center: {
                return "6000";
            }
            case audit_businessFormatCode: {
                return BusinessFormatEnum.getDesc((String)propertyClass.getBusinessFormatCode());
            }
            case audit_businessUnitCode: {
                return BusinessUnitEnum.getDesc((String)propertyClass.getBusinessUnitCode());
            }
            case audit_salesInstitutionName: {
                return propertyClass.getSalesInstitutionName();
            }
            case audit_salesOrgRegionName: {
                return propertyClass.getSalesRegionName();
            }
            case audit_salesOrgProvinceName: {
                return propertyClass.getSalesOrgName();
            }
            case audit_budgetProjectName: {
                return StringUtils.isBlank((CharSequence)propertyClass.getBudgetItemName()) ? propertyClass.getHeadBudgetItemName() : propertyClass.getBudgetItemName();
            }
            case audit_brand_Txt: {
                return propertyClass.getProductBrandName();
            }
            case audit_productName: {
                return propertyClass.getProductName();
            }
            case audit_activityFormName: {
                return StringUtils.isNotBlank((CharSequence)propertyClass.getActivityFormName()) ? propertyClass.getActivityFormName() : propertyClass.getActivityFormCode();
            }
            case audit_activityBeginDate: {
                if (Objects.nonNull(propertyClass.getActivityBeginTime())) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityBeginTime());
                }
                return "";
            }
            case audit_activityEndDate: {
                if (Objects.nonNull(propertyClass.getActivityEndTime())) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityEndTime());
                }
                return "";
            }
            case audit_description: {
                return propertyClass.getActivityFormDesc();
            }
            case audit_dealerBearFee: {
                return propertyClass.getDealerUndertakeAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString() : propertyClass.getDealerUndertakeAmount().setScale(2, RoundingMode.HALF_UP).toString();
            }
            case audit_approvedAmount: {
                return Optional.ofNullable(propertyClass.getApplyAmount()).orElse(BigDecimal.ZERO).toPlainString();
            }
            case audit_closingAmount: {
                if (Objects.nonNull(propertyClass.getCurrentAuditAmount())) {
                    return propertyClass.getCurrentAuditAmount().toString();
                }
                return "";
            }
            case audit_taxQuota: {
                if (Objects.nonNull(propertyClass.getDeductionTaxAmount())) {
                    return propertyClass.getDeductionTaxAmount().toString();
                }
                return "";
            }
            case audit_finalClosingAmount: {
                if (Objects.nonNull(propertyClass.getCurrentActualAuditAmount())) {
                    return propertyClass.getCurrentActualAuditAmount().toString();
                }
                return "";
            }
            case audit_discountTaxTotalAmount: {
                return propertyClass.getDiscountUpAccount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString() : propertyClass.getDiscountUpAccount().setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
            case audit_reimburse_TaxAmount: {
                return propertyClass.getReimburseTaxAmount() == null ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toString() : propertyClass.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP).toString();
            }
            case create_name: {
                return propertyClass.getCreateName();
            }
            case examine_circular_amount: {
                return Objects.isNull(propertyClass.getExamineCircularAmount()) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString() : propertyClass.getExamineCircularAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
            case process_title: {
                return propertyClass.getProcessTitle();
            }
            case method_accounting: {
                return propertyClass.getAccountMethod();
            }
            case up_account_code: {
                return propertyClass.getAccountNumber();
            }
        }
        return "";
    }

    public String convertHead(String propertyName, List<Object> propertyList) {
        ReconciliationPropertyHeadEnum.AuditDetailPropertyEnum auditDetailPropertyEnum = ReconciliationPropertyHeadEnum.AuditDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(auditDetailPropertyEnum) || CollectionUtils.isEmpty(propertyList)) {
            return "";
        }
        List<Object> customerDetailCollectionVos = propertyList;
        switch (auditDetailPropertyEnum) {
            case audit_year_month: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getReconciliationYearMonth();
            }
            case audit_customer_name: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getCustomerName();
            }
            case audit_total_reimburseTaxAmount: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getPromotionTotalAmount().toString();
            }
            case audit_total_discountTaxTotalAmount: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getDiscountTotalAmount().toString();
            }
            case audit_toytal_discount_And_reimbursement: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getPromotionAndDiscountTotalAmount().toString();
            }
            case car_amount: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getFollowCarAmount().toString();
            }
            case assessment_deduction_amount: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getExamineCircularAmount().toString();
            }
            case total_amount: {
                return ((AuditCustomerDetailCollectionVo)customerDetailCollectionVos.get(0)).getTotalAmount().toString();
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }
}

