/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailAuditTypeEnum;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditSubForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy<AuditCustomerDetailCollectionVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditSubForAbstractReconciliation.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private Zmsd121Service zmsd121Service;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.CLOSURE.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        String startDate = DateUtil.format((Date)dto.getStartDateTime(), (String)"yyyyMMdd");
        String endDate = DateUtil.format((Date)dto.getEndDateTime(), (String)"yyyyMMdd");
        String ds = AuditSubForAbstractReconciliation.get121Ds(dto.getStartDateTime());
        log.info("\u751f\u6210\u7ed3\u6848\u5bf9\u8d26\u5355121,\u67e5\u8be2\u53c2\u6570:{}", (Object)dto);
        log.info("\u751f\u6210\u7ed3\u6848\u5bf9\u8d26\u5355121,startDate:{},endDate:{},ds:{}", new Object[]{startDate, endDate, ds});
        List customerCodes = this.zmsd121Service.findCustomerListByDate(startDate, endDate, dto.getCustomerCode(), ds);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        map.put(BusinessUnitEnum.SON_COMPANY.getCode(), Sets.newHashSet((Iterable)customerCodes));
        log.info("\u751f\u6210\u7ed3\u6848\u5bf9\u8d26\u5355121\u5ba2\u6237\u7f16\u7801{}", map);
        return map;
    }

    public List<AuditCustomerDetailCollectionVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List productVoList;
        log.info("\u5206\u5b50\u7ed3\u6848\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570customerCode{},\u53c2\u6570[{}]", (Object)customerCode, (Object)JSON.toJSONString((Object)dto));
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
            String[] split = customerCode.split("-");
            detailCollectionDto.setSubReconciliationCustomerCode(split[0]);
            if (split.length > 1) {
                detailCollectionDto.setSubReconciliationInstitutionCode(split[1]);
            }
        }
        List result = this.auditService.auditDetail(detailCollectionDto);
        Set productCodeSet = result.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getProductCode())).map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        result.forEach(item -> {
            if (StringUtil.isNotEmpty((CharSequence)item.getProductCode()) && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });
        log.info("\u5206\u5b50\u7ed3\u6848\u5bf9\u8d26customerCode{}\u5355\u67e5\u8be2\u7ed3\u679c\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public String convert(String propertyName, AuditCustomerDetailCollectionVo propertyClass) {
        ReconciliationPropertyEnum.AuditSubDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.AuditSubDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        switch (detailPropertyEnum) {
            case audit_sub_channel: {
                return propertyClass.getFirstChannelName();
            }
            case audit_sub_sale_org: {
                return propertyClass.getSalesRegionName();
            }
            case audit_sub_customer: {
                return propertyClass.getCustomerName();
            }
            case audit_sub_activity_form_name: {
                return propertyClass.getActivityFormName();
            }
            case head_budget_item_name: {
                return propertyClass.getHeadBudgetItemName();
            }
            case product_name: {
                return propertyClass.getProductName();
            }
            case start_date: {
                if (Objects.nonNull(propertyClass.getActivityBeginTime())) {
                    return DateUtil.format((Date)propertyClass.getActivityBeginTime(), (String)"yyyy-MM-dd");
                }
                return "";
            }
            case end_date: {
                if (Objects.nonNull(propertyClass.getActivityEndTime())) {
                    return DateUtil.format((Date)propertyClass.getActivityEndTime(), (String)"yyyy-MM-dd");
                }
                return "";
            }
            case approved_amount: {
                if (Objects.nonNull(propertyClass.getApplyAmount())) {
                    return propertyClass.getApplyAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
            case end_case_form: {
                return EndCaseFormEnum.codeToValue((String)propertyClass.getEndCaseForm());
            }
            case amount: {
                if (StringUtils.equals((CharSequence)AuditFormEnum.EXPENSE.getCode(), (CharSequence)propertyClass.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.RED_INVOICE.getCode(), (CharSequence)propertyClass.getEndCaseForm())) {
                    if (Objects.nonNull(propertyClass.getReimburseTaxAmount())) {
                        return propertyClass.getReimburseTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                    }
                    return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                if (StringUtils.equals((CharSequence)AuditFormEnum.DISCOUNT.getCode(), (CharSequence)propertyClass.getEndCaseForm()) || StringUtils.equals((CharSequence)AuditFormEnum.ORDER.getCode(), (CharSequence)propertyClass.getEndCaseForm())) {
                    if (Objects.nonNull(propertyClass.getDiscountTaxAmount())) {
                        return propertyClass.getDiscountTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                    }
                    return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                if (Objects.nonNull(propertyClass.getThisAuditAmount())) {
                    return propertyClass.getThisAuditAmount().setScale(2, RoundingMode.HALF_UP).toPlainString();
                }
                return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
            case remark: {
                return propertyClass.getRemark();
            }
            case audit_activity_name: {
                return propertyClass.getActivityName();
            }
            case audit_way: {
                return SubComActivityDetailAuditTypeEnum.codeToName((String)propertyClass.getAuditWay());
            }
        }
        return "";
    }

    public String convertHead(String propertyName, List<Object> propertyList) {
        ReconciliationPropertyHeadEnum.AuditSubHeadlPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.AuditSubHeadlPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(headPropertyEnum) || CollectionUtils.isEmpty(propertyList)) {
            return "";
        }
        List pdfHeadVos = JSON.parseArray((String)JSON.toJSONString(propertyList), SapForReconciliationPdfHeadVo.class);
        SapForReconciliationPdfHeadVo headVo = (SapForReconciliationPdfHeadVo)pdfHeadVos.get(0);
        switch (headPropertyEnum) {
            case audit_sub_item_name: {
                return headVo.getName();
            }
            case audit_sub_amount: {
                return Objects.nonNull(headVo.getAmount()) ? headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : "";
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }

    public static String get121Ds(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        String ds = DateUtil.format((Date)calendar.getTime(), (String)"yyyyMM");
        return ds + "01";
    }
}

