/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.Zmfi046Dto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.Zmfi046Voservice;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.Zmfi046SdkVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.dto.TpmDistributionCustomerMonthSaleDto;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.service.TpmDistributionCustomerMonthSaleService;
import com.biz.crm.tpm.business.distribution.customer.month.sale.sdk.vo.TpmDistributionCustomerMonthSaleRespVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.DistributionReconciliationAuditVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DistributionAuditForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy<DistributionReconciliationAuditVo> {
    private static final Logger log = LoggerFactory.getLogger(DistributionAuditForAbstractReconciliation.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private TpmDistributionCustomerMonthSaleService tpmDistributionCustomerMonthSaleService;
    @Autowired(required=false)
    TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private Zmfi046Voservice zmfi046Voservice;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.DISTRIBUTION.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.AUDIT.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setTenantCode(TenantUtils.getTenantCode());
        detailCollectionDto.setCustomerCode(dto.getCustomerCode());
        detailCollectionDto.setChannelCode("20");
        detailCollectionDto.setSalesInstitutionCode("20111171");
        log.info("\u751f\u6210\u5bf9\u8d26\u5355:\u4e3b\u4f53\u5ba2\u6237-\u6838\u9500\uff0cdetailCollectionDto:{}", (Object)detailCollectionDto);
        List customerCodeList = this.auditService.auditDetailEndCaseCustomerList(detailCollectionDto);
        detailCollectionDto.setActivityBeginTime(null);
        detailCollectionDto.setActivityEndTime(null);
        detailCollectionDto.setActivityBeginTimeYearMonthStr(dto.getStartDate().substring(0, 7));
        List customerCodeList2 = this.auditService.auditDetailEndCaseCustomerList(detailCollectionDto);
        customerCodeList.addAll(customerCodeList2);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), Sets.newHashSet((Iterable)customerCodeList));
        return map;
    }

    public List findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List productVoList;
        ArrayList<DistributionReconciliationAuditVo> list = new ArrayList<DistributionReconciliationAuditVo>();
        AuditCustomerDetailCollectionDto detailCollectionDto = new AuditCustomerDetailCollectionDto();
        detailCollectionDto.setActivityBeginTime(dto.getStartDateTime());
        detailCollectionDto.setActivityEndTime(dto.getEndDateTime());
        detailCollectionDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        detailCollectionDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        detailCollectionDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        detailCollectionDto.setEndCaseCustomerCode(customerCode);
        detailCollectionDto.setChannelCode("20");
        detailCollectionDto.setSalesInstitutionCode("20111171");
        log.info("\u751f\u6210\u5bf9\u8d26\u5355:\u4e3b\u4f53\u5ba2\u6237-\u6838\u9500\uff0cdetailCollectionDto:{}", (Object)detailCollectionDto);
        List auditCustomerDetails = this.auditService.auditDetail(detailCollectionDto);
        detailCollectionDto.setActivityBeginTime(null);
        detailCollectionDto.setActivityEndTime(null);
        detailCollectionDto.setActivityBeginTimeYearMonthStr(dto.getStartDate().substring(0, 7));
        List auditCustomerDetails2 = this.auditService.auditDetail(detailCollectionDto);
        List auditDetailCodeList = auditCustomerDetails.stream().map(AuditCustomerDetailCollectionVo::getAuditDetailCode).collect(Collectors.toList());
        for (AuditCustomerDetailCollectionVo auditCustomerDetailCollectionVo : auditCustomerDetails2) {
            if (auditDetailCodeList.contains(auditCustomerDetailCollectionVo.getAuditDetailCode())) continue;
            auditCustomerDetails.add(auditCustomerDetailCollectionVo);
        }
        if (CollectionUtils.isEmpty((Collection)auditCustomerDetails)) {
            return new ArrayList();
        }
        Set productCodeSet = auditCustomerDetails.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getProductCode())).map(AuditCustomerDetailCollectionVo::getProductCode).collect(Collectors.toSet());
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        auditCustomerDetails.forEach(item -> {
            if (StringUtil.isNotEmpty((CharSequence)item.getProductCode()) && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });
        Map<String, List<AuditCustomerDetailCollectionVo>> auditCustomerDetailMap = auditCustomerDetails.stream().peek(item -> {
            if (StringUtils.isEmpty((CharSequence)item.getOffsetProductCode())) {
                item.setOffsetProductCode("\u7a7a");
                item.setOffsetProductName("\u7a7a");
            }
        }).collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getOffsetProductCode));
        String sapCustomerCode = customerCode.substring(0, 10);
        String yearMonth = DateUtil.format((Date)dto.getStartDateTime(), (String)"yyyy-MM");
        TpmDistributionCustomerMonthSaleDto distributionMonthDto = new TpmDistributionCustomerMonthSaleDto();
        distributionMonthDto.setCustomerCode(sapCustomerCode);
        distributionMonthDto.setDistributionCustomerMonthSaleYearMonth(yearMonth);
        List distributionCustomerVoList = this.tpmDistributionCustomerMonthSaleService.findDistribution(distributionMonthDto);
        Map<Object, Object> distributionCustomerMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)distributionCustomerVoList)) {
            distributionCustomerMap = distributionCustomerVoList.stream().collect(Collectors.groupingBy(TpmDistributionCustomerMonthSaleRespVo::getProductCode));
        }
        TpmDistributionCustomerAuditDataDto distributionAuditDto = new TpmDistributionCustomerAuditDataDto();
        distributionAuditDto.setCustomerCode(sapCustomerCode);
        distributionAuditDto.setDistributionCustomerAuditYearMonth(yearMonth);
        List distributionAuditVoList = this.tpmDistributionCustomerAuditDataService.findListByConditions(distributionAuditDto);
        Map<Object, Object> distributionAuditMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)distributionAuditVoList)) {
            distributionAuditMap = distributionAuditVoList.stream().collect(Collectors.groupingBy(TpmDistributionCustomerAuditDataRespVo::getProductCode, Collectors.summingInt(e -> e.getInFactAuditQuantity() != null ? e.getInFactAuditQuantity() : 0)));
        }
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        for (String k2 : auditCustomerDetailMap.keySet()) {
            List<AuditCustomerDetailCollectionVo> details = auditCustomerDetailMap.get(k2);
            DistributionReconciliationAuditVo reconciliationVo = (DistributionReconciliationAuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)details.get(0), DistributionReconciliationAuditVo.class, HashSet.class, ArrayList.class, new String[0]);
            reconciliationVo.setCustomerCode(details.get(0).getEndCaseCustomerCode());
            reconciliationVo.setSapCustomerCode(sapCustomerCode);
            reconciliationVo.setCustomerName(details.get(0).getEndCaseCustomerName());
            BigDecimal supplyPrice = BigDecimal.ZERO;
            Integer monthSaleQuantity = 0;
            BigDecimal monthSaleAmount = BigDecimal.ZERO;
            BigDecimal auditQuantity = BigDecimal.ZERO;
            Integer boundGiftSaleQuantity = 0;
            Integer baseQuantity = 0;
            BigDecimal combinationFee = BigDecimal.ZERO;
            BigDecimal distributionBaseTen = BigDecimal.ZERO;
            BigDecimal goalAchievement = BigDecimal.ZERO;
            BigDecimal month = BigDecimal.ZERO;
            BigDecimal staffFee = BigDecimal.ZERO;
            Integer logisticsQuantity = 0;
            BigDecimal logistics = BigDecimal.ZERO;
            BigDecimal quarter = BigDecimal.ZERO;
            BigDecimal otherCooperation = BigDecimal.ZERO;
            BigDecimal otherCooperationTwo = BigDecimal.ZERO;
            BigDecimal fine = BigDecimal.ZERO;
            BigDecimal lastMonthAccount = BigDecimal.ZERO;
            for (AuditCustomerDetailCollectionVo detail : details) {
                String formCode;
                BigDecimal thisAuditAmount = this.bdNull(detail.getThisAuditAmount());
                if (null != detail.getProcessDate() && yearMonthFormat.format(detail.getProcessDate()).equals(yearMonth)) {
                    lastMonthAccount = lastMonthAccount.add(thisAuditAmount);
                }
                if (StringUtils.isBlank((CharSequence)detail.getActivityFormCode())) continue;
                switch (formCode = detail.getActivityFormCode()) {
                    case "DB15": {
                        combinationFee = combinationFee.add(thisAuditAmount);
                        break;
                    }
                    case "DA35": {
                        distributionBaseTen = distributionBaseTen.add(thisAuditAmount);
                        break;
                    }
                    case "DB01": {
                        goalAchievement = goalAchievement.add(thisAuditAmount);
                        break;
                    }
                    case "DA36": {
                        month = month.add(thisAuditAmount);
                        break;
                    }
                    case "DA78": {
                        staffFee = staffFee.add(thisAuditAmount);
                        break;
                    }
                    case "DA91": {
                        logistics = logistics.add(thisAuditAmount);
                        break;
                    }
                    case "DA45": {
                        quarter = quarter.add(thisAuditAmount);
                        break;
                    }
                    case "\u5176\u5b83\u652f\u63011\uff08\u5206\u9500\uff09": {
                        otherCooperation = otherCooperation.add(thisAuditAmount);
                        break;
                    }
                    case "\u5176\u5b83\u652f\u63012\uff08\u5206\u9500\uff09": {
                        otherCooperationTwo = otherCooperationTwo.add(thisAuditAmount);
                        break;
                    }
                    case "DA71": {
                        fine = fine.add(thisAuditAmount);
                        break;
                    }
                }
            }
            if (!distributionCustomerMap.isEmpty() && !CollectionUtils.isEmpty((Collection)((Collection)distributionCustomerMap.get(k2)))) {
                List monthList = (List)distributionCustomerMap.get(k2);
                for (TpmDistributionCustomerMonthSaleRespVo monthVo : monthList) {
                    Integer monthSaleQuantityTemp = this.intNull(monthVo.getMonthSaleQuantity());
                    BigDecimal manualAuditSaleQuantityTemp = this.bdNull(monthVo.getManualAuditSaleQuantity());
                    Integer boundGiftSaleQuantityTemp = this.intNull(monthVo.getBoundGiftSaleQuantity());
                    Integer ridSaleQuantityTemp = this.bdNull(monthVo.getRidSaleQuantity()).intValue();
                    supplyPrice = supplyPrice.add(this.bdNull(monthVo.getSupplyPrice()));
                    monthSaleQuantity = monthSaleQuantity + monthSaleQuantityTemp;
                    monthSaleAmount = monthSaleAmount.add(this.bdNull(monthVo.getMonthSaleAmount()));
                    auditQuantity = auditQuantity.add(new BigDecimal(monthSaleQuantityTemp).subtract(manualAuditSaleQuantityTemp));
                    boundGiftSaleQuantity = boundGiftSaleQuantity + boundGiftSaleQuantityTemp;
                    baseQuantity = baseQuantity + (monthSaleQuantityTemp - manualAuditSaleQuantityTemp.intValue() - boundGiftSaleQuantityTemp - ridSaleQuantityTemp);
                }
            }
            if (!distributionAuditMap.isEmpty() && distributionAuditMap.get(k2) != null) {
                logisticsQuantity = logisticsQuantity + (Integer)distributionAuditMap.get(k2);
            }
            reconciliationVo.setYearMonth(yearMonth);
            reconciliationVo.setProductCode(details.get(0).getOffsetProductCode());
            reconciliationVo.setProductName(details.get(0).getOffsetProductName());
            reconciliationVo.setCombinationFee(combinationFee);
            reconciliationVo.setDistributionBaseTen(distributionBaseTen);
            reconciliationVo.setGoalAchievement(goalAchievement);
            reconciliationVo.setMonth(month);
            reconciliationVo.setStaffFee(staffFee);
            reconciliationVo.setLogistics(logistics);
            reconciliationVo.setQuarter(quarter);
            reconciliationVo.setOtherCooperation(otherCooperation);
            reconciliationVo.setOtherCooperationTwo(otherCooperationTwo);
            reconciliationVo.setFine(fine);
            reconciliationVo.setLastMonthAccount(lastMonthAccount);
            reconciliationVo.setStaffLogistics(reconciliationVo.getStaffFee().add(reconciliationVo.getLogistics()));
            reconciliationVo.setMonthAccount(combinationFee.add(distributionBaseTen).add(month).add(quarter).add(fine));
            reconciliationVo.setSupplyPrice(supplyPrice);
            reconciliationVo.setMonthSaleQuantity(monthSaleQuantity);
            reconciliationVo.setMonthSaleAmount(monthSaleAmount);
            reconciliationVo.setAuditQuantity(auditQuantity);
            reconciliationVo.setBoundGiftSaleQuantity(boundGiftSaleQuantity);
            reconciliationVo.setBaseQuantity(baseQuantity);
            reconciliationVo.setLogisticsQuantity(logisticsQuantity);
            list.add(reconciliationVo);
        }
        return list;
    }

    public String convert(String propertyName, DistributionReconciliationAuditVo propertyClass) {
        ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        switch (detailPropertyEnum) {
            case year_month: {
                return propertyClass.getYearMonth();
            }
            case customer_code: {
                return propertyClass.getCustomerCode();
            }
            case customer_name: {
                return propertyClass.getCustomerName();
            }
            case product_code: {
                return propertyClass.getProductCode();
            }
            case product_name: {
                return propertyClass.getProductName();
            }
            case supply_price: {
                return propertyClass.getSupplyPrice().toPlainString();
            }
            case month_sale_quantity: {
                return propertyClass.getMonthSaleQuantity().toString();
            }
            case month_sale_amount: {
                return propertyClass.getMonthSaleAmount().toPlainString();
            }
            case audit_quantity: {
                return propertyClass.getAuditQuantity().toPlainString();
            }
            case bound_gift_sale_quantity: {
                return propertyClass.getBoundGiftSaleQuantity().toString();
            }
            case base_quantity: {
                return propertyClass.getBaseQuantity().toString();
            }
            case combination_fee: {
                return propertyClass.getCombinationFee().toPlainString();
            }
            case distribution_base_ten: {
                return propertyClass.getDistributionBaseTen().toPlainString();
            }
            case goal_achievement: {
                return propertyClass.getGoalAchievement().toPlainString();
            }
            case month: {
                return propertyClass.getMonth().toPlainString();
            }
            case staff_fee: {
                return propertyClass.getStaffFee().toPlainString();
            }
            case logistics_quantity: {
                return propertyClass.getLogisticsQuantity().toString();
            }
            case logistics: {
                return propertyClass.getLogistics().toPlainString();
            }
            case quarter: {
                return propertyClass.getQuarter().toPlainString();
            }
            case other_cooperation: {
                return propertyClass.getOtherCooperation().toPlainString();
            }
            case other_cooperation_two: {
                return propertyClass.getOtherCooperationTwo().toPlainString();
            }
            case fine: {
                return propertyClass.getFine().toPlainString();
            }
            case last_month_account: {
                return propertyClass.getLastMonthAccount().toPlainString();
            }
            case month_account: {
                return propertyClass.getMonthAccount().toPlainString();
            }
            case staff_logistics: {
                return propertyClass.getStaffLogistics().toPlainString();
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
        log.info("\u5f00\u59cb\u8f6c\u6362\u5c3e\u90e8");
        if (CollectionUtils.isEmpty(linkedHashMap)) {
            log.info("\u5c3e\u90e8\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        Zmfi046Dto dto = new Zmfi046Dto();
        dto.setCyM(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.year_month.getCode()));
        dto.setGenLegrCtm(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.customer_code.getCode()));
        log.info("\u5f00\u59cb\u8c03\u7528kms\u63a5\u53e3");
        List zmfi046VoList = this.zmfi046Voservice.findZmfi046VoForReconciliation(dto);
        log.info("\u7ed3\u675f\u8c03\u7528kms\u63a5\u53e3");
        BigDecimal crtCreditIncrcAmt = BigDecimal.ZERO;
        BigDecimal finalBalc = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)zmfi046VoList)) {
            Zmfi046SdkVo vo = (Zmfi046SdkVo)zmfi046VoList.get(0);
            crtCreditIncrcAmt = this.bdNull(vo.getCrtCreditIncrcAmt());
            finalBalc = this.bdNull(vo.getFinalBalc());
        }
        BigDecimal monthAccount = new BigDecimal(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_account.getCode()));
        BigDecimal staffLogistics = new BigDecimal(linkedHashMap.get(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.staff_logistics.getCode()));
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.next_month_account.getCode(), monthAccount.add(staffLogistics).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.crt_credit_incrc_amt.getCode(), crtCreditIncrcAmt.toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.month_init.getCode(), finalBalc.add(monthAccount.add(staffLogistics)).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.audit_final.getCode(), finalBalc.add(crtCreditIncrcAmt).toPlainString());
        linkedHashMap.put(ReconciliationPropertyEnum.DistributionAuditDetailPropertyEnum.financial_final.getCode(), finalBalc.add(crtCreditIncrcAmt).negate().toPlainString());
        log.info("\u7ed3\u675f\u8f6c\u6362\u5c3e\u90e8");
    }

    private BigDecimal bdNull(BigDecimal b) {
        return Optional.ofNullable(b).orElse(BigDecimal.ZERO);
    }

    private Integer intNull(Integer i) {
        return Optional.ofNullable(i).orElse(0);
    }

    public String convertHead(String propertyName, List propertyList) {
        return null;
    }
}

