/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReplyForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy<ActivityDetailPlanItemVo> {
    private static final Logger log = LoggerFactory.getLogger(ReplyForAbstractReconciliation.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.APPROVAL.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.DETAIL.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        activityDetailPlanItemDto.setActivityBeginDate(dto.getStartDateTime());
        activityDetailPlanItemDto.setActivityEndDate(dto.getEndDateTime());
        activityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        activityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        activityDetailPlanItemDto.setCustomerCode(dto.getCustomerCode());
        log.info("\u751f\u6210\u6279\u590d\u5bf9\u8d26\u5355\u4e3b\u4f53\u5ba2\u6237\u6d3b\u52a8\uff0c\u67e5\u8be2\u53c2\u6570:{}", (Object)activityDetailPlanItemDto);
        Set set = this.activityDetailPlanItemSdkService.findCustomer(activityDetailPlanItemDto);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), set);
        log.info("\u751f\u6210\u6279\u590d\u5bf9\u8d26\u5355\u4e3b\u4f53\u5ba2\u6237\u6d3b\u52a8\uff0c\u5ba2\u6237\u4fe1\u606f:{}", map);
        return map;
    }

    public List<ActivityDetailPlanItemVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List productVoList;
        log.info("\u4e3b\u4f53\u6279\u590d\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570customerCode{},\u53c2\u6570[{}]", (Object)customerCode, (Object)JSON.toJSONString((Object)dto));
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        activityDetailPlanItemDto.setActivityBeginDate(dto.getStartDateTime());
        activityDetailPlanItemDto.setActivityEndDate(dto.getEndDateTime());
        activityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        activityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        activityDetailPlanItemDto.setCustomerCode(customerCode);
        List result = this.activityDetailPlanItemSdkService.findByCustomerCode(activityDetailPlanItemDto);
        if (CollectionUtil.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        Set productCodeSet = result.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getProductCode())).map(ActivityDetailPlanItemBase::getProductCode).collect(Collectors.toSet());
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        AtomicInteger index = new AtomicInteger(1);
        result.forEach(item -> {
            if (StringUtil.isNotEmpty((CharSequence)item.getProductCode()) && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
            item.setNumber(String.valueOf(index.getAndIncrement()));
            if (Objects.isNull(item.getHeadFeeAmount())) {
                item.setHeadFeeAmount(BigDecimal.ZERO);
            }
            item.setHeadFeeAmount(item.getHeadFeeAmount().setScale(2, RoundingMode.HALF_UP));
            if (Objects.isNull(item.getDepartmentFeeAmount())) {
                item.setDepartmentFeeAmount(BigDecimal.ZERO);
            }
            item.setDepartmentFeeAmount(item.getDepartmentFeeAmount().setScale(2, RoundingMode.HALF_UP));
            if (Objects.isNull(item.getCustomerFeeAmount())) {
                item.setCustomerFeeAmount(BigDecimal.ZERO);
            }
            item.setCustomerFeeAmount(item.getCustomerFeeAmount().setScale(2, RoundingMode.HALF_UP));
            item.setTotalFee(item.getHeadFeeAmount().add(item.getDepartmentFeeAmount()).add(item.getCustomerFeeAmount()).setScale(2, RoundingMode.HALF_UP));
            item.setApplyFee(item.getHeadFeeAmount().add(item.getDepartmentFeeAmount()).setScale(2, RoundingMode.HALF_UP));
        });
        log.info("\u4e3b\u4f53\u6279\u590d\u5bf9\u8d26customerCode{}\u5355\u67e5\u8be2\u7ed3\u679c\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public String convert(String propertyName, ActivityDetailPlanItemVo propertyClass) {
        ReconciliationPropertyEnum.ReplyDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.ReplyDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        switch (detailPropertyEnum) {
            case number: {
                return Optional.ofNullable(propertyClass.getNumber()).orElse("");
            }
            case business_format: {
                return BusinessFormatEnum.getDesc((String)propertyClass.getBusinessFormatCode());
            }
            case business_unit: {
                return BusinessUnitEnum.getDesc((String)propertyClass.getBusinessUnitCode());
            }
            case customer_name: {
                return propertyClass.getCustomerName();
            }
            case sales_organization: {
                return propertyClass.getSalesInstitutionName();
            }
            case sales_region: {
                return propertyClass.getSalesRegionName();
            }
            case budget_project: {
                return propertyClass.getBudgetItemName();
            }
            case activity_form: {
                return propertyClass.getActivityFormName();
            }
            case brand: {
                return propertyClass.getProductBrandName();
            }
            case product: {
                return propertyClass.getProductName();
            }
            case expense_application: {
                return propertyClass.getApplyFee().toString();
            }
            case total_expenses: {
                return propertyClass.getTotalFee().toString();
            }
            case customer_bear: {
                return propertyClass.getCustomerFeeAmount().toString();
            }
            case start_time: {
                if (Objects.nonNull(propertyClass.getActivityBeginDate())) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityBeginDate());
                }
                return "";
            }
            case end_time: {
                if (Objects.nonNull(propertyClass.getActivityEndDate())) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityEndDate());
                }
                return "";
            }
            case remarks: {
                return propertyClass.getRemark();
            }
        }
        return "";
    }

    public String convertHead(String propertyName, List<Object> propertyList) {
        if (CollectionUtils.isEmpty(propertyList) || !(propertyList.get(0) instanceof ActivityDetailPlanItemVo)) {
            return "";
        }
        List<Object> itemVos = propertyList;
        if (CollectionUtils.isEmpty(itemVos)) {
            return "";
        }
        ReconciliationPropertyHeadEnum.ReplyHeadPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.ReplyHeadPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(headPropertyEnum)) {
            return "";
        }
        switch (headPropertyEnum) {
            case year_month: {
                if (Objects.nonNull(((ActivityDetailPlanItemVo)itemVos.get(0)).getActivityBeginDate())) {
                    return DateUtil.format((Date)((ActivityDetailPlanItemVo)itemVos.get(0)).getActivityBeginDate(), (String)"yyyy-MM");
                }
            }
            case customer_name: {
                return ((ActivityDetailPlanItemVo)itemVos.get(0)).getCustomerName();
            }
            case total_expenses: {
                return itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemBase::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            }
            case total_expenses_application: {
                return itemVos.stream().filter(Objects::nonNull).map(x -> NumberUtil.add((Number)x.getDepartmentFeeAmount(), (Number)x.getHeadFeeAmount())).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            }
            case customer_bear_total: {
                return itemVos.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemBase::getCustomerFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }
}

