/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReplySubReconciliationHeadVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReplySubForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy<SubComActivityDetailPlanItemVo> {
    private static final Logger log = LoggerFactory.getLogger(ReplySubForAbstractReconciliation.class);
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.APPROVAL.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SUB_DETAIL.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto dto) {
        SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto = new SubComActivityDetailPlanItemDto();
        subComActivityDetailPlanItemDto.setActivityBeginTime(dto.getStartDateTime());
        subComActivityDetailPlanItemDto.setActivityEndTime(dto.getEndDateTime());
        subComActivityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComActivityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        ArrayList<String> activityDetailStatusList = new ArrayList<String>();
        activityDetailStatusList.add(ActivityStatusEnum.PASS.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.END.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_REJECT.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_RECOVER.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode());
        subComActivityDetailPlanItemDto.setActivityDetailStatusList(activityDetailStatusList);
        subComActivityDetailPlanItemDto.setCustomerCode(dto.getCustomerCode());
        log.info("\u751f\u6210\u6279\u590d\u5bf9\u8d26\u5355\u5206\u5b50\u5ba2\u6237\u6d3b\u52a8\uff0c\u67e5\u8be2\u53c2\u6570:{}", (Object)subComActivityDetailPlanItemDto);
        Set set = this.subComActivityDetailPlanItemVoService.findCustomer(subComActivityDetailPlanItemDto);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        map.put(BusinessUnitEnum.SON_COMPANY.getCode(), set);
        log.info("\u751f\u6210\u6279\u590d\u5bf9\u8d26\u5355\u5206\u5b50\u5ba2\u6237\u6d3b\u52a8\uff0c\u5ba2\u6237\u4fe1\u606f:{}", map);
        return map;
    }

    public List<SubComActivityDetailPlanItemVo> findDateList(ReconciliationGenerateDto dto, String customerCode) {
        List productVoList;
        log.info("\u5206\u5b50\u6279\u590d\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570customerCode{},\u53c2\u6570[{}]", (Object)customerCode, (Object)JSON.toJSONString((Object)dto));
        SubComActivityDetailPlanItemDto subComActivityDetailPlanItemDto = new SubComActivityDetailPlanItemDto();
        subComActivityDetailPlanItemDto.setActivityBeginTime(dto.getStartDateTime());
        subComActivityDetailPlanItemDto.setActivityEndTime(dto.getEndDateTime());
        subComActivityDetailPlanItemDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComActivityDetailPlanItemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
            String[] split = customerCode.split("-");
            subComActivityDetailPlanItemDto.setSubReconciliationCustomerCode(split[0]);
            if (split.length > 1) {
                subComActivityDetailPlanItemDto.setSubReconciliationInstitutionCode(split[1]);
            }
        }
        ArrayList<String> activityDetailStatusList = new ArrayList<String>();
        activityDetailStatusList.add(ActivityStatusEnum.PASS.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.END.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_REJECT.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_RECOVER.getCode());
        activityDetailStatusList.add(ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode());
        subComActivityDetailPlanItemDto.setActivityDetailStatusList(activityDetailStatusList);
        List result = this.subComActivityDetailPlanItemVoService.findByCustomerCode(subComActivityDetailPlanItemDto);
        Set productCodeSet = result.stream().filter(k -> StringUtil.isNotEmpty((CharSequence)k.getProductCode())).map(SubComActivityDetailPlanItemVo::getProductCode).collect(Collectors.toSet());
        HashMap productVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(productCodeSet) && CollectionUtil.isNotEmpty((Collection)(productVoList = this.productVoService.findDetailsByProductCodes(new ArrayList(productCodeSet))))) {
            productVoMap.putAll(productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n)));
        }
        Set itemCodes = result.stream().map(SubComActivityDetailPlanItemVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List budgetItemVoList = this.budgetItemService.listByCodes(new ArrayList(itemCodes));
        Map<String, String> itemVoMap = budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, BudgetItemVo::getBudgetItemName));
        result.forEach(item -> {
            item.setBudgetItemName((String)itemVoMap.get(item.getBudgetItemCode()));
            if (StringUtil.isNotEmpty((CharSequence)item.getProductCode()) && productVoMap.containsKey(item.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(item.getProductCode());
                item.setProductName(productVo.getProductName());
                item.setProductBrandCode(productVo.getProductBrandCode());
                item.setProductBrandName(productVo.getProductBrandName());
                item.setProductCategoryCode(productVo.getProductCategoryCode());
                item.setProductCategoryName(productVo.getProductCategoryName());
            }
        });
        log.info("\u5206\u5b50\u6279\u590d\u5bf9\u8d26customerCode{}\u5355\u67e5\u8be2\u7ed3\u679c\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public String convert(String propertyName, SubComActivityDetailPlanItemVo propertyClass) {
        ReconciliationPropertyEnum.ReplyDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.ReplyDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        switch (detailPropertyEnum) {
            case channel_name: {
                return Optional.ofNullable(propertyClass.getChannelName()).orElse("");
            }
            case department_name: {
                return Optional.ofNullable(propertyClass.getDepartmentName()).orElse("");
            }
            case customer_name: {
                return Optional.ofNullable(propertyClass.getCustomerName()).orElse("");
            }
            case activity_form: {
                return Optional.ofNullable(propertyClass.getActivityFormName()).orElse("");
            }
            case budget_project: {
                return Optional.ofNullable(propertyClass.getBudgetItemName()).orElse("");
            }
            case product: {
                return Optional.ofNullable(propertyClass.getProductName()).orElse("");
            }
            case activity_intensity: {
                return Optional.ofNullable(propertyClass.getActivityIntensity()).orElse("");
            }
            case start_time: {
                if (propertyClass.getActivityBeginTime() != null) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityBeginTime());
                }
                return "";
            }
            case end_time: {
                if (propertyClass.getActivityEndTime() != null) {
                    return DateUtil.formatDate((Date)propertyClass.getActivityEndTime());
                }
                return "";
            }
            case total_cost: {
                return Optional.ofNullable(propertyClass.getTotalCost()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP).toPlainString();
            }
        }
        return "";
    }

    public String convertHead(String propertyName, List<Object> propertyList) {
        if (CollectionUtils.isEmpty(propertyList)) {
            return "";
        }
        ReplySubReconciliationHeadVo headVo = (ReplySubReconciliationHeadVo)propertyList.get(0);
        ReconciliationPropertyHeadEnum.ReplySubHeadPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.ReplySubHeadPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(headVo) || Objects.isNull(headPropertyEnum)) {
            return "";
        }
        switch (headPropertyEnum) {
            case reply_sub_item_name: {
                return Optional.ofNullable(headVo.getProjectName()).orElse("");
            }
            case reply_sub_amount: {
                return Objects.nonNull(headVo.getAmount()) ? headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : "";
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap<String, String> linkedHashMap) {
    }
}

