/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.reconciliation.doc.list.local.strategy.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.vo.SapForReconciliationPdfHeadVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationGenerateDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationBuesinssTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationPropertyHeadEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums.ReconciliationTypeEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.SapReconciliationService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.strategy.AbstractReconciliationGenerateStrategy;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SapForAbstractReconciliation
extends AbstractReconciliationGenerateStrategy {
    private static final Logger log = LoggerFactory.getLogger(SapForAbstractReconciliation.class);
    @Autowired(required=false)
    private SapReconciliationService sapReconciliationService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public String getReconciliationType() {
        return ReconciliationTypeEnum.COMMUNICATION.getCode();
    }

    public String getBusinessType() {
        return ReconciliationBuesinssTypeEnum.SAP.getCode();
    }

    public Map<String, Set<String>> findCustomerCodes(ReconciliationGenerateDto reconciliationGenerateDto) {
        SapReconciliationDto dto = new SapReconciliationDto();
        dto.setCustomerCode(reconciliationGenerateDto.getCustomerCode());
        dto.setStartDateStr(DateUtil.format((Date)reconciliationGenerateDto.getStartDateTime(), (String)"yyyyMMdd"));
        dto.setEndDateStr(DateUtil.format((Date)reconciliationGenerateDto.getEndDateTime(), (String)"yyyyMMdd"));
        dto.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        dto.setCustomerCode(reconciliationGenerateDto.getCustomerCode());
        log.info("\u751f\u6210\u5f80\u6765\u5bf9\u8d26\u5355\u5355\u5ba2\u6237SAP\uff0c\u67e5\u8be2\u53c2\u6570:{}", (Object)dto);
        Set set = this.sapReconciliationService.findCustomer(dto);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reconciliationGenerateDto.getBusinessUnitCode())) {
            map.put(BusinessUnitEnum.SON_COMPANY.getCode(), set);
        } else {
            map.put(BusinessUnitEnum.HEADQUARTERS.getCode(), set);
        }
        log.info("\u751f\u6210\u5f80\u6765\u5bf9\u8d26\u5355\u5355\u5ba2\u6237SAP\uff0c\u5ba2\u6237\u4fe1\u606f:{}", (Object)dto);
        return map;
    }

    public List<SapReconciliationVo> findDateList(ReconciliationGenerateDto reconciliationGenerateDto, String customerCode) {
        SapReconciliationDto dto = new SapReconciliationDto();
        log.info("SAP\u5f80\u6765\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570customerCode{},\u53c2\u6570[{}]", (Object)customerCode, (Object)JSON.toJSONString((Object)dto));
        if (StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)reconciliationGenerateDto.getBusinessUnitCode())) {
            if (StringUtils.isNotEmpty((CharSequence)customerCode)) {
                String[] split = customerCode.split("-");
                dto.setSubReconciliationCustomerCode(split[0]);
                if (split.length > 1) {
                    dto.setSubReconciliationInstitutionCode(split[1]);
                }
            }
        } else {
            dto.setCustomerCode(customerCode);
        }
        dto.setStartDateStr(DateUtil.format((Date)reconciliationGenerateDto.getStartDateTime(), (String)"yyyyMMdd"));
        dto.setEndDateStr(DateUtil.format((Date)reconciliationGenerateDto.getEndDateTime(), (String)"yyyyMMdd"));
        dto.setBusinessFormatCode(reconciliationGenerateDto.getBusinessFormatCode());
        dto.setBusinessUnitCode(reconciliationGenerateDto.getBusinessUnitCode());
        dto.setYearMonthLy(com.biz.crm.mn.common.base.util.DateUtil.format((Date)reconciliationGenerateDto.getStartDateTime(), (String)"yyyy-MM"));
        log.info("SAP\u5f80\u6765\u5bf9\u8d26\u67e5\u8be2\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List result = this.sapReconciliationService.findListByCustomerCode(dto);
        log.info("SAP\u5f80\u6765\u5bf9\u8d26customerCode{}\u5355\u67e5\u8be2\u7ed3\u679c\u3010{}\u3011", (Object)customerCode, (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public String convert(String propertyName, Object propertyClass) {
        ReconciliationPropertyEnum.SapDetailPropertyEnum detailPropertyEnum = ReconciliationPropertyEnum.SapDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(detailPropertyEnum) || Objects.isNull(propertyClass)) {
            return "";
        }
        SapReconciliationVo vo = (SapReconciliationVo)propertyClass;
        switch (detailPropertyEnum) {
            case sap_vtext: {
                return vo.getVtext();
            }
            case sap_kunrg: {
                return vo.getKunrg();
            }
            case sap_kunag_txt: {
                return vo.getKunagTxt();
            }
            case sap_fkdat: {
                return vo.getFkdat();
            }
            case sap_zdoc_name: {
                return vo.getZdocName();
            }
            case sap_zsh: {
                return vo.getZsh();
            }
            case sap_zfkfs: {
                return vo.getZfkfs();
            }
            case sap_zyszk_bdyy: {
                return vo.getZyszkBdyy();
            }
            case sap_vbeln: {
                return vo.getVbeln();
            }
            case sap_posnr: {
                return vo.getPosnr();
            }
            case sap_pstyv: {
                return vo.getPstyv();
            }
            case sap_belnr: {
                return vo.getBelnr();
            }
            case sap_aubel: {
                return vo.getAubel();
            }
            case sap_vgbel: {
                return vo.getVgbel();
            }
            case sap_arktx: {
                return vo.getArktx();
            }
            case sap_matnr: {
                return vo.getMatnr();
            }
            case sap_netwr_hs: {
                return vo.getNetwrHs();
            }
            case sap_netwr_zk: {
                return vo.getNetwrZk();
            }
            case sap_ratio: {
                return vo.getRatio();
            }
            case sap_fkimg: {
                return vo.getFkimg();
            }
            case sap_vrkme: {
                return vo.getVrkme();
            }
            case sap_fklmg: {
                return vo.getFklmg();
            }
            case sap_meins: {
                return vo.getMeins();
            }
            case sap_kzwi6: {
                return vo.getKzwi6();
            }
            case sap_kzwi1: {
                return vo.getKzwi1();
            }
            case sap_zysye: {
                return vo.getZysye();
            }
            case sap_zsdfy: {
                return vo.getZsdfy();
            }
            case sap_zk01: {
                return vo.getZk01();
            }
            case sap_zfpfy: {
                return vo.getZfpfy();
            }
            case sap_kunwe: {
                return vo.getKunwe();
            }
            case sap_kunwe_txt: {
                return vo.getKunweTxt();
            }
            case sap_bstnk: {
                return vo.getBstnk();
            }
            case sap_prctr: {
                return vo.getPrctr();
            }
        }
        return "";
    }

    public void convertTail(LinkedHashMap linkedHashMap) {
    }

    public String convertHead(String propertyName, List propertyList) {
        ReconciliationPropertyHeadEnum.SapDetailPropertyEnum headPropertyEnum = ReconciliationPropertyHeadEnum.SapDetailPropertyEnum.codeToEnum((String)propertyName);
        if (Objects.isNull(headPropertyEnum) || CollectionUtils.isEmpty((Collection)propertyList)) {
            return "";
        }
        SapForReconciliationPdfHeadVo headVo = (SapForReconciliationPdfHeadVo)propertyList.get(0);
        if (Objects.isNull(headVo)) {
            return "";
        }
        BigDecimal amount = Objects.nonNull(headVo.getAmount()) ? headVo.getAmount() : BigDecimal.ZERO;
        switch (headPropertyEnum) {
            case sap_item_name: {
                return headVo.getName();
            }
            case sap_order: {
                return headVo.getIndex();
            }
            case sap_amount: {
                return Objects.nonNull(headVo.getAmount()) ? headVo.getAmount().setScale(2, RoundingMode.HALF_UP).toPlainString() : "";
            }
        }
        return "";
    }
}

