package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.constant;


/**
 * 对账单据编码常量
 *
 * @author : youjun
 * @date : 2022-11-17
 */
public interface ReconciliationConstant {

    /**
     * 最大循环次数
     */
    Integer LOOP_TIMES_MAX = 10000;
    /**
     * 最大重复执行次数
     */
    Integer RETRY_TIMES_MAX = 3;

    /**
     * 对账单据编码前缀
     */
    String RECONCILIATION_CODE = "DZ";


    /**
     * 对账单新增redis,锁
     */
    String REDIS_LOCK = "audit:reconciliation:lock:";

    /**
     * 对账单新增失败补偿redis,锁
     */
    String REDIS_FAIL_LOCK = "audit:reconciliation:lock:fail:";

    /**
     * 发送者
     */
    String SENDER_TPM = "TPM";

    /**
     * 接受者
     */
    String RECEIVER_ECC = "ECC";

    /**
     * 考核扣款
     */
    String TPM_EXAMINE_CIRCULAR = "考核扣款";

    /**
     * 考核类型字典
     */
    String EXAMINE_CIRCULAR_EXAMINE_TYPE = "examine_circular_examine_type";

    /**
     * RTM模式
     */
    String MDM_RTX_MODEL = "mdm_rtx_model";

    /**
     * 批复金额合计
     */
    String TOTAL_COST = "批复金额合计";

    String TEMPLATE_TYPE = "Z321";

    /**
     * 同步105数据销售组织编码
     */
    String SYNC_105_SALES_ORG_CODE = "sync_105_sales_org_code";

    /**
     * 同步123数据销售组织编码
     */
    String SYNC_123_SALES_ORG_CODE = "sync_123_sales_org_code";

    /**
     * 同步123数据渠道编码
     */
    String SYNC_123_CHANNEL_CODE = "sync_123_channel_code";

    /**
     * 同步123数据利润中心
     */
    String SYNC_123_PROFIT_CENTER = "sync_123_profit_center";

    /**
     * 拉取123数据定时任务锁
     */
    String RECONCILIATION_SYNC_123_JOB = "reconciliation_sync_123_job:lock:";

    /**
     * 150接口名称
     */
    String SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT = "SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT";

    /**
     * 期初余额
     */
    String BEGIN_PERIOD_BALANCE = "期初余额";

    /**
     * 本期回款
     */
    String THIS_PERIOD_BACK_MONEY = "本期货款金额";

    /**
     * 费用报销上账
     */
    String EXPENSE_REIMBURSE_UP_ACCOUNT = "费用报销上账";

    /**
     * 本期进货金额
     */
    String THIS_PERIOD_STOCK_IN_AMOUNT = "本期进货金额";

    /**
     * 本期销售折扣
     */
    String THIS_PERIOD_SALES_DISCOUNT = "本期销售折扣";

    /**
     * 期末余额
     */
    String END_PERIOD_BALANCE = "期末余额";

    /**
     * 保证金金额
     */
    String EARNEST_MONEY = "保证金金额";

    /**
     * 期初折扣池余额
     */
    String BEGIN_PERIOD_DISCOUNT_POOL_BALANCE = "期初折扣池余额①";

    /**
     * 本期处理费用
     */
    String THIS_PERIOD_HANDLE_AMOUNT = "费用②";

    String DEDUCTION_AMOUNT = "考核扣款金额⑥";

    String EXAMINE_ACCOUNT = "考核上账金额⑦";

    /**
     * 本月应处理费用
     */
    String THIS_MONTH_SHOULD_HANDLE_AMOUNT = "本月应处理费用②";

    /**
     * 本月实际折扣金额
     */
    String THIS_MONTH_ACTUAL_DISCOUNT_AMOUNT = "本月实际折扣金额③";

    /**
     * 本月发票报销金额
     */
    String THIS_MONTH_INVOICE_REIMBURSE_AMOUNT = "本月发票报销金额④";

    /**
     * 费用转移
     */
    String COST_TRANSFER = "费用转移⑤";

    /**
     * 期末费用池余额
     */
    String END_PERIOD_FEE_POOL_BALANCE = "期末费用池余额⑧=①+②-③-④+⑤-⑥+⑦";

    /**
     * 事中费用合计
     */
    String IN_PROCESS_EXPENSE_TOTAL = "本月事中费用金额";

    /**
     * 其他核对项
     */
    String OTHER_CHECK_ITEM = "其他核对项";

    /**
     * 事中
     */
    String IN_PROCESS = "1";

    /**
     * 批复合计金额
     */
    String APPROVE_TOTAL_AMOUNT = "批复合计金额";

    /**
     * 短横线
     */
    String SHORT_LINE = "-";
}
