package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * TPM-对账单据关联数据dto
 *
 * @author liuyifan
 * @date 2023-02-20 14:50:59
 */
@Data
@ApiModel(value = "ReconciliationCorrelationDto", description = "TPM-对账单据关联数据dto")
public class ReconciliationCorrelationDto extends TenantFlagOpDto {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    private String statementCode;


    /**
     * 对账单类型
     */
    @ApiModelProperty(name = "accountReconciliationType",value = "对账单类型",notes = "对账单类型")
    private String accountReconciliationType;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType",value = "业务类型",notes = "业务类型")
    private String businessType;

    /**
     * 关联数据编码ID
     */
    @ApiModelProperty(name = "associative_date",value = "关联数据编码ID",notes = "关联数据编码ID")
    private String associativeDate;

}
