package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReconciliationDocListTaskDto {

    @ApiModelProperty(value = "businessFormatCode", notes = "业态编码")
    private String businessFormatCode;

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "startDate", notes = "计算开始时间")
    private Date startDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "endDate", notes = "计算结束时间")
    private Date endDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "calculationTime", notes = "计算时间")
    private Date calculationTime;


    @ApiModelProperty(name = "accountReconciliationRuleCode",value = "对账规则编码",notes = "对账规则编码")
    private String accountReconciliationRuleCode;

    @ApiModelProperty(name = "accountReconciliationType",value = "对账类型", notes = "")
    private String accountReconciliationType;


    @ApiModelProperty(value = "customerCode", notes = "客户编码")
    private String customerCode;
}
