package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liuyifan
 */

@Data
@ApiModel(value = "ReconciliationGenerateDto", description = "TPM-生成对账单据dto参数")
public class ReconciliationGenerateDto {

    @ApiModelProperty("是否为小业务单元")
    private boolean smallBusinessUnit;

    @ApiModelProperty(name = "accountReconciliationRuleCode",value = "对账规则编码",notes = "对账规则编码")
    private String accountReconciliationRuleCode;
    /**
     * 业态编码
     */
    @ApiModelProperty(value = "业态编码", notes = "")
    private String businessFormatCode;


    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    private String businessUnitCode;

    @ApiModelProperty(value = "对账类型", notes = "")
    private String accountReconciliationType;


    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "计算开始时间", notes = "")
    private String startDate;


    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "计算结束时间", notes = "")
    private String endDate;


    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "计算开始时间", notes = "")
    private Date startDateTime;


    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "计算结束时间", notes = "")
    private Date endDateTime;

    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;
}
