package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntityDetail
 * @Description 分子结案对账单明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailSubAuditDto", description = "TPM-分子结案对账单明细表")
@Data
public class ReconciliationSummaryDataDisplayDetailSubAuditDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "channelCode",value = "渠道编码",notes = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构名称",notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "activityFormCode",value = "活动形式编码",notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName",value = "活动形式名称",notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName",value = "预算项目名称",notes = "预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("产品品牌编码")
    private String productBrandCode;

    @ApiModelProperty("产品品牌名称")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    private String productCategoryName;

    @ApiModelProperty("活动开始时间")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    private Date activityEndTime;

    @ApiModelProperty("批复金额")
    private BigDecimal approveAmount;

    @ApiModelProperty(name = "handling",value = "处理方式",notes = "处理方式")
    private String  handling;

    @ApiModelProperty(name = "currentHandleAmount",value = "本次应处理金额",notes = "本次应处理金额")
    private BigDecimal currentHandleAmount;
}
