package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntityDetail
 * @Description 分子往来对账单明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailSubCommunicateDto", description = "TPM-分子往来对账单明细表")
@Data
public class ReconciliationSummaryDataDisplayDetailSubCommunicateDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "vkorg",value = "销售机构",notes = "销售机构")
    private String vkorg;

    @ApiModelProperty("分销渠道")
    private String vtweg;

    @ApiModelProperty("渠道描述")
    private String vtext;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构名称",notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName",value = "预算项目名称",notes = "预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("产品品牌编码")
    private String productBrandCode;

    @ApiModelProperty("产品品牌名称")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    private String productCategoryName;

    @ApiModelProperty("售达方")
    private String kunrg;

    @ApiModelProperty("客户全称")
    private String kunagTxt;

    @ApiModelProperty("日期")
    private String fkdat;

    @ApiModelProperty("财务单据名称")
    private String zdocName;

    @ApiModelProperty("实收金额")
    private String zsh;

    @ApiModelProperty("付款方式")
    private String zfkfs;

    @ApiModelProperty("预收账款变动原因")
    private String zyszkBdyy;

    @ApiModelProperty("销售发票编号")
    private String vbeln;

    @ApiModelProperty("发票行项目")
    private String posnr;

    @ApiModelProperty("订单行项目类别")
    private String pstyv;

    @ApiModelProperty("订单行项目类别")
    private String pstyvT;

    @ApiModelProperty("会计凭证")
    private String belnr;

    @ApiModelProperty("销售订单编号")
    private String aubel;

    @ApiModelProperty("交货单编号")
    private String vgbel;

    @ApiModelProperty("商品")
    private String arktx;

    @ApiModelProperty("标准价")
    private String netwrHs;

    @ApiModelProperty("实际价")
    private String netwrZk;

    @ApiModelProperty("折扣率(%)")
    private String ratio;

    @ApiModelProperty("数量")
    private String fkimg;

    @ApiModelProperty("单位")
    private String vrkme;

    @ApiModelProperty("基本单位数量")
    private String fklmg;

    @ApiModelProperty("基本单位")
    private String meins;

    @ApiModelProperty("折扣金额")
    private String kzwi6;

    @ApiModelProperty("应收金额")
    private String kzwi1;

    @ApiModelProperty("应收余额")
    private String zysye;

    @ApiModelProperty("随单费用折扣值")
    private String zsdfy;

    @ApiModelProperty("发票固定折扣值")
    private String zk01;

    @ApiModelProperty("发票费用折扣值")
    private String zfpfy;

    @ApiModelProperty("商品编号")
    private String matnr;

    @ApiModelProperty("送达方")
    private String kunwe;

    @ApiModelProperty("送达方名称")
    private String kunweTxt;

    @ApiModelProperty("客户订单号")
    private String bstnk;

    @ApiModelProperty("利润中心")
    private String prctr;

}
