package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntity
 * @Description 对账单汇总数据展示
 * @AUTHOR WangJJ
 * @DATE 2023/5/24 14:34
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDto", description = "TPM-对账单汇总数据展示")
@Data
public class ReconciliationSummaryDataDisplayDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "reconciliationType",value = "对账单编码",notes = "对账单编码")
    private String statementCode;

    @ApiModelProperty(name = "reconciliationType",value = "对账单类型",notes = "对账单类型")
    private String reconciliationType;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "channelCode",value = "渠道编码",notes = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构名称",notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "customerErpCode",value = "ECRM客户编码",notes = "ECRM客户编码")
    private String customerErpCode;

    @ApiModelProperty(name = "reconciliationYearMonth",value = "对账年月",notes = "对账年月")
    private String reconciliationYearMonth;

    @ApiModelProperty(name = "thisMonthFeeTotalAmount",value = "本月费用合计金额（元）",notes = "本月费用合计金额（元）")
    private BigDecimal thisMonthFeeTotalAmount;

    @ApiModelProperty(name = "thisMonthFeeApplyAmount",value = "本月费用申请金额（元）",notes = "本月费用申请金额（元）")
    private BigDecimal thisMonthFeeApplyAmount;

    @ApiModelProperty(name = "thisMonthCustomerBearTotalAmount",value = "本月客户承担合计金额（元）",notes = "本月客户承担合计金额（元）")
    private BigDecimal thisMonthCustomerBearTotalAmount;

    @ApiModelProperty(name = "promotionTotalAmount",value = "报销合计金额",notes = "报销合计金额")
    private BigDecimal promotionTotalAmount;

    @ApiModelProperty(name = "discountTotalAmount",value = "折扣合计金额",notes = "折扣合计金额")
    private BigDecimal discountTotalAmount;

    @ApiModelProperty("报销和折扣合计金额")
    private BigDecimal promotionAndDiscountTotalAmount;

    @ApiModelProperty(name = "followCarAmount",value = "随车金额",notes = "随车金额")
    private BigDecimal followCarAmount;

    @ApiModelProperty(name = "examineCircularAmount",value = "考核扣款金额",notes = "考核扣款金额")
    private BigDecimal examineCircularAmount;

    @ApiModelProperty(name = "totalAmount",value = "合计金额",notes = "合计金额")
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "thisPeriodHandleAmount",value = "本期处理费用",notes = "本期处理费用")
    private BigDecimal thisPeriodHandleAmount;

    @ApiModelProperty(name = "inProcessExpenseTotal",value = "事中费用合计",notes = "事中费用合计")
    private BigDecimal inProcessExpenseTotal;

    @ApiModelProperty(name = "otherCheckItem",value = "其他核对项",notes = "其他核对项")
    private BigDecimal otherCheckItem;

    @ApiModelProperty(name = "beginPeriodDiscountPoolBalance",value = "期初折扣池余额",notes = "期初折扣池余额")
    private BigDecimal beginPeriodDiscountPoolBalance;

    @ApiModelProperty(name = "thisMonthShouldHandleAmount",value = "本月应处理费用",notes = "本月应处理费用")
    private BigDecimal thisMonthShouldHandleAmount;

    @ApiModelProperty(name = "thisMonthActualDiscountAmount",value = "本月实际折扣金额",notes = "本月实际折扣金额")
    private BigDecimal thisMonthActualDiscountAmount;

    @ApiModelProperty(name = "thisMonthInvoiceReimburseAmount",value = "本月发票报销金额",notes = "本月发票报销金额")
    private BigDecimal thisMonthInvoiceReimburseAmount;

    @ApiModelProperty(name = "endPeriodFeePoolBalance",value = "期末费用池余额",notes = "期末费用池余额")
    private BigDecimal endPeriodFeePoolBalance;

    @ApiModelProperty(name = "costTransfer",value = "费用转移",notes = "费用转移")
    private BigDecimal costTransfer;

    @ApiModelProperty(name = "beginPeriodBalance",value = "期初余额",notes = "期初余额")
    private BigDecimal beginPeriodBalance;

    @ApiModelProperty(name = "thisPeriodBackMoney",value = "本期回款",notes = "本期回款")
    private BigDecimal thisPeriodBackMoney;

    @ApiModelProperty(name = "expenseReimburseUpAccount",value = "费用报销上账",notes = "费用报销上账")
    private BigDecimal expenseReimburseUpAccount;

    @ApiModelProperty(name = "thisPeriodStockInAmount",value = "本期进货金额",notes = "本期进货金额")
    private BigDecimal thisPeriodStockInAmount;

    @ApiModelProperty(name = "thisPeriodSalesDiscount",value = "本期销售折扣",notes = "本期销售折扣")
    private BigDecimal thisPeriodSalesDiscount;

    @ApiModelProperty(name = "endPeriodBalance",value = "期末余额",notes = "期末余额")
    private BigDecimal endPeriodBalance;

    @ApiModelProperty(name = "earnestMoney",value = "保证金金额",notes = "保证金金额")
    private BigDecimal earnestMoney;

    @ApiModelProperty("hr组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty(name = "detailHeadApproveDtos",value = "主体批复明细集合",notes = "主体批复明细集合")
    private List<ReconciliationSummaryDataDisplayDetailHeadApproveDto> detailHeadApproveDtos;

    @ApiModelProperty(name = "detailHeadAuditDtos",value = "主体结案明细集合",notes = "主体结案明细集合")
    private List<ReconciliationSummaryDataDisplayDetailHeadAuditDto> detailHeadAuditDtos;

    @ApiModelProperty(name = "detailSubApproveDtos",value = "分子批复明细集合",notes = "分子批复明细集合")
    private List<ReconciliationSummaryDataDisplayDetailSubApproveDto> detailSubApproveDtos;

    @ApiModelProperty(name = "detailSubAuditDtos",value = "分子结案明细集合",notes = "分子结案明细集合")
    private List<ReconciliationSummaryDataDisplayDetailSubAuditDto> detailSubAuditDtos;

    @ApiModelProperty(name = "detailSubCommunicateDtos",value = "分子往来明细集合",notes = "分子往来明细集合")
    private List<ReconciliationSummaryDataDisplayDetailSubCommunicateDto> detailSubCommunicateDtos;

    @ApiModelProperty(name = "distributionReconciliationHead",value = "分销对账汇总",notes = "分销对账汇总")
    private LinkedHashMap<String, String> distributionReconciliationHeadMap;

}
