package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "SAP对账数据dto")
@Data
public class SapReconciliationDto extends TenantFlagOpDto {

    private String startDateStr;

    private String endDateStr;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "售达方编码",notes = "售达方编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "售达方名称",notes = "售达方名称")
    private String customerName;

    @ApiModelProperty("售达方")
    private String kunrg;

    @ApiModelProperty("售达方名称")
    private String kunagTxt;

    @ApiModelProperty(name = "arktx",value = "产品编码",notes = "产品编码")
    private String matnr;

    @ApiModelProperty(name = "arktx",value = "产品名称",notes = "产品名称")
    private String arktx;

    @ApiModelProperty(name = "yearMonthLy",value = "对账年月",notes = "对账年月")
    private String yearMonthLy;

    @ApiModelProperty(name = "kunwe",value = "送达方编码",notes = "送达方编码")
    private String kunwe;

    @ApiModelProperty(name = "kunweTxt",value = "送达方名称",notes = "送达方名称")
    private String kunweTxt;

    /**
     * 业务单元
     */
    private String businessUnitCode;

    /**
     * 业态
     */
    private String businessFormatCode;


    //对账单使用字段，勿动
    @ApiModelProperty(name = "分子对账单查询客户编码（终端编码）", notes = "终端编码")
    private String subReconciliationCustomerCode;
    @ApiModelProperty(name = "分子对账单查询销售机构编码（销售机构编码短码）", notes = "销售机构编码短码")
    private String subReconciliationInstitutionCode;
}
