package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

@Getter
@AllArgsConstructor
public enum ReconciliationBuesinssTypeEnum {

    AUDIT("audit","核销"),
    SUB_DETAIL("sub_detail", "分子公司明细"),
    DETAIL("detail","主体公司明细"),
    SAP("sap","sap"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        for (ReconciliationBuesinssTypeEnum value : values()) {
            codes.add(value.getCode());
        }
        return codes;
    }

    public static ReconciliationBuesinssTypeEnum findByBusinessUnitCode(String businessUnitCode){
        if (StringUtils.isEmpty(businessUnitCode)){
            return null;
        }
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(businessUnitCode);
        switch (businessUnitEnum){
            case SON_COMPANY:
                return ReconciliationBuesinssTypeEnum.SUB_DETAIL;
            case HEADQUARTERS:
            case FRESH_MILK:
                return ReconciliationBuesinssTypeEnum.DETAIL;
            case ONLINE:
                return ReconciliationBuesinssTypeEnum.AUDIT;
            default:
                return null;
        }
    }

    public static ReconciliationBuesinssTypeEnum codeToEnum(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (ReconciliationBuesinssTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public static String getDesc(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (ReconciliationBuesinssTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value.getDes();
            }
        }
        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        for (ReconciliationBuesinssTypeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
