package com.biz.crm.tpm.business.reconciliation.doc.list.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

public class ReconciliationPropertyEnum {

    public enum ReplyDetailPropertyEnum {
        number("number", "序号"),
        business_format("business_format", "业态"),
        business_unit("business_unit", "业务单元"),
        customer_name("customer_name", "客户名称"),
        sales_organization("sales_organization", "销售机构"),
        sales_region("sales_region", "销售大区"),
        sales_province("sales_province", "销售省区"),
        budget_project("budget_project", "预算项目名称"),
        activity_form("activity_form", "活动形式名称"),
        brand("brand", "品牌"),
        product("product", "产品名称"),
        total_expenses("total_expenses", "费用合计（元）"),
        expense_application("expense_application", "费用申请（元）"),
        customer_bear("customer_bear", "客户承担金额（元）"),
        start_time("start_time", "活动开始时间"),
        end_time("end_time", "活动结束时间"),
        remarks("remarks", "备注"),
        channel_name("channel_name", "渠道"),
        department_name("department_name", "部门"),
        activity_intensity("activity_intensity", "活动内容"),
        total_cost("total_cost", "批复金额"),

        ;

        @EnumValue
        @JsonValue
        private String code;
        private String des;

        ReplyDetailPropertyEnum(String code, String des) {
            this.code = code;
            this.des = des;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.des;
        }

        public static ReplyDetailPropertyEnum codeToEnum(String code) {
            ReplyDetailPropertyEnum calculationRules = null;
            ReplyDetailPropertyEnum[] var2 = values();
            int var3 = var2.length;

            for (int var4 = 0; var4 < var3; ++var4) {
                ReplyDetailPropertyEnum calculationRulesEnum = var2[var4];
                if (calculationRulesEnum.code.equals(code)) {
                    calculationRules = calculationRulesEnum;
                }
            }

            return calculationRules;
        }
    }

    public enum AuditDetailPropertyEnum {

        audit_number("audit_number","序号"),
        audit_customerName("audit_customerName","客户名称"),
        audit_firstChannelName("audit_firstChannelName","一级管理渠道"),
        audit_secondChannelName("audit_secondChannelName","二级管理渠道名称"),
        audit_center("audit_center","中心"),
        audit_businessFormatCode("audit_businessFormatCode","业态"),
        audit_businessUnitCode("audit_businessUnitCode","业务单元"),
        audit_salesInstitutionName("audit_salesInstitutionName","销售机构"),
        audit_salesOrgRegionName("audit_salesOrgRegionName","销售大区"),
        audit_salesOrgProvinceName("audit_salesOrgProvinceName","销售省区"),
        audit_budgetProjectName("audit_budgetProjectName","預算項目"),
        audit_brand_Txt("audit_brand_Txt","品牌"),
        audit_productName("audit_productName","产品名称"),
        audit_activityFormName("audit_activityFormName","活动形式"),
        audit_activityBeginDate("audit_activityBeginDate","活动开始时间"),
        audit_activityEndDate("audit_activityEndDate","活动结束时间"),
        audit_description("audit_description","形式说明"),
        audit_dealerBearFee("audit_dealerBearFee","经销商承担费用（元）"),
        audit_approvedAmount("audit_approvedAmount","批复金额（元）"),
        audit_closingAmount("audit_closingAmount","本次应结案金额（元）"),
        audit_taxQuota("audit_taxQuota","扣税金額（元）"),
        audit_finalClosingAmount("audit_finalClosingAmount","本次实际结案金额（元）"),
        audit_discountTaxTotalAmount("audit_discountTaxTotalAmount","折扣金額（元）"),
        audit_reimburse_TaxAmount("audit_reimburse_TaxAmount","报销金额（元）"),
        create_name("create_name","起草人"),
        examine_circular_amount("examine_circular_amount","考核扣款"),
        process_title("process_title","便签名称"),
        method_accounting("method_accounting","上账"),
        up_account_code("up_account_code","上账单号"),
        ;
        @EnumValue
        @JsonValue
        private String code;
        private String des;

        AuditDetailPropertyEnum(String code, String des) {
            this.code = code;
            this.des = des;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.des;
        }

        public static AuditDetailPropertyEnum codeToEnum(String code) {
            AuditDetailPropertyEnum calculationRules = null;
            AuditDetailPropertyEnum[] var2 = values();
            int var3 = var2.length;

            for (int var4 = 0; var4 < var3; ++var4) {
                AuditDetailPropertyEnum calculationRulesEnum = var2[var4];
                if (calculationRulesEnum.code.equals(code)) {
                    calculationRules = calculationRulesEnum;
                }
            }

            return calculationRules;
        }
    }

    public enum SapDetailPropertyEnum {
        sap_vtext("sap_vtext","渠道"),
        sap_kunrg("sap_kunrg","售达方"),
        sap_kunag_txt("sap_kunag_txt","客户全称"),
        sap_fkdat("sap_fkdat","日期"),
        sap_zdoc_name("sap_zdoc_name","财务单据名称"),
        sap_zsh("sap_zsh","实收金额"),
        sap_zfkfs("sap_zfkfs","付款方式"),
        sap_zyszk_bdyy("sap_zyszk_bdyy","预收账款变动原因"),
        sap_vbeln("sap_vbeln","销售发票编号"),
        sap_posnr("sap_posnr","发票行项目"),
        sap_pstyv("sap_pstyv","订单行项目类别"),
        sap_belnr("sap_belnr","会计凭证"),
        sap_aubel("sap_aubel","销售订单编号"),
        sap_vgbel("sap_vgbel","交货单编号"),
        sap_arktx("sap_arktx","商品"),
        sap_matnr("sap_matnr","商品编号"),
        sap_netwr_hs("sap_netwr_hs","标准价"),
        sap_netwr_zk("sap_netwr_zk","实际价"),
        sap_ratio("sap_ratio","折扣率"),
        sap_fkimg("sap_fkimg","数量"),
        sap_vrkme("sap_vrkme","单位"),
        sap_fklmg("sap_fklmg","基本单位数量"),
        sap_meins("sap_meins","基本单位"),
        sap_kzwi6("sap_kzwi6","折扣金额"),
        sap_kzwi1("sap_kzwi1","应收金额"),
        sap_zysye("sap_zysye","应收余额"),
        sap_zsdfy("sap_zsdfy","随单费用折扣值"),
        sap_zk01("sap_zk01","发票固定折扣值"),
        sap_zfpfy("sap_zfpfy","发票费用折扣值"),
        sap_kunwe("sap_kunwe","送达方"),
        sap_kunwe_txt("sap_kunwe_txt","送达方名称"),
        sap_bstnk("sap_bstnk","客户订单号"),
        sap_prctr("sap_prctr","利润中心"),
        ;

        @EnumValue
        @JsonValue
        private String code;
        private String des;

        SapDetailPropertyEnum(String code, String des) {
            this.code = code;
            this.des = des;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.des;
        }

        public static SapDetailPropertyEnum codeToEnum(String code) {
            SapDetailPropertyEnum calculationRules = null;
            SapDetailPropertyEnum[] var2 = values();
            int var3 = var2.length;

            for (int var4 = 0; var4 < var3; ++var4) {
                SapDetailPropertyEnum calculationRulesEnum = var2[var4];
                if (calculationRulesEnum.code.equals(code)) {
                    calculationRules = calculationRulesEnum;
                }
            }

            return calculationRules;
        }
    }

    public enum AuditSubDetailPropertyEnum {
        audit_sub_channel("audit_sub_channel","渠道"),
        audit_sub_sale_org("audit_sub_sale_org","销售组"),
        audit_sub_customer("audit_sub_customer","客户名称"),
        audit_sub_activity_form_name("audit_sub_activity_form_name","活动形式"),
        head_budget_item_name("head_budget_item_name","预算名称"),
        product_name("product_name","产品名称"),
        start_date("start_date","活动开始日期"),
        end_date("end_date","活动结束日期"),
        approved_amount("approved_amount","批复金额"),
        end_case_form("end_case_form","结案形式"),
        amount("amount","本期应处理金额"),
        remark("remark","备注"),
        audit_activity_name("audit_activity_name","活动名称"),
        audit_way("audit_way","核销方式"),
        ;

        @EnumValue
        @JsonValue
        private String code;
        private String des;

        AuditSubDetailPropertyEnum(String code, String des) {
            this.code = code;
            this.des = des;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.des;
        }

        public static AuditSubDetailPropertyEnum codeToEnum(String code) {
            AuditSubDetailPropertyEnum calculationRules = null;
            AuditSubDetailPropertyEnum[] var2 = values();
            int var3 = var2.length;

            for (int var4 = 0; var4 < var3; ++var4) {
                AuditSubDetailPropertyEnum calculationRulesEnum = var2[var4];
                if (calculationRulesEnum.code.equals(code)) {
                    calculationRules = calculationRulesEnum;
                }
            }

            return calculationRules;
        }
    }

    public enum DistributionAuditDetailPropertyEnum {
        year_month("year_month1", "年月"),
        customer_code("customer_code1", "客户编码"),
        customer_name("customer_name1", "客户名称"),
        product_code("product_code1","产品编码"),
        product_name("product_name1","产品名称"),
        supply_price("supply_price","供货价"),
        month_sale_quantity("month_sale_quantity","销售数量"),
        month_sale_amount("month_sale_amount","订货金额"),
        audit_quantity("audit_quantity","核销数量"),
        bound_gift_sale_quantity("bound_gift_sale_quantity","组合装数量"),
        base_quantity("base_quantity","基础数量"),
        combination_fee("combination_fee","组合装费用"),
        distribution_base_ten("distribution_base_ten","基础旬返费用"),
        goal_achievement("goal_achievement","基础目标返费用"),
        month("month","基础月返（基础运营返）"),
        staff_fee("staff_fee","实际人员返点"),
        logistics_quantity("logistics_quantity","实际核销物流数量"),
        logistics("logistics","物流返点费用"),
        quarter("quarter","季返"),
        other_cooperation("other_cooperation","其它支持1"),
        other_cooperation_two("other_cooperation_two","其它支持2"),
        fine("fine","罚款金额"),
        last_month_account("last_month_account","上月已上账"),
        month_account("month_account","基础返当月上账"),
        staff_logistics("staff_logistics","人员物流当月上账"),


        crt_credit_incrc_amt("crt_credit_incrc_amt","本期贷方发生额"),
        next_month_account("next_month_account","活动下月上账费用"),
        month_init("month_init","活动月期初"),
        audit_final("audit_final","活动月核算期末余额"),
        financial_final("financial_final","财务期末余额"),
        ;

        @EnumValue
        @JsonValue
        private String code;
        private String des;

        DistributionAuditDetailPropertyEnum(String code, String des) {
            this.code = code;
            this.des = des;
        }

        public String getCode() {
            return this.code;
        }

        public String getDes() {
            return this.des;
        }

        public static DistributionAuditDetailPropertyEnum codeToEnum(String code) {
            DistributionAuditDetailPropertyEnum calculationRules = null;
            DistributionAuditDetailPropertyEnum[] var2 = values();
            int var3 = var2.length;

            for (int var4 = 0; var4 < var3; ++var4) {
                DistributionAuditDetailPropertyEnum calculationRulesEnum = var2[var4];
                if (calculationRulesEnum.code.equals(code)) {
                    calculationRules = calculationRulesEnum;
                }
            }

            return calculationRules;
        }
    }
}
